/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.api;

import com.ebaiyihui.framework.api.BaseController;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.framework.enums.ReturnCodeEnum;
import com.ebaiyihui.sysinfo.common.BasicDictEntity;
import com.ebaiyihui.sysinfo.common.vo.BaseDictVo;
import com.ebaiyihui.sysinfo.server.service.BasicDictService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u57fa\u7840\u5b57\u5178"})
@RestController
@RequestMapping(value={"/api/v1/basic_dict"})
public class BasicDictController
extends BaseController {
    @Autowired
    BasicDictService basicDictService;

    @ApiOperation(value="\u6839\u636e\u7c7b\u578bcode\u83b7\u53d6\u5b57\u5178\u4fe1\u606f")
    @GetMapping(value={"/get/bytypecode"})
    public ResultInfo<BaseDictVo> getDictByTypeCode(@RequestParam(value="typeCode", required=true) Integer typeCode) {
        return this.returnSucceed((Object)this.basicDictService.getByTypeCode(typeCode), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6839\u636ecode\u67e5\u8be2\u57fa\u7840\u5b57\u5178")
    @GetMapping(value={"/get/bycode"})
    public ResultInfo<BasicDictEntity> getBasicDictByCode(@RequestParam(value="code") Integer code) {
        return this.returnSucceed((Object)this.basicDictService.getByCode(code), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6dfb\u52a0\u57fa\u7840\u5b57\u5178")
    @PostMapping(value={"/save"})
    public ResultInfo save(@RequestBody BasicDictEntity basicDictEntity) {
        int insertBasicDict = this.basicDictService.save(basicDictEntity);
        if (insertBasicDict == 0) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed((Object)basicDictEntity, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6839\u636ecode\u5220\u9664\u57fa\u7840\u4fe1\u606f\u5b57\u5178")
    @DeleteMapping(value={"/delete"})
    public ResultInfo deleteBasicDictByCode(@RequestParam(value="code") Integer code) {
        int deleteBasicDictByCode = this.basicDictService.deleteByCode(code);
        if (deleteBasicDictByCode == 0) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6839\u636e\u533b\u751f\u670d\u52a1\u96c6\u5408\u83b7\u53d6\u5bf9\u5e94\u5b9e\u4f53\u96c6\u5408")
    @PostMapping(value={"/getbycodelist"})
    public ResultInfo<List<BasicDictEntity>> getbycodelist(@RequestBody List<Integer> codes) {
        return this.returnSucceed((Object)this.basicDictService.getByCodeList(codes), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6309\u56fe\u6587\u3001\u89c6\u9891\u67e5\u8be2\u6240\u6709\u5b50\u4e1a\u52a1--\u4f20\u5165511XX\uff0c(\u524d\u4e24\u4f4d\u8bc6\u522b\u533b\u9662\u6216\u4e2a\u4eba\uff0c\u7b2c\u4e09\u4f4d\u8bc6\u522b \u56fe\u6587\u6216\u89c6\u9891)")
    @GetMapping(value={"/getlikecode"})
    public ResultInfo<List<BasicDictEntity>> getlikecode(@RequestParam(value="likeCode") Integer likeCode) {
        return this.returnSucceed((Object)this.basicDictService.getLikeCode(likeCode), ReturnCodeEnum.SUCCEED.getDisplay());
    }
}

