/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.api;

import com.ebaiyihui.framework.api.BaseController;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.framework.enums.ReturnCodeEnum;
import com.ebaiyihui.sysinfo.common.BasicTypeEntity;
import com.ebaiyihui.sysinfo.server.service.BasicTypeService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u57fa\u7840\u679a\u4e3e\u7c7b\u578b"})
@RestController
@RequestMapping(value={"/api/v1/basic_type"})
public class BasicTypeController
extends BaseController {
    @Autowired
    BasicTypeService basicTypeService;

    @ApiOperation(value="\u6839\u636e\u4e3b\u5065\u67e5\u8be2\u57fa\u7840\u679a\u4e3e\u7c7b\u578b\u8868")
    @GetMapping(value={"/get/byid"})
    public ResultInfo<BasicTypeEntity> getBasicTypeById(@RequestParam(value="id") Long id) {
        return this.returnSucceed((Object)this.basicTypeService.getById(id), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6839\u636ename\u67e5\u8be2\u57fa\u7840\u679a\u4e3e\u7c7b\u578b\u8868")
    @GetMapping(value={"/get/byname"})
    public ResultInfo<List<BasicTypeEntity>> getBasicTypeByName(@RequestParam(value="name") String name) {
        return this.returnSucceed((Object)this.basicTypeService.getLikeName(name), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6839\u636ename\u67e5\u8be2\u57fa\u7840\u679a\u4e3e\u7c7b\u578b\u8868")
    @GetMapping(value={"/get/bycode"})
    public ResultInfo<BasicTypeEntity> getBasicTypeByCode(@RequestParam(value="typeCode") Integer typeCode) {
        return this.returnSucceed((Object)this.basicTypeService.getByCode(typeCode), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6dfb\u52a0\u3001\u4fee\u6539\u57fa\u7840\u679a\u4e3e\u7c7b\u578b")
    @PostMapping(value={"/save"})
    public ResultInfo save(@RequestBody BasicTypeEntity basicTypeEntity) {
        int insertBasicType = this.basicTypeService.save(basicTypeEntity);
        if (insertBasicType == 0) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed((Object)basicTypeEntity, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6839\u636e\u7f16\u7801\u5220\u9664\u57fa\u7840\u679a\u4e3e\u7c7b\u578b\u8868")
    @DeleteMapping(value={"/delete"})
    public ResultInfo deleteBasicTypeById(@RequestParam(value="typeCode") Integer typeCode) {
        int deleteBasicTypeById = this.basicTypeService.delete(typeCode);
        if (deleteBasicTypeById == 0) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }
}

