/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.api;

import com.ebaiyihui.framework.api.BaseController;
import com.ebaiyihui.framework.common.PageResult;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.framework.enums.ReturnCodeEnum;
import com.ebaiyihui.sysinfo.common.BasicDictEntity;
import com.ebaiyihui.sysinfo.common.HelpCenterEntity;
import com.ebaiyihui.sysinfo.common.vo.HelpCenterQuery;
import com.ebaiyihui.sysinfo.common.vo.HelpCenterVo;
import com.ebaiyihui.sysinfo.server.service.HelpCenterService;
import com.github.pagehelper.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5e2e\u52a9\u4e2d\u5fc3"})
@RestController
@RequestMapping(value={"/api/v1/helpcenter"})
public class HelpCenterController
extends BaseController {
    @Autowired
    private HelpCenterService helpCenterService;

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u95ee\u9898\u5206\u7c7b\u53ca\u5b50\u95ee\u9898")
    @PostMapping(value={"/getAll"})
    public ResultInfo<List<HelpCenterVo>> getAll() {
        return this.returnSucceed((Object)this.helpCenterService.getAll(), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6dfb\u52a0\u5e2e\u52a9\u7c7b\u578b")
    @PostMapping(value={"/addType"})
    public ResultInfo<BasicDictEntity> addType(@RequestParam(value="name") String name, @RequestParam(value="icon") String icon) {
        BasicDictEntity entity = this.helpCenterService.addType(name, icon);
        if (entity == null) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed((Object)entity, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2")
    @GetMapping(value={"/getById"})
    public ResultInfo<HelpCenterEntity> getById(@RequestParam(value="id") Long id) {
        return this.returnSucceed((Object)this.helpCenterService.getById(id), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u8d85\u7ba1\uff1a\u5e2e\u52a9\u4e2d\u5fc3\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/getList"})
    public ResultInfo<PageResult<Page<HelpCenterEntity>>> getList(@RequestBody HelpCenterQuery query) {
        return this.returnSucceed((Object)this.helpCenterService.getByCondition(query), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    @GetMapping(value={"/delete"})
    public ResultInfo delete(@RequestParam(value="id") Long id) {
        Integer deleteFlag = this.helpCenterService.deleteById(id);
        if (deleteFlag > 0) {
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u4fee\u6539")
    @PostMapping(value={"/update"})
    public ResultInfo update(@RequestBody HelpCenterEntity helpCenterEntity) {
        HelpCenterEntity centerEntity = this.helpCenterService.updateOne(helpCenterEntity);
        if (centerEntity != null) {
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u6dfb\u52a0")
    @PostMapping(value={"/addOne"})
    public ResultInfo addOne(@RequestBody HelpCenterEntity helpCenterEntity) {
        HelpCenterEntity centerEntity = this.helpCenterService.addOne(helpCenterEntity);
        if (centerEntity != null) {
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u4fee\u6539\u5206\u7c7b")
    @PostMapping(value={"/updateType"})
    public ResultInfo<BasicDictEntity> updateType(@RequestParam(value="code") Integer code, @RequestParam(value="name") String name, @RequestParam(value="icon") String icon) {
        BasicDictEntity entity = this.helpCenterService.updateType(code, name, icon);
        if (entity != null) {
            return this.returnSucceed((Object)entity, ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u5220\u9664\u5206\u7c7b")
    @GetMapping(value={"/deleteType"})
    public ResultInfo<Integer> deleteType(@RequestParam(value="code") Integer code) {
        Integer deleteType = this.helpCenterService.deleteType(code);
        if (deleteType != null) {
            return this.returnSucceed((Object)deleteType, ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }
}

