/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.api;

import com.ebaiyihui.framework.api.BaseController;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.framework.enums.ReturnCodeEnum;
import com.ebaiyihui.sysinfo.common.entity.MenuInfoEntity;
import com.ebaiyihui.sysinfo.server.service.MenuInfoService;
import io.swagger.annotations.Api;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/menu"})
@Api(tags={"\u83dc\u5355\u4fe1\u606f\u63a5\u53e3"})
public class MenuInfoController
extends BaseController {
    @Autowired
    private MenuInfoService menuInfoService;

    @GetMapping(value={"/get_menu_info_list_by_account_type"})
    public ResultInfo<List<MenuInfoEntity>> getMenuInfoListByAccountType(@RequestParam(value="accountType") String accountType) {
        List menuInfoEntityList = this.menuInfoService.getMenuInfoListByAccountType(accountType);
        return this.returnSucceed((Object)menuInfoEntityList, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @GetMapping(value={"/get_web_super_manager_menu_info_list"})
    public ResultInfo<String> getWebSuperManagerMenuInfoList() {
        String menuList = this.menuInfoService.getWebSuperManagerMenuInfoList();
        return this.returnSucceed((Object)menuList, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @PostMapping(value={"/update_menu_info"})
    public ResultInfo<String> updateMenuInfoById(MenuInfoEntity menuInfoEntity) {
        this.menuInfoService.updateMenuInfoById(menuInfoEntity);
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @PostMapping(value={"/save"})
    public ResultInfo<String> save(MenuInfoEntity menuInfoEntity) {
        this.menuInfoService.save(menuInfoEntity);
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @PostMapping(value={"/delete_menu_info"})
    public ResultInfo<String> deleteMenuInfoById(@RequestParam(value="id") Long id) {
        this.menuInfoService.deleteMenuInfoById(id);
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }
}

