/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.api;

import com.ebaiyihui.framework.api.BaseController;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.framework.enums.ReturnCodeEnum;
import com.ebaiyihui.sysinfo.common.ProductVersionEntity;
import com.ebaiyihui.sysinfo.common.vo.ProductVersionQuery;
import com.ebaiyihui.sysinfo.server.service.ProductVersionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/productVersion"})
@Api(tags={"\u4ea7\u54c1\u7248\u672c\u63a7\u5236"})
public class ProductVersionController
extends BaseController {
    @Autowired
    private ProductVersionService productVersionService;

    @ApiOperation(value="\u6dfb\u52a0")
    @PostMapping(value={"/addOne"})
    public ResultInfo<ProductVersionEntity> addOne(@RequestBody ProductVersionEntity entity) {
        ProductVersionEntity productVersionEntity = this.productVersionService.addOne(entity);
        if (productVersionEntity == null) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed((Object)productVersionEntity, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u4fee\u6539")
    @PostMapping(value={"/update"})
    public ResultInfo<ProductVersionEntity> update(@RequestBody ProductVersionEntity entity) {
        ProductVersionEntity productVersionEntity = this.productVersionService.update(entity);
        if (productVersionEntity == null) {
            return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
        }
        return this.returnSucceed((Object)productVersionEntity, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u5220\u9664")
    @GetMapping(value={"/delete"})
    public ResultInfo delete(@RequestParam(value="id") Long id) {
        Integer delete = this.productVersionService.delete(id);
        if (delete > 0) {
            return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
        }
        return this.returnFailure(ReturnCodeEnum.FAILURE.getDisplay());
    }

    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2")
    @GetMapping(value={"/getById"})
    public ResultInfo getById(@RequestParam(value="id") Long id) {
        return this.returnSucceed((Object)this.productVersionService.getById(id), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6761\u4ef6\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/getList"})
    public ResultInfo getList(@RequestBody ProductVersionQuery query) {
        return this.returnSucceed((Object)this.productVersionService.getByCondition(query), ReturnCodeEnum.SUCCEED.getDisplay());
    }
}

