/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.api;

import com.ebaiyihui.framework.api.BaseController;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.framework.enums.ReturnCodeEnum;
import com.ebaiyihui.sysinfo.common.RegionEntity;
import com.ebaiyihui.sysinfo.common.vo.RegionVo;
import com.ebaiyihui.sysinfo.common.vo.SingleRegionVo;
import com.ebaiyihui.sysinfo.server.service.RegionService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5168\u56fd\u7701\u5e02\u533a\u67e5\u8be2"})
@RestController
@RequestMapping(value={"/api/v1/region"})
public class RegionController
extends BaseController {
    @Autowired
    private RegionService regionService;

    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5730\u533a\uff0c\u4e0d\u5206\u7ea7")
    @GetMapping(value={"/getAll"})
    public ResultInfo<Map<String, String>> getAll() {
        return this.returnSucceed((Object)this.regionService.getAll(), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u83b7\u53d6\u70ed\u95e8\u57ce\u5e02")
    @GetMapping(value={"/hotcity"})
    public ResultInfo<List<RegionEntity>> hotcity() {
        return this.returnSucceed((Object)this.regionService.getHotcity(), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u67e5\u8be2\u6240\u6709\u7684\u7701")
    @GetMapping(value={"/province"})
    public ResultInfo<List<RegionEntity>> province() {
        return this.returnSucceed((Object)this.regionService.selectAllProvince(), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u6839\u636e\u7236\u7ea7\u533a\u57dfid\u67e5\u6240\u6709\u5b50\u533a\u57df")
    @GetMapping(value={"/subregion"})
    public ResultInfo<List<RegionEntity>> subregion(@RequestParam(value="parentId") String parentId) {
        return this.returnSucceed((Object)this.regionService.selectSubRegion(parentId), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u4e8c\u7ea7\u8054\u52a8")
    @GetMapping(value={"/provinceandcity"})
    public ResultInfo<List<RegionVo>> provinceandcity() {
        return this.returnSucceed((Object)this.regionService.getProvinceAndCity(), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u4e09\u7ea7\u8054\u52a8")
    @GetMapping(value={"/allregion"})
    public ResultInfo<List<RegionVo>> allregion() {
        return this.returnSucceed((Object)this.regionService.getAllRegion(), ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @GetMapping(value={"/getbycode"})
    public ResultInfo<SingleRegionVo> getRegionByCode(@RequestParam(value="regionId") String regionId) {
        return this.returnSucceed((Object)this.regionService.getRegionByCode(regionId), ReturnCodeEnum.SUCCEED.getDisplay());
    }
}

