/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.api;

import com.ebaiyihui.framework.api.BaseController;
import com.ebaiyihui.framework.common.PageResult;
import com.ebaiyihui.framework.common.ResultInfo;
import com.ebaiyihui.framework.enums.ReturnCodeEnum;
import com.ebaiyihui.sysinfo.common.entity.RoleInfoEntity;
import com.ebaiyihui.sysinfo.common.vo.RolePermissionVo;
import com.ebaiyihui.sysinfo.server.exception.RoleException;
import com.ebaiyihui.sysinfo.server.service.RoleService;
import com.ebaiyihui.sysinfo.server.vo.RoleInfoVo;
import com.ebaiyihui.sysinfo.server.vo.SearchParamVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8d26\u53f7\u89d2\u8272\u63a5\u53e3"})
@RequestMapping(value={"/api/v1/role"})
public class RoleInfoController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(RoleInfoController.class);
    @Autowired
    RoleService roleService;

    @ApiOperation(value="\u901a\u8fc7\u8d26\u53f7\u7c7b\u578b\u67e5\u8be2\u6240\u6709\u7684\u89d2\u8272")
    @GetMapping(value={"/get_all_role_by_account_type"})
    public ResultInfo<List<RoleInfoEntity>> getAllRoleByAccountType(@RequestParam(value="accountType") String accountType) {
        List roleInfoList = null;
        try {
            roleInfoList = this.roleService.getAllRoleByAccountType(accountType);
        }
        catch (RoleException e) {
            log.error(e.getMessage());
            this.returnFailure(e.getMessage());
        }
        return this.returnSucceed((Object)roleInfoList, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u901a\u8fc7\u89d2\u8272id\u67e5\u8be2\u67e5\u8be2\u6743\u9650\u4fe1\u606f")
    @GetMapping(value={"/get_menu_info_permission_by_role_id"})
    public ResultInfo<RolePermissionVo> getMenuInfoPermissionByRoleId(@RequestParam(value="roleId") Long roleId) {
        RolePermissionVo rolePermissionVo = this.roleService.getMenuInfoPermissionByRoleId(roleId);
        return this.returnSucceed((Object)rolePermissionVo, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u901a\u8fc7\u7528\u6237\u7684\u7684viewId\u67e5\u8be2\u6240\u83dc\u5355\u6743\u9650\u4ee5\u53ca\u533b\u9662\u6743\u9650")
    @GetMapping(value={"/get_all_permission_by_account_view_id"})
    public ResultInfo<RolePermissionVo> getAllPermissionByAccountViewId(@RequestParam(value="accountViewId") String accountViewId) {
        RolePermissionVo rolePermissionVo = this.roleService.getAllPermissionByAccountViewId(accountViewId);
        return this.returnSucceed((Object)rolePermissionVo, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u901a\u8fc7\u8d26\u53f7\u7c7b\u578b\u5206\u9875\u67e5\u8be2\u6240\u6709\u7684\u89d2\u8272")
    @GetMapping(value={"/get_all_role_page_by_search_param"})
    public ResultInfo<PageResult> getAllRolePageBySearchParam(SearchParamVo searchParamVo, @RequestParam(value="pageNum") Integer pageNum, @RequestParam(value="pageSize") Integer pageSize) {
        PageResult pageResult = null;
        pageResult = this.roleService.getAllRolePageBySearchParam(searchParamVo, pageNum, pageSize);
        return this.returnSucceed((Object)pageResult, ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u901a\u8fc7\u89d2\u8272\u7684id\u4fee\u6539\u83dc\u5355\u6743\u9650")
    @PostMapping(value={"/update_menu_permission_info_by_role_id"})
    public ResultInfo updateMenuPermissionInfoByRoleId(@RequestBody RoleInfoVo roleInfoVo) {
        this.roleService.updateMenuPermissionInfoByRoleId(roleInfoVo);
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u521b\u5efa\u89d2\u8272")
    @PostMapping(value={"/save_role_menu_permission_info"})
    public ResultInfo saveRoleMenuPermissionInfo(@RequestBody RoleInfoVo roleInfoVo) {
        try {
            this.roleService.saveRoleMenuPermissionInfo(roleInfoVo);
        }
        catch (RoleException e) {
            e.printStackTrace();
            return this.returnFailure(e.getMessage());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }

    @ApiOperation(value="\u5220\u9664\u89d2\u8272")
    @PostMapping(value={"/delete_role_info"})
    public ResultInfo deleteRoleInfo(@RequestParam(value="roleId") Long roleId) {
        try {
            this.roleService.deleteRoleInfo(roleId);
        }
        catch (RoleException e) {
            e.printStackTrace();
            return this.returnFailure(e.getMessage());
        }
        return this.returnSucceed(ReturnCodeEnum.SUCCEED.getDisplay());
    }
}

