/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.service.impl;

import com.ebaiyihui.framework.common.PageResult;
import com.ebaiyihui.framework.utils.UuidUtils;
import com.ebaiyihui.sysinfo.common.SuperAdminUserEntity;
import com.ebaiyihui.sysinfo.common.entity.AccountRoleInfoEntity;
import com.ebaiyihui.sysinfo.common.entity.HospitalPermissionsInfoEntity;
import com.ebaiyihui.sysinfo.common.entity.RoleInfoEntity;
import com.ebaiyihui.sysinfo.common.vo.ResetPwdVo;
import com.ebaiyihui.sysinfo.common.vo.RolePermissionVo;
import com.ebaiyihui.sysinfo.server.common.CommonConstant;
import com.ebaiyihui.sysinfo.server.dao.AccountRoleInfoMapper;
import com.ebaiyihui.sysinfo.server.dao.HospitalPermissionsInfoMapper;
import com.ebaiyihui.sysinfo.server.dao.MenuInfoMapper;
import com.ebaiyihui.sysinfo.server.dao.RoleInfoMapper;
import com.ebaiyihui.sysinfo.server.dao.SuperAdminUserMapper;
import com.ebaiyihui.sysinfo.server.exception.SuperAdminUserException;
import com.ebaiyihui.sysinfo.server.service.AdminService;
import com.ebaiyihui.sysinfo.server.service.RoleService;
import com.ebaiyihui.sysinfo.server.vo.SearchParamVo;
import com.ebaiyihui.sysinfo.server.vo.SuperAdminUserDetailsVo;
import com.ebaiyihui.sysinfo.server.vo.SuperAdminUserVo;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class AdminServiceImpl
implements AdminService {
    private static final Logger log = LoggerFactory.getLogger(AdminServiceImpl.class);
    public static final String LOGON_NAME_EXIST = "\u767b\u5f55\u540d\u5df2\u5b58\u5728";
    public static final String WEB_SUPER_MANAGER = "web_super_manager";
    @Autowired
    private SuperAdminUserMapper adminUserMapper;
    @Autowired
    private AccountRoleInfoMapper accountRoleInfoMapper;
    @Autowired
    private RoleInfoMapper roleInfoMapper;
    @Autowired
    private RoleService roleService;
    @Autowired
    private MenuInfoMapper menuInfoMapper;
    @Autowired
    private HospitalPermissionsInfoMapper hospitalPermissionsInfoMapper;

    public SuperAdminUserEntity getByLoginName(String loginName) {
        SuperAdminUserEntity superAdminUserEntity = this.adminUserMapper.selectByLoginName(loginName);
        return superAdminUserEntity;
    }

    public Integer saveAdminToken(String loginName, String token) {
        Integer integer = this.adminUserMapper.updateToken(loginName, token);
        return integer;
    }

    @Transactional(rollbackFor={Exception.class})
    public void saveSuperAdminUser(SuperAdminUserVo superAdminUserVo) throws SuperAdminUserException {
        this.checkSuperAdminUserAccountInfo(superAdminUserVo);
        SuperAdminUserEntity superAdminUser = this.createSuperAdminUser(superAdminUserVo);
        this.adminUserMapper.insertSelective(superAdminUser);
        if (superAdminUserVo.getRoleId() != null && superAdminUserVo.getRoleId() != 0L) {
            AccountRoleInfoEntity accountRoleInfoEntity = this.createAccountRoleInfoEntity(superAdminUserVo.getRoleId(), superAdminUser);
            this.accountRoleInfoMapper.insertSelective(accountRoleInfoEntity);
            SuperAdminUserEntity fullSuperAdminUser = this.adminUserMapper.selectByLoginName(superAdminUser.getLoginName());
            List hospitalPermissionsInfoEntityList = superAdminUserVo.getHospitalPermissionsInfoEntityList();
            this.batchSaveHospitalPermissionsInfoEntity(fullSuperAdminUser.getViewId(), hospitalPermissionsInfoEntityList);
            return;
        }
        this.checkRoleInfo(superAdminUserVo.getRoleName());
        RoleInfoEntity roleInfoEntity = this.createRoleInfoEntity(superAdminUserVo.getRoleName(), superAdminUser);
        this.roleInfoMapper.insertSelective(roleInfoEntity);
        AccountRoleInfoEntity accountRoleInfoEntity = this.createAccountRoleInfoEntity(roleInfoEntity.getId(), superAdminUser);
        this.accountRoleInfoMapper.insertSelective(accountRoleInfoEntity);
        SuperAdminUserEntity fullSuperAdminUser = this.adminUserMapper.selectByLoginName(superAdminUser.getLoginName());
        List hospitalPermissionsInfoEntityList = superAdminUserVo.getHospitalPermissionsInfoEntityList();
        this.batchSaveHospitalPermissionsInfoEntity(fullSuperAdminUser.getViewId(), hospitalPermissionsInfoEntityList);
        Long roleId = roleInfoEntity.getId();
        List menuPermissionsInfoEntityList = superAdminUserVo.getMenuInfoEntityList();
        this.roleService.batchSaveMenuPermissionsInfoEntity(roleId, menuPermissionsInfoEntityList);
    }

    public PageResult<List<SuperAdminUserVo>> getSuperAdminUserPageBySearchParam(SearchParamVo searchParamVo, Integer pageNum, Integer pageSize) {
        PageResult pageResult = new PageResult();
        List superAdminUserEntityList = this.adminUserMapper.selectSuperAdminUserPageBySearchParam(searchParamVo, Integer.valueOf((pageNum - 1) * pageSize), pageSize);
        if (superAdminUserEntityList == null || superAdminUserEntityList.isEmpty()) {
            return pageResult;
        }
        List superAdminUserVos = superAdminUserEntityList.stream().map(superAdminUserEntity -> {
            SuperAdminUserVo superAdminUserVo = this.getSuperAdminUserVo(superAdminUserEntity);
            return superAdminUserVo;
        }).collect(Collectors.toList());
        Integer count = this.adminUserMapper.selectSuperAdminUserCountBySearchParam(searchParamVo);
        pageResult.setPageData(superAdminUserVos);
        pageResult.setTotal((long)count.intValue());
        return pageResult;
    }

    private SuperAdminUserVo getSuperAdminUserVo(SuperAdminUserEntity superAdminUserEntity) {
        SuperAdminUserVo superAdminUserVo = new SuperAdminUserVo();
        AccountRoleInfoEntity accountRoleInfoEntity = this.accountRoleInfoMapper.selectAccountRoleInfoByAccountViewId(superAdminUserEntity.getViewId());
        RoleInfoEntity roleInfoEntity = this.roleInfoMapper.selectById(accountRoleInfoEntity.getRoleId());
        BeanUtils.copyProperties((Object)superAdminUserEntity, (Object)superAdminUserVo);
        superAdminUserVo.setSuperAdminId(superAdminUserEntity.getId());
        if (roleInfoEntity != null) {
            superAdminUserVo.setRoleId(roleInfoEntity.getId());
            superAdminUserVo.setRoleName(roleInfoEntity.getName());
        }
        return superAdminUserVo;
    }

    public void deleteSuperAdminById(Long id) {
        this.adminUserMapper.updateStatusById(CommonConstant.INVALID_STATUS, id);
    }

    public Integer resetPwd(ResetPwdVo vo) {
        String oldPwd;
        SuperAdminUserEntity userEntity = this.adminUserMapper.selectByLoginName(vo.getLoginName().trim());
        if (userEntity == null) {
            log.info("\u8d26\u6237\u4e3a\u7a7a");
            return 0;
        }
        if (vo.getResetType() == ResetPwdVo.TYPE_OLDPWD && !(oldPwd = DigestUtils.md5Hex((String)vo.getOldPwd().trim())).equals(userEntity.getPassword())) {
            log.info("\u65e7\u5bc6\u7801\u9519\u8bef");
            return 0;
        }
        String newPwd = DigestUtils.md5Hex((String)vo.getNewPwd().trim());
        userEntity.setPassword(newPwd);
        return this.adminUserMapper.updateByIdSelective(userEntity);
    }

    public SuperAdminUserDetailsVo selectSuperAdminDetailInfoById(Long id) {
        SuperAdminUserEntity superAdminUserEntity = this.adminUserMapper.selectById(id);
        SuperAdminUserDetailsVo superAdminUserDetailsVo = this.getSuperAdminUserDetailsVo(superAdminUserEntity);
        RolePermissionVo rolePermissionVo = this.roleService.getAllPermissionByAccountViewId(superAdminUserEntity.getViewId());
        superAdminUserDetailsVo.setRolePermissionVo(rolePermissionVo);
        superAdminUserDetailsVo.setRoleName(rolePermissionVo.getRoleName());
        superAdminUserDetailsVo.setRoleId(rolePermissionVo.getRoleId());
        return superAdminUserDetailsVo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateSuperAdminInfoById(SuperAdminUserVo superAdminUserVo) {
        SuperAdminUserEntity superAdminUserEntity = new SuperAdminUserEntity();
        superAdminUserEntity.setId(superAdminUserVo.getSuperAdminId());
        superAdminUserEntity.setMobileNumber(superAdminUserVo.getMobileNumber());
        SuperAdminUserEntity oldSuperAdminUserEntity = this.adminUserMapper.selectById(superAdminUserVo.getSuperAdminId());
        if (!oldSuperAdminUserEntity.getPassword().equalsIgnoreCase(superAdminUserVo.getPassword())) {
            String password = superAdminUserVo.getPassword();
            password = DigestUtils.md5Hex((String)password);
            superAdminUserEntity.setPassword(password);
        }
        this.adminUserMapper.updateByIdSelective(superAdminUserEntity);
        List hospitalPermissionsInfoEntityList = superAdminUserVo.getHospitalPermissionsInfoEntityList();
        this.hospitalPermissionsInfoMapper.deleteByAccountViewId(superAdminUserVo.getViewId());
        this.batchSaveHospitalPermissionsInfoEntity(superAdminUserVo.getViewId(), hospitalPermissionsInfoEntityList);
    }

    public void enableSuperAdminById(Long id) {
        this.adminUserMapper.updateStatusById(Integer.valueOf(1), id);
    }

    private SuperAdminUserDetailsVo getSuperAdminUserDetailsVo(SuperAdminUserEntity superAdminUserEntity) {
        SuperAdminUserDetailsVo superAdminUserDetailsVo = new SuperAdminUserDetailsVo();
        BeanUtils.copyProperties((Object)superAdminUserEntity, (Object)superAdminUserDetailsVo);
        superAdminUserDetailsVo.setSuperAdminId(superAdminUserEntity.getId());
        return superAdminUserDetailsVo;
    }

    private void checkRoleInfo(String roleName) throws SuperAdminUserException {
        RoleInfoEntity roleInfoEntity = this.roleInfoMapper.selectAccountRoleInfoByName(roleName);
        if (roleInfoEntity != null) {
            throw new SuperAdminUserException("\u7528\u6237\u89d2\u8272\u5df2\u5b58\u5728");
        }
    }

    private void batchSaveHospitalPermissionsInfoEntity(String viewId, List<HospitalPermissionsInfoEntity> hospitalPermissionsInfoEntityList) {
        if (hospitalPermissionsInfoEntityList != null && !hospitalPermissionsInfoEntityList.isEmpty()) {
            hospitalPermissionsInfoEntityList = hospitalPermissionsInfoEntityList.stream().map(hospitalPermissionsInfoEntity -> {
                hospitalPermissionsInfoEntity.setStatus(CommonConstant.VALID_STATUS);
                hospitalPermissionsInfoEntity.setAccountViewId(viewId);
                hospitalPermissionsInfoEntity.setCity(hospitalPermissionsInfoEntity.getCity());
                hospitalPermissionsInfoEntity.setProvince(hospitalPermissionsInfoEntity.getProvince());
                hospitalPermissionsInfoEntity.setHospitalName(hospitalPermissionsInfoEntity.getHospitalName());
                hospitalPermissionsInfoEntity.setHospitalId(hospitalPermissionsInfoEntity.getHospitalId());
                return hospitalPermissionsInfoEntity;
            }).collect(Collectors.toList());
            this.hospitalPermissionsInfoMapper.batchInsert(hospitalPermissionsInfoEntityList);
        }
    }

    private RoleInfoEntity createRoleInfoEntity(String roleName, SuperAdminUserEntity superAdminUser) {
        RoleInfoEntity roleInfoEntity = new RoleInfoEntity();
        roleInfoEntity.setAccountType(WEB_SUPER_MANAGER);
        roleInfoEntity.setName(roleName);
        roleInfoEntity.setStatus(CommonConstant.VALID_STATUS);
        roleInfoEntity.setCreator(superAdminUser.getLoginName());
        return roleInfoEntity;
    }

    private void checkSuperAdminUserAccountInfo(SuperAdminUserVo superAdminUserVo) throws SuperAdminUserException {
        String loginName = superAdminUserVo.getLoginName();
        SuperAdminUserEntity superAdminUserEntity = this.adminUserMapper.selectByLoginName(loginName);
        if (superAdminUserEntity != null) {
            throw new SuperAdminUserException(LOGON_NAME_EXIST);
        }
    }

    private AccountRoleInfoEntity createAccountRoleInfoEntity(Long roleId, SuperAdminUserEntity superAdminUser) {
        AccountRoleInfoEntity accountRoleInfoEntity = new AccountRoleInfoEntity();
        accountRoleInfoEntity.setAccountId(superAdminUser.getId());
        accountRoleInfoEntity.setAccountViewId(superAdminUser.getViewId());
        accountRoleInfoEntity.setAccountType(WEB_SUPER_MANAGER);
        accountRoleInfoEntity.setStatus(CommonConstant.VALID_STATUS);
        accountRoleInfoEntity.setRoleId(roleId);
        return accountRoleInfoEntity;
    }

    private SuperAdminUserEntity createSuperAdminUser(SuperAdminUserVo superAdminUserVo) {
        SuperAdminUserEntity superAdminUser = new SuperAdminUserEntity();
        BeanUtils.copyProperties((Object)superAdminUserVo, (Object)superAdminUser);
        superAdminUser.setStatus(CommonConstant.VALID_STATUS);
        superAdminUser.setViewId(UuidUtils.generateUUID());
        String password = superAdminUserVo.getPassword();
        password = DigestUtils.md5Hex((String)password);
        superAdminUser.setPassword(password);
        return superAdminUser;
    }
}

