/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.service.impl;

import com.ebaiyihui.sysinfo.common.BasicDictEntity;
import com.ebaiyihui.sysinfo.common.BasicTypeEntity;
import com.ebaiyihui.sysinfo.common.vo.BaseDictVo;
import com.ebaiyihui.sysinfo.server.dao.BasicDictMapper;
import com.ebaiyihui.sysinfo.server.service.BasicDictService;
import com.ebaiyihui.sysinfo.server.service.BasicTypeService;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BasicDictServiceImpl
implements BasicDictService {
    private static final Logger log = LoggerFactory.getLogger(BasicDictServiceImpl.class);
    @Autowired
    BasicDictMapper basicDictMapper;
    @Autowired
    BasicTypeService basicTypeService;

    public BaseDictVo getByTypeCode(Integer typeCode) {
        BaseDictVo result = new BaseDictVo();
        BasicTypeEntity typeEntity = this.basicTypeService.getByCode(typeCode);
        result.setTypeEntity(typeEntity);
        result.setDictEntityList(this.basicDictMapper.getBasicDictByTypeId(typeEntity.getId(), Integer.valueOf(1)));
        return result;
    }

    public BasicDictEntity getByCode(Integer code) {
        return this.basicDictMapper.getBasicDictByCode(code, Integer.valueOf(1));
    }

    public Integer save(BasicDictEntity entity) {
        BasicDictEntity byCode = this.getByCode(entity.getCode());
        if (byCode != null) {
            log.info("=======\u5b57\u5178\u6570\u636e========\u4fee\u6539");
            return this.basicDictMapper.updateBasicDict(entity);
        }
        BasicTypeEntity typeEntity = this.basicTypeService.getByCode(entity.getTypeCode());
        entity.setTypeId(typeEntity.getId());
        log.info("=======\u5b57\u5178\u6570\u636e========\u589e\u52a0");
        return this.basicDictMapper.insertBasicDict(entity);
    }

    public Integer deleteByCode(Integer code) {
        return this.basicDictMapper.updateStatusByCode(code, Integer.valueOf(-1));
    }

    public Integer deleteByTypeCode(Integer typeCode) {
        return this.basicDictMapper.updateStatusByTypeCode(typeCode, Integer.valueOf(-1));
    }

    public List<BasicDictEntity> getByCodeList(List<Integer> codes) {
        Long typeId = 5L;
        List basicDictEntityList = this.basicDictMapper.getBasicDictByTypeId(typeId, Integer.valueOf(1));
        ArrayList<BasicDictEntity> result = new ArrayList<BasicDictEntity>();
        for (Integer code : codes) {
            for (BasicDictEntity entity : basicDictEntityList) {
                if (!entity.getCode().equals(code)) continue;
                result.add(entity);
            }
        }
        return result;
    }

    public List<BasicDictEntity> getLikeCode(Integer code) {
        String likeCode = code.toString().replaceAll("0", "_");
        return this.basicDictMapper.selectLikeCode(likeCode);
    }
}

