/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.service.impl;

import com.ebaiyihui.sysinfo.common.BasicTypeEntity;
import com.ebaiyihui.sysinfo.server.dao.BasicTypeMapper;
import com.ebaiyihui.sysinfo.server.service.BasicDictService;
import com.ebaiyihui.sysinfo.server.service.BasicTypeService;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BasicTypeServiceImpl
implements BasicTypeService {
    private static final Logger log = LoggerFactory.getLogger(BasicTypeServiceImpl.class);
    @Autowired
    BasicTypeMapper basicTypeMapper;
    @Autowired
    BasicDictService basicDictService;

    public BasicTypeEntity getById(Long id) {
        return this.basicTypeMapper.getBasicTypeById(id, Integer.valueOf(1));
    }

    public BasicTypeEntity getByCode(Integer typeCode) {
        return this.basicTypeMapper.getBasicTypeByCode(typeCode, Integer.valueOf(1));
    }

    public List<BasicTypeEntity> getLikeName(String name) {
        return this.basicTypeMapper.getBasicTypeLikeName(name.trim(), Integer.valueOf(1));
    }

    public Integer save(BasicTypeEntity entity) {
        BasicTypeEntity byCode = this.getByCode(entity.getTypeCode());
        if (byCode == null) {
            log.info("===========\u5b57\u5178\u7c7b\u578b=====\u589e\u52a0");
            return this.basicTypeMapper.insertBasicType(entity);
        }
        log.info("===========\u5b57\u5178\u7c7b\u578b=====\u4fee\u6539");
        return this.basicTypeMapper.updateBasicType(entity);
    }

    public int delete(Integer typeCode) {
        this.basicDictService.deleteByTypeCode(typeCode);
        return this.basicTypeMapper.updateStatusByCode(typeCode, Integer.valueOf(-1));
    }
}

