/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.service.impl;

import com.ebaiyihui.framework.common.PageResult;
import com.ebaiyihui.sysinfo.common.BasicDictEntity;
import com.ebaiyihui.sysinfo.common.HelpCenterEntity;
import com.ebaiyihui.sysinfo.common.vo.HelpCenterQuery;
import com.ebaiyihui.sysinfo.common.vo.HelpCenterVo;
import com.ebaiyihui.sysinfo.server.dao.HelpCenterMapper;
import com.ebaiyihui.sysinfo.server.service.BasicDictService;
import com.ebaiyihui.sysinfo.server.service.HelpCenterService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HelpCenterServiceImpl
implements HelpCenterService {
    private static final Logger log = LoggerFactory.getLogger(HelpCenterServiceImpl.class);
    private static final Integer TYPE_CODE = 800;
    private static final Long TYPE_ID = 8L;
    @Autowired
    private HelpCenterMapper helpCenterMapper;
    @Autowired
    private BasicDictService basicDictService;

    public HelpCenterEntity addOne(HelpCenterEntity helpCenterEntity) {
        this.getNameByCode(helpCenterEntity);
        int addFlag = this.helpCenterMapper.insertSelective(helpCenterEntity);
        if (addFlag > 0) {
            return helpCenterEntity;
        }
        return null;
    }

    public HelpCenterEntity getById(Long id) {
        return this.helpCenterMapper.selectByPrimaryKey(id);
    }

    public Integer deleteById(Long id) {
        return this.helpCenterMapper.deleteByPrimaryKey(id);
    }

    public HelpCenterEntity updateOne(HelpCenterEntity helpCenterEntity) {
        this.getNameByCode(helpCenterEntity);
        int addFlag = this.helpCenterMapper.updateByPrimaryKeySelective(helpCenterEntity);
        if (addFlag > 0) {
            return helpCenterEntity;
        }
        return null;
    }

    public PageResult<Page<HelpCenterEntity>> getByCondition(HelpCenterQuery query) {
        if (query.getPageNum() == null || query.getPageSize() == null) {
            query.setPageNum(Integer.valueOf(1));
            query.setPageSize(Integer.valueOf(10));
        }
        PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        PageResult result = new PageResult();
        Page entityPage = this.helpCenterMapper.selectByCondition(query);
        for (HelpCenterEntity entity : entityPage) {
            String icon = this.basicDictService.getByCode(entity.getTypeCode()).getIcon();
            entity.setIcon(icon);
        }
        result.setPageData((Object)entityPage);
        result.setPageSize(query.getPageSize().intValue());
        result.setPageNum(query.getPageNum().intValue());
        result.setTotal(entityPage.getTotal());
        result.setPages(entityPage.getPages());
        return result;
    }

    public BasicDictEntity addType(String name, String icon) {
        List dictEntityList = this.basicDictService.getByTypeCode(TYPE_CODE).getDictEntityList();
        Integer newCode = TYPE_CODE;
        for (BasicDictEntity basicDictEntity : dictEntityList) {
            if (basicDictEntity.getCode() <= newCode) continue;
            newCode = basicDictEntity.getCode();
        }
        BasicDictEntity entity = new BasicDictEntity();
        entity.setCode(Integer.valueOf(newCode + 1));
        entity.setIcon(icon.trim());
        entity.setName(name.trim());
        entity.setTypeCode(TYPE_CODE);
        entity.setTypeId(TYPE_ID);
        Integer saveFlag = this.basicDictService.save(entity);
        if (saveFlag > 0) {
            return entity;
        }
        return null;
    }

    public BasicDictEntity updateType(Integer code, String name, String icon) {
        BasicDictEntity dictEntity = this.basicDictService.getByCode(code);
        dictEntity.setName(name.trim());
        dictEntity.setIcon(icon.trim());
        Integer saveFlag = this.basicDictService.save(dictEntity);
        Integer updateFlag = this.helpCenterMapper.updateAllByTypeCode(code, name);
        if (saveFlag > 0) {
            return dictEntity;
        }
        return null;
    }

    public Integer deleteType(Integer code) {
        Integer deleteFlag = this.basicDictService.deleteByCode(code);
        this.helpCenterMapper.deleteAllByTypeCode(code);
        if (deleteFlag > 0) {
            return deleteFlag;
        }
        return null;
    }

    public List<HelpCenterVo> getAll() {
        HelpCenterQuery query = new HelpCenterQuery();
        query.setPageNum(Integer.valueOf(1));
        query.setPageSize(Integer.valueOf(100));
        ArrayList<HelpCenterVo> result = new ArrayList<HelpCenterVo>();
        List dictEntityList = this.basicDictService.getByTypeCode(TYPE_CODE).getDictEntityList();
        for (BasicDictEntity entity : dictEntityList) {
            HelpCenterVo vo = new HelpCenterVo();
            vo.setHelpCenterType(entity);
            query.setTypeCode(entity.getCode());
            vo.setEntityList((List)this.helpCenterMapper.selectByCondition(query));
            result.add(vo);
        }
        return result;
    }

    private void getNameByCode(HelpCenterEntity helpCenterEntity) {
        try {
            Integer typeCode = helpCenterEntity.getTypeCode();
            BasicDictEntity byCode = this.basicDictService.getByCode(typeCode);
            helpCenterEntity.setTypeName(byCode.getName());
        }
        catch (Exception e) {
            log.error("===\u5e2e\u52a9\u4e2d\u5fc3\u589e\u6539\u8bb0\u5f55===\u6839\u636e\u5b57\u5178code\u83b7\u53d6name\u6709\u8bef===" + e.getMessage());
        }
    }
}

