/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.utils.UuidUtils;
import com.ebaiyihui.sysinfo.common.entity.MenuInfoEntity;
import com.ebaiyihui.sysinfo.common.vo.MenuInfoVo;
import com.ebaiyihui.sysinfo.server.common.CommonConstant;
import com.ebaiyihui.sysinfo.server.dao.MenuInfoMapper;
import com.ebaiyihui.sysinfo.server.service.MenuInfoService;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class MenuInfoServiceImpl
implements MenuInfoService {
    public static final String WEB_SUPER_MANAGER = "web_super_manager";
    @Autowired
    private MenuInfoMapper menuInfoMapper;

    public List<MenuInfoEntity> getMenuInfoListByAccountType(String accountType) {
        return this.menuInfoMapper.selectMenuInfoListByAccountType(accountType);
    }

    public void updateMenuInfoById(MenuInfoEntity menuInfoEntity) {
        this.menuInfoMapper.updateByIdSelective(menuInfoEntity);
    }

    public void save(MenuInfoEntity menuInfoEntity) {
        menuInfoEntity.setStatus(CommonConstant.VALID_STATUS);
        menuInfoEntity.setViewId(UuidUtils.generateUUID());
        this.menuInfoMapper.insertSelective(menuInfoEntity);
    }

    public void deleteMenuInfoById(Long id) {
        this.menuInfoMapper.updateStatusById(CommonConstant.INVALID_STATUS, id);
    }

    public String getWebSuperManagerMenuInfoList() {
        List parentMenuInfoList = this.menuInfoMapper.selectPatientMenuInfoListByAccountType(WEB_SUPER_MANAGER);
        if (parentMenuInfoList == null || parentMenuInfoList.isEmpty()) {
            return null;
        }
        List menuList = parentMenuInfoList.stream().map(menuInfoEntity -> {
            MenuInfoVo menuInfoVo = new MenuInfoVo();
            BeanUtils.copyProperties((Object)menuInfoEntity, (Object)menuInfoVo);
            List itemGroup = this.menuInfoMapper.selectByParentId(menuInfoEntity.getId());
            if (!CollectionUtils.isEmpty((Collection)itemGroup)) {
                itemGroup = itemGroup.stream().sorted(Comparator.comparing(MenuInfoEntity::getOrderNumber)).collect(Collectors.toList());
                menuInfoVo.setItemGroup(itemGroup);
            }
            return menuInfoVo;
        }).collect(Collectors.toList());
        menuList = menuList.stream().sorted(Comparator.comparing(MenuInfoEntity::getOrderNumber)).collect(Collectors.toList());
        String menuListJson = JSON.toJSONString(menuList);
        return menuListJson;
    }

    public MenuInfoEntity selectMenuInfoById(Long menuId) {
        return this.menuInfoMapper.selectById(menuId);
    }

    public List<MenuInfoEntity> selectMenuInfoByIdList(List<Long> menuIdList) {
        return this.menuInfoMapper.selectMenuInfoByIdList(menuIdList);
    }
}

