/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.service.impl;

import com.ebaiyihui.framework.common.PageResult;
import com.ebaiyihui.sysinfo.common.BasicDictEntity;
import com.ebaiyihui.sysinfo.common.ProductVersionEntity;
import com.ebaiyihui.sysinfo.common.vo.ProductVersionQuery;
import com.ebaiyihui.sysinfo.server.dao.ProductVersionMapper;
import com.ebaiyihui.sysinfo.server.service.BasicDictService;
import com.ebaiyihui.sysinfo.server.service.ProductVersionService;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProductVersionServiceImpl
implements ProductVersionService {
    @Autowired
    private ProductVersionMapper productVersionMapper;
    @Autowired
    private BasicDictService basicDictService;

    public ProductVersionEntity addOne(ProductVersionEntity entity) {
        if (entity.getTypeCode() == null) {
            return null;
        }
        BasicDictEntity basicDictEntity = this.basicDictService.getByCode(entity.getTypeCode());
        if (basicDictEntity == null) {
            return null;
        }
        entity.setTypeName(basicDictEntity.getName());
        this.productVersionMapper.insertSelective(entity);
        return entity;
    }

    public ProductVersionEntity update(ProductVersionEntity entity) {
        if (entity.getId() == null) {
            return null;
        }
        if (entity.getTypeCode() != null) {
            BasicDictEntity basicDictEntity = this.basicDictService.getByCode(entity.getTypeCode());
            if (basicDictEntity == null) {
                return null;
            }
            entity.setTypeName(basicDictEntity.getName());
        }
        this.productVersionMapper.updateByPrimaryKeySelective(entity);
        return entity;
    }

    public Integer delete(Long id) {
        return this.productVersionMapper.deleteByPrimaryKey(id);
    }

    public ProductVersionEntity getById(Long id) {
        ProductVersionEntity versionEntity = this.productVersionMapper.selectByPrimaryKey(id);
        BasicDictEntity byCode = this.basicDictService.getByCode(versionEntity.getTypeCode());
        if (byCode != null) {
            versionEntity.setIcon(byCode.getIcon());
        }
        return versionEntity;
    }

    public PageResult<List<ProductVersionEntity>> getByCondition(ProductVersionQuery query) {
        PageResult result = new PageResult();
        if (query.getPageNum() == null || query.getPageSize() == null) {
            query.setPageNum(Integer.valueOf(1));
            query.setPageSize(Integer.valueOf(10));
        }
        PageHelper.startPage((int)query.getPageNum(), (int)query.getPageSize());
        Page productVersionEntities = this.productVersionMapper.selectByCondition(query);
        for (ProductVersionEntity entity : productVersionEntities) {
            BasicDictEntity byCode = this.basicDictService.getByCode(entity.getTypeCode());
            if (byCode == null) continue;
            entity.setIcon(byCode.getIcon());
        }
        result.setPageData((Object)productVersionEntities);
        result.setPageNum(query.getPageNum().intValue());
        result.setPageSize(query.getPageSize().intValue());
        result.setPages(productVersionEntities.getPages());
        result.setTotal(productVersionEntities.getTotal());
        return result;
    }
}

