/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.service.impl;

import com.ebaiyihui.sysinfo.common.RegionEntity;
import com.ebaiyihui.sysinfo.common.vo.RegionVo;
import com.ebaiyihui.sysinfo.common.vo.SingleRegionVo;
import com.ebaiyihui.sysinfo.server.dao.RegionMapper;
import com.ebaiyihui.sysinfo.server.enums.RegionTypeEnum;
import com.ebaiyihui.sysinfo.server.service.RegionService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RegionServiceImpl
implements RegionService {
    @Autowired
    private RegionMapper regionMapper;

    public List<RegionEntity> selectAllProvince() {
        return this.regionMapper.selectRegionByType(RegionTypeEnum.PROVINCE.getValue());
    }

    public List<RegionEntity> selectSubRegion(String RegionParentId) {
        return this.regionMapper.selectSubRegion(RegionParentId);
    }

    public List<RegionVo> getProvinceAndCity() {
        List regionVoList = this.getRegionVoListByType(RegionTypeEnum.PROVINCE.getValue(), RegionTypeEnum.CITY.getValue());
        return regionVoList;
    }

    public List<RegionVo> getAllRegion() {
        ArrayList<RegionVo> result = new ArrayList<RegionVo>();
        List province = this.regionMapper.selectRegionByType(RegionTypeEnum.PROVINCE.getValue());
        List cityList = this.getRegionVoListByType(RegionTypeEnum.CITY.getValue(), RegionTypeEnum.COUNTY.getValue());
        for (RegionEntity provn : province) {
            RegionVo regionVo = new RegionVo();
            regionVo.setParentRegion(provn);
            ArrayList<RegionVo> cityVoList = new ArrayList<RegionVo>();
            for (RegionVo vo : cityList) {
                if (!vo.getParentRegion().getRegionParentId().equals(provn.getRegionId())) continue;
                cityVoList.add(vo);
            }
            regionVo.setSubRegionVoList(cityVoList);
            result.add(regionVo);
        }
        return result;
    }

    public SingleRegionVo getRegionByCode(String regionId) {
        SingleRegionVo vo = new SingleRegionVo();
        RegionEntity entity = new RegionEntity();
        do {
            if ((entity = this.regionMapper.selectRegionById(regionId)) == null) {
                return null;
            }
            int flag = entity.getRegionType();
            switch (flag) {
                case 1: {
                    vo.setProvince(entity);
                    break;
                }
                case 2: {
                    vo.setCity(entity);
                    break;
                }
                case 3: {
                    vo.setCounty(entity);
                }
            }
            regionId = entity.getRegionParentId();
        } while (entity.getRegionType() > RegionTypeEnum.PROVINCE.getValue());
        return vo;
    }

    public List<RegionEntity> getHotcity() {
        return this.regionMapper.selectHotcity();
    }

    public Map<String, String> getAll() {
        List list = this.regionMapper.selectAll();
        HashMap<String, String> map = new HashMap<String, String>();
        for (RegionEntity entity : list) {
            map.put(entity.getRegionId(), entity.getRegionName());
        }
        return map;
    }

    public List<RegionVo> getRegionVoListByType(Integer parent, Integer sub) {
        ArrayList<RegionVo> regionVoList = new ArrayList<RegionVo>();
        List provinceList = this.regionMapper.selectRegionByType(parent);
        List cityList = this.regionMapper.selectRegionByType(sub);
        for (RegionEntity province : provinceList) {
            RegionVo vo = new RegionVo();
            vo.setParentRegion(province);
            regionVoList.add(vo);
            ArrayList<RegionEntity> list = new ArrayList<RegionEntity>();
            for (RegionEntity city : cityList) {
                if (!city.getRegionParentId().equals(province.getRegionId())) continue;
                list.add(city);
            }
            vo.setSubRegionList(list);
        }
        return regionVoList;
    }
}

