/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.service.impl;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.framework.common.PageResult;
import com.ebaiyihui.sysinfo.common.entity.AccountRoleInfoEntity;
import com.ebaiyihui.sysinfo.common.entity.MenuInfoEntity;
import com.ebaiyihui.sysinfo.common.entity.MenuPermissionsInfoEntity;
import com.ebaiyihui.sysinfo.common.entity.RoleInfoEntity;
import com.ebaiyihui.sysinfo.common.vo.MenuInfoVo;
import com.ebaiyihui.sysinfo.common.vo.RolePermissionVo;
import com.ebaiyihui.sysinfo.server.common.CommonConstant;
import com.ebaiyihui.sysinfo.server.dao.AccountRoleInfoMapper;
import com.ebaiyihui.sysinfo.server.dao.HospitalPermissionsInfoMapper;
import com.ebaiyihui.sysinfo.server.dao.MenuPermissionsInfoMapper;
import com.ebaiyihui.sysinfo.server.dao.RoleInfoMapper;
import com.ebaiyihui.sysinfo.server.exception.RoleException;
import com.ebaiyihui.sysinfo.server.service.MenuInfoService;
import com.ebaiyihui.sysinfo.server.service.RoleService;
import com.ebaiyihui.sysinfo.server.vo.RoleInfoVo;
import com.ebaiyihui.sysinfo.server.vo.SearchParamVo;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class RoleServiceImpl
implements RoleService {
    private static final Logger log = LoggerFactory.getLogger(RoleServiceImpl.class);
    @Autowired
    private RoleInfoMapper roleInfoMapper;
    @Autowired
    private MenuPermissionsInfoMapper menuPermissionsInfoMapper;
    @Autowired
    private HospitalPermissionsInfoMapper hospitalPermissionsInfoMapper;
    @Autowired
    private AccountRoleInfoMapper accountRoleInfoMapper;
    @Autowired
    private MenuInfoService menuInfoService;

    public List<RoleInfoEntity> getAllRoleByAccountType(String accountType) {
        List roleInfoEntityList = this.roleInfoMapper.selectRoleListByAccountType(accountType);
        return roleInfoEntityList;
    }

    public RolePermissionVo getMenuInfoPermissionByRoleId(Long roleId) {
        RolePermissionVo rolePermissionVo = new RolePermissionVo();
        RoleInfoEntity roleInfoEntity = this.roleInfoMapper.selectById(roleId);
        rolePermissionVo.setRoleId(roleId);
        rolePermissionVo.setRoleName(roleInfoEntity.getName());
        if (roleId == -1L) {
            String menuList = this.menuInfoService.getWebSuperManagerMenuInfoList();
            rolePermissionVo.setMenuList(menuList);
            return rolePermissionVo;
        }
        List parentMenuPermissionsInfoEntities = this.menuPermissionsInfoMapper.selectParentMenuPermissionsByRoleId(roleId);
        String menuList = this.convertMenuPermissionListToJsonPattern(parentMenuPermissionsInfoEntities);
        rolePermissionVo.setMenuList(menuList);
        return rolePermissionVo;
    }

    private String convertMenuPermissionListToJsonPattern(List<MenuPermissionsInfoEntity> parentMenuPermissionsInfoEntities) {
        if (CollectionUtils.isEmpty(parentMenuPermissionsInfoEntities)) {
            return "";
        }
        List menuList = parentMenuPermissionsInfoEntities.stream().map(parentMenuPermissionsInfoEntity -> {
            MenuInfoVo menuInfoVo = new MenuInfoVo();
            MenuInfoEntity menuInfoEntity = this.menuInfoService.selectMenuInfoById(parentMenuPermissionsInfoEntity.getMenuId());
            BeanUtils.copyProperties((Object)menuInfoEntity, (Object)menuInfoVo);
            menuInfoVo.setIsCheck(parentMenuPermissionsInfoEntity.getIsCheck());
            List childrenMenuPermissionsInfoEntityList = this.menuPermissionsInfoMapper.selectByParentIdAndRoleId(parentMenuPermissionsInfoEntity.getMenuId(), parentMenuPermissionsInfoEntity.getRoleId());
            if (!CollectionUtils.isEmpty((Collection)childrenMenuPermissionsInfoEntityList)) {
                List childrenMenuInfoEntityList = childrenMenuPermissionsInfoEntityList.stream().map(menuPermissionsInfoEntity -> {
                    MenuInfoEntity menuInfo = this.menuInfoService.selectMenuInfoById(menuPermissionsInfoEntity.getMenuId());
                    menuInfo.setIsCheck(menuPermissionsInfoEntity.getIsCheck());
                    return menuInfo;
                }).collect(Collectors.toList());
                childrenMenuInfoEntityList = childrenMenuInfoEntityList.stream().sorted(Comparator.comparing(MenuInfoEntity::getOrderNumber)).collect(Collectors.toList());
                menuInfoVo.setItemGroup(childrenMenuInfoEntityList);
            }
            return menuInfoVo;
        }).collect(Collectors.toList());
        menuList = menuList.stream().sorted(Comparator.comparing(MenuInfoEntity::getOrderNumber)).collect(Collectors.toList());
        return JSON.toJSONString(menuList);
    }

    public RolePermissionVo getAllPermissionByAccountViewId(String accountViewId) {
        AccountRoleInfoEntity accountRoleInfoEntity = this.accountRoleInfoMapper.selectAccountRoleInfoByAccountViewId(accountViewId);
        Long roleId = accountRoleInfoEntity.getRoleId();
        RolePermissionVo rolePermissionVo = this.getMenuInfoPermissionByRoleId(roleId);
        List hospitalPermissionsVoList = this.hospitalPermissionsInfoMapper.selectHospitalPermissionsVoByAccountViewId(accountRoleInfoEntity.getAccountViewId());
        rolePermissionVo.setHospitalPermissionsVoList(hospitalPermissionsVoList);
        return rolePermissionVo;
    }

    public void updateSuperAdminUserPermissionBySuperAdminViewId(Long roleId, String accountViewId) {
        this.accountRoleInfoMapper.updateRoleIdByAccountViewId(roleId, accountViewId);
    }

    public PageResult<List<RoleInfoEntity>> getAllRolePageBySearchParam(SearchParamVo searchParamVo, Integer pageNum, Integer pageSize) {
        PageHelper.startPage((int)pageNum, (int)pageSize);
        Page page = this.roleInfoMapper.getAllRolePageBySearchParam(searchParamVo);
        PageResult pageResult = new PageResult();
        pageResult.setTotal(page.getTotal());
        pageResult.setPageData((Object)page.getResult());
        return pageResult;
    }

    public void updateMenuPermissionInfoByRoleId(RoleInfoVo roleInfoVo) {
        List menuPermissionsInfoEntityList = roleInfoVo.getMenuPermissionsInfoEntityList();
        menuPermissionsInfoEntityList.stream().forEach(menuPermissionsInfoEntity -> this.menuPermissionsInfoMapper.updateIsCheckByRoleIdAndMenuId(menuPermissionsInfoEntity.getIsCheck(), menuPermissionsInfoEntity.getRoleId(), menuPermissionsInfoEntity.getMenuId()));
    }

    public void saveRoleMenuPermissionInfo(RoleInfoVo roleInfoVo) throws RoleException {
        RoleInfoEntity roleInfoEntity = this.roleInfoMapper.selectAccountRoleInfoByName(roleInfoVo.getName());
        if (roleInfoEntity != null) {
            throw new RoleException("\u89d2\u8272\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u521b\u5efa");
        }
        roleInfoEntity = new RoleInfoEntity();
        BeanUtils.copyProperties((Object)roleInfoVo, (Object)roleInfoEntity);
        roleInfoEntity.setStatus(Integer.valueOf(1));
        this.roleInfoMapper.insertSelective(roleInfoEntity);
        List menuPermissionsInfoEntityList = roleInfoVo.getMenuPermissionsInfoEntityList();
        if (!CollectionUtils.isEmpty((Collection)menuPermissionsInfoEntityList)) {
            this.batchSaveMenuPermissionsInfoEntity(roleInfoEntity.getId(), menuPermissionsInfoEntityList);
        }
    }

    public void batchSaveMenuPermissionsInfoEntity(Long roleId, List<MenuPermissionsInfoEntity> menuPermissionsInfoEntityList) {
        if (menuPermissionsInfoEntityList != null && !menuPermissionsInfoEntityList.isEmpty()) {
            menuPermissionsInfoEntityList = menuPermissionsInfoEntityList.stream().map(menuPermissionsInfoEntity -> {
                menuPermissionsInfoEntity.setStatus(CommonConstant.VALID_STATUS);
                menuPermissionsInfoEntity.setRoleId(roleId);
                return menuPermissionsInfoEntity;
            }).collect(Collectors.toList());
            this.menuPermissionsInfoMapper.batchInsert(menuPermissionsInfoEntityList);
        }
    }

    public void deleteRoleInfo(Long roleId) throws RoleException {
        List accountRoleInfoEntities = this.accountRoleInfoMapper.selectAccountRoleInfoByRoleId(roleId);
        if (accountRoleInfoEntities != null && !accountRoleInfoEntities.isEmpty()) {
            throw new RoleException("\u8be5\u89d2\u8272\u6b63\u5728\u4f7f\u7528\uff0c\u65e0\u6cd5\u5220\u9664");
        }
        this.roleInfoMapper.deleteById(roleId);
    }
}

