/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.sysinfo.server.utils;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.sysinfo.common.IdcardAuditEntity;
import com.ebaiyihui.sysinfo.server.utils.HttpUtil;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
public class IdCardUtil {
    private static final Logger log = LoggerFactory.getLogger(IdCardUtil.class);
    private static String host = "http://idcard3.market.alicloudapi.com";
    private static String path = "/idcardAudit";
    private static String method = "GET";
    private static String appcode;

    @Value(value="${idcard.appcode}")
    public void setAppcode(String appcode) {
        IdCardUtil.appcode = appcode;
    }

    public static String verifyIdWithName(String idcard, String name) {
        log.info("==============\u5f00\u59cb\u8fdb\u5165\u8eab\u4efd\u8bc1\u6821\u9a8c==================");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Authorization", "APPCODE " + appcode);
        HashMap<String, String> querys = new HashMap<String, String>();
        querys.put("idcard", idcard);
        querys.put("name", name);
        try {
            HttpResponse response = HttpUtil.doGet((String)host, (String)path, (String)method, headers, querys);
            log.info("============\u6821\u9a8c\u5b8c\u6210====================");
            String entityString = EntityUtils.toString((HttpEntity)response.getEntity());
            System.out.println(entityString);
            return entityString;
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("============\u8eab\u4efd\u8bc1\u6821\u9a8c\u51fa\u9519===================");
            return null;
        }
    }

    public static IdcardAuditEntity jsonToEntity(String str) {
        HashMap hashMap = (HashMap)JSON.parseObject((String)str, HashMap.class);
        IdcardAuditEntity entity = (IdcardAuditEntity)JSON.parseObject((String)hashMap.get("showapi_res_body").toString(), IdcardAuditEntity.class);
        return entity;
    }

    public static void main(String[] args) {
        String str = "{\n  \"showapi_res_code\": 0,\n  \"showapi_res_error\": \"\",\n  \"showapi_res_body\": {\n    \"code\": \"0\",\n    \"msg\": \"\u5339\u914d\",\n    \"address\": \"\u6e56\u5357\u7701\u6e58\u897f\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde\u6cf8\u6eaa\u53bf\",\n    \"birthday\": \"1991-06-10\",\n    \"sex\": \"M\",\n    \"error\": \"\",\n    \"ret_code\": \"0\"\n  }\n}";
        System.out.println(IdCardUtil.jsonToEntity((String)str));
    }

    public static Map<String, String> getBirAgeSex(String certificateNo) {
        int x;
        String birthday = "";
        String age = "";
        String sexCode = "";
        int year = Calendar.getInstance().get(1);
        char[] number = certificateNo.toCharArray();
        boolean flag = true;
        if (number.length == 15) {
            for (x = 0; x < number.length; ++x) {
                if (!flag) {
                    return new HashMap<String, String>();
                }
                flag = Character.isDigit(number[x]);
            }
        } else if (number.length == 18) {
            for (x = 0; x < number.length - 1; ++x) {
                if (!flag) {
                    return new HashMap<String, String>();
                }
                flag = Character.isDigit(number[x]);
            }
        }
        if (flag && certificateNo.length() == 15) {
            birthday = "19" + certificateNo.substring(6, 8) + "-" + certificateNo.substring(8, 10) + "-" + certificateNo.substring(10, 12);
            sexCode = Integer.parseInt(certificateNo.substring(certificateNo.length() - 3, certificateNo.length())) % 2 == 0 ? "F" : "M";
            age = year - Integer.parseInt("19" + certificateNo.substring(6, 8)) + "";
        } else if (flag && certificateNo.length() == 18) {
            birthday = certificateNo.substring(6, 10) + "-" + certificateNo.substring(10, 12) + "-" + certificateNo.substring(12, 14);
            sexCode = Integer.parseInt(certificateNo.substring(certificateNo.length() - 4, certificateNo.length() - 1)) % 2 == 0 ? "F" : "M";
            age = year - Integer.parseInt(certificateNo.substring(6, 10)) + "";
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("birthday", birthday);
        map.put("age", age);
        map.put("sexCode", sexCode);
        return map;
    }
}

