/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hisfront.service.impl;

import cn.hutool.core.util.IdcardUtil;
import cn.hutool.json.JSONArray;
import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.hisfront.service.ICardService;
import com.ebaiyihui.hisfront.utils.DobUtils;
import com.ebaiyihui.hisfront.utils.HttpUtils;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.card.QueryCardInfoReqVO;
import his.pojo.vo.card.QueryCardInfoResVO;
import his.pojo.vo.card.RegisteredCardReqVO;
import his.pojo.vo.card.RegisteredCardResVO;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CardServiceImpl
implements ICardService {
    private static final Logger log = LoggerFactory.getLogger(CardServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";

    public FrontResponse<RegisteredCardResVO> registerCard(FrontRequest<RegisteredCardReqVO> param) {
        log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            RegisteredCardReqVO body = (RegisteredCardReqVO)param.getBody();
            HashMap<String, String> creatPatientResultMapReq = new HashMap<String, String>();
            creatPatientResultMapReq.put("birthday", DobUtils.format((String)body.getCredNo().substring(6, 14)));
            creatPatientResultMapReq.put("cardType", "01");
            creatPatientResultMapReq.put("idenNo", body.getCredNo());
            creatPatientResultMapReq.put("name", body.getName());
            creatPatientResultMapReq.put("operCode", "4356");
            creatPatientResultMapReq.put("phone", body.getTelephone());
            creatPatientResultMapReq.put("sexDc", String.valueOf(IdcardUtil.getGenderByIdCard((String)body.getCredNo())).equals("1") ? "1" : "2");
            String post = HttpUtils.postNew((String)"https://hlw.cacah.com/sync//v1/pat/account/create", (String)com.alibaba.fastjson.JSONObject.toJSONString(creatPatientResultMapReq));
            log.info("\u5c31\u8bca\u5361\u6ce8\u518c\u51fa\u53c2====>>> " + post);
            JSONObject json = new JSONObject((Object)post);
            if (!SUCCESS_FLAG.equals(json.getStr((Object)"code"))) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)json.getStr((Object)"message"));
            }
            String cardNo = json.getJSONObject((Object)"data").getStr((Object)"cardNo");
            String patientId = json.getJSONObject((Object)"data").getStr((Object)"patientId");
            RegisteredCardResVO registeredCardResVO = new RegisteredCardResVO();
            registeredCardResVO.setCardNo(cardNo);
            registeredCardResVO.setPatientId(patientId);
            registeredCardResVO.setCardType("01");
            registeredCardResVO.setName(body.getName());
            registeredCardResVO.setTelephone(body.getTelephone());
            registeredCardResVO.setCredNo(body.getCredNo());
            registeredCardResVO.setAddress(IdcardUtil.getProvinceByIdCard((String)body.getCredNo()));
            registeredCardResVO.setDob(DobUtils.format((String)body.getCredNo().substring(6, 14)));
            registeredCardResVO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)body.getCredNo())).equals("1") ? "M" : "F");
            return FrontResponse.success((String)param.getTransactionId(), (Object)registeredCardResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38");
        }
    }

    public FrontResponse<RegisteredCardResVO> zlRegisterCard(FrontRequest<RegisteredCardReqVO> param) {
        log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            RegisteredCardReqVO body = (RegisteredCardReqVO)param.getBody();
            HashMap<String, Object> creatPatientResultMapReq = new HashMap<String, Object>();
            creatPatientResultMapReq.put("address", IdcardUtil.getProvinceByIdCard((String)body.getCredNo()));
            creatPatientResultMapReq.put("birthday", DobUtils.format((String)body.getCredNo().substring(6, 14)));
            creatPatientResultMapReq.put("cardType", "01");
            creatPatientResultMapReq.put("hosId", 61010800);
            creatPatientResultMapReq.put("idenNo", body.getCredNo());
            creatPatientResultMapReq.put("name", body.getName());
            creatPatientResultMapReq.put("national", "1");
            creatPatientResultMapReq.put("operCode", "HLWYY");
            creatPatientResultMapReq.put("pactCode", "1");
            creatPatientResultMapReq.put("password", body.getCredNo().substring(12, 18));
            creatPatientResultMapReq.put("payType", "01");
            creatPatientResultMapReq.put("phone", body.getTelephone());
            creatPatientResultMapReq.put("professionDc", "24");
            creatPatientResultMapReq.put("sexDc", String.valueOf(IdcardUtil.getGenderByIdCard((String)body.getCredNo())).equals("1") ? "1" : "2");
            String post = HttpUtils.postNew((String)"https://gateway-sxszlyy-prod.swiftcare.cn/sync//v1/pat/account/create", (String)com.alibaba.fastjson.JSONObject.toJSONString(creatPatientResultMapReq));
            log.info("\u5c31\u8bca\u5361\u6ce8\u518c\u51fa\u53c2====>>> " + post);
            JSONObject json = new JSONObject((Object)post);
            if (!SUCCESS_FLAG.equals(json.getStr((Object)"code"))) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)json.getStr((Object)"message"));
            }
            String cardNo = json.getJSONObject((Object)"data").getStr((Object)"cardNo");
            String patientId = json.getJSONObject((Object)"data").getStr((Object)"markNo");
            RegisteredCardResVO registeredCardResVO = new RegisteredCardResVO();
            registeredCardResVO.setCardNo(cardNo);
            registeredCardResVO.setPatientId(patientId);
            registeredCardResVO.setCardType("01");
            registeredCardResVO.setName(body.getName());
            registeredCardResVO.setTelephone(body.getTelephone());
            registeredCardResVO.setCredNo(body.getCredNo());
            registeredCardResVO.setAddress(IdcardUtil.getProvinceByIdCard((String)body.getCredNo()));
            registeredCardResVO.setDob(DobUtils.format((String)body.getCredNo().substring(6, 14)));
            registeredCardResVO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)body.getCredNo())).equals("1") ? "M" : "F");
            return FrontResponse.success((String)param.getTransactionId(), (Object)registeredCardResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u6ce8\u518c\u5c31\u8bca\u5361\u5f02\u5e38");
        }
    }

    public FrontResponse<QueryCardInfoResVO> queryCardInfo(FrontRequest<QueryCardInfoReqVO> param) {
        log.info("\u6839\u636e\u8eab\u4efd\u8bc1\u67e5\u8be2\u5c31\u8bca\u5361\uff1a" + JSON.toJSONString(param));
        try {
            QueryCardInfoReqVO body = (QueryCardInfoReqVO)param.getBody();
            HashMap<String, String> queryPatientResultMapReq = new HashMap<String, String>();
            queryPatientResultMapReq.put("idenNo", body.getCredNo());
            queryPatientResultMapReq.put("name", body.getName());
            String url = null;
            if ("130215".equals(param.getOrganCode())) {
                url = "https://hlw.cacah.com/sync/";
            } else if ("130214".equals(param.getOrganCode())) {
                url = "https://gateway-sxszlyy-prod.swiftcare.cn/sync/";
            } else {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u5b9a\u4f4d\u5230\u533b\u9662");
            }
            log.info("0101-\u6839\u636e\u8eab\u4efd\u8bc1\u67e5\u8be2\u5c31\u8bca\u5361\u5165\u53c2====>>> {} ", queryPatientResultMapReq);
            String querypost = HttpUtils.postNew((String)(url + "v1/pat/card/list?idenno=" + body.getCredNo() + "&name=" + body.getName()), (String)com.alibaba.fastjson.JSONObject.toJSONString(queryPatientResultMapReq));
            log.info("0101-\u6839\u636e\u8eab\u4efd\u8bc1\u67e5\u8be2\u5c31\u8bca\u5361====>>> " + querypost);
            JSONObject json = new JSONObject((Object)querypost);
            if (!SUCCESS_FLAG.equals(json.getStr((Object)"code"))) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)json.getStr((Object)"message"));
            }
            JSONArray dataJsonArray = json.getJSONArray((Object)"data");
            JSONObject dataObject = (JSONObject)dataJsonArray.get(0);
            QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
            queryCardInfoResVO.setCardNo(dataObject.getStr((Object)"cardNo"));
            queryCardInfoResVO.setPatientId(dataObject.getStr((Object)"markNo"));
            queryCardInfoResVO.setCredType("01");
            queryCardInfoResVO.setCardType("1702");
            queryCardInfoResVO.setTelephone("");
            queryCardInfoResVO.setCredNo(body.getCredNo());
            queryCardInfoResVO.setAddress(IdcardUtil.getProvinceByIdCard((String)body.getCredNo()));
            queryCardInfoResVO.setDob(DobUtils.format((String)body.getCredNo().substring(6, 14)));
            queryCardInfoResVO.setSex(String.valueOf(IdcardUtil.getGenderByIdCard((String)body.getCredNo())).equals("1") ? "M" : "F");
            queryCardInfoResVO.setName(body.getName());
            return FrontResponse.success((String)param.getTransactionId(), (Object)queryCardInfoResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u5c31\u8bca\u5361\u5f02\u5e38");
        }
    }

    public FrontResponse<QueryCardInfoResVO> queryCardInfoNew(FrontRequest<QueryCardInfoReqVO> param) {
        log.info("\u6839\u636e\u5361\u53f7\u67e5\u8be2\u5c31\u8bca\u5361\uff1a" + JSON.toJSONString(param));
        try {
            QueryCardInfoReqVO body = (QueryCardInfoReqVO)param.getBody();
            HashMap<String, String> queryPatientByCardNoMapReq = new HashMap<String, String>();
            queryPatientByCardNoMapReq.put("cardno", body.getCardNo());
            String url = null;
            if ("130215".equals(param.getOrganCode())) {
                url = "https://hlw.cacah.com/sync/";
            } else if ("130214".equals(param.getOrganCode())) {
                url = "https://gateway-sxszlyy-prod.swiftcare.cn/sync/";
            } else {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u5b9a\u4f4d\u5230\u533b\u9662");
            }
            log.info("0103-\u6839\u636e\u5c31\u8bca\u5361\u53f7\u67e5\u8be2\u5c31\u8bca\u5361 IN====>>> {} ", queryPatientByCardNoMapReq);
            String queryPatientByCard = HttpUtils.postNew((String)(url + "/v1/pat/info/get?cardno=" + body.getCardNo()), (String)com.alibaba.fastjson.JSONObject.toJSONString(queryPatientByCardNoMapReq));
            log.info("0103-\u6839\u636e\u5c31\u8bca\u5361\u53f7\u67e5\u8be2\u5c31\u8bca\u5361 OUT====>>> " + queryPatientByCard);
            JSONObject json = new JSONObject((Object)queryPatientByCard);
            if (!SUCCESS_FLAG.equals(json.getStr((Object)"code"))) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)json.getStr((Object)"message"));
            }
            JSONObject dataObject = json.getJSONObject((Object)"data");
            QueryCardInfoResVO queryCardInfoResVO = new QueryCardInfoResVO();
            queryCardInfoResVO.setCardNo(dataObject.getStr((Object)"cardNo"));
            if ("130215".equals(param.getOrganCode())) {
                queryCardInfoResVO.setPatientId(dataObject.getStr((Object)"patientId"));
                queryCardInfoResVO.setCredNo(dataObject.getStr((Object)"idNo"));
            } else if ("130214".equals(param.getOrganCode())) {
                queryCardInfoResVO.setPatientId(dataObject.getStr((Object)"markNo"));
                queryCardInfoResVO.setCredNo(dataObject.getStr((Object)"cardNo"));
            }
            queryCardInfoResVO.setTelephone(dataObject.getStr((Object)"phone"));
            queryCardInfoResVO.setName(dataObject.getStr((Object)"name"));
            return FrontResponse.success((String)param.getTransactionId(), (Object)queryCardInfoResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u5c31\u8bca\u5361\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u5c31\u8bca\u5361\u5f02\u5e38");
        }
    }
}

