/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hisfront.service.impl;

import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.hisfront.service.HospitalizationService;
import com.ebaiyihui.hisfront.utils.DataUtils;
import com.ebaiyihui.hisfront.utils.HttpUtils;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.dto.GetIPDepositRecordsItem;
import his.pojo.vo.dto.GetIPDepositRecordsResDTO;
import his.pojo.vo.dto.GetInpAdmissionResDTO;
import his.pojo.vo.dto.GetOrdItemsDTO;
import his.pojo.vo.dto.GetOrdItemsDetailDTO;
import his.pojo.vo.dto.GetOrdItemsResDTO;
import his.pojo.vo.hospitalization.DepositReq;
import his.pojo.vo.hospitalization.DepositRes;
import his.pojo.vo.hospitalization.GetIPDepositRecordsReq;
import his.pojo.vo.hospitalization.GetIPDepositRecordsRes;
import his.pojo.vo.hospitalization.GetInpAdmissionReq;
import his.pojo.vo.hospitalization.GetInpAdmissionRes;
import his.pojo.vo.hospitalization.GetOrdItemsReq;
import his.pojo.vo.hospitalization.GetOrdItemsRes;
import his.pojo.vo.hospitalization.items.GetIPDepositRecordsItems;
import his.pojo.vo.hospitalization.items.GetInpAdmissionResItems;
import his.pojo.vo.hospitalization.items.GetOrdItemsResItems;
import his.pojo.vo.hospitalization.items.GetOrdItemsResItemsDetail;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class HospitalizationServiceImpl
implements HospitalizationService {
    private static final Logger log = LoggerFactory.getLogger(HospitalizationServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";
    public static final String SUCCESS_MESSAGE = "true";

    public FrontResponse<GetInpAdmissionRes> getInpAdmission(FrontRequest<GetInpAdmissionReq> param) {
        log.info("\u67e5\u8be2\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetInpAdmissionReq body = (GetInpAdmissionReq)param.getBody();
            HashMap<String, Object> queryHosRecordMapReq = new HashMap<String, Object>();
            queryHosRecordMapReq.put("cardNos", body.getCardNo());
            queryHosRecordMapReq.put("name", "");
            queryHosRecordMapReq.put("idenNo", body.getCredNo());
            queryHosRecordMapReq.put("size", 999);
            queryHosRecordMapReq.put("page", 0);
            queryHosRecordMapReq.put("inDate", "");
            queryHosRecordMapReq.put("outDate", "");
            String url = null;
            if ("130215".equals(param.getOrganCode())) {
                url = "https://hlw.cacah.com/sync/";
            } else if ("130214".equals(param.getOrganCode())) {
                url = "https://gateway-sxszlyy-prod.swiftcare.cn/sync/";
            } else {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u5b9a\u4f4d\u5230\u533b\u9662");
            }
            log.info("\u30100701\u3011-\u6839\u636e\u5361\u53f7\u6216\u8eab\u4efd\u8bc1\u53f7\u67e5\u8be2\u4f4f\u9662\u8bb0\u5f55 IN====>>> {}", queryHosRecordMapReq);
            String queryHosRecordMapRes = HttpUtils.postNew((String)(url + "/v1/doc/inp/record"), (String)com.alibaba.fastjson.JSONObject.toJSONString(queryHosRecordMapReq));
            log.info("\u30100701\u3011-\u6839\u636e\u5361\u53f7\u6216\u8eab\u4efd\u8bc1\u53f7\u67e5\u8be2\u4f4f\u9662\u8bb0\u5f55 OUT====>>> " + queryHosRecordMapRes);
            GetInpAdmissionResDTO response = (GetInpAdmissionResDTO)JSON.parseObject((String)queryHosRecordMapRes, GetInpAdmissionResDTO.class);
            log.info("\u6839\u636e\u5361\u53f7\u6216\u8eab\u4efd\u8bc1\u53f7\u67e5\u8be2\u4f4f\u9662\u8bb0\u5f55 parseObject\u8f6c\u6362\u540e\u51fa\u53c2====>>> " + com.alibaba.fastjson.JSONObject.toJSONString((Object)response));
            if (!SUCCESS_FLAG.equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            List models = response.getData().getModels();
            if ("130215".equals(param.getOrganCode())) {
                models.removeIf(o -> !o.getInState().equals("1"));
            } else if ("130214".equals(param.getOrganCode())) {
                models.removeIf(o -> !o.getInState().equals(SUCCESS_FLAG));
            }
            log.info("\u6839\u636e\u5361\u53f7\u6216\u8eab\u4efd\u8bc1\u53f7\u67e5\u8be2\u4f4f\u9662\u8bb0\u5f55 -\u53bb\u9664\u5df2\u7ecf\u51fa\u9662\u8bb0\u5f55====>>> " + com.alibaba.fastjson.JSONObject.toJSONString((Object)models));
            GetInpAdmissionRes getInpAdmissionRes = new GetInpAdmissionRes();
            ArrayList GetInpAdmissionResItemsItem = new ArrayList();
            models.stream().forEach(dateItem -> {
                GetInpAdmissionResItems getInpAdmissionResItems = new GetInpAdmissionResItems();
                getInpAdmissionResItems.setDeptName(dateItem.getDeptName());
                getInpAdmissionResItems.setBed(dateItem.getBedNo());
                getInpAdmissionResItems.setDeptCode(dateItem.getDeptCode());
                getInpAdmissionResItems.setDocName(dateItem.getChargeDocName());
                getInpAdmissionResItems.setDocCode(dateItem.getChargeDocName());
                getInpAdmissionResItems.setCardNo(body.getCardNo());
                getInpAdmissionResItems.setDiagnoseResult(dateItem.getClinicDiagnose());
                getInpAdmissionResItems.setPatientId(dateItem.getPatientNo());
                getInpAdmissionResItems.setCaseDesc(dateItem.getClinicDiagnose());
                getInpAdmissionResItems.setPatientAge(dateItem.getAge());
                getInpAdmissionResItems.setPatientName(dateItem.getName());
                getInpAdmissionResItems.setPatientSex(dateItem.getSex());
                getInpAdmissionResItems.setStartDate(dateItem.getInDate());
                getInpAdmissionResItems.setEndDate(dateItem.getOutDate());
                getInpAdmissionResItems.setInHospNo(dateItem.getInpatientNo());
                getInpAdmissionResItems.setInHospId(dateItem.getPatientNo());
                if ("130215".equals(param.getOrganCode())) {
                    BigDecimal totalMoney = new BigDecimal(dateItem.getChangeTotCost()).subtract(new BigDecimal(dateItem.getFreeCost()));
                    getInpAdmissionResItems.setTotalMoney(String.valueOf(totalMoney));
                    getInpAdmissionResItems.setDepost(dateItem.getChangeTotCost());
                }
                getInpAdmissionResItems.setCurrentMoney(dateItem.getFreeCost());
                GetInpAdmissionResItemsItem.add(getInpAdmissionResItems);
            });
            getInpAdmissionRes.setItems(GetInpAdmissionResItemsItem);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getInpAdmissionRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u8bf7\u6c42\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u8bf7\u6c42\u5f02\u5e38");
        }
    }

    public FrontResponse<DepositRes> deposit(FrontRequest<DepositReq> param) {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            DepositReq body = (DepositReq)param.getBody();
            HashMap<String, Object> inHosRechargeMapReq = new HashMap<String, Object>();
            inHosRechargeMapReq.put("cardNo", body.getCardNo());
            inHosRechargeMapReq.put("inpatientNo", body.getInHospNo());
            inHosRechargeMapReq.put("patientNo", body.getInHospId());
            inHosRechargeMapReq.put("tranNo", body.getRespmsg().getPosId());
            inHosRechargeMapReq.put("amt", body.getRespmsg().getAmount());
            String url = null;
            if ("130215".equals(param.getOrganCode())) {
                inHosRechargeMapReq.put("payMode", "\u652f\u4ed8\u5b9d");
                inHosRechargeMapReq.put("outPayNo", body.getRespmsg().getOrderid());
                url = "https://hlw.cacah.com/sync/";
            } else if ("130214".equals(param.getOrganCode())) {
                inHosRechargeMapReq.put("payMode", body.getPayChannel());
                inHosRechargeMapReq.put("exeFlag", "1");
                inHosRechargeMapReq.put("inDpcd", "1");
                inHosRechargeMapReq.put("printFlag", SUCCESS_FLAG);
                inHosRechargeMapReq.put("inDpcd", "");
                inHosRechargeMapReq.put("name", "");
                inHosRechargeMapReq.put("operCode", "HLWYY");
                inHosRechargeMapReq.put("receiptNo", body.getRespmsg().getOrderid());
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("userId", "");
                inHosRechargeMapReq.put("params", params);
                url = "https://gateway-sxszlyy-prod.swiftcare.cn/sync/";
            } else {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u5b9a\u4f4d\u5230\u533b\u9662");
            }
            log.info("\u30100808\u3011-\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c IN====>>> " + com.alibaba.fastjson.JSONObject.toJSONString(inHosRechargeMapReq));
            String inHosRechargeMapRes = HttpUtils.postNew((String)(url + "/v1/inpa/recharge"), (String)com.alibaba.fastjson.JSONObject.toJSONString(inHosRechargeMapReq));
            log.info("\u30100808\u3011-\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c OUT====>>> " + inHosRechargeMapRes);
            JSONObject json = new JSONObject((Object)inHosRechargeMapRes);
            if (!SUCCESS_FLAG.equals(json.getStr((Object)"code")) || !SUCCESS_MESSAGE.equals(json.getStr((Object)"success"))) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)json.getStr((Object)"message"));
            }
            DepositRes depositRes = new DepositRes();
            return FrontResponse.success((String)param.getTransactionId(), (Object)depositRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5f02\u5e38");
        }
    }

    public FrontResponse<GetIPDepositRecordsRes> getIPDepositRecords(FrontRequest<GetIPDepositRecordsReq> param) {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u67e5\u8be2\u5145\u503c\u8bb0\u5f55\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetIPDepositRecordsReq body = (GetIPDepositRecordsReq)param.getBody();
            HashMap<String, Object> queryHosRechargeRecordMapReq = new HashMap<String, Object>();
            queryHosRechargeRecordMapReq.put("inpatientNo", body.getInHospNo());
            queryHosRechargeRecordMapReq.put("patientNo", body.getInHospId());
            queryHosRechargeRecordMapReq.put("size", 9999);
            queryHosRechargeRecordMapReq.put("page", 0);
            String url = null;
            if ("130215".equals(param.getOrganCode())) {
                queryHosRechargeRecordMapReq.put("cardNo", body.getCardNo());
                url = "https://hlw.cacah.com/sync/";
            } else if ("130214".equals(param.getOrganCode())) {
                queryHosRechargeRecordMapReq.put("endDate", new SimpleDateFormat("yyyy-MM-dd").format(System.currentTimeMillis()));
                url = "https://gateway-sxszlyy-prod.swiftcare.cn/sync/";
            } else {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u5b9a\u4f4d\u5230\u533b\u9662");
            }
            log.info("\u30100802\u3011-\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u8bb0\u5f55\u67e5\u8be2 IN====>>> {}", queryHosRechargeRecordMapReq);
            String queryHosRechargeRecordMapRes = HttpUtils.postNew((String)(url + "/v1/inpa/recharge/query"), (String)com.alibaba.fastjson.JSONObject.toJSONString(queryHosRechargeRecordMapReq));
            log.info("\u30100802\u3011-\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u8bb0\u5f55\u67e5\u8be2 OUT====>>> " + queryHosRechargeRecordMapRes);
            GetIPDepositRecordsResDTO response = (GetIPDepositRecordsResDTO)JSON.parseObject((String)queryHosRechargeRecordMapRes, GetIPDepositRecordsResDTO.class);
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u8bb0\u5f55\u67e5\u8be2 parseObject\u8f6c\u6362\u540e\u51fa\u53c2====>>> " + com.alibaba.fastjson.JSONObject.toJSONString((Object)response));
            if (!SUCCESS_FLAG.equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            GetIPDepositRecordsRes getIPDepositRecordsRes = new GetIPDepositRecordsRes();
            ArrayList<GetIPDepositRecordsItems> items = new ArrayList<GetIPDepositRecordsItems>();
            List models = response.getData().getModels();
            for (GetIPDepositRecordsItem itemResDTO : models) {
                GetIPDepositRecordsItems getIPDepositRecordsItems = new GetIPDepositRecordsItems();
                getIPDepositRecordsItems.setPrePayDateTime(itemResDTO.getRechargeTime());
                if ("130214".equals(param.getOrganCode())) {
                    getIPDepositRecordsItems.setPrePayDateTime(DataUtils.dealDateFormat((String)itemResDTO.getOperDate()));
                }
                getIPDepositRecordsItems.setAmout(itemResDTO.getPrepayCost());
                getIPDepositRecordsItems.setPayChannel("\u652f\u4ed8\u5b9d\u652f\u4ed8");
                items.add(getIPDepositRecordsItems);
            }
            getIPDepositRecordsRes.setItems(items);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getIPDepositRecordsRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u67e5\u8be2\u5145\u503c\u8bb0\u5f55\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u4f4f\u9662\u9884\u4ea4\u91d1\u67e5\u8be2\u5145\u503c\u8bb0\u5f55\u5f02\u5e38");
        }
    }

    public FrontResponse<GetOrdItemsRes> getOrdItemsChangan(FrontRequest<GetOrdItemsReq> param) {
        log.info("\u957f\u5b89\u4f4f\u9662\u8d39\u7528\u6e05\u5355\u67e5\u8be2\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetOrdItemsReq body = (GetOrdItemsReq)param.getBody();
            HashMap<String, Object> inHosRechargedetailMapReq = new HashMap<String, Object>();
            inHosRechargedetailMapReq.put("endDate", body.getEndDate());
            inHosRechargedetailMapReq.put("idenNo", "");
            inHosRechargedetailMapReq.put("inpatientNo", body.getInHospNo());
            inHosRechargedetailMapReq.put("page", 0);
            inHosRechargedetailMapReq.put("size", 999);
            inHosRechargedetailMapReq.put("startDate", body.getStartDate());
            inHosRechargedetailMapReq.put("userId", "");
            HashMap params = new HashMap();
            inHosRechargedetailMapReq.put("params", params);
            log.info("\u30100805\u3011-\u957f\u5b89\u5728\u9662\u60a3\u8005\u65e5\u6e05\u5355\u8be6\u60c5\u5217\u8868 IN====>>> " + com.alibaba.fastjson.JSONObject.toJSONString(inHosRechargedetailMapReq));
            String inHosRechargedetailMapRes = HttpUtils.postNew((String)"https://hlw.cacah.com/sync//v1/inpa/daily/detail", (String)com.alibaba.fastjson.JSONObject.toJSONString(inHosRechargedetailMapReq));
            log.info("\u30100805\u3011-\u957f\u5b89\u5728\u9662\u60a3\u8005\u65e5\u6e05\u5355\u8be6\u60c5\u5217\u8868 OUT====>>> " + inHosRechargedetailMapRes);
            GetOrdItemsResDTO response = (GetOrdItemsResDTO)JSON.parseObject((String)inHosRechargedetailMapRes, GetOrdItemsResDTO.class);
            log.info("\u957f\u5b89\u5728\u9662\u60a3\u8005\u65e5\u6e05\u5355\u8be6\u60c5\u5217\u8868 parseObject\u8f6c\u6362\u540e\u51fa\u53c2====>>> " + com.alibaba.fastjson.JSONObject.toJSONString((Object)response));
            if (!SUCCESS_FLAG.equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            GetOrdItemsRes getOrdItemsRes = new GetOrdItemsRes();
            ArrayList<GetOrdItemsResItems> getOrdItemsResItemsList = new ArrayList<GetOrdItemsResItems>();
            List data = response.getData();
            for (GetOrdItemsDTO itemResDTO : data) {
                GetOrdItemsResItems getOrdItemsResItems2 = new GetOrdItemsResItems();
                getOrdItemsResItems2.setTotFee(itemResDTO.getTotFee());
                getOrdItemsResItems2.setTypeName(itemResDTO.getTypeName());
                List itemResDTODetail = itemResDTO.getDetail();
                ArrayList<GetOrdItemsResItemsDetail> detail = new ArrayList<GetOrdItemsResItemsDetail>();
                for (GetOrdItemsDetailDTO ordItemsDetail : itemResDTODetail) {
                    GetOrdItemsResItemsDetail GetOrdItemsResItemsDetail2 = new GetOrdItemsResItemsDetail();
                    GetOrdItemsResItemsDetail2.setFeeType(ordItemsDetail.getClassOnInpRcpt());
                    GetOrdItemsResItemsDetail2.setItmMastName(ordItemsDetail.getItemName());
                    GetOrdItemsResItemsDetail2.setQty(ordItemsDetail.getAmount());
                    GetOrdItemsResItemsDetail2.setPrice(ordItemsDetail.getItemPrice());
                    GetOrdItemsResItemsDetail2.setAmount(ordItemsDetail.getCharges());
                    GetOrdItemsResItemsDetail2.setUomDesc(ordItemsDetail.getUnits());
                    GetOrdItemsResItemsDetail2.setFeeDate(ordItemsDetail.getBillingDateTime());
                    detail.add(GetOrdItemsResItemsDetail2);
                }
                getOrdItemsResItems2.setDetail(detail);
                getOrdItemsResItemsList.add(getOrdItemsResItems2);
            }
            List amountList = getOrdItemsResItemsList.stream().map(getOrdItemsResItems -> new BigDecimal(getOrdItemsResItems.getTotFee())).collect(Collectors.toList());
            log.info("\u5904\u7406\u540e\u4f4f\u9662\u8d39\u7528\u6e05\u5355\u8fd4\u56de\u503c\u4e3a:{}", getOrdItemsResItemsList);
            BigDecimal totalMoney = new BigDecimal(SUCCESS_FLAG);
            for (BigDecimal amount : amountList) {
                totalMoney = totalMoney.add(amount);
            }
            getOrdItemsRes.setTotalMoney(String.valueOf(totalMoney));
            getOrdItemsRes.setInHospNo(((GetOrdItemsReq)param.getBody()).getInHospNo());
            getOrdItemsRes.setOrdItem(getOrdItemsResItemsList);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getOrdItemsRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u957f\u5b89\u4f4f\u9662\u8d39\u7528\u6e05\u5355\u67e5\u8be2\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u957f\u5b89\u4f4f\u9662\u8d39\u7528\u6e05\u5355\u67e5\u8be2\u5f02\u5e38");
        }
    }

    public FrontResponse<GetOrdItemsRes> getOrdItemsZhongLiu(FrontRequest<GetOrdItemsReq> param) {
        log.info("\u80bf\u7624\u4f4f\u9662\u8d39\u7528\u6e05\u5355\u67e5\u8be2\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetOrdItemsReq body = (GetOrdItemsReq)param.getBody();
            HashMap<String, Object> inHosRechargedetailMapReq = new HashMap<String, Object>();
            inHosRechargedetailMapReq.put("endDate", body.getEndDate() + " 23:59:59");
            inHosRechargedetailMapReq.put("idenNo", body.getCredNo());
            inHosRechargedetailMapReq.put("inpatientNo", body.getInHospNo());
            inHosRechargedetailMapReq.put("page", 0);
            inHosRechargedetailMapReq.put("size", 999);
            inHosRechargedetailMapReq.put("startDate", body.getStartDate() + " 00:00:00");
            log.info("\u30100805\u3011-\u80bf\u7624\u5728\u9662\u60a3\u8005\u65e5\u6e05\u5355\u8be6\u60c5\u5217\u8868 IN====>>> " + com.alibaba.fastjson.JSONObject.toJSONString(inHosRechargedetailMapReq));
            String inHosRechargedetailMapRes = HttpUtils.postNew((String)"https://gateway-sxszlyy-prod.swiftcare.cn/sync//v1/inpa/daily/detail", (String)com.alibaba.fastjson.JSONObject.toJSONString(inHosRechargedetailMapReq));
            log.info("\u30100805\u3011-\u80bf\u7624\u5728\u9662\u60a3\u8005\u65e5\u6e05\u5355\u8be6\u60c5\u5217\u8868 OUT====>>> " + inHosRechargedetailMapRes);
            GetOrdItemsResDTO response = (GetOrdItemsResDTO)JSON.parseObject((String)inHosRechargedetailMapRes, GetOrdItemsResDTO.class);
            log.info("\u80bf\u7624\u5728\u9662\u60a3\u8005\u65e5\u6e05\u5355\u8be6\u60c5\u5217\u8868 parseObject\u8f6c\u6362\u540e\u51fa\u53c2====>>> " + com.alibaba.fastjson.JSONObject.toJSONString((Object)response));
            if (!SUCCESS_FLAG.equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            GetOrdItemsRes getOrdItemsRes = new GetOrdItemsRes();
            ArrayList<GetOrdItemsResItems> getOrdItemsResItemsList = new ArrayList<GetOrdItemsResItems>();
            List data = response.getData();
            for (GetOrdItemsDTO itemResDTO : data) {
                GetOrdItemsResItems getOrdItemsResItems2 = new GetOrdItemsResItems();
                getOrdItemsResItems2.setTotFee(itemResDTO.getTotFee());
                getOrdItemsResItems2.setTypeName(itemResDTO.getTypeName());
                List itemResDTODetail = itemResDTO.getDetail();
                ArrayList<GetOrdItemsResItemsDetail> detail = new ArrayList<GetOrdItemsResItemsDetail>();
                for (GetOrdItemsDetailDTO ordItemsDetail : itemResDTODetail) {
                    GetOrdItemsResItemsDetail GetOrdItemsResItemsDetail2 = new GetOrdItemsResItemsDetail();
                    GetOrdItemsResItemsDetail2.setFeeType(ordItemsDetail.getTypeName());
                    GetOrdItemsResItemsDetail2.setItmMastName(ordItemsDetail.getName());
                    GetOrdItemsResItemsDetail2.setQty(ordItemsDetail.getQty());
                    GetOrdItemsResItemsDetail2.setPrice(ordItemsDetail.getUnitPrice());
                    GetOrdItemsResItemsDetail2.setAmount(ordItemsDetail.getTotCost());
                    GetOrdItemsResItemsDetail2.setUomDesc(ordItemsDetail.getCurrentUnit());
                    GetOrdItemsResItemsDetail2.setFeeDate(ordItemsDetail.getChargeDate());
                    detail.add(GetOrdItemsResItemsDetail2);
                }
                getOrdItemsResItems2.setDetail(detail);
                getOrdItemsResItemsList.add(getOrdItemsResItems2);
            }
            List amountList = getOrdItemsResItemsList.stream().map(getOrdItemsResItems -> new BigDecimal(getOrdItemsResItems.getTotFee())).collect(Collectors.toList());
            log.info("\u5904\u7406\u540e\u4f4f\u9662\u8d39\u7528\u6e05\u5355\u8fd4\u56de\u503c\u4e3a:{}", getOrdItemsResItemsList);
            BigDecimal totalMoney = new BigDecimal(SUCCESS_FLAG);
            for (BigDecimal amount : amountList) {
                totalMoney = totalMoney.add(amount);
            }
            getOrdItemsRes.setTotalMoney(String.valueOf(totalMoney));
            getOrdItemsRes.setInHospNo(((GetOrdItemsReq)param.getBody()).getInHospNo());
            getOrdItemsRes.setOrdItem(getOrdItemsResItemsList);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getOrdItemsRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u80bf\u7624\u4f4f\u9662\u8d39\u7528\u6e05\u5355\u67e5\u8be2\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u80bf\u7624\u4f4f\u9662\u8d39\u7528\u6e05\u5355\u67e5\u8be2\u5f02\u5e38");
        }
    }
}

