/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hisfront.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.ebaiyihui.hisfront.service.ScheduleService;
import com.ebaiyihui.hisfront.utils.HttpUtils;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.dto.GetDeptDoctorInfoResDTO;
import his.pojo.vo.dto.GetDeptScheduleResDTO;
import his.pojo.vo.dto.GetDocTimeItemDTO;
import his.pojo.vo.dto.GetScheduleItemDTO;
import his.pojo.vo.dto.GetScheduleResDTO;
import his.pojo.vo.schedule.GetDeptDoctorInfoReqVO;
import his.pojo.vo.schedule.GetDeptDoctorInfoResVO;
import his.pojo.vo.schedule.GetDeptScheduleReqVO;
import his.pojo.vo.schedule.GetDeptScheduleResVO;
import his.pojo.vo.schedule.GetScheduleReqVO;
import his.pojo.vo.schedule.GetScheduleResVO;
import his.pojo.vo.schedule.items.GetDeptDoctorInfoResItems;
import his.pojo.vo.schedule.items.GetDeptScheduleResItems;
import his.pojo.vo.schedule.items.GetScheduleResItems;
import his.pojo.vo.schedule.items.TimeArrangeItems;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    public static final String SUCCESS_FLAG = "0";

    public FrontResponse<GetDeptScheduleResVO> getDeptSchedule(FrontRequest<GetDeptScheduleReqVO> param) {
        log.info("\u67e5\u8be2\u79d1\u5ba4\u4fe1\u606f\u63a5\u53e3\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetDeptScheduleReqVO body = (GetDeptScheduleReqVO)param.getBody();
            HashMap<String, String> queryPaibanDeptMapReq = new HashMap<String, String>();
            queryPaibanDeptMapReq.put("hosId", "61011900");
            String url = null;
            if ("130215".equals(param.getOrganCode())) {
                url = "https://hlw.cacah.com/sync//v1/offclinic/schema/query/dept?hosId=61011900";
            } else if ("130214".equals(param.getOrganCode())) {
                url = "https://gateway-sxszlyy-prod.swiftcare.cn/sync//v1/offclinic/schema/query/dept?hosId=61010800";
            } else {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u5b9a\u4f4d\u5230\u533b\u9662");
            }
            log.info("0101-\u6839\u636e\u8eab\u4efd\u8bc1\u67e5\u8be2\u5c31\u8bca\u5361his\u5165\u53c2====>>> {} ", queryPaibanDeptMapReq);
            String queryPaibanDept = HttpUtils.postNew((String)url, (String)com.alibaba.fastjson.JSONObject.toJSONString(queryPaibanDeptMapReq));
            log.info("\u6839\u636e\u533b\u9662id\u67e5\u8be2\u4e00\u5468\u5185\u53ef\u6392\u73ed\u7684\u79d1\u5ba4his\u51fa\u53c2====>>> " + queryPaibanDept);
            JSONObject json = new JSONObject((Object)queryPaibanDept);
            if (!SUCCESS_FLAG.equals(json.getStr((Object)"code"))) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)json.getStr((Object)"message"));
            }
            GetDeptScheduleResDTO response = (GetDeptScheduleResDTO)JSON.parseObject((String)queryPaibanDept, GetDeptScheduleResDTO.class);
            List getDeptItemsResDTOList = response.getData();
            log.info("\u6839\u636e\u533b\u9662id\u67e5\u8be2\u4e00\u5468\u5185\u53ef\u6392\u73ed\u7684\u79d1\u5ba4-\u8f6c\u6362\u540e====>>> " + response);
            GetDeptScheduleResVO getDeptScheduleResVO = new GetDeptScheduleResVO();
            ArrayList getDeptScheduleResItems = new ArrayList();
            getDeptItemsResDTOList.stream().forEach(date -> {
                GetDeptScheduleResItems getDeptScheduleRes = new GetDeptScheduleResItems();
                getDeptScheduleRes.setDeptCode(date.getDeptCode());
                getDeptScheduleRes.setDeptName(date.getDeptName());
                getDeptScheduleRes.setDeptAddress(date.getHosId());
                getDeptScheduleResItems.add(getDeptScheduleRes);
            });
            getDeptScheduleResVO.setItems(getDeptScheduleResItems);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptScheduleResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u79d1\u5ba4\u4fe1\u606f\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u79d1\u5ba4\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public FrontResponse<GetDeptDoctorInfoResVO> getDeptDoctorInfo(FrontRequest<GetDeptDoctorInfoReqVO> param) {
        log.info("\u67e5\u8be2\u79d1\u5ba4\u6392\u73ed\u533b\u751f\u63a5\u53e3\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetDeptDoctorInfoReqVO body = (GetDeptDoctorInfoReqVO)param.getBody();
            GetDeptDoctorInfoResVO getDeptDoctorInfoResVO = new GetDeptDoctorInfoResVO();
            ArrayList getDeptDoctorInfoResItems = new ArrayList();
            getDeptDoctorInfoResVO.setItems(getDeptDoctorInfoResItems);
            HashMap<String, Object> queryPaibanDeptdetailMapReq = new HashMap<String, Object>();
            HashMap params = new HashMap();
            queryPaibanDeptdetailMapReq.put("deptCode", body.getDeptCode());
            queryPaibanDeptdetailMapReq.put("endTime", body.getEndTime());
            queryPaibanDeptdetailMapReq.put("startTime", body.getStartTime());
            queryPaibanDeptdetailMapReq.put("size", 999);
            queryPaibanDeptdetailMapReq.put("params", params);
            queryPaibanDeptdetailMapReq.put("page", 0);
            String url = null;
            if ("130215".equals(param.getOrganCode())) {
                queryPaibanDeptdetailMapReq.put("hosId", "61011900");
                url = "https://hlw.cacah.com/sync/";
            } else if ("130214".equals(param.getOrganCode())) {
                queryPaibanDeptdetailMapReq.put("hosId", "61010800");
                url = "https://gateway-sxszlyy-prod.swiftcare.cn/sync/";
            } else {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u5b9a\u4f4d\u5230\u533b\u9662");
            }
            log.info("0202-\u67e5\u8be2\u67d0\u4e2a\u79d1\u5ba4\u7684\u53ef\u6302\u53f7\u533b\u751f,\u6302\u53f7\u8d39,\u4ee5\u53ca\u53f7\u6e90\u60c5\u51b5 IN====>>> " + com.alibaba.fastjson.JSONObject.toJSONString(queryPaibanDeptdetailMapReq));
            String queryPaibandetailDept = HttpUtils.postNew((String)(url + "/v1/offclinic/schema/dept/detail"), (String)com.alibaba.fastjson.JSONObject.toJSONString(queryPaibanDeptdetailMapReq));
            log.info("0202-\u67e5\u8be2\u67d0\u4e2a\u79d1\u5ba4\u7684\u53ef\u6302\u53f7\u533b\u751f,\u6302\u53f7\u8d39,\u4ee5\u53ca\u53f7\u6e90\u60c5\u51b5 OUT====>>> " + queryPaibandetailDept);
            JSONObject json = new JSONObject((Object)queryPaibandetailDept);
            if (!SUCCESS_FLAG.equals(json.getStr((Object)"code"))) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)json.getStr((Object)"message"));
            }
            GetDeptDoctorInfoResDTO response = (GetDeptDoctorInfoResDTO)JSON.parseObject((String)queryPaibandetailDept, GetDeptDoctorInfoResDTO.class);
            List models = response.getData().getModels();
            if (models.size() <= 0) {
                return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptDoctorInfoResVO);
            }
            log.info("\u67e5\u8be2\u79d1\u5ba4\u6392\u73ed\u533b\u751f\u63a5\u53e3-\u8f6c\u6362\u540e====>>> " + response);
            models.stream().forEach(date -> {
                GetDeptDoctorInfoResItems getDeptDoctorInfoRes = new GetDeptDoctorInfoResItems();
                getDeptDoctorInfoRes.setDoctorTitle(date.getTitleDc());
                getDeptDoctorInfoRes.setDeptCode(date.getDeptCode());
                getDeptDoctorInfoRes.setDeptName(date.getDeptName());
                getDeptDoctorInfoRes.setDoctorDesc(date.getSpecial());
                getDeptDoctorInfoRes.setImage(date.getImage());
                getDeptDoctorInfoRes.setRegFee(date.getRegFee().toString());
                getDeptDoctorInfoRes.setDoctorCode(date.getDocCode());
                getDeptDoctorInfoRes.setDoctorName(date.getDocName());
                getDeptDoctorInfoRes.setScheduleDate(date.getScheduleDate().substring(0, 10));
                getDeptDoctorInfoResItems.add(getDeptDoctorInfoRes);
            });
            getDeptDoctorInfoResVO.setItems(getDeptDoctorInfoResItems);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getDeptDoctorInfoResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u79d1\u5ba4\u6392\u73ed\u533b\u751f\u4fe1\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u79d1\u5ba4\u6392\u73ed\u533b\u751f\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public FrontResponse<GetScheduleResVO> getSchedule(FrontRequest<GetScheduleReqVO> param) {
        log.info("\u67e5\u8be2\u533b\u751f\u6392\u73ed\u63a5\u53e3\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetScheduleReqVO body = (GetScheduleReqVO)param.getBody();
            HashMap<String, String> queryDoctorSchemaMapReq = new HashMap<String, String>();
            queryDoctorSchemaMapReq.put("deptCode", body.getLocCode());
            queryDoctorSchemaMapReq.put("docCode", body.getDocCode());
            queryDoctorSchemaMapReq.put("beginTime", body.getBgDate());
            queryDoctorSchemaMapReq.put("endTime", body.getEdDate());
            String url = null;
            if ("130215".equals(param.getOrganCode())) {
                url = "https://hlw.cacah.com/sync/";
            } else if ("130214".equals(param.getOrganCode())) {
                url = "https://gateway-sxszlyy-prod.swiftcare.cn/sync/";
            } else {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u672a\u5b9a\u4f4d\u5230\u533b\u9662");
            }
            log.info("0203-\u67e5\u8be2\u533b\u751f\u6392\u73ed\u4fe1\u606fhis IN====>>> {}", queryDoctorSchemaMapReq);
            String queryDoctorSchemaMapRes = HttpUtils.postNew((String)(url + "/v1/offclinic/schema/doc/info?beginTime=" + queryDoctorSchemaMapReq.get("beginTime") + "&endTime=" + queryDoctorSchemaMapReq.get("endTime") + "&deptCode=" + queryDoctorSchemaMapReq.get("deptCode") + "&docCode=" + queryDoctorSchemaMapReq.get("docCode")), (String)com.alibaba.fastjson.JSONObject.toJSONString(queryDoctorSchemaMapReq));
            log.info("0203--\u67e5\u8be2\u533b\u751f\u6392\u73ed\u4fe1\u606fhis OUT====>>> " + queryDoctorSchemaMapRes);
            JSONObject json = new JSONObject((Object)queryDoctorSchemaMapRes);
            if (!SUCCESS_FLAG.equals(json.getStr((Object)"code"))) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)json.getStr((Object)"message"));
            }
            GetScheduleResDTO response = (GetScheduleResDTO)JSON.parseObject((String)queryDoctorSchemaMapRes, GetScheduleResDTO.class);
            List responseData = response.getData();
            if (responseData.size() <= 0) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)json.getStr((Object)"message"));
            }
            GetScheduleResVO getScheduleResVO = new GetScheduleResVO();
            ArrayList GetScheduleItems = new ArrayList();
            responseData.stream().forEach(date -> {
                GetDocTimeItemDTO timeResponse;
                GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
                getScheduleResItems.setScheduleId(date.getScheduleId());
                getScheduleResItems.setAdmDate(date.getScheduleDate().substring(0, 10));
                getScheduleResItems.setLocCode(date.getDeptCode());
                getScheduleResItems.setLocName(date.getDeptName());
                getScheduleResItems.setDocCode(date.getDoctorCode());
                getScheduleResItems.setDocName(date.getDoctorName());
                getScheduleResItems.setScheduleLevelName(date.getRegLevName());
                getScheduleResItems.setRegFee(date.getRegFee());
                getScheduleResItems.setRegTitleCode(date.getDoctorCode());
                getScheduleResItems.setRegTitleName(date.getDoctorName());
                getScheduleResItems.setAdmLocation(date.getDeptName());
                getScheduleResItems.setAdmTimeRange(date.getNoon());
                getScheduleResItems.setEndTime(date.getEndTime());
                getScheduleResItems.setStartTime(date.getStartTime());
                if (null != date.getLeftTotalNum() && null != date.getLeftTotalNum()) {
                    getScheduleResItems.setRegAvailable(Integer.valueOf(date.getLeftTotalNum()));
                    getScheduleResItems.setRegTotal(Integer.valueOf(date.getLeftTotalNum()));
                }
                getScheduleResItems.setIsTimeArrange(Integer.valueOf(1));
                getScheduleResItems.setScheduleStatus(date.getWorkStatus());
                ArrayList timeArrangeItems = new ArrayList();
                if ("130214".equals(param.getOrganCode())) {
                    getScheduleResItems.setScheduleLevelName(date.getType());
                    timeResponse = this.queryTimeItems_zl(responseData);
                    timeResponse.getData().stream().forEach(timeDate -> {
                        TimeArrangeItems timeArrange = new TimeArrangeItems();
                        timeArrange.setEndTime(timeDate.getEndTime());
                        timeArrange.setStartTime(timeDate.getBeginTime());
                        timeArrange.setTimeRangeSeqNo(timeDate.getTimeSepId());
                        timeArrange.setAvailableTotalNum(timeDate.getOnNum().toString());
                        Integer availableLeftNum = timeDate.getOnNum() - timeDate.getOnleftNum();
                        timeArrange.setAvailableLeftNum(availableLeftNum.toString());
                        timeArrangeItems.add(timeArrange);
                    });
                }
                if ("130215".equals(param.getOrganCode())) {
                    getScheduleResItems.setScheduleLevelName(date.getType());
                    timeResponse = this.queryTimeItems_ca(getScheduleResItems.getScheduleId());
                    if (BeanUtil.isNotEmpty((Object)timeResponse, (String[])new String[0])) {
                        timeResponse.getData().stream().forEach(timeDate -> {
                            TimeArrangeItems timeArrange = new TimeArrangeItems();
                            timeArrange.setEndTime(timeDate.getEndTime());
                            timeArrange.setStartTime(timeDate.getBeginTime());
                            timeArrange.setTimeRangeSeqNo(timeDate.getTimeSepId());
                            timeArrange.setAvailableTotalNum(timeDate.getOnNum().toString());
                            Integer availableLeftNum = timeDate.getOnNum() - timeDate.getOnleftNum();
                            timeArrange.setAvailableLeftNum(availableLeftNum.toString());
                            timeArrangeItems.add(timeArrange);
                        });
                    }
                }
                getScheduleResItems.setTimeArrangeItems(timeArrangeItems);
                GetScheduleItems.add(getScheduleResItems);
            });
            getScheduleResVO.setItems(GetScheduleItems);
            log.info("\u67e5\u8be2\u533b\u751f\u6392\u73ed\u4fe1\u606f\u63a5\u53e3\u51fa\u53c2====>>> " + com.alibaba.fastjson.JSONObject.toJSONString((Object)getScheduleResVO));
            return FrontResponse.success((String)param.getTransactionId(), (Object)getScheduleResVO);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u6392\u73ed\u4fe1\u606f\u5f02\u5e38 {}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u6392\u73ed\u4fe1\u606f\u5f02\u5e38");
        }
    }

    public GetDocTimeItemDTO queryTimeItems_zl(List<GetScheduleItemDTO> responseData) {
        GetDocTimeItemDTO GetScheduleItem = new GetDocTimeItemDTO();
        responseData.stream().forEach(date1 -> {
            HashMap<String, String> queryDoctorTimeSchemaMapReq = new HashMap<String, String>();
            queryDoctorTimeSchemaMapReq.put("DoctorID", date1.getDoctorCode());
            queryDoctorTimeSchemaMapReq.put("DepartmentID", date1.getDeptCode());
            queryDoctorTimeSchemaMapReq.put("type", date1.getType());
            queryDoctorTimeSchemaMapReq.put("Date", date1.getScheduleDate().substring(0, 10));
            log.info("0204-\u67e5\u8be2\u533b\u751f\u6392\u73ed\u5206\u65f6\u4fe1\u606f IN====>>> " + com.alibaba.fastjson.JSONObject.toJSONString(queryDoctorTimeSchemaMapReq));
            String queryDoctorTimeSchemaMapRes = null;
            try {
                queryDoctorTimeSchemaMapRes = HttpUtils.postNew((String)"https://gateway-sxszlyy-prod.swiftcare.cn/sync//v1/offclinic/schema/divtime?schemano=", (String)com.alibaba.fastjson.JSONObject.toJSONString(queryDoctorTimeSchemaMapReq));
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            log.info("0204--\u67e5\u8be2\u533b\u751f\u6392\u73ed\u5206\u65f6\u4fe1\u606f OUT====>>> " + queryDoctorTimeSchemaMapRes);
            GetDocTimeItemDTO timeResponse = (GetDocTimeItemDTO)JSON.parseObject((String)queryDoctorTimeSchemaMapRes, GetDocTimeItemDTO.class);
            log.info("\u67e5\u8be2\u533b\u751f\u6392\u73ed\u4fe1\u606f\u5206\u65f6\u8f6c\u6362\u540e OUT====>>> " + queryDoctorTimeSchemaMapRes);
            BeanUtils.copyProperties((Object)timeResponse, (Object)GetScheduleItem);
            log.info("\u67e5\u8be2\u533b\u751f\u6392\u73ed\u4fe1\u606f\u5206\u65f6copyProperties\u540e OUT====>>> " + queryDoctorTimeSchemaMapRes);
        });
        return GetScheduleItem;
    }

    public GetDocTimeItemDTO queryTimeItems_ca(String schemano) {
        HashMap<String, String> queryDoctorSchemaMapReq = new HashMap<String, String>();
        queryDoctorSchemaMapReq.put("schemano", schemano);
        log.info("0204-\u67e5\u8be2\u533b\u751f\u6392\u73ed\u4fe1\u606fhis IN====>>> {}", queryDoctorSchemaMapReq);
        String queryDoctorSchemaMapRes = null;
        try {
            queryDoctorSchemaMapRes = HttpUtils.postNew((String)("https://hlw.cacah.com/sync/v1/offclinic/schema/divtime?schemano=" + schemano), (String)com.alibaba.fastjson.JSONObject.toJSONString(queryDoctorSchemaMapReq));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        if (StrUtil.isBlank((CharSequence)queryDoctorSchemaMapRes)) {
            return new GetDocTimeItemDTO();
        }
        log.info("0204--\u67e5\u8be2\u533b\u751f\u6392\u73ed\u4fe1\u606fhis OUT====>>> " + queryDoctorSchemaMapRes);
        GetDocTimeItemDTO timeResponse = null;
        try {
            timeResponse = (GetDocTimeItemDTO)JSON.parseObject((String)queryDoctorSchemaMapRes, GetDocTimeItemDTO.class);
        }
        catch (Exception e) {
            return new GetDocTimeItemDTO();
        }
        if (timeResponse.getSuccess().booleanValue()) {
            if (CollUtil.isEmpty((Collection)timeResponse.getData())) {
                return new GetDocTimeItemDTO();
            }
            return timeResponse;
        }
        return new GetDocTimeItemDTO();
    }
}

