/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.hisfront.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.hisfront.service.ZhongLiuElectronicReportService;
import com.ebaiyihui.hisfront.utils.DataUtils;
import com.ebaiyihui.hisfront.utils.FileUtils;
import com.ebaiyihui.hisfront.utils.HttpUtils;
import his.pojo.vo.base.FrontRequest;
import his.pojo.vo.base.FrontResponse;
import his.pojo.vo.dto.GetReportLists;
import his.pojo.vo.dto.GetReportListsResDTO;
import his.pojo.vo.dto.PacsReportListDTO;
import his.pojo.vo.dto.PacsReportListResDTO;
import his.pojo.vo.report.GetReportListsReq;
import his.pojo.vo.report.GetReportListsRes;
import his.pojo.vo.report.LisReportListReq;
import his.pojo.vo.report.LisReportListRes;
import his.pojo.vo.report.PacsReportListReq;
import his.pojo.vo.report.PacsReportListRes;
import his.pojo.vo.report.datas.GetReportListsData;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ZhongLiuElectronicReportServiceImpl
implements ZhongLiuElectronicReportService {
    private static final Logger log = LoggerFactory.getLogger(ZhongLiuElectronicReportServiceImpl.class);
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int MAP_SIZE = 1;
    public static final String SUCCESS_FLAG = "0";

    public FrontResponse<GetReportListsRes> getJYReportLists(FrontRequest<GetReportListsReq> param) {
        log.info("\u67e5\u8be2\u7535\u5b50\u62a5\u544aJY\u5217\u8868\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetReportListsReq body = (GetReportListsReq)param.getBody();
            HashMap<String, Object> JYListMapReq = new HashMap<String, Object>();
            ArrayList<String> cardNos = new ArrayList<String>();
            cardNos.add(0, body.getCardNo());
            JYListMapReq.put("page", 0);
            JYListMapReq.put("cardNos", cardNos);
            JYListMapReq.put("idenNo", body.getCredNo());
            JYListMapReq.put("type", "3");
            ArrayList patientNos = new ArrayList();
            JYListMapReq.put("patientNos", patientNos);
            JYListMapReq.put("name", "");
            log.info("\u30100401\u3011-\u67e5\u8be2\u68c0\u9a8c\u7ed3\u679c\u5217\u8868 IN====>>> " + JSONObject.toJSONString(JYListMapReq));
            String JYListMapRes = HttpUtils.postNew((String)"https://gateway-sxszlyy-prod.swiftcare.cn/sync//v1/lis/report/list", (String)JSONObject.toJSONString(JYListMapReq));
            log.info("\u30100401\u3011-\u67e5\u8be2\u68c0\u9a8c\u7ed3\u679c\u5217\u8868 OUT====>>> " + JYListMapRes);
            GetReportListsResDTO response = (GetReportListsResDTO)JSON.parseObject((String)JYListMapRes, GetReportListsResDTO.class);
            log.info("\u67e5\u8be2\u68c0\u9a8c\u7ed3\u679c\u5217\u8868 parseObject\u8f6c\u6362\u540e\u51fa\u53c2====>>> " + JSONObject.toJSONString((Object)response));
            if (!SUCCESS_FLAG.equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            List getReportLists = response.getData();
            String starDate = DataUtils.dateToSimpleString((Date)DataUtils.getDateBefore((Date)new Date(), (int)180));
            log.info("150\u5929\u524d====>>> " + starDate);
            getReportLists.removeIf(o -> DataUtils.judgeTime((String)DataUtils.dealDateFormat((String)o.getReportTime()), (String)starDate));
            log.info("\u67e5\u8be2\u68c0\u9a8c\u7ed3\u679c\u5217\u8868-\u8fc7\u6ee4\u540e====>>> " + JSONObject.toJSONString((Object)getReportLists));
            GetReportListsRes getReportListsRes = new GetReportListsRes();
            ArrayList<GetReportListsData> datas = new ArrayList<GetReportListsData>();
            for (GetReportLists reportInfoDTO : getReportLists) {
                GetReportListsData getReportListsData = new GetReportListsData();
                getReportListsData.setReportNo(reportInfoDTO.getInspectCode());
                getReportListsData.setReportName(reportInfoDTO.getItemName());
                getReportListsData.setReportType(reportInfoDTO.getReportType());
                getReportListsData.setReportDate(DataUtils.dealDateFormat((String)reportInfoDTO.getReportTime()));
                getReportListsData.setSpecName(reportInfoDTO.getSampleClassDn());
                getReportListsData.setAuthTime(DataUtils.dealDateFormat((String)reportInfoDTO.getReceiveTime()));
                getReportListsData.setAuthUser(reportInfoDTO.getCheckPerson());
                getReportListsData.setRecUser(reportInfoDTO.getInspectPerson());
                getReportListsData.setDoctorName(reportInfoDTO.getRequisitionPerson());
                getReportListsData.setDeptName(reportInfoDTO.getDeptName());
                if (null != reportInfoDTO.getSampleTime()) {
                    getReportListsData.setRecTime(DataUtils.dealDateFormat((String)reportInfoDTO.getSampleTime()));
                    getReportListsData.setColTime(DataUtils.dealDateFormat((String)reportInfoDTO.getSampleTime()));
                } else {
                    getReportListsData.setRecTime(DataUtils.dealDateFormat((String)reportInfoDTO.getReceiveTime()));
                    getReportListsData.setColTime(DataUtils.dealDateFormat((String)reportInfoDTO.getReceiveTime()));
                }
                datas.add(getReportListsData);
            }
            getReportListsRes.setDatas(datas);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u7535\u5b50\u62a5\u544aJY\u5217\u8868\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u7535\u5b50\u62a5\u544aJY\u5217\u8868\u5f02\u5e38");
        }
    }

    public FrontResponse<GetReportListsRes> getJCReportLists(FrontRequest<GetReportListsReq> param) {
        log.info("JC\u67e5\u8be2\u7535\u5b50\u62a5\u544a\u5217\u8868\u8bf7\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            GetReportListsReq body = (GetReportListsReq)param.getBody();
            HashMap<String, Object> JCListMapReq = new HashMap<String, Object>();
            ArrayList<String> cardNos = new ArrayList<String>();
            cardNos.add(0, body.getCardNo());
            JCListMapReq.put("cardNos", cardNos);
            JCListMapReq.put("page", 0);
            JCListMapReq.put("idenNo", body.getCredNo());
            JCListMapReq.put("size", 999);
            JCListMapReq.put("type", "3");
            log.info("\u30100501\u3011-\u67e5\u8be2\u68c0\u67e5\u7ed3\u679c\u5217\u8868 IN====>>> " + JSONObject.toJSONString(JCListMapReq));
            String JCListMapRes = HttpUtils.postNew((String)"https://gateway-sxszlyy-prod.swiftcare.cn/sync//v1/pacs/report/list", (String)JSONObject.toJSONString(JCListMapReq));
            log.info("\u30100501\u3011-\u67e5\u8be2\u68c0\u67e5\u7ed3\u679c\u5217\u8868 OUT====>>> " + JCListMapRes);
            GetReportListsResDTO response = (GetReportListsResDTO)JSON.parseObject((String)JCListMapRes, GetReportListsResDTO.class);
            if (!SUCCESS_FLAG.equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            List getReportLists = response.getData();
            String starDate = DataUtils.dateToSimpleString((Date)DataUtils.getDateBefore((Date)new Date(), (int)180));
            log.info("150\u5929\u524d====>>> " + starDate);
            getReportLists.removeIf(o -> DataUtils.judgeTime((String)DataUtils.dealDateFormat((String)o.getReportTime()), (String)starDate));
            log.info("\u67e5\u8be2\u68c0\u9a8c\u7ed3\u679c\u5217\u8868-\u8fc7\u6ee4\u540e====>>> " + JSONObject.toJSONString((Object)getReportLists));
            GetReportListsRes getReportListsRes = new GetReportListsRes();
            ArrayList<GetReportListsData> datas = new ArrayList<GetReportListsData>();
            for (GetReportLists reportInfoDTO : getReportLists) {
                GetReportListsData getReportListsData = new GetReportListsData();
                getReportListsData.setReportNo(reportInfoDTO.getCheckSerialNo());
                getReportListsData.setReportName(reportInfoDTO.getItemName());
                getReportListsData.setReportType(reportInfoDTO.getReportType());
                getReportListsData.setReportDate(DataUtils.dealDateFormat((String)reportInfoDTO.getReportTime()));
                datas.add(getReportListsData);
            }
            getReportListsRes.setDatas(datas);
            return FrontResponse.success((String)param.getTransactionId(), (Object)getReportListsRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u7535\u5b50\u62a5\u544aJC\u5217\u8868\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u7535\u5b50\u62a5\u544aJC\u5217\u8868\u5f02\u5e38");
        }
    }

    public FrontResponse<LisReportListRes> lisReportList(FrontRequest<LisReportListReq> param) {
        log.info("\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            LisReportListReq body = (LisReportListReq)param.getBody();
            HashMap<String, String> JCDetialMapReq = new HashMap<String, String>();
            JCDetialMapReq.put("hosId", "61010800");
            JCDetialMapReq.put("inspectionId", body.getReportNo());
            JCDetialMapReq.put("type", "");
            log.info("\u30100402\u3011-\u67e5\u8be2\u68c0\u9a8c\u7ed3\u679c\u8be6\u60c5 IN====>>> " + JSONObject.toJSONString(JCDetialMapReq));
            InputStream JCDetialMapRes = HttpUtils.getNew((String)"https://gateway-sxszlyy-prod.swiftcare.cn/sync//v1/lis/report/detail", JCDetialMapReq);
            String base64FromInputStream = FileUtils.getBase64FromInputStream((InputStream)JCDetialMapRes);
            log.info("\u30100402\u3011-\u67e5\u8be2\u68c0\u9a8c\u7ed3\u679c\u8be6\u60c5 OUT====>>> " + base64FromInputStream);
            LisReportListRes lisReportListRes = new LisReportListRes();
            lisReportListRes.setReportNo(base64FromInputStream);
            return FrontResponse.success((String)param.getTransactionId(), (Object)lisReportListRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5f02\u5e38{}", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u68c0\u9a8c\u62a5\u544a\u8be6\u60c5\u5f02\u5e38");
        }
    }

    public FrontResponse<PacsReportListRes> pacsReportList(FrontRequest<PacsReportListReq> param) {
        log.info("\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u6c42\u5165\u53c2\uff1a" + JSON.toJSONString(param));
        try {
            PacsReportListReq body = (PacsReportListReq)param.getBody();
            PacsReportListRes pacsReportListRes = new PacsReportListRes();
            HashMap<String, String> JYDetialMapReq = new HashMap<String, String>();
            if ("0001".equals(body.getReportType())) {
                JYDetialMapReq.put("checkserialnums", body.getReportNo());
                log.info("\u30100504\u3011-\u67e5\u8be2\u68c0\u67e5\u7ed3\u679c\u8be6\u60c5 IN====>>> " + JSONObject.toJSONString(JYDetialMapReq));
                InputStream JYDetialMapRes = HttpUtils.postInputStream((String)("https://gateway-sxszlyy-prod.swiftcare.cn/sync//v1/pacs/ecg/report/picture/detail?checkserialnums=" + JYDetialMapReq.get("checkserialnums")), (String)JSONObject.toJSONString(JYDetialMapReq));
                log.info("\u30100504\u3011-\u67e5\u8be2\u68c0\u67e5\u7ed3\u679c\u8be6\u60c5 OUT====>>> " + JYDetialMapRes);
                String base64FromInputStream = FileUtils.getBase64FromInputStream((InputStream)JYDetialMapRes);
                pacsReportListRes.setCheckResult(base64FromInputStream);
                return FrontResponse.success((String)param.getTransactionId(), (Object)pacsReportListRes);
            }
            JYDetialMapReq.put("checkserialnums", body.getReportNo());
            JYDetialMapReq.put("hosId", "");
            log.info("\u30100502\u3011-\u67e5\u8be2\u68c0\u67e5\u7ed3\u679c\u8be6\u60c5 IN====>>> " + JSONObject.toJSONString(JYDetialMapReq));
            String JYDetialMapRes = HttpUtils.postNew((String)("https://gateway-sxszlyy-prod.swiftcare.cn/sync//v1/pacs/report/detail?checkserialnums=" + JYDetialMapReq.get("checkserialnums") + "&hosId=" + JYDetialMapReq.get("hosId")), (String)JSONObject.toJSONString(JYDetialMapReq));
            log.info("\u30100502\u3011-\u67e5\u8be2\u68c0\u67e5\u7ed3\u679c\u8be6\u60c5 OUT====>>> " + JYDetialMapRes);
            PacsReportListResDTO response = (PacsReportListResDTO)JSON.parseObject((String)JYDetialMapRes, PacsReportListResDTO.class);
            if (!SUCCESS_FLAG.equals(response.getCode())) {
                return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)response.getMessage());
            }
            PacsReportListDTO pacsReportListDTO = (PacsReportListDTO)response.getData().get(0);
            pacsReportListRes.setDoctorName(pacsReportListDTO.getCheckDocName());
            pacsReportListRes.setAuthTime(pacsReportListDTO.getStudyTime());
            pacsReportListRes.setCheckResult(pacsReportListDTO.getReportDiagnose());
            pacsReportListRes.setAuthUser(pacsReportListDTO.getCheckDocName());
            pacsReportListRes.setCheckDesc(pacsReportListDTO.getReportDescribe());
            return FrontResponse.success((String)param.getTransactionId(), (Object)pacsReportListRes);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u5f02\u5e38", (Object)e.getMessage());
            return FrontResponse.error((String)param.getTransactionId(), (String)SUCCESS_FLAG, (String)"\u67e5\u8be2\u68c0\u67e5\u62a5\u544a\u8be6\u60c5\u5f02\u5e38");
        }
    }
}

