/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.upload.business;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.upload.business.IRegulatory;
import com.ebaiyihui.upload.business.UploadFactory;
import com.ebaiyihui.upload.enums.RegulatoryEnum;
import com.ebaiyihui.upload.utils.CxfClientUtil;
import com.ebaiyihui.upload.utils.XmlUtil;
import java.util.ArrayList;
import java.util.Map;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class HeNanUpload
implements IRegulatory,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(HeNanUpload.class);
    private String typeName = RegulatoryEnum.HENAN.toString();
    private String data;
    private String hospitalUrl;
    private String serviceMethod;
    private String username;
    private String password;
    private String ERROR_CODE = "ERRORCODE";

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getHospitalUrl() {
        return this.hospitalUrl;
    }

    public void setHospitalUrl(String hospitalUrl) {
        this.hospitalUrl = hospitalUrl;
    }

    public String getServiceMethod() {
        return this.serviceMethod;
    }

    public void setServiceMethod(String serviceMethod) {
        this.serviceMethod = serviceMethod;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void splitData(String listData) {
        HeNanUpload heNanUpload = (HeNanUpload)JSONObject.parseObject((String)listData, this.getClass());
        BeanUtils.copyProperties((Object)heNanUpload, (Object)this);
        this.data = heNanUpload.getData();
    }

    public void auth() {
    }

    public boolean upload() {
        String[] list = this.data.split("$");
        ArrayList<String> dataList = new ArrayList<String>();
        for (String newDate : list) {
            if (newDate.isEmpty() || newDate.equals("\n")) continue;
            dataList.add(newDate);
        }
        for (String data : dataList) {
            log.info("\u4e0a\u62a5\u4e1a\u52a1\u6570\u636e\uff1a{}", (Object)data);
            String result = new CxfClientUtil().send(this.hospitalUrl, this.serviceMethod, new String[]{this.username, this.password, data});
            if (result == null) continue;
            try {
                Map map = XmlUtil.convertStringXmlToMap((String)result);
                if (!map.get(this.ERROR_CODE).equals(0)) continue;
                return true;
            }
            catch (DocumentException e) {
                log.error("henan response error,e=", (Throwable)e);
            }
        }
        return false;
    }

    public String uploadJs() {
        return null;
    }

    public void afterPropertiesSet() {
        UploadFactory.registerRegulatoryType((String)this.typeName, (IRegulatory)this);
    }
}

