/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.upload.business;

import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.upload.business.IRegulatory;
import com.ebaiyihui.upload.business.UploadFactory;
import com.ebaiyihui.upload.enums.RegulatoryEnum;
import com.ebaiyihui.upload.pojo.HuNanResVO;
import com.ebaiyihui.upload.utils.HttpKit;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class HuNanUpload
implements IRegulatory,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(HuNanUpload.class);
    public static final String ACTION = "SM3E";
    private String typeName = RegulatoryEnum.HUNAN.toString();
    private String data;
    private String hospitalUrl;
    private String digestUrl;
    private String appCode;
    private String hlwyljgdm;
    private String requestId;
    private String timestamp;
    private String serviceId;
    private String sign;
    private String digest;

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setHospitalUrl(String hospitalUrl) {
        this.hospitalUrl = hospitalUrl;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getData() {
        return this.data;
    }

    public String getHospitalUrl() {
        return this.hospitalUrl;
    }

    public String getAppCode() {
        return this.appCode;
    }

    public void setAppCode(String appCode) {
        this.appCode = appCode;
    }

    public String getHlwyljgdm() {
        return this.hlwyljgdm;
    }

    public void setHlwyljgdm(String hlwyljgdm) {
        this.hlwyljgdm = hlwyljgdm;
    }

    public String getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String getDigestUrl() {
        return this.digestUrl;
    }

    public void setDigestUrl(String digestUrl) {
        this.digestUrl = digestUrl;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public String getDigest() {
        return this.digest;
    }

    public void setDigest(String digest) {
        this.digest = digest;
    }

    public void afterPropertiesSet() {
        UploadFactory.registerRegulatoryType((String)this.typeName, (IRegulatory)this);
    }

    public void splitData(String listData) {
        HuNanUpload huNanUpload = (HuNanUpload)JSONObject.parseObject((String)listData, this.getClass());
        BeanUtils.copyProperties((Object)huNanUpload, (Object)this);
        log.info("huNan upload data = " + this.data);
    }

    public void auth() {
        this.digest = this.getSignStr();
    }

    public boolean upload() {
        if (this.digest == null) {
            return false;
        }
        JSONObject param = this.getParam();
        Map headerMap = this.getHeaderMap();
        boolean flag = false;
        try {
            String result = HttpKit.jsonPost((String)this.hospitalUrl, (String)param.toJSONString(), (Map)headerMap);
            log.info("hu nan upload result =" + result);
            HuNanResVO huNanResVO = (HuNanResVO)JSONObject.parseObject((String)result, HuNanResVO.class);
            if (huNanResVO.getCode().equals("200")) {
                flag = true;
            }
        }
        catch (Exception e) {
            log.error("hu nan upload error,e=", (Throwable)e);
        }
        return flag;
    }

    public String uploadJs() {
        return null;
    }

    private JSONObject getParam() {
        JSONObject jsonObject = new JSONObject(true);
        jsonObject.put("appCode", (Object)this.appCode);
        jsonObject.put("hlwyljgdm", (Object)this.hlwyljgdm);
        jsonObject.put("requestId", (Object)this.requestId);
        jsonObject.put("method", (Object)this.serviceId);
        jsonObject.put("req", (Object)this.data);
        jsonObject.put("digest", (Object)this.digest);
        jsonObject.put("timestamp", (Object)this.timestamp);
        log.info("param format data=" + jsonObject.toString());
        return jsonObject;
    }

    private Map<String, String> getHeaderMap() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("sign", this.sign);
        headerMap.put("appCode", this.appCode);
        return headerMap;
    }

    private String getSignStr() {
        String signParam = MessageFormat.format("appCode={0}&requestid={1}&hlwyljgdm={2}&method={3}&timestamp={4}&req={5}", this.appCode, this.requestId, this.hlwyljgdm, this.serviceId, this.timestamp, this.data);
        try {
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("action", ACTION);
            paramMap.put("text", signParam);
            paramMap.put("key", this.sign);
            String result = HttpKit.get((String)this.digestUrl, paramMap);
            log.info("huNan upload result =" + result);
            HuNanResVO huNanResVO = (HuNanResVO)JSONObject.parseObject((String)result, HuNanResVO.class);
            if (huNanResVO.getCode().equals("200")) {
                return huNanResVO.getData();
            }
            return null;
        }
        catch (Exception e) {
            log.error("huNan sign param error,e=", (Throwable)e);
            return null;
        }
    }
}

