/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.upload.business;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.upload.business.IRegulatory;
import com.ebaiyihui.upload.business.UploadFactory;
import com.ebaiyihui.upload.enums.RegulatoryEnum;
import com.ebaiyihui.upload.pojo.JxResVO;
import com.ebaiyihui.upload.utils.DateUtils;
import com.ebaiyihui.upload.utils.HttpKit;
import com.ebaiyihui.upload.utils.HttpUtils;
import com.ebaiyihui.upload.utils.Md5Utils;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
public class JxUpload
implements IRegulatory,
InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(JxUpload.class);
    private String typeName = RegulatoryEnum.JIANGXI.toString();
    private String data;
    private String hospitalUrl;
    private String appKey;
    private String appSecret;
    private String serviceId;
    private String tokenUrl;
    private String notifyUrl;
    private String sign;
    private String requestBody;
    private String authorization;

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setHospitalUrl(String hospitalUrl) {
        this.hospitalUrl = hospitalUrl;
    }

    public void setAppKey(String appKey) {
        this.appKey = appKey;
    }

    public void setAppSecret(String appSecret) {
        this.appSecret = appSecret;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    public void setTokenUrl(String tokenUrl) {
        this.tokenUrl = tokenUrl;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public void setNotifyUrl(String notifyUrl) {
        this.notifyUrl = notifyUrl;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public String getData() {
        return this.data;
    }

    public String getHospitalUrl() {
        return this.hospitalUrl;
    }

    public String getAppKey() {
        return this.appKey;
    }

    public String getAppSecret() {
        return this.appSecret;
    }

    public String getServiceId() {
        return this.serviceId;
    }

    public String getTokenUrl() {
        return this.tokenUrl;
    }

    public String getNotifyUrl() {
        return this.notifyUrl;
    }

    public void afterPropertiesSet() {
        UploadFactory.registerRegulatoryType((String)this.typeName, (IRegulatory)this);
    }

    public void splitData(String listData) {
        JxUpload jxUpload = (JxUpload)JSONObject.parseObject((String)listData, this.getClass());
        BeanUtils.copyProperties((Object)jxUpload, (Object)this);
        this.requestBody = this.dataHandler();
        log.info("jx upload requestBody=" + this.requestBody);
    }

    private String dataHandler() {
        JSONObject jsonObject = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        JSONArray.parseArray((String)this.data).forEach(dataTemp -> {
            JSONObject jsonObjectTemp = (JSONObject)dataTemp;
            jsonObjectTemp.put("uploadDate", (Object)DateUtils.getFormatNow());
            jsonArray.add((Object)jsonObjectTemp);
        });
        jsonObject.put("appKey", (Object)this.appKey);
        jsonObject.put("data", (Object)jsonArray);
        String result = jsonObject.toString();
        log.info("param format data=" + result);
        return result;
    }

    public void auth() {
        String signStr = this.getSignStr();
        this.sign = Md5Utils.encryption((String)signStr).toUpperCase();
        this.authorization = this.getJwtToken();
    }

    private String getJwtToken() {
        try {
            log.info("jx get token url =" + this.tokenUrl);
            String result = HttpUtils.noParamGetInvoke((String)this.tokenUrl);
            log.info("jx get token  result =" + result);
            String data = ((JxResVO)JSONObject.parseObject((String)result, JxResVO.class)).getData();
            return data;
        }
        catch (Exception e) {
            log.error("jx get jwtToken error,e=", (Throwable)e);
            return "";
        }
    }

    public boolean upload() {
        JSONObject param = this.getParam();
        Map headerMap = this.getHeaderMap();
        boolean flag = false;
        try {
            String result = HttpKit.jsonPost((String)this.hospitalUrl, (String)param.toJSONString(), (Map)headerMap);
            log.info("jx upload result =" + result);
            JxResVO jxResVO = (JxResVO)JSONObject.parseObject((String)result, JxResVO.class);
            if (jxResVO.getBusinessCode() == 1) {
                flag = true;
                if ("Patient.CreateArchive".equals(this.serviceId) || "Patient.Treatment".equals(this.serviceId)) {
                    this.notifyInfo(jxResVO);
                }
            }
        }
        catch (Exception e) {
            log.error("jx upload error,e=", (Throwable)e);
        }
        return flag;
    }

    public String uploadJs() {
        return null;
    }

    private void notifyInfo(JxResVO jxResVO) throws Exception {
        JSONObject jsonObject = JSONObject.parseObject((String)jxResVO.getData());
        JSONArray jsonArray = jsonObject.getJSONArray("data");
        String s = HttpKit.jsonPost((String)this.notifyUrl, (String)jsonArray.toJSONString());
        log.info("save platform return data =" + s);
    }

    private JSONObject getParam() {
        JSONObject jsonObject = new JSONObject();
        JSONObject jsonObjectTemp = JSONObject.parseObject((String)this.requestBody);
        jsonObject.put("requestBody", (Object)jsonObjectTemp.toJSONString());
        return jsonObject;
    }

    private Map<String, String> getHeaderMap() {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("sign", this.sign);
        headerMap.put("Authorization", this.authorization);
        headerMap.put("serviceId", this.serviceId);
        return headerMap;
    }

    private String getSignStr() {
        String signStr = this.requestBody + this.appSecret;
        return signStr;
    }
}

