/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.upload.utils;

import com.ebaiyihui.upload.utils.IError;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.beans.Transient;
import java.util.Objects;

public class BaseResponse<T> {
    public static final String DEFAULT_SUCCESS_MESSAGE = "\u64cd\u4f5c\u6210\u529f";
    public static final String DEFAULT_ERROR_MESSAGE = "\u64cd\u4f5c\u5931\u8d25";
    public static final String DEFAULT_SUCCESS_CODE = "1";
    public static final String DEFAULT_ERROR_CODE = "0";
    private String code;
    private String errCode = "0";
    private String msg;
    private T data;

    public BaseResponse() {
    }

    public BaseResponse(String code, String msg, T data) {
        this.code = code;
        this.data = data;
        this.msg = msg;
    }

    public static <T> BaseResponse<T> success(T t) {
        BaseResponse res = new BaseResponse();
        res.setCode(DEFAULT_SUCCESS_CODE);
        res.setMsg(DEFAULT_SUCCESS_MESSAGE);
        res.setData(t);
        return res;
    }

    public static <T> BaseResponse<T> success() {
        BaseResponse res = new BaseResponse();
        res.setCode(DEFAULT_SUCCESS_CODE);
        res.setMsg(DEFAULT_SUCCESS_MESSAGE);
        res.setData(null);
        return res;
    }

    public static <T> BaseResponse<T> error(IError error) {
        BaseResponse res = new BaseResponse();
        res.setCode(DEFAULT_ERROR_CODE);
        res.setErrCode(error.getErrCode());
        res.setMsg(error.getMsg());
        res.setData(null);
        return res;
    }

    public static <T> BaseResponse<T> error(String msg) {
        BaseResponse res = new BaseResponse();
        res.setCode(DEFAULT_ERROR_CODE);
        res.setErrCode(IError.GENERAL_ERROR.getErrCode());
        res.setMsg(msg);
        res.setData(null);
        return res;
    }

    public static <T> BaseResponse<T> error(IError error, String msg) {
        BaseResponse res = new BaseResponse();
        res.setCode(DEFAULT_ERROR_CODE);
        res.setErrCode(error.getErrCode());
        res.setMsg(msg);
        res.setData(null);
        return res;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public T getData() {
        return (T)this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getErrCode() {
        return this.errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    @Transient
    @JsonIgnore
    public boolean isSuccess() {
        return Objects.equals(this.code, DEFAULT_SUCCESS_CODE);
    }

    public String toString() {
        return "BaseResponse [code=" + this.code + ", errCode=" + this.errCode + ", msg=" + this.msg + ", data=" + this.data + "]";
    }
}

