/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.usercenter.authorization_center.intercepter;

import com.ebaiyihui.usercenter.authorization_center.config.AuthorityConfig;
import com.ebaiyihui.usercenter.authorization_center.token.ValidateTokenService;
import com.ebaiyihui.usercenter.authorization_center.utils.CommonsUtils;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;

@Component
public class ApiAccessInterceptor
implements WebRequestInterceptor {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String AUTHORIZATION_FIELD = "accessToken";
    @Autowired
    private ValidateTokenService tokenService;
    private static AuthorityConfig authorityConfig = new AuthorityConfig();
    @Value(value="{authority.enabled}")
    private String enable;

    public void preHandle(WebRequest webRequest) throws Exception {
        HttpServletRequest request = CommonsUtils.currentRequest();
        StringBuffer requestURL = request.getRequestURL();
        System.out.println(requestURL);
        String requestURI = request.getRequestURI();
        System.out.println(requestURI);
        String token = webRequest.getHeader(AUTHORIZATION_FIELD);
        if (StringUtils.isEmpty((CharSequence)token)) {
            this.log.info("\u8bf7\u6c42\u5934\u4e2d\u672a\u83b7\u53d6\u5230token\u4fe1\u606f");
            throw new RuntimeException("Token not obtained in request header 'accessToken'");
        }
        if (authorityConfig.isEnabled()) {
            List<String> whiteIpList = authorityConfig.getWhiteIpList();
            List<String> whiteUriList = authorityConfig.getWhiteUriList();
            System.out.println(this.enable);
            if (!this.tokenService.validateAccessToken(token).booleanValue()) {
                this.log.info("token\u6821\u9a8c\u4e0d\u901a\u8fc7");
                throw new RuntimeException("Token check not pass");
            }
        }
    }

    public void postHandle(WebRequest webRequest, ModelMap modelMap) throws Exception {
    }

    public void afterCompletion(WebRequest webRequest, Exception e) throws Exception {
    }
}

