/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.usercenter.authorization_center.token;

import com.ebaiyihui.usercenter.authorization_center.token.TokenBody;
import com.ebaiyihui.usercenter.authorization_center.token.TokenJson;
import com.ebaiyihui.usercenter.authorization_center.token.Tokenutil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class ValidateTokenService {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static final String JWT_SECRET = "hxgy-ehospital";
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;

    public Boolean validateAccessToken(String accessToken) {
        TokenBody tokenBody;
        if (StringUtils.isEmpty((CharSequence)accessToken)) {
            return false;
        }
        try {
            tokenBody = Tokenutil.parse(accessToken, JWT_SECRET);
        }
        catch (Exception e) {
            this.log.error("Token\u53c2\u6570\u89e3\u6790\u5931\u8d25\uff0cToken\u4fe1\u606f[{}]", (Object)accessToken, (Object)e);
            return false;
        }
        if (!tokenBody.expire()) {
            this.log.error("Token\u5df2\u8fc7\u671f\uff0cToken\u4fe1\u606f[{}]", (Object)tokenBody);
            return false;
        }
        TokenJson tokenJson = tokenBody.getTokenJson();
        String tokenKey = Tokenutil.genTokenKey(tokenJson.getUserId(), tokenJson.getAppCode(), tokenJson.getDeviceType());
        String cacheToken = this.getCacheToken(tokenKey);
        if (StringUtils.isEmpty((CharSequence)cacheToken)) {
            this.log.error("Token\u767b\u5f55\u4fe1\u606f\u5df2\u5931\u6548\uff0cToken\u4fe1\u606f[{}]", (Object)tokenBody);
            return false;
        }
        if (!accessToken.equals(cacheToken)) {
            this.log.error("Token\u767b\u5f55\u4fe1\u606f\u5df2\u5931\u6548\uff0c\u7528\u6237\u5728\u5176\u4ed6\u8bbe\u5907\u5df2\u91cd\u65b0\u767b\u5f55,Token\u4fe1\u606f[{}]", (Object)accessToken);
            return false;
        }
        return true;
    }

    public String getCacheToken(String tokenKey) {
        return tokenKey == null ? null : (String)this.redisTemplate.opsForValue().get((Object)tokenKey);
    }
}

