/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller;

import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.pojo.vo.push.PlatformPushMainDrugListRequestVO;
import com.ebaiyihui.wisdommedical.pojo.vo.push.PlatformPushMainRequestVO;
import com.ebaiyihui.wisdommedical.pojo.vo.push.RevokePrescriptionVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.IdCardInfo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.IdCardResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.AfterConsultationVo;
import com.ebaiyihui.wisdommedical.service.PushService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u5904\u65b9\u6d41\u8f6c\u63a8\u9001 API"})
@RestController
@RequestMapping(value={"/api/platformMain"})
public class PlatformMainController {
    private static final Logger log = LoggerFactory.getLogger(PlatformMainController.class);
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private PushService pushService;

    @PostMapping(value={"/v1/platformPushMain"})
    @ApiOperation(value="\u63a8\u9001\u5904\u65b9", notes="\u63a8\u9001\u5904\u65b9")
    public BaseResponse<Object> platformPushMain(@RequestBody @Validated PlatformPushMainRequestVO platformPushMainRequestVO) {
        String url = "https://ihos.chinachdu.com/prescription/api/platformMain/v1/platformPushMain";
        try {
            if (null != platformPushMainRequestVO.getDrugData() && platformPushMainRequestVO.getDrugData().size() > 0) {
                for (PlatformPushMainDrugListRequestVO platformPushMainDrugListRequestVO : platformPushMainRequestVO.getDrugData()) {
                    Integer drugNum = Integer.parseInt(platformPushMainDrugListRequestVO.getDrugNum());
                    Integer drugWholePackingUnitNum = Integer.parseInt(platformPushMainDrugListRequestVO.getDrugNum());
                    Integer sum = drugNum * drugWholePackingUnitNum;
                    platformPushMainDrugListRequestVO.setDrugNum(sum.toString());
                }
            }
            log.info("\u63a8\u9001\u5904\u65b9\u63a8\u9001\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)platformPushMainRequestVO));
            String post = HttpUtil.post((String)url, (String)JSON.toJSONString((Object)platformPushMainRequestVO));
            log.info("\u63a8\u9001\u5904\u65b9\u8fd4\u56de\u503c->{}", (Object)post);
            if (StringUtils.isEmpty((String)post)) {
                return BaseResponse.error((String)"\u63a8\u9001\u5904\u65b9\u5931\u8d25");
            }
            JSONObject jsonObject = JSON.parseObject((String)post);
            if ("0".equals(jsonObject.getString("code"))) {
                return BaseResponse.error((String)jsonObject.getString("msg"));
            }
        }
        catch (Exception e) {
            return BaseResponse.error((String)"\u63a8\u9001\u5904\u65b9\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    @PostMapping(value={"/v1/platformRevokeMain"})
    @ApiOperation(value="\u64a4\u9500\u5904\u65b9", notes="\u64a4\u9500\u5904\u65b9")
    public BaseResponse<Object> platformRevokeMain(@RequestBody @Validated RevokePrescriptionVo vo) {
        String url = "https://ihos.chinachdu.com/prescription/api/platformMain/v1/platformRevokeMain";
        try {
            log.info("\u64a4\u9500\u5904\u65b9\u63a8\u9001\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)vo));
            String post = HttpUtil.post((String)url, (String)JSON.toJSONString((Object)vo));
            log.info("\u64a4\u9500\u5904\u65b9\u8fd4\u56de\u503c->{}", (Object)post);
            if (StringUtils.isEmpty((String)post)) {
                return BaseResponse.error((String)"\u64a4\u9500\u5904\u65b9\u5931\u8d25");
            }
            JSONObject jsonObject = JSON.parseObject((String)post);
            if ("0".equals(jsonObject.getString("code"))) {
                return BaseResponse.error((String)jsonObject.getString("msg"));
            }
        }
        catch (Exception e) {
            return BaseResponse.error((String)"\u64a4\u9500\u5904\u65b9\u5931\u8d25");
        }
        return BaseResponse.success();
    }

    @PostMapping(value={"/v1/pushAfterConsultation"})
    @ApiOperation(value="\u8bca\u540e\u6d88\u606f\u63a8\u9001", notes="\u8bca\u540e\u6d88\u606f\u63a8\u9001")
    public BaseResponse<Object> pushAfterConsultation(@RequestBody @Validated AfterConsultationVo afterConsultationVo) {
        this.taskExecutor.execute(() -> this.pushService.pushAfterConsultation(afterConsultationVo));
        return BaseResponse.success();
    }

    @GetMapping(value={"getAdressByIdCard"})
    @ApiOperation(value="\u901a\u8fc7\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u51fa\u751f\u5730", notes="\u901a\u8fc7\u8eab\u4efd\u8bc1\u53f7\u83b7\u53d6\u51fa\u751f\u5730")
    public BaseResponse<IdCardInfo> test(String idCard) {
        String reportImg = HttpUtil.get((String)("https://www.haoshudi.com/api/id/query?userid=" + idCard));
        IdCardResVo idCardResVo = (IdCardResVo)JSON.parseObject((String)reportImg, IdCardResVo.class);
        System.out.println(idCardResVo);
        IdCardInfo info = new IdCardInfo();
        if (idCardResVo.getCode() == 10000) {
            if (idCardResVo.getData().getNewAddress().length > 0) {
                String str = idCardResVo.getData().getNewAddress()[0];
                String[] parts = StringUtils.splitByWholeSeparator((String)str, (String)" ");
                for (int i = 0; i < 3; ++i) {
                    if (i == 0) {
                        info.setProvinceName(parts[i]);
                    }
                    if (i == 1) {
                        info.setCityName(parts[i]);
                    }
                    if (i != 2) continue;
                    info.setCityAreaName(parts[i]);
                }
            } else {
                String str = idCardResVo.getData().getAddress();
                String[] parts = StringUtils.splitByWholeSeparator((String)str, (String)" ");
                for (int i = 0; i < 3; ++i) {
                    if (i == 0) {
                        info.setProvinceName(parts[i]);
                    }
                    if (i == 1) {
                        info.setCityName(parts[i]);
                    }
                    if (i != 2) continue;
                    info.setCityAreaName(parts[i]);
                }
            }
        } else {
            info.setProvinceName("\u6cb3\u5357\u7701");
            info.setCityName("\u6d1b\u9633\u5e02");
            info.setCityAreaName("\u897f\u5de5\u533a");
        }
        return BaseResponse.success((Object)info);
    }
}

