/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.appointment;

import com.ebaiyihui.framework.page.PageResult;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.DocAppendInfoQrcodeDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleDoctorVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleDoctorVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.DocAppendInfoResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetDocListReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.UploadDocExcelReqVo;
import com.ebaiyihui.wisdommedical.service.DoctorService;
import com.ebaiyihui.wisdommedical.util.ExcelUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@Api(tags={"\u533b\u751fapi"})
@RequestMapping(value={"/api/v1/doctor"})
public class DoctorController {
    private static final Logger log = LoggerFactory.getLogger(DoctorController.class);
    @Autowired
    private DoctorService doctorService;

    @GetMapping(value={"/getDoctorRecordEntity"})
    public BaseResponse<DoctorRecordEntity> getDoctorRecordEntity(@RequestParam(value="doctorId") String doctorId, @RequestParam(value="hospitalCode") String hospitalCode) {
        DoctorRecordEntity doctorRecordEntity = this.doctorService.getDoctorRecordEntity(doctorId, hospitalCode);
        return BaseResponse.success((Object)doctorRecordEntity);
    }

    @PostMapping(value={"/updateDoctorIdByDoctorCode"})
    public BaseResponse<String> updateDoctorIdByDoctorCode(@RequestParam(value="doctorId") String doctorId, @RequestParam(value="doctorCode") String doctorCode, @RequestParam(value="hospitalCode") String hospitalCode) {
        this.doctorService.updateDoctorIdByDoctorCode(doctorId, doctorCode, hospitalCode);
        return BaseResponse.success();
    }

    @PostMapping(value={"/getDoctorCodesByDoctorIds"})
    public BaseResponse<List<Long>> getDoctorCodeByDoctorId(@RequestParam(value="doctorId") String doctorId) {
        List doctorCodeList = this.doctorService.getDoctorCodeListBydoctorIds(doctorId);
        return BaseResponse.success((Object)doctorCodeList);
    }

    @PostMapping(value={"/getSchduleDoctor"})
    public BaseResponse<List<ScheduleDoctorVoRes>> getSchduleDoctor(@RequestBody @Valid ScheduleDoctorVoReq scheduleDoctorVoReq) {
        List scheduleDoctor = this.doctorService.getScheduleDoctor(scheduleDoctorVoReq);
        return BaseResponse.success((Object)scheduleDoctor);
    }

    @PostMapping(value={"/importWesternFileUpload"})
    @ApiOperation(value="\u6587\u4ef6\u5bfc\u5165", notes="\u6587\u4ef6\u5bfc\u5165")
    public BaseResponse<Object> importWesternFileUpload(@RequestParam(value="file") MultipartFile file) throws Exception {
        return this.doctorService.importWestern(file);
    }

    @PostMapping(value={"/importDocAvatarFileUpload"})
    @ApiOperation(value="\u6279\u91cf\u4e0a\u4f20\u5934\u50cf", notes="\u6279\u91cf\u4e0a\u4f20\u5934\u50cf")
    public BaseResponse<Object> importDocAvatarFileUpload(@RequestParam(value="file") MultipartFile file) {
        try {
            BaseResponse ObjectRes = this.doctorService.insertDoctorPortraiturl(file);
            return ObjectRes;
        }
        catch (Exception e) {
            return BaseResponse.error((String)e.toString());
        }
    }

    @GetMapping(value={"/downloadImportDrugTemplate"})
    @ApiOperation(value="\u5bfc\u51fa\u6a21\u677f", notes="\u5bfc\u51fa\u6a21\u677f")
    public void downloadImportDrugTemplate(HttpServletResponse response) throws IOException {
        ArrayList list = new ArrayList();
        ExcelUtil.exportExcel(list, null, (String)"sheet1", UploadDocExcelReqVo.class, (String)"\u533b\u751f\u5bfc\u5165\u8868\u5934", (HttpServletResponse)response);
    }

    @GetMapping(value={"/getDoctorRecord"})
    @ApiOperation(value="\u67e5\u8be2\u8be6\u60c5", notes="\u67e5\u8be2\u8be6\u60c5")
    public BaseResponse<DoctorRecordEntity> getDoctorRecord(@RequestParam(value="id") Long id) {
        DoctorRecordEntity doctorRecord = this.doctorService.getDoctorRecord(id);
        return BaseResponse.success((Object)doctorRecord);
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5217\u8868", notes="\u5206\u9875\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/getDocInfoList"})
    public BaseResponse<PageResult<DoctorRecordEntity>> getDocInfoList(@RequestBody @Valid GetDocListReqVo getDocListReqVo) {
        PageResult docInfoList = this.doctorService.getDocInfoList(getDocListReqVo);
        return BaseResponse.success((Object)docInfoList);
    }

    @ApiOperation(value="\u5220\u9664", notes="\u5220\u9664")
    @GetMapping(value={"/deleteDoctorRecord"})
    public BaseResponse<Integer> deleteDoctorRecord(@RequestParam(value="id") Long id) {
        return BaseResponse.success((Object)this.doctorService.deleteDoctorRecord(id));
    }

    @ApiOperation(value="\u65b0\u589e", notes="\u65b0\u589e")
    @PostMapping(value={"/addDoctorRecord"})
    public BaseResponse<Integer> addDoctorRecord(@RequestBody DoctorRecordEntity doctorRecordEntity) throws Exception {
        return BaseResponse.success((Object)this.doctorService.addDoctorRecord(doctorRecordEntity));
    }

    @ApiOperation(value="\u4fee\u6539", notes="\u4fee\u6539")
    @PostMapping(value={"/updateDoctorRecord"})
    public BaseResponse<Integer> updateDoctorRecord(@RequestBody DoctorRecordEntity doctorRecordEntity) {
        return BaseResponse.success((Object)this.doctorService.updateDoctorRecord(doctorRecordEntity));
    }

    @ApiOperation(value="\u67e5\u8be2\u52a0\u53f7\u533b\u751f\u8be6\u60c5\u4fe1\u606f", notes="\u67e5\u8be2\u52a0\u53f7\u533b\u751f\u8be6\u60c5\u4fe1\u606f")
    @GetMapping(value={"/getDocAppendInfo"})
    public BaseResponse<DocAppendInfoResVO> getDocAppendInfo(@RequestParam(value="doctorCode") String doctorCode) {
        return this.doctorService.getDocAppendInfo(doctorCode);
    }

    @ApiOperation(value="\u751f\u6210\u52a0\u53f7\u4e8c\u7ef4\u7801\u552f\u4e00\u6807\u8bc6", notes="\u751f\u6210\u52a0\u53f7\u4e8c\u7ef4\u7801\u552f\u4e00\u6807\u8bc6")
    @PostMapping(value={"/generateDocAppendInfoQrcode"})
    public BaseResponse<String> generateDocAppendInfoQrcode(@RequestBody @Validated DocAppendInfoQrcodeDTO req) {
        return this.doctorService.generateDocAppendInfoQrcode(req);
    }

    @ApiOperation(value="\u67e5\u8be2\u4e8c\u7ef4\u7801\u4fe1\u606f", notes="\u67e5\u8be2\u4e8c\u7ef4\u7801\u4fe1\u606f")
    @GetMapping(value={"/getDocAppendInfoQrcode"})
    public BaseResponse<DocAppendInfoQrcodeDTO> getDocAppendInfoQrcode(@RequestParam(value="qrcodeId") String qrcodeId) {
        return BaseResponse.success((Object)this.doctorService.getDocAppendInfoQrcode(qrcodeId));
    }
}

