/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.MedicalAppointmentInfoMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.CancelAppointmentVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.RabbitMqDelayedOrderVo;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.MedicalAppointmentInfoService;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisCluster;

@Component
public class DelayedAppointmentRecordReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedAppointmentRecordReceiver.class);
    public static final int NO_PAY_AUTO_CANCEL_APPOINTMENT = 2;
    @Autowired
    private AppointmentService appointmentService;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private MedicalAppointmentInfoMapper medicalAppointmentInfoMapper;
    @Autowired
    private MedicalAppointmentInfoService medicalAppointmentInfoService;
    @Autowired
    private JedisCluster jedisCluster;
    private static String AUTO_CANCEL = "\u8d85\u65f6\u672a\u4ed8\u6b3e\u81ea\u52a8\u53d6\u6d88";

    @RabbitListener(queues={"wisdommedical.appointment.delayed.order.jcszxyy_pro"})
    @RabbitHandler
    public void process(String rabbitMqDelayedOrderVoStr) {
        try {
            log.info("Fetch appointment info from rabbit mq\uff1a " + rabbitMqDelayedOrderVoStr);
            RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = (RabbitMqDelayedOrderVo)JSON.parseObject((String)rabbitMqDelayedOrderVoStr, RabbitMqDelayedOrderVo.class);
            if (Objects.isNull(rabbitMqDelayedOrderVo)) {
                log.info("rabbitMqDelayedOrderVoStr\u4e3a\u7a7a");
                return;
            }
            AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(rabbitMqDelayedOrderVo.getSysAppointmentId());
            if (appointmentRecordEntity == null) {
                log.info("\u67e5\u8be2\u8be5\u6302\u53f7\u8ba2\u5355\u4e3a\u7a7a\uff1a" + rabbitMqDelayedOrderVo.getSysAppointmentId());
                return;
            }
            log.info("\u67e5\u8be2\u8be5\u6302\u53f7\u8ba2\u5355\u4e3a\uff1a " + JSON.toJSONString((Object)appointmentRecordEntity));
            if (Objects.equals(AppointmentStatusEnum.WAIT_PAY.getValue(), appointmentRecordEntity.getAppointStatus())) {
                log.info("\u8d85\u65f6\u672a\u4ed8\u6b3e\u81ea\u52a8\u53d6\u6d88 -> " + rabbitMqDelayedOrderVo.getSysAppointmentId());
                CancelAppointmentVoReq cancelAppointmentVoReq = new CancelAppointmentVoReq();
                cancelAppointmentVoReq.setHospitalCode(appointmentRecordEntity.getHospitalCode());
                cancelAppointmentVoReq.setChannelName(appointmentRecordEntity.getChannelCode());
                cancelAppointmentVoReq.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
                this.appointmentService.cancelAppointment(cancelAppointmentVoReq);
            }
        }
        catch (Exception e) {
            log.info("mq\u81ea\u52a8\u53d6\u6d88\u6302\u53f7\u5f02\u5e38 \u8ba2\u5355\u4fe1\u606f:{}", (Throwable)e);
        }
    }
}

