/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.rabbitmq;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.pojo.YB.CreatePayMedicalOrderRequest;
import com.ebaiyihui.wisdommedical.pojo.YB.YbPayMedicalOrder;
import com.ebaiyihui.wisdommedical.service.MedicalService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Component;

@Component
public class YbDelayedPayOrderReceiver {
    private static final Logger log = LoggerFactory.getLogger(YbDelayedPayOrderReceiver.class);
    @Autowired
    MedicalService medicalService;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    private final String redisKeyExpenseDetails = "fymx";
    private final String redisKeyMedicareRecords = "ybjl";
    private final String redisKeyPaymentDetails = "jfxq";
    private final String redisKeyMedicalInsuranceWithdrawal = "ybcx";

    @RabbitListener(queues={"wisdommedical.appointment.delayed.order.jcszxyy1_pro"})
    @RabbitHandler
    public void process(String rabbitMqYbPayment) {
        try {
            log.info("rabbitMqYbPayment->{}", (Object)JSON.toJSONString((Object)rabbitMqYbPayment, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            YbPayMedicalOrder ybPayMedicalOrder = (YbPayMedicalOrder)JSON.parseObject((String)rabbitMqYbPayment, YbPayMedicalOrder.class);
            log.info("mq\u5bf9\u8c61\u5185\u5bb9\u4e3a->{}", (Object)JSON.toJSONString((Object)ybPayMedicalOrder));
            if (BeanUtil.isEmpty((Object)ybPayMedicalOrder, (String[])new String[0])) {
                log.error("\u5f53\u524dmq\u5bf9\u8c61\u4e3a\u7a7a");
            }
            if (ybPayMedicalOrder.getId().equals("1")) {
                this.ybMedicalPayment(ybPayMedicalOrder);
                return;
            }
        }
        catch (Exception e) {
            log.error("mq\u51fa\u73b0\u4e25\u91cd\u5f02\u5e38->{}", (Throwable)e);
            return;
        }
    }

    private void ybMedicalPayment(YbPayMedicalOrder ybPayMedicalOrder) {
        String s = (String)this.redisTemplate.opsForValue().get((Object)("ybjl" + ybPayMedicalOrder.getOutPatientId()));
        if (StrUtil.isBlank((CharSequence)s)) {
            log.error("redis\u5185\u83b7\u53d6\u533b\u4fdd\u64a4\u9500\u4fe1\u606f\u4e3a\u7a7a \u65e0\u6cd5\u8fdb\u884c\u8ba2\u5355\u64a4\u9500");
            return;
        }
        CreatePayMedicalOrderRequest createPayMedicalOrderRequest = (CreatePayMedicalOrderRequest)JSONObject.parseObject((String)s, CreatePayMedicalOrderRequest.class);
        String s1 = this.medicalService.medicalRevokeorder(createPayMedicalOrderRequest);
        if ("\u8d39\u7528\u660e\u7ec6\u64a4\u9500\u5931\u8d25".equals(s1)) {
            log.error("mq\u7f34\u8d39\u8ba2\u5355\u64a4\u9500\u5931\u8d25!");
            return;
        }
        log.info("\u533b\u4fdd\u8ba2\u5355\u64a4\u9500\u6210\u529f-------\u5f00\u59cb\u4fee\u6539\u8ba2\u5355\u72b6\u6001");
    }
}

