/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateTime;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.IdcardUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.api.AppointmentClient;
import com.ebaiyihui.api.PaymentClient;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.common.pojo.vo.card.UcCardListReqVO;
import com.ebaiyihui.common.pojo.vo.card.UserCardListRespVO;
import com.ebaiyihui.common.pojo.vo.card.UserPatientListRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.hkdhisfront.appoint.GetScheduleResVO;
import com.ebaiyihui.hkdhisfront.appoint.NoSchedulingRegistResVO;
import com.ebaiyihui.hkdhisfront.appoint.NoSchedulingRequestRegVo;
import com.ebaiyihui.hkdhisfront.appoint.RegBookingResVo;
import com.ebaiyihui.hkdhisfront.appoint.RequestBookIdVo;
import com.ebaiyihui.hkdhisfront.appoint.RequestRegBookedVo;
import com.ebaiyihui.hkdhisfront.appoint.RequestRegBookingVo;
import com.ebaiyihui.hkdhisfront.appoint.ResultInfoVo;
import com.ebaiyihui.hkdhisfront.base.FrontRequest;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.hkdhisfront.outpatient.PayItemReq;
import com.ebaiyihui.hkdhisfront.payment.AttachParams;
import com.ebaiyihui.hkdhisfront.payment.CreateOrderRequest;
import com.ebaiyihui.hkdhisfront.payment.CreateOrderResponse;
import com.ebaiyihui.hkdhisfront.payment.CreateRefundOrderRequest;
import com.ebaiyihui.hkdhisfront.payment.CreateRefundOrderResponse;
import com.ebaiyihui.hkdhisfront.payment.DeliverApplyRequest;
import com.ebaiyihui.hkdhisfront.payment.DeliverNotifyRequest;
import com.ebaiyihui.hkdhisfront.payment.PayCallBackRequest;
import com.ebaiyihui.hkdhisfront.payment.PrepayRequest;
import com.ebaiyihui.hkdhisfront.payment.PrepayResponse;
import com.ebaiyihui.hkdhisfront.payment.RefundDetailEntity;
import com.ebaiyihui.hkdhisfront.payment.RefundDetailRes;
import com.ebaiyihui.hkdhisfront.payment.RefundNotifyRequest;
import com.ebaiyihui.hkdhisfront.payment.RefundRequest;
import com.ebaiyihui.hkdhisfront.payment.TradeCancelRequest;
import com.ebaiyihui.push.pojo.miniapp.AlibabaMedicalPushReqVO;
import com.ebaiyihui.push.pojo.miniapp.RegistrationPushReqVo;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.BusinessTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.CancelTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundChannelCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.OutpatientPaymentException;
import com.ebaiyihui.wisdommedical.exception.ScheduleException;
import com.ebaiyihui.wisdommedical.gateway.GateWayCommonUtil;
import com.ebaiyihui.wisdommedical.gateway.RouteEnum;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.BusinessResultMapper;
import com.ebaiyihui.wisdommedical.mapper.DoctorRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalConfigMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.BusinessResultEntity;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.HospitalConfigEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleRecordEntity;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.DoDayAppointmentDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentPayVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordDetailVo;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordVo;
import com.ebaiyihui.wisdommedical.pojo.vo.CancelAppointmentVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ConfirmAppointmentVo;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentPayVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetConfirmPayInfoVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.RabbitMqDelayedOrderVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRefundOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.SmsVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdateDelayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdatePayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.WithdrawNumberVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.DocAppendInfoResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetAdmissionReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.PayRequestVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.ScanCodeRegistrationReqVO;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.OutpatientPaymentService;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.PayUtil;
import com.ebaiyihui.wisdommedical.util.RabbitMqUtils;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import his.pojo.vo.appoint.CancelRegisterReq;
import his.pojo.vo.appoint.CancelRegisterRes;
import his.pojo.vo.appoint.DayRegisterReq;
import his.pojo.vo.appoint.GetAppointRecordReq;
import his.pojo.vo.appoint.GetAppointRecords;
import his.pojo.vo.appoint.LockOrderReq;
import his.pojo.vo.appoint.LockOrderRes;
import his.pojo.vo.appoint.PayRegistrationMsg;
import his.pojo.vo.appoint.PayRegistrationReq;
import his.pojo.vo.appoint.PayRegistrationRes;
import his.pojo.vo.appoint.ReturnRegisterReq;
import his.pojo.vo.appoint.ReturnRegisterRes;
import his.pojo.vo.base.GatewayRequest;
import his.pojo.vo.base.GatewayResponse;
import his.pojo.vo.nucleic.nucleicAcidAppointmentReq;
import his.pojo.vo.outpatient.PayItemRes;
import his.pojo.vo.outpatient.datas.PayItemResDatas;
import his.pojo.vo.outpatient.items.GetAdmissionItems;
import his.pojo.vo.schedule.GetScheduleReqVO;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class AppointmentServiceImpl
implements AppointmentService {
    private static final Logger log = LoggerFactory.getLogger(AppointmentServiceImpl.class);
    public static final int HAF_HOURS = 1800;
    public static final int TWO_HOURS = 7200;
    public static final int CURRENT_DAY_APPOINTMENT = 2;
    public static final int NOT_CURRENT_DAY_APPOINTMENT = 1;
    public static final String YES_TOPAY = "1";
    public static final String NOT_TOPAY = "0";
    public static final String SUCCESS = "Y";
    public static final int HAVE_TIME_ARRANGE_FLAG = 1;
    public static final String HIS_MORNING = "0";
    public static final String HIS_AFTERNOON = "1";
    @Autowired
    private PayUtil payUtil;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private OutpatientPaymentService outpatientPaymentService;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private HospitalConfigMapper hospitalConfigMapper;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private BusinessResultMapper businessResultMapper;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private PushService pushService;
    public static final List<Integer> WAIT_CONFIRMED = Arrays.asList(11, 15, 16, 17, 18);
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private AppointmentClient appointmentClient;
    @Autowired
    private PaymentClient paymentClient;
    private String hisOrderNumber = "his-order-number";
    @Autowired
    private DoctorRecordMapper doctorRecordMapper;

    public String confirmAppointment(ConfirmAppointmentVo confirmAppointmentVo) throws ScheduleException {
        List timeArrangeItems;
        String admDate = confirmAppointmentVo.getAdmDate();
        if (String.valueOf(LocalDate.now()).equals(admDate) && confirmAppointmentVo.getIsTimeArrange().equals(1) && !CollectionUtils.isEmpty((Collection)(timeArrangeItems = confirmAppointmentVo.getTimeArrangeItems()))) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            timeArrangeItems.stream().filter(timeArrangeItem -> {
                LocalDateTime localDateTime = LocalDateTime.now();
                String admDteTimeStr = admDate + " " + timeArrangeItem.getStartTime();
                String nowDateTimeStr = localDateTime.format(DateTimeFormatter.ofPattern("yyyy-MM-dd hh:mm"));
                try {
                    Long admDteTime = sdf.parse(admDteTimeStr).getTime();
                    Long nowDateTime = sdf.parse(nowDateTimeStr).getTime();
                    return admDteTime <= nowDateTime;
                }
                catch (Exception e) {
                    log.error("\u8f6c\u6362\u65e5\u671f\u5f02\u5e38:" + e);
                    return false;
                }
            }).collect(Collectors.toList());
        }
        String confirmAppointmentId = String.valueOf(this.snowflakeIdWorker.nextId());
        if (String.valueOf(LocalDate.now()).equals(admDate)) {
            confirmAppointmentVo.setAppointmentType(2);
        } else {
            confirmAppointmentVo.setAppointmentType(1);
        }
        String confirmAppointmentVoStr = JSON.toJSONString((Object)confirmAppointmentVo);
        this.jedisCluster.set(confirmAppointmentId, confirmAppointmentVoStr);
        this.jedisCluster.expire(confirmAppointmentId, 7200);
        return confirmAppointmentId;
    }

    public String dayAppointmentCreateOrder(DayAppointmentCreateOrderVoReq createOrderVoReq) throws Exception {
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u5165\u53c2{}", (Object)JSON.toJSONString((Object)createOrderVoReq, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null == cardDetail) {
            throw new AppointmentException("\u83b7\u53d6\u60a3\u8005\u5c31\u8bca\u5361\u4fe1\u606f\u5931\u8d25\uff0c\u6302\u53f7\u5f02\u5e38!");
        }
        this.registrationRules(createOrderVoReq.getIdNo(), createOrderVoReq.getDeptCode(), createOrderVoReq.getDeptName());
        long sysAppointmentId = this.snowflakeIdWorker.nextId();
        LockOrderRes dayRegisterRes = new LockOrderRes();
        FrontRequest frontRequest = this.buildPayRegistrationReq(createOrderVoReq);
        log.info("\u8bf7\u6c42\u5f53\u65e5\u6302\u53f7\u9884\u7ed3\u7b97\u63a5\u53e3\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)frontRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        return null;
    }

    private void registrationRules(String idNo, String deptCode, String deptName) throws AppointmentException {
        log.info("registrationRules \u5165\u53c2 idNo - >{}, deptCode - > {}", (Object)idNo, (Object)deptCode);
        String gender = Convert.toStr((Object)IdcardUtil.getGenderByIdCard((String)idNo));
        int age = IdcardUtil.getAgeByIdCard((String)idNo);
        if (deptName.contains("\u513f\u79d1") && age > 18) {
            throw new AppointmentException("\u513f\u79d1\u95e8\u8bca\uff0c\u53ea\u5141\u8bb818\u5468\u5c81\u53ca\u4ee5\u4e0b\u6302\u53f7");
        }
        if ((deptName.contains("\u5987\u79d1") || deptName.contains("\u4ea7\u79d1")) && "1".equals(gender)) {
            throw new AppointmentException("\u5987\u4ea7\u79d1\u95e8\u8bca\uff0c\u53ea\u5141\u8bb8\u5973\u6027\u6302\u53f7");
        }
    }

    private void registrationRulesByDept(String patientCardNo, String admDate) throws AppointmentException {
        String beginDate = admDate + " 00:00:00";
        String endDate = admDate + " 23:59:59";
    }

    private FrontRequest<DayRegisterReq> bulidDayRegisterReq(DayAppointmentCreateOrderVoReq createOrderVoReq, FrontResponse<PayRegistrationRes> payRegistrationResFrontRespons) {
        FrontRequest frontRequest = new FrontRequest();
        DayRegisterReq dayRegisterReq = new DayRegisterReq();
        dayRegisterReq.setRbasId(createOrderVoReq.getScheduleHisId());
        dayRegisterReq.setAdmNo(((PayRegistrationRes)payRegistrationResFrontRespons.getBody()).getReceiptId());
        dayRegisterReq.setTimeArrangeId(createOrderVoReq.getStarTime());
        dayRegisterReq.setRegFee(createOrderVoReq.getRegFee());
        dayRegisterReq.setPayChannel(createOrderVoReq.getHl());
        dayRegisterReq.setCardNo(createOrderVoReq.getPatientCardNo());
        dayRegisterReq.setTimeFlag(createOrderVoReq.getEndTime());
        if (createOrderVoReq.getHl().equals("2")) {
            dayRegisterReq.setDoctorNo(createOrderVoReq.getDocCode() + "*" + createOrderVoReq.getDocName());
        } else {
            dayRegisterReq.setDeptNo(createOrderVoReq.getDeptCode() + "*" + createOrderVoReq.getDeptName());
        }
        dayRegisterReq.setMedicalFee(createOrderVoReq.getDiagFee());
        frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        frontRequest.setBody((Object)dayRegisterReq);
        return frontRequest;
    }

    private FrontRequest<PayRegistrationReq> buildPayRegistrationReq(DayAppointmentCreateOrderVoReq createOrderVoReq) {
        FrontRequest frontRequest = new FrontRequest();
        PayRegistrationReq payRegistrationReq = new PayRegistrationReq();
        payRegistrationReq.setPatientId(createOrderVoReq.getDocCode());
        payRegistrationReq.setCardNo(createOrderVoReq.getPatientCardNo());
        payRegistrationReq.setAppointId(createOrderVoReq.getDeptCode());
        payRegistrationReq.setScheduleId(createOrderVoReq.getHl());
        frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        frontRequest.setBody((Object)payRegistrationReq);
        return frontRequest;
    }

    public String nucleicAppointmentCreateOrder(DayAppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException, OutpatientPaymentException {
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null == cardDetail) {
            throw new AppointmentException("\u83b7\u53d6\u60a3\u8005\u5c31\u8bca\u5361\u4fe1\u606f\u5931\u8d25\uff0c\u6302\u53f7\u5f02\u5e38!");
        }
        GatewayRequest gatewayRequest = this.buildGetScheduleGatewayReq(createOrderVoReq);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.GET_DOC_SCHEDULE_INFO.getValue(), gatewayRequest, GetScheduleResVO.class);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new AppointmentException("\u6392\u73ed\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        }
        AppointmentRecordEntity appointmentRecordEntity = null;
        long sysAppointmentId = this.snowflakeIdWorker.nextId();
        GatewayRequest dayGatewayRequest = this.buildDayConfirmRegisterReq(sysAppointmentId, createOrderVoReq);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u9501\u53f7 \u8bf7\u6c42his\u5165\u53c2\uff1a" + dayGatewayRequest);
        GatewayResponse dayGatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), dayGatewayRequest.getOrganCode(), RouteEnum.CONFIRM_REGISTER.getValue(), dayGatewayRequest, LockOrderRes.class);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u9501\u53f7 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + dayGatewayResponse);
        if (null == dayGatewayResponse) {
            log.error("\u5f53\u65e5\u6302\u53f7 \u9501\u53f7\u5931\u8d25 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u9501\u53f7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        if (!"1".equals(dayGatewayResponse.getCode())) {
            log.error("\u5f53\u65e5\u6302\u53f7 \u9501\u53f7\u5931\u8d25 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)dayGatewayResponse.getErrCode(), (Object)dayGatewayResponse.getMsg());
            throw new AppointmentException("\u9501\u53f7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u53bb\u4eba\u5de5\u7a97\u53e3\u8fdb\u884c\u6302\u53f7");
        }
        if (null == dayGatewayResponse.getData()) {
            log.error("\u5f53\u65e5\u6302\u53f7 \u9501\u53f7\u5931\u8d25 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException("\u9501\u53f7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u53bb\u4eba\u5de5\u7a97\u53e3\u8fdb\u884c\u6302\u53f7");
        }
        LockOrderRes dayRegisterRes = (LockOrderRes)dayGatewayResponse.getData();
        GatewayRequest dayPayGatewayRequest = this.buildNucleicRegisterParams(appointmentRecordEntity);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse dayPayGatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), dayPayGatewayRequest.getOrganCode(), RouteEnum.REGISTERHT_PAY.getValue(), dayPayGatewayRequest, PayRegistrationRes.class);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)gatewayResponse));
        if (null == dayPayGatewayResponse.getData() || null == dayPayGatewayResponse) {
            log.error("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8 ========= -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(dayPayGatewayResponse.getMsg());
        }
        if (!"1".equals(dayPayGatewayResponse.getCode())) {
            log.error("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8 ========= -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)dayPayGatewayResponse.getErrCode(), (Object)dayPayGatewayResponse.getMsg());
            throw new AppointmentException(dayPayGatewayResponse.getMsg());
        }
        GetAdmissionReqVO getAdmissionReqVO = new GetAdmissionReqVO();
        getAdmissionReqVO.setCardNo(appointmentRecordEntity.getPatientId());
        List getAdmissionItemsList = this.outpatientPaymentService.getAdmission(getAdmissionReqVO);
        getAdmissionItemsList.removeIf(o -> !o.getDeptName().equals("\u6838\u9178\u68c0\u6d4b\u4fbf\u6c11\u95e8\u8bca"));
        getAdmissionItemsList.sort(Comparator.comparing(GetAdmissionItems::getAdmDate).reversed());
        GetAdmissionItems getAdmissionItems = (GetAdmissionItems)getAdmissionItemsList.get(0);
        if (getAdmissionItemsList.size() <= 0 || null == getAdmissionItems) {
            log.error("\u6838\u9178\u7f34\u8d39\u5904\u65b9\u5217\u8868 ========= -> his\u67e5\u8be2\u5931\u8d25");
            throw new AppointmentException("\u672a\u67e5\u8be2\u5230\u6838\u9178\u5f85\u7f34\u8d39\u5904\u65b9");
        }
        GatewayRequest detilGatewayRequest = this.buildNucleicOutDetialParams(appointmentRecordEntity, getAdmissionItems);
        GatewayResponse detilGatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), detilGatewayRequest.getOrganCode(), RouteEnum.PATIENT_PAYMENT_DETAILS.getValue(), detilGatewayRequest, PayItemRes.class);
        PayItemRes data = (PayItemRes)detilGatewayResponse.getData();
        PayItemResDatas payItemResDatas = (PayItemResDatas)data.getDatas().get(0);
        if (data.getDatas().size() <= 0 || null == payItemResDatas) {
            log.error("\u6838\u9178\u7f34\u8d39\u5904\u65b9\u8be6\u60c5 ========= -> his\u67e5\u8be2\u5931\u8d25");
            throw new AppointmentException("\u672a\u67e5\u8be2\u5230\u6838\u9178\u5f85\u7f34\u8d39\u5904\u65b9\u8be6\u60c5");
        }
        if (!"1".equals(detilGatewayResponse.getCode())) {
            log.error("\u6838\u9178\u7f34\u8d39\u5904\u65b9\u8be6\u60c5 ========= -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)detilGatewayResponse.getErrCode(), (Object)detilGatewayResponse.getMsg());
            throw new AppointmentException(detilGatewayResponse.getMsg());
        }
        appointmentRecordEntity.setReceptId(payItemResDatas.getAdmId());
        appointmentRecordEntity.setPayAmount(payItemResDatas.getAmount());
        log.info("\u8ba2\u5355\u4fe1\u606f\uff1a" + JSON.toJSONString(appointmentRecordEntity));
        this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
        AppointmentRecordEntity recordEntity = this.appointmentRecordMapper.selectBySysAppointId(appointmentRecordEntity.getSysAppointmentId());
        RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = new RabbitMqDelayedOrderVo();
        rabbitMqDelayedOrderVo.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        rabbitMqDelayedOrderVo.setOrderId(String.valueOf(recordEntity.getId()));
        RabbitMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)rabbitMqDelayedOrderVo));
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private GatewayRequest<PayItemReq> buildNucleicOutDetialParams(AppointmentRecordEntity appointmentRecordEntity, GetAdmissionItems getAdmissionItems) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PayItemReq payItemReq = new PayItemReq();
        payItemReq.setAdmId(getAdmissionItems.getAdmId());
        payItemReq.setCardNo(appointmentRecordEntity.getPatientId());
        gatewayRequest.setBody((Object)payItemReq);
        return gatewayRequest;
    }

    public ConfirmAppointmentVo getConfirmAppointment(String confirmAppointmentId) {
        String confirmAppointmentVoStr = this.jedisCluster.get(confirmAppointmentId);
        ConfirmAppointmentVo confirmAppointmentVo = (ConfirmAppointmentVo)JSON.parseObject((String)confirmAppointmentVoStr, ConfirmAppointmentVo.class);
        List timeArrangeItemsList = null;
        if (null != confirmAppointmentVo && !CollectionUtils.isEmpty((Collection)confirmAppointmentVo.getTimeArrangeItems())) {
            timeArrangeItemsList = confirmAppointmentVo.getTimeArrangeItems();
            timeArrangeItemsList.sort(Comparator.comparing(GetScheduleResVO.TimeArrangeItems::getStartTime));
        }
        return confirmAppointmentVo;
    }

    public GetConfirmPayInfoVoRes getConfirmPayInfo(String sysAppointmentId) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        GetConfirmPayInfoVoRes getConfirmPayInfoVoRes = new GetConfirmPayInfoVoRes();
        getConfirmPayInfoVoRes.setCreateTime(appointmentRecordEntity.getCreatetime());
        getConfirmPayInfoVoRes.setPayAccount(appointmentRecordEntity.getPayAmount());
        getConfirmPayInfoVoRes.setSysAppointmentId(sysAppointmentId);
        getConfirmPayInfoVoRes.setAppointmentType(appointmentRecordEntity.getAppointmentType());
        getConfirmPayInfoVoRes.setPatientName(appointmentRecordEntity.getPatientName());
        return getConfirmPayInfoVoRes;
    }

    public List<AppointmentRecordVo> selectByUserIdAndStatus(Map<String, Object> queryMap, String appCode, String channelCode) throws Exception {
        UcCardListReqVO reqVo = new UcCardListReqVO();
        reqVo.setUserId((String)queryMap.get("userId"));
        reqVo.setOrganCode((String)queryMap.get("hospitalCode"));
        reqVo.setAppCode(appCode);
        reqVo.setChannelCode(channelCode);
        List cardIdList = this.getCardIdList(reqVo);
        List appointmentRecordEntityList = null;
        if (cardIdList.size() < 1) {
            return new ArrayList<AppointmentRecordVo>();
        }
        queryMap.put("cardIdList", cardIdList);
        appointmentRecordEntityList = this.appointmentRecordMapper.selectByUserIdAndStatus(queryMap);
        return this.buildAppointmentRecordVo(appointmentRecordEntityList);
    }

    private GatewayRequest<GetScheduleReqVO> buildGetScheduleGatewayReq(DayAppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(dayAppointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setEdDate(dayAppointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setLocCode(dayAppointmentCreateOrderVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(dayAppointmentCreateOrderVoReq.getDocCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(dayAppointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setChannel(dayAppointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("dayAppointmentCreateOrder");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public List<AppointmentRecordVo> getAppointRecordByCardList(String userId, String hospitalCode, String appCode, String channelCode) throws AppointmentException {
        UcCardListReqVO reqVo = new UcCardListReqVO();
        reqVo.setUserId(userId);
        reqVo.setOrganCode(hospitalCode);
        reqVo.setAppCode(appCode);
        reqVo.setChannelCode(channelCode);
        List cardIdList = this.getCardIdList(reqVo);
        if (CollectionUtils.isEmpty((Collection)cardIdList)) {
            return new ArrayList<AppointmentRecordVo>();
        }
        List appointmentRecordEntityList = null;
        Date startDate = DateUtils.getCurrentDate();
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("admDateStart", DateUtils.dateToSimpleString((Date)startDate));
        queryMap.put("admDateEnd", DateUtils.dateToSimpleString((Date)DateUtils.getDateAfter((Date)startDate, (int)7)));
        queryMap.put("userId", userId);
        ArrayList<Integer> appointStatusList = new ArrayList<Integer>();
        appointStatusList.add(AppointmentStatusEnum.PAY.getValue());
        appointStatusList.add(AppointmentStatusEnum.WAIT_PAY.getValue());
        queryMap.put("appointStatus", appointStatusList);
        queryMap.put("now", DateUtils.dateToSimpleString((Date)startDate));
        queryMap.put("hospitalCode", hospitalCode);
        queryMap.put("cardIdList", cardIdList);
        appointmentRecordEntityList = this.appointmentRecordMapper.selectByUserIdAndStatus(queryMap);
        appointmentRecordEntityList = appointmentRecordEntityList.stream().filter(appointmentRecordEntity -> appointmentRecordEntity.getAppointmentType() != AppointmentTypeEnums.DAY_APPOINTMENT.getValue().intValue() || !appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.WAIT_PAY.getValue())).collect(Collectors.toList());
        return this.buildAppointmentRecordVo(appointmentRecordEntityList);
    }

    private List<String> getCardIdList(UcCardListReqVO reqVo) throws AppointmentException {
        ArrayList<String> cardIdList = new ArrayList<String>();
        log.error("getCardIdList start-------reqVo:{}", (Object)reqVo);
        BaseResponse resp = this.getCardInfoUtil.getUserCardList(reqVo);
        List UserPatientListRespVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)resp.getData()), UserPatientListRespVO.class);
        for (UserPatientListRespVO userPatientListRespVO : UserPatientListRespVOList) {
            List userCardListRespVOList = userPatientListRespVO.getUserCardListRespVOS();
            if (userCardListRespVOList == null && userCardListRespVOList.size() <= 0) continue;
            for (UserCardListRespVO userCardListRespVO : userCardListRespVOList) {
                if (userCardListRespVO == null || userCardListRespVO.getCardId() == null || "".equals(userCardListRespVO.getCardId())) continue;
                cardIdList.add(userCardListRespVO.getCardId());
            }
        }
        return cardIdList;
    }

    public List<AppointmentRecordVo> getMyRegistrationList(String cardNo) throws Exception {
        log.info("\u6211\u7684\u6302\u53f7\u8bb0\u5f55  \u5165\u53c2\uff1a" + cardNo);
        List appointmentRecordEntityList = this.appointmentRecordMapper.getMyRegistrationList(cardNo);
        log.info("\u6211\u7684\u6302\u53f7\u8bb0\u5f55  \u67e5\u8be2\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)appointmentRecordEntityList));
        List appointmentRecordVoList = this.buildAppointmentRecordVo(appointmentRecordEntityList);
        for (int i = 0; i < appointmentRecordVoList.size(); ++i) {
            AppointmentRecordVo appointmentRecordVo = (AppointmentRecordVo)appointmentRecordVoList.get(i);
            String admDate = appointmentRecordVo.getAdmDate();
            boolean flag = DateUtils.judgeDate((String)appointmentRecordVo.getAdmDate(), (String)String.valueOf(LocalDate.now()));
            if (admDate.equals(String.valueOf(LocalDate.now()))) {
                appointmentRecordVo.setIsTheDay(0L);
            } else if (flag) {
                appointmentRecordVo.setIsTheDay(1L);
            } else if (!flag) {
                appointmentRecordVo.setIsTheDay(-1L);
            }
            appointmentRecordVo.setExpiredtime(480L);
            if (appointmentRecordVo.getScheduleType().contains("3")) {
                appointmentRecordVo.setExpiredendtime(appointmentRecordVo.getCreatetime() + 180000L);
                continue;
            }
            appointmentRecordVo.setExpiredendtime(appointmentRecordVo.getCreatetime() + 600000L);
        }
        log.info("\u6211\u7684\u6302\u53f7\u8bb0\u5f55  \u8fd4\u56de\u5bf9\u8c61 \uff1a" + JSON.toJSONString((Object)appointmentRecordVoList));
        return appointmentRecordVoList;
    }

    private List<AppointmentRecordVo> buildAppointmentRecordVo(List<AppointmentRecordEntity> appointmentRecordEntityList) throws AppointmentException {
        if (CollectionUtils.isEmpty(appointmentRecordEntityList)) {
            return new ArrayList<AppointmentRecordVo>();
        }
        log.info("\u672c\u4eba\u8bca\u7597\u6302\u53f7\u6570\u636e ------>{}", appointmentRecordEntityList);
        ArrayList<AppointmentRecordVo> appointmentRecordVoList = new ArrayList<AppointmentRecordVo>();
        for (int i = 0; i < appointmentRecordEntityList.size(); ++i) {
            AppointmentRecordEntity appointmentRecordEntity = appointmentRecordEntityList.get(i);
            if (StringUtils.isEmpty((String)appointmentRecordEntity.getPayAmount())) continue;
            AppointmentRecordVo appointmentRecordVo = new AppointmentRecordVo();
            appointmentRecordVo.setAdmDate(appointmentRecordEntity.getAdmDate());
            appointmentRecordVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
            appointmentRecordVo.setScheduleType(appointmentRecordEntity.getScheduleType());
            Integer appointStatus = appointmentRecordEntity.getAppointStatus();
            if (WAIT_CONFIRMED.contains(appointStatus)) {
                appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
            }
            appointmentRecordVo.setAppointStatus(appointStatus);
            appointmentRecordVo.setDeptName(appointmentRecordEntity.getDeptName());
            appointmentRecordVo.setDocName(appointmentRecordEntity.getDocName());
            appointmentRecordVo.setPatientIdCard(appointmentRecordEntity.getCardId());
            appointmentRecordVo.setUserId(appointmentRecordEntity.getUserId());
            appointmentRecordVo.setPatientName(appointmentRecordEntity.getPatientName());
            appointmentRecordVo.setAdmRange(appointmentRecordEntity.getAdmRange());
            appointmentRecordVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
            appointmentRecordVo.setRegFee(new BigDecimal(appointmentRecordEntity.getPayAmount()));
            appointmentRecordVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
            appointmentRecordVo.setAppointmentType(appointmentRecordEntity.getAppointmentType());
            if (appointmentRecordEntity.getCreatetime() != null) {
                long createtime = appointmentRecordEntity.getCreatetime().getTime();
                appointmentRecordVo.setCreatetime(createtime);
            }
            long daysRemaining = 0L;
            try {
                daysRemaining = DateUtils.getDistanceDays((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            }
            catch (Exception e) {
                log.error("-------\u8ba1\u7b97\u8ddd\u79bb\u5c31\u8bca\u65e5\u5931\u8d25-------");
            }
            appointmentRecordVo.setDaysRemaining(daysRemaining);
            boolean flag = DateUtils.judgeDate((String)appointmentRecordEntity.getAdmDate(), (String)String.valueOf(LocalDate.now()));
            appointmentRecordVo.setIsTheDay(flag ? 1L : -1L);
            CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
            cardDetailsInfoReqVO.setCardId(appointmentRecordEntity.getCardId());
            cardDetailsInfoReqVO.setChannelCode("app");
            CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
            if (cardDetailsInfoRespVO != null && cardDetailsInfoRespVO.getCardTypeName() != null) {
                appointmentRecordVo.setPatientCardName(cardDetailsInfoRespVO.getCardTypeName());
            }
            appointmentRecordVoList.add(appointmentRecordVo);
        }
        return appointmentRecordVoList;
    }

    public AppointmentRecordDetailVo getMyRegistrationDetail(String sysAppointmentId) throws AppointmentException {
        log.info("AppointmentServiceImpl.getMyRegistrationDetail->\u8bf7\u6c42\u53c2\u6570sysAppointmentId:{}", (Object)sysAppointmentId);
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        if (null == appointmentRecordEntity) {
            log.error("AppointmentServiceImpl.getMyRegistrationDetail->\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570sysAppointmentId\u4e3a:{}", (Object)sysAppointmentId);
            throw new AppointmentException();
        }
        String hospitalCode = appointmentRecordEntity.getHospitalCode();
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(appointmentRecordEntity.getCardId());
        cardDetailsInfoReqVO.setChannelCode("app");
        AppointmentRecordDetailVo appointmentRecordDetailVo = new AppointmentRecordDetailVo();
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        if (cardDetailsInfoRespVO != null && cardDetailsInfoRespVO.getCardTypeName() != null) {
            appointmentRecordDetailVo.setPatientCardName(cardDetailsInfoRespVO.getCardTypeName());
            int age = 0;
            try {
                age = DateUtils.getAgeByBirth((Date)DateUtils.stringToSimpleDate((String)cardDetailsInfoRespVO.getBirth()));
            }
            catch (ParseException e) {
                throw new AppointmentException("\u5e74\u9f84\u8f6c\u5316\u5f02\u5e38\uff01");
            }
            appointmentRecordDetailVo.setPatientAge(Integer.valueOf(age));
            appointmentRecordDetailVo.setPatientSex(Integer.valueOf(cardDetailsInfoRespVO.getGender().intValue()));
            appointmentRecordDetailVo.setPatientId(appointmentRecordEntity.getPatientId());
        }
        this.buildAppointmentRecordDetailVo(appointmentRecordDetailVo, appointmentRecordEntity, hospitalCode);
        return appointmentRecordDetailVo;
    }

    private void buildAppointmentRecordDetailVo(AppointmentRecordDetailVo appointmentRecordDetailVo, AppointmentRecordEntity appointmentRecordEntity, String hospitalCode) {
        appointmentRecordDetailVo.setRemark(appointmentRecordEntity.getRemark());
        appointmentRecordDetailVo.setId(appointmentRecordEntity.getId());
        appointmentRecordDetailVo.setPatientName(appointmentRecordEntity.getPatientName());
        appointmentRecordDetailVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        Date admDate = DateUtils.stringToSimpleDate((String)appointmentRecordEntity.getAdmDate());
        appointmentRecordDetailVo.setAdmDate(DateUtils.dateToYMDString((Date)admDate));
        appointmentRecordDetailVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
        appointmentRecordDetailVo.setWeekday(DateUtils.getWeekZhou((String)appointmentRecordEntity.getAdmDate()));
        appointmentRecordDetailVo.setPatientId(appointmentRecordEntity.getPatientId());
        appointmentRecordDetailVo.setDocName(appointmentRecordEntity.getDocName());
        appointmentRecordDetailVo.setDeptName(appointmentRecordEntity.getDeptName());
        if (StringUtils.isNotEmpty((String)appointmentRecordEntity.getAdmAddress())) {
            appointmentRecordDetailVo.setAdmAddress(appointmentRecordEntity.getAdmAddress());
        } else {
            appointmentRecordDetailVo.setAdmAddress(appointmentRecordEntity.getHospitalName() + " " + appointmentRecordEntity.getDeptName());
        }
        appointmentRecordDetailVo.setPatientCardNo(appointmentRecordEntity.getPatientCardNo());
        appointmentRecordDetailVo.setCreatetime(appointmentRecordEntity.getCreatetime().getTime());
        appointmentRecordDetailVo.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        HospitalConfigEntity hospitalConfigEntity = this.hospitalConfigMapper.selectByHospitalCode(hospitalCode);
        if (hospitalConfigEntity != null && hospitalConfigEntity.getAppointAutoCancelMin() != null) {
            int appointAutoCancelMin = hospitalConfigEntity.getAppointAutoCancelMin();
            appointmentRecordDetailVo.setExpiredtime((long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60));
            appointmentRecordDetailVo.setExpiredendtime(appointmentRecordDetailVo.getCreatetime() + (long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60 * 1000));
        } else {
            appointmentRecordDetailVo.setExpiredtime(480L);
            appointmentRecordDetailVo.setExpiredendtime(appointmentRecordEntity.getCreatetime().getTime() + 480000L);
        }
        appointmentRecordDetailVo.setAppointmentType(appointmentRecordEntity.getAppointmentType());
        appointmentRecordDetailVo.setAdmRange(appointmentRecordEntity.getAdmRange());
        appointmentRecordDetailVo.setRegTitleName(appointmentRecordEntity.getRegTitleName());
        appointmentRecordDetailVo.setTakeTime(appointmentRecordEntity.getTakeTime());
        appointmentRecordDetailVo.setTakeAddress(appointmentRecordEntity.getTakeAddress());
        appointmentRecordDetailVo.setScheduleLevelName(appointmentRecordEntity.getScheduleLevelName());
        appointmentRecordDetailVo.setRegFee(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentRecordDetailVo.setAppointmentNo(appointmentRecordEntity.getAppointmentNo());
        appointmentRecordDetailVo.setPayAccdate(appointmentRecordEntity.getPayAccdate());
        Integer appointStatus = appointmentRecordEntity.getAppointStatus();
        if (WAIT_CONFIRMED.contains(appointStatus)) {
            appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
        }
        String ade = appointmentRecordEntity.getAdmDate();
        boolean flag = DateUtils.judgeDate((String)appointmentRecordEntity.getAdmDate(), (String)String.valueOf(LocalDate.now()));
        if (ade.equals(String.valueOf(LocalDate.now()))) {
            appointmentRecordDetailVo.setIsTheDay(0L);
        } else if (flag) {
            appointmentRecordDetailVo.setIsTheDay(1L);
        } else if (!flag) {
            appointmentRecordDetailVo.setIsTheDay(-1L);
        }
        try {
            long daysRemaining = DateUtils.getDistanceDays((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            appointmentRecordDetailVo.setDaysRemaining(daysRemaining);
        }
        catch (Exception e) {
            log.error("======\u8ba1\u7b97\u8ddd\u8bca\u65ad\u65e5\u8fd8\u5269\u4e0b\u5929\u6570\u5931\u8d25=====");
        }
        appointmentRecordDetailVo.setAppointStatus(appointStatus.intValue());
        appointmentRecordDetailVo.setRefundMoney(appointmentRecordEntity.getReturnAmount());
        appointmentRecordDetailVo.setRefundTime(appointmentRecordEntity.getReturnAccdate());
        appointmentRecordDetailVo.setCancelType(Integer.valueOf(appointmentRecordEntity.getCancleType()));
        appointmentRecordDetailVo.setHisTimeArrangeId(appointmentRecordEntity.getHisTimeArrangeId());
        if (appointmentRecordEntity.getScheduleType().contains("3")) {
            appointmentRecordDetailVo.setExpiredendtime(appointmentRecordEntity.getCreatetime().getTime() + 180000L);
        } else {
            appointmentRecordDetailVo.setExpiredendtime(appointmentRecordEntity.getCreatetime().getTime() + 600000L);
        }
    }

    public void cancelAppointment(CancelAppointmentVoReq cancelAppointmentVoReq) throws AppointmentException {
        FrontRequest regBookedVoFrontRequest;
        FrontResponse frontResponse;
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(cancelAppointmentVoReq.getSysAppointmentId());
        if (Objects.isNull(appointmentRecordEntity) || !AppointmentStatusEnum.WAIT_PAY.getValue().equals(appointmentRecordEntity.getAppointStatus())) {
            throw new AppointmentException("\u6b64\u8ba2\u5355\u4e0d\u53ef\u53d6\u6d88\uff01");
        }
        if (!(appointmentRecordEntity.getScheduleType().contains("3") || !Objects.isNull(frontResponse = this.appointmentClient.tackNumber(regBookedVoFrontRequest = this.buildCancelRegisterGatewayReq(cancelAppointmentVoReq, appointmentRecordEntity))) && "1".equals(frontResponse.getCode()))) {
            throw new AppointmentException("\u53d6\u6d88\u9884\u7ea6\u5931\u8d25\uff01");
        }
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.CANCEL.getValue());
        appointmentRecordEntity.setCancleTime(new Date());
        appointmentRecordEntity.setCancleType(CancelTypeEnum.CHANNEL_CANCEL.getValue().intValue());
        appointmentRecordEntity.setCancleReason("\u7528\u6237\u53d6\u6d88");
        appointmentRecordEntity.setRemark("\u60a8\u5df2\u53d6\u6d88\u672c\u6b21\u9884\u7ea6\u6302\u53f7");
        appointmentRecordEntity.setCancleChannelCode(cancelAppointmentVoReq.getChannelName());
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    public BaseResponse<String> withdrawNumber(WithdrawNumberVoReq withdrawNumberVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(withdrawNumberVoReq.getSysAppointmentId());
        if (Objects.isNull(appointmentRecordEntity)) {
            throw new AppointmentException("\u5f53\u524d\u6302\u53f7\u8bb0\u5f55\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        if (!appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) {
            throw new AppointmentException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        FrontRequest request = new FrontRequest();
        request.setOrganCode(appointmentRecordEntity.getInnerChannelCode());
        CreateRefundOrderRequest createRefundOrderRequest = CreateRefundOrderRequest.builder().bizRefundCode("register_refund").bizRefundTime(DateUtil.now()).identityId(appointmentRecordEntity.getPatientCardNo()).macNumber("\u4e92\u8054\u7f51\u533b\u9662\u5fae\u4fe1\u5c0f\u7a0b\u5e8f").mobile(appointmentRecordEntity.getPatientPhone()).name(appointmentRecordEntity.getPatientName()).operatorId("zwby").refundReason("\u60a3\u8005\u4e3b\u52a8\u9000\u53f7").totalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount())).build();
        RefundDetailEntity detailEntity = RefundDetailEntity.builder().orgPayAmount(new BigDecimal(appointmentRecordEntity.getPayAmount())).orgPayFlowno(appointmentRecordEntity.getPayTransationId()).orgPayType("WeChatAppletPay").orgTradeNo(appointmentRecordEntity.getPayPostId()).orgTranTime(appointmentRecordEntity.getPayAccdate()).selfRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount())).ybRefundAmount(BigDecimal.ZERO).build();
        ArrayList<RefundDetailEntity> refundDetailEntityList = new ArrayList<RefundDetailEntity>();
        refundDetailEntityList.add(detailEntity);
        createRefundOrderRequest.setRefundDetail(refundDetailEntityList);
        request.setBody((Object)createRefundOrderRequest);
        log.info("\u3010\u9000\u6b3e\u3011\u521b\u5efa\u9000\u6b3e\u5355\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)request));
        FrontResponse frontResponse = this.paymentClient.createRefundOrder(request);
        log.info("\u3010\u9000\u6b3e\u3011\u521b\u5efa\u9000\u6b3e\u5355\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)frontResponse));
        if (Objects.isNull(frontResponse)) {
            log.error("\u3010\u9000\u6b3e\u3011\u521b\u5efa\u9000\u6b3e\u5355\u5931\u8d25, \u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a");
            throw new AppointmentException("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff01\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a");
        }
        if (!"1".equals(frontResponse.getCode())) {
            log.error("\u3010\u9000\u6b3e\u3011\u521b\u5efa\u9000\u6b3e\u5355\u5931\u8d25");
            throw new AppointmentException("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff01" + frontResponse.getMessage());
        }
        CreateRefundOrderResponse createRefundOrderResponse = (CreateRefundOrderResponse)frontResponse.getBody();
        if (Objects.isNull(createRefundOrderResponse)) {
            log.error("\u3010\u9000\u6b3e\u3011\u521b\u5efa\u9000\u6b3e\u5355\u5931\u8d25, \u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u63a5\u53e3\u54cd\u5e94createRefundOrderResponse\u4e3a\u7a7a");
            throw new AppointmentException("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff01\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a");
        }
        List refundDetails = createRefundOrderResponse.getRefundDetail();
        if (CollectionUtils.isEmpty((Collection)refundDetails)) {
            log.error("\u3010\u9000\u6b3e\u3011\u521b\u5efa\u9000\u6b3e\u5355\u5931\u8d25, \u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u63a5\u53e3\u54cd\u5e94refundId\u4e3a\u7a7a");
            throw new AppointmentException("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff01\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u521b\u5efa\u9000\u6b3e\u8ba2\u5355\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a");
        }
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)RequestBookIdVo.builder().bookId(appointmentRecordEntity.getAppointmentId()).flowNo(((RefundDetailRes)refundDetails.get(0)).getRefundId()).build());
        log.info("\u3010\u9000\u53f7\u3011his\u63a5\u53e3\u8bf7\u6c42 frontRequest:{}", (Object)JSON.toJSONString((Object)frontRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        FrontResponse resultInfoVoFrontResponse = this.appointmentClient.payBackNumber(frontRequest);
        log.info("\u3010\u9000\u53f7\u3011his\u63a5\u53e3\u8fd4\u56de frontResponse:{}", (Object)JSON.toJSONString((Object)resultInfoVoFrontResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (Objects.isNull(resultInfoVoFrontResponse)) {
            log.error("\u3010\u9000\u53f7\u3011his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            throw new AppointmentException("\u9000\u53f7\u5931\u8d25\uff01his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
        }
        if (!"1".equals(resultInfoVoFrontResponse.getCode())) {
            log.error("\u3010\u9000\u53f7\u3011his\u63a5\u53e3\u8fd4\u56de\u5931\u8d25,\u5931\u8d25\u539f\u56e0:{}", (Object)resultInfoVoFrontResponse.getMessage());
            throw new AppointmentException("\u9000\u53f7\u5931\u8d25\uff01his\u63a5\u53e3\u8fd4\u56de\u5931\u8d25 \u5931\u8d25\u539f\u56e0:" + resultInfoVoFrontResponse.getMessage());
        }
        FrontRequest refundNotifyRequestFrontRequest = new FrontRequest();
        refundNotifyRequestFrontRequest.setOrganCode(appointmentRecordEntity.getInnerChannelCode());
        JSONObject bizExtendParams = new JSONObject();
        bizExtendParams.put("his_refund_serial_number", (Object)appointmentRecordEntity.getAppointmentId());
        bizExtendParams.put("extend_params", null);
        RefundNotifyRequest refundNotifyRequest = RefundNotifyRequest.builder().bizRefundContent(bizExtendParams.toJSONString()).bizRefundNo(appointmentRecordEntity.getSysAppointmentId()).bizRefundTime(DateUtil.now()).identityId(appointmentRecordEntity.getPatientCardNo()).name(appointmentRecordEntity.getPatientName()).refundOrderId(createRefundOrderResponse.getRefundOrderId()).refundType("2").build();
        refundNotifyRequestFrontRequest.setBody((Object)refundNotifyRequest);
        log.info("\u3010\u9000\u6b3e\u3011\u652f\u4ed8\u5e73\u53f0\u9000\u8d27\u901a\u77e5\u5165\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)refundNotifyRequestFrontRequest));
        FrontResponse responseResultFrontResponse = this.paymentClient.refundNotify(refundNotifyRequestFrontRequest);
        log.info("\u3010\u9000\u6b3e\u3011\u652f\u4ed8\u5e73\u53f0\u9000\u8d27\u901a\u77e5\u51fa\u53c2\uff1a{}", (Object)JSON.toJSONString((Object)responseResultFrontResponse));
        if (Objects.isNull(responseResultFrontResponse)) {
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue());
            appointmentRecordEntity.setCancleTime(new Date());
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u3010\u9000\u6b3e\u3011\u652f\u4ed8\u5e73\u53f0\u9000\u8d27\u901a\u77e5\u5931\u8d25,\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u9000\u8d27\u901a\u77e5\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a");
            throw new AppointmentException("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff01\u8c03\u7528\u652f\u4ed8\u5e73\u53f0\u9000\u8d27\u901a\u77e5\u63a5\u53e3\u54cd\u5e94\u4e3a\u7a7a");
        }
        if (!"1".equals(responseResultFrontResponse.getCode())) {
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue());
            appointmentRecordEntity.setCancleTime(new Date());
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u3010\u9000\u6b3e\u3011\u652f\u4ed8\u5e73\u53f0\u9000\u8d27\u901a\u77e5\u5931\u8d25,\u5931\u8d25\u539f\u56e0:{}", (Object)responseResultFrontResponse.getMessage());
            throw new AppointmentException("\u7533\u8bf7\u9000\u6b3e\u5931\u8d25\uff01\u652f\u4ed8\u5e73\u53f0\u9000\u8d27\u901a\u77e5\u5931\u8d25 \u5931\u8d25\u539f\u56e0:" + responseResultFrontResponse.getMessage());
        }
        FrontRequest refundRequestFrontRequest = new FrontRequest();
        refundRequestFrontRequest.setOrganCode(appointmentRecordEntity.getInnerChannelCode());
        refundRequestFrontRequest.setBody((Object)RefundRequest.builder().refundOrderId(createRefundOrderResponse.getRefundOrderId()).refundReason("\u60a3\u8005\u4e3b\u52a8\u9000\u8d39").refundUser("zwby").build());
        this.paymentClient.refund(refundRequestFrontRequest);
        String sysAppointmentId = appointmentRecordEntity.getSysAppointmentId();
        AppointmentPayorderEntity appointmentPayorderEntity = new AppointmentPayorderEntity();
        appointmentPayorderEntity.setSysAppointmentId(sysAppointmentId);
        appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.REFUND_AND_CONFIRMATION.getValue().intValue()));
        appointmentPayorderEntity.setRefundChannelCode(Byte.valueOf((byte)RefundChannelCodeEnum.CURRENT_SYSTEM_REFUND.getValue().intValue()));
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
        appointmentRecordEntity.setCancleTime(new Date());
        appointmentRecordEntity.setRemark(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getDisplay() + "-" + withdrawNumberVoReq.getRemark());
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        return BaseResponse.success((Object)"\u9000\u6b3e\u6210\u529f");
    }

    public BaseResponse<String> appointReturnNumber(WithdrawNumberVoReq withdrawNumberVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(withdrawNumberVoReq.getSysAppointmentId());
        if (appointmentRecordEntity == null || appointmentRecordEntity.getAppointStatus() == null) {
            throw new AppointmentException("\u5f53\u524d\u6302\u53f7\u8bb0\u5f55\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        if (!appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) {
            throw new AppointmentException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        boolean overdueRefundDate = DateUtils.judgeDate((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
        if (!overdueRefundDate) {
            throw new AppointmentException("\u5c31\u8bca\u5f53\u65e5\u4e0d\u80fd\u9000\u53f7\uff0c\u5982\u9700\u9000\u53f7\u8bf7\u81f3\u533b\u9662\u7a97\u53e3\u54a8\u8be2\u529e\u7406\u3002");
        }
        GatewayRequest gatewayRequest = this.returnRegGatewayReq(withdrawNumberVoReq, appointmentRecordEntity);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.REFUND_WRITE.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        GatewayResponse gatewayResponse = this.invokeHisReturnRegister(gatewayRequest, "");
        if (gatewayResponse.isSuccess()) {
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue());
            appointmentRecordEntity.setCancleTime(new Date());
            appointmentRecordEntity.setCancleType(CancelTypeEnum.CHANNEL_CANCEL.getValue().intValue());
            appointmentRecordEntity.setCancleReason("\u7528\u6237\u53d6\u6d88");
            appointmentRecordEntity.setRemark("\u7528\u6237\u4e3b\u52a8\u53d6\u6d88");
            appointmentRecordEntity.setCancleChannelCode(withdrawNumberVoReq.getPayChannel());
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            businessResultEntity.setErrorCode(gatewayResponse.getErrCode());
            businessResultEntity.setErrorMsg(gatewayResponse.getMsg());
            businessResultEntity.setHisResponse(JSON.toJSONString((Object)gatewayResponse));
            businessResultEntity.setTransationId(gatewayResponse.getTransactionId());
            businessResultEntity.setStatus(new Byte("0"));
            this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        } else {
            log.info("his\u9000\u53f7\u5931\u8d25\uff1a" + gatewayResponse.getMsg());
            appointmentRecordEntity.setCancleType(CancelTypeEnum.CHANNEL_CANCEL.getValue().intValue());
            appointmentRecordEntity.setCancleReason("\u7528\u6237\u53d6\u6d88");
            appointmentRecordEntity.setRemark("HIS\u9000\u53f7\u5931\u8d25:" + gatewayResponse.getMsg());
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        }
        return BaseResponse.success();
    }

    public GatewayRequest<ReturnRegisterReq> returnRegGatewayReq(WithdrawNumberVoReq withdrawNumberVoReq, AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ReturnRegisterReq returnRegisterReq = new ReturnRegisterReq();
        returnRegisterReq.setAppointId(appointmentRecordEntity.getAdmId());
        gatewayRequest.setBody((Object)returnRegisterReq);
        gatewayRequest.setChannelName(withdrawNumberVoReq.getPayChannel());
        gatewayRequest.setChannel(withdrawNumberVoReq.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("returnAppointment");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private BaseResponse<String> refund(RequestRefundOrderVoReq requestRefundOrderVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)requestRefundOrderVoReq));
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            return response;
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25\uff0c\u539f\u56e0\u662f:{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
    }

    public String payAppointmentPayToHis(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo, AppointmentPayorderEntity payOrderEntity) throws AppointmentException {
        FrontRequest request = new FrontRequest();
        request.setOrganCode(appointmentRecordEntity.getInnerChannelCode());
        String attach = responseNotifyRestVo.getAttach();
        PayCallBackRequest payCallBackRequest = (PayCallBackRequest)JSON.parseObject((String)attach, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        request.setBody((Object)DeliverApplyRequest.builder().tradeNo(appointmentRecordEntity.getPayPostId()).payList(payCallBackRequest.getPayList()).build());
        FrontResponse deliverApplyResponseFrontResponse = this.paymentClient.deliverApply(request);
        if (Objects.isNull(deliverApplyResponseFrontResponse) || !"1".equals(deliverApplyResponseFrontResponse.getCode())) {
            log.error("\u8c03\u7528\u6e90\u542f\u652f\u4ed8-\u4ea4\u8d27\u7533\u8bf7\u63a5\u53e3\u5931\u8d25{}", (Object)JSON.toJSONString((Object)deliverApplyResponseFrontResponse));
            FrontRequest cancelRequestFrontRequest = new FrontRequest();
            cancelRequestFrontRequest.setOrganCode(appointmentRecordEntity.getInnerChannelCode());
            cancelRequestFrontRequest.setBody((Object)TradeCancelRequest.builder().orgTranNo(payCallBackRequest.getTranNo()).cancelReason("\u4ea4\u8d27\u7533\u8bf7\u5931\u8d25").build());
            FrontResponse tradeCancelResponseFrontResponse = this.paymentClient.tradeCancel(cancelRequestFrontRequest);
            if (Objects.isNull(tradeCancelResponseFrontResponse) || !"1".equals(tradeCancelResponseFrontResponse.getCode())) {
                log.error("\u8c03\u7528\u6e90\u542f\u652f\u4ed8-\u4ea4\u6613\u64a4\u9500\u63a5\u53e3\u5931\u8d25{}", (Object)JSON.toJSONString((Object)tradeCancelResponseFrontResponse));
                throw new AppointmentException("\u4ea4\u6613\u64a4\u9500\u5931\u8d25");
            }
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
            appointmentRecordEntity.setRemark("\u8c03\u7528\u652f\u4ed8\u4ea4\u8d27\u7533\u8bf7\u5931\u8d25\uff0c\u652f\u4ed8\u64a4\u9500");
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            throw new AppointmentException("\u4ea4\u8d27\u7533\u8bf7\u5931\u8d25");
        }
        log.info("\u4ea4\u8d27\u7533\u8bf7\u6210\u529f\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)deliverApplyResponseFrontResponse));
        UpdatePayAppointmentRecordVoReq updatePayAppointment = new UpdatePayAppointmentRecordVoReq();
        if (Objects.equals(appointmentRecordEntity.getKeepSource(), new Byte("2"))) {
            FrontRequest frontRequest = new FrontRequest();
            NoSchedulingRequestRegVo noSchedulingRequestRegVo = new NoSchedulingRequestRegVo();
            noSchedulingRequestRegVo.setCardNo(appointmentRecordEntity.getPatientCardNo());
            noSchedulingRequestRegVo.setDeptCode(appointmentRecordEntity.getDeptCode());
            noSchedulingRequestRegVo.setDoctCode(appointmentRecordEntity.getDocCode());
            noSchedulingRequestRegVo.setRegDate(appointmentRecordEntity.getAdmDate());
            noSchedulingRequestRegVo.setRegLv(appointmentRecordEntity.getScheduleLevelName());
            noSchedulingRequestRegVo.setFlowNo(appointmentRecordEntity.getPayPostId());
            noSchedulingRequestRegVo.setDiagFee(appointmentRecordEntity.getServiceFee().toPlainString());
            noSchedulingRequestRegVo.setRegFee(appointmentRecordEntity.getRegFee().toPlainString());
            noSchedulingRequestRegVo.setOperCode("zwby");
            frontRequest.setBody((Object)noSchedulingRequestRegVo);
            log.info("\u3010\u65e0\u6392\u73ed\u6302\u53f7\u3011\u8bf7\u6c42his\u5165\u53c2\u4e3a:{}", (Object)JSON.toJSONString((Object)noSchedulingRequestRegVo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            FrontResponse frontResponse = this.appointmentClient.noSchedulingRegister(frontRequest);
            log.info("\u3010\u65e0\u6392\u73ed\u6302\u53f7\u3011his\u63a5\u53e3\u8fd4\u56de\u4e3a:{}", (Object)JSON.toJSONString((Object)frontResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if (Objects.isNull(frontResponse) || !"1".equals(frontResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.APPOINT_FAIL.getValue());
                appointmentRecordEntity.setRemark(AppointmentStatusEnum.APPOINT_FAIL.getDisplay());
                this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
                this.deliverNotify(appointmentRecordEntity, "fail");
                throw new AppointmentException("\u52a0\u53f7\u6302\u53f7\u5931\u8d25");
            }
            updatePayAppointment.setAdmId(((NoSchedulingRegistResVO)frontResponse.getBody()).getClinicNo());
            updatePayAppointment.setAppointNo(((NoSchedulingRegistResVO)frontResponse.getBody()).getClinicNo());
            updatePayAppointment.setReceptId(((NoSchedulingRegistResVO)frontResponse.getBody()).getClinicNo());
            updatePayAppointment.setAppointmentId(((NoSchedulingRegistResVO)frontResponse.getBody()).getClinicNo());
        } else {
            FrontRequest frontRequest = new FrontRequest();
            RequestRegBookedVo requestRegBookedVo = RequestRegBookedVo.builder().cardNo(appointmentRecordEntity.getPatientCardNo()).payType("QD").bookId(appointmentRecordEntity.getAppointmentId()).flowNo(appointmentRecordEntity.getPayPostId()).orderNo(appointmentRecordEntity.getSysAppointmentId()).payState("1").powerPayChannel("WX").build();
            frontRequest.setBody((Object)requestRegBookedVo);
            FrontResponse frontResponse = this.appointmentClient.tackNumber(frontRequest);
            if (Objects.isNull(frontResponse) || !"1".equals(frontResponse.getCode())) {
                log.error("\u9884\u7ea6\u6302\u53f7\u786e\u8ba4\u63a5\u53e3\u5931\u8d25{}", (Object)JSON.toJSONString((Object)frontResponse));
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.APPOINT_FAIL.getValue());
                appointmentRecordEntity.setRemark(AppointmentStatusEnum.APPOINT_FAIL.getDisplay() + "-" + frontResponse.getMessage());
                this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
                this.deliverNotify(appointmentRecordEntity, "fail");
                throw new AppointmentException("\u9884\u7ea6\u6302\u53f7\u786e\u8ba4\u63a5\u53e3\u5931\u8d25-" + frontResponse.getMessage());
            }
            updatePayAppointment.setAdmId(appointmentRecordEntity.getAppointmentNo());
            updatePayAppointment.setReceptId(appointmentRecordEntity.getAppointmentNo());
            updatePayAppointment.setAdmAdress(((ResultInfoVo)frontResponse.getBody()).getErr());
        }
        this.deliverNotify(appointmentRecordEntity, "success");
        updatePayAppointment.setPayAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        updatePayAppointment.setPayPostId(appointmentRecordEntity.getPayPostId());
        updatePayAppointment.setPayTransationId(responseNotifyRestVo.getTradeNo());
        updatePayAppointment.setPayChannel(PayChannelEnum.getDisplay((String)responseNotifyRestVo.getPayChannel()));
        updatePayAppointment.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        updatePayAppointment.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        updatePayAppointment.setPayChannelCode(responseNotifyRestVo.getPayChannel());
        updatePayAppointment.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        this.updatePayAppointmentRecord(updatePayAppointment);
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setPatientId(appointmentRecordEntity.getPatientId());
        payOrderEntity.setPaymentSeq(appointmentRecordEntity.getPayChannelCode());
        payOrderEntity.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        payOrderEntity.setPayBillNo(responseNotifyRestVo.getTradeNo());
        this.appointmentPayOrderMapper.updateByPrimaryKey(payOrderEntity);
        this.taskExecutor.execute(() -> this.pushService.appointmentCancelMsgPush(appointmentRecordEntity));
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private void deliverNotify(AppointmentRecordEntity appointmentRecordEntity, String flag) {
        FrontRequest deliverNoticeRequestFrontRequest = new FrontRequest();
        deliverNoticeRequestFrontRequest.setOrganCode(appointmentRecordEntity.getInnerChannelCode());
        deliverNoticeRequestFrontRequest.setBody((Object)DeliverNotifyRequest.builder().tradeNo(appointmentRecordEntity.getPayPostId()).receiptStatus(flag).receiptId(appointmentRecordEntity.getSysAppointmentId()).rcptNo(appointmentRecordEntity.getAppointmentId()).receiptTime(DateUtil.now()).build());
        this.paymentClient.deliverNotify(deliverNoticeRequestFrontRequest);
    }

    private GatewayResponse<CancelRegisterRes> invokeHisCancelRegister(GatewayRequest<CancelRegisterReq> gatewayRequest, String message) throws AppointmentException {
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.CANCEL_REGISTERHT.getValue(), gatewayRequest, CancelRegisterRes.class);
        if (gatewayResponse == null) {
            log.error(message + "-> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error(message + " -> his\u53d6\u6d88\u6302\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error(message + " -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        return gatewayResponse;
    }

    private GatewayResponse<ReturnRegisterRes> invokeHisReturnRegister(GatewayRequest<ReturnRegisterReq> gatewayRequest, String message) throws AppointmentException {
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.RETURN_REGISTER.getValue(), gatewayRequest, ReturnRegisterRes.class);
        if (gatewayResponse.getCode() == null) {
            log.error(message + "-> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error(message + " -> his\u9000\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        return gatewayResponse;
    }

    private FrontRequest<RequestRegBookedVo> buildCancelRegisterGatewayReq(CancelAppointmentVoReq cancelAppointmentVoReq, AppointmentRecordEntity appointmentRecordEntity) {
        FrontRequest frontRequest = new FrontRequest();
        RequestRegBookedVo requestRegBookedVo = RequestRegBookedVo.builder().bookId(appointmentRecordEntity.getAppointmentId()).cardNo(appointmentRecordEntity.getPatientCardNo()).flowNo(appointmentRecordEntity.getSysAppointmentId()).payState("0").payType("QD").powerPayChannel("WX").orderNo(appointmentRecordEntity.getSysAppointmentId()).build();
        frontRequest.setBody((Object)requestRegBookedVo);
        frontRequest.setChannelName(cancelAppointmentVoReq.getChannelName());
        frontRequest.setOrganCode(cancelAppointmentVoReq.getHospitalCode());
        frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return frontRequest;
    }

    private FrontRequest<RequestRegBookedVo> buildCancelRegisterReq(CancelAppointmentVoReq cancelAppointmentVoReq, AppointmentRecordEntity appointmentRecordEntity) {
        FrontRequest frontRequest = new FrontRequest();
        RequestRegBookedVo requestRegBookedVo = RequestRegBookedVo.builder().bookId(appointmentRecordEntity.getAppointmentId()).cardNo(appointmentRecordEntity.getPatientCardNo()).flowNo(appointmentRecordEntity.getSysAppointmentId()).payState("1").payType("QD").powerPayChannel("WX").orderNo(appointmentRecordEntity.getSysAppointmentId()).build();
        frontRequest.setBody((Object)requestRegBookedVo);
        frontRequest.setChannelName(cancelAppointmentVoReq.getChannelName());
        frontRequest.setOrganCode(cancelAppointmentVoReq.getHospitalCode());
        frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return frontRequest;
    }

    private GatewayRequest<PayRegistrationReq> cancelRegGatewayReq(WithdrawNumberVoReq withdrawNumberVoReq, AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PayRegistrationReq registrationReq = new PayRegistrationReq();
        PayRegistrationMsg payRegistrationMsg = new PayRegistrationMsg();
        registrationReq.setAppointId(appointmentRecordEntity.getReceptId());
        registrationReq.setPatientId(appointmentRecordEntity.getPatientId());
        payRegistrationMsg.setOrderid(appointmentRecordEntity.getPayTransationId());
        registrationReq.setRespMsg(payRegistrationMsg);
        gatewayRequest.setBody((Object)registrationReq);
        gatewayRequest.setChannelName(withdrawNumberVoReq.getPayChannel());
        gatewayRequest.setChannel(withdrawNumberVoReq.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("cancelAppointment");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<ReturnRegisterReq> buildWithdrawNumberGatewayReq(AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ReturnRegisterReq returnRegisterReq = new ReturnRegisterReq();
        returnRegisterReq.setAppointId(appointmentRecordEntity.getAppointmentId());
        gatewayRequest.setBody((Object)returnRegisterReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)appointmentRecordEntity.getChannelCode()));
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("cancelAppointment");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public AppointmentRecordEntity appointmentCreateOrder(AppointmentCreateOrderVoReq createOrderVoReq) throws Exception {
        AppointmentRecordEntity appointmentRecordEntity;
        block5: {
            FrontResponse frontResponseNew;
            block7: {
                block6: {
                    log.info("\u9884\u7ea6\u6302\u53f7\u5165\u53c2 - > {}", (Object)JSON.toJSONString((Object)createOrderVoReq, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                    this.registrationRules(createOrderVoReq.getIdNo(), createOrderVoReq.getDeptCode(), createOrderVoReq.getLocName());
                    long sysAppointmnetId = this.snowflakeIdWorker.nextId();
                    FrontRequest frontRequest = this.buildConfirmRegisterReq(Long.valueOf(sysAppointmnetId), createOrderVoReq);
                    log.info("\u8bf7\u6c42his\u9884\u7ea6\u6302\u53f7\u9501\u53f7\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)frontRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                    FrontResponse frontResponse = this.appointmentClient.lockNumber(frontRequest);
                    log.info("\u8bf7\u6c42his\u9884\u7ea6\u6302\u53f7\u9501\u53f7\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)frontResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
                    if (Objects.isNull(frontResponse) || Objects.isNull(frontResponse.getBody())) {
                        log.error("\u9884\u7ea6\u9501\u53f7\u5931\u8d25");
                        throw new AppointmentException(frontResponse.getMessage());
                    }
                    if (!"1".equals(frontResponse.getCode())) {
                        log.error("\u9884\u7ea6\u9501\u53f7\u5931\u8d25");
                        throw new AppointmentException("\u9884\u7ea6\u9501\u53f7\u5931\u8d25" + frontResponse.getMessage());
                    }
                    this.jedisCluster.set(this.hisOrderNumber + sysAppointmnetId, ((RegBookingResVo)frontResponse.getBody()).getLockNo());
                    appointmentRecordEntity = this.buildnewSuccessAppointmentRecordEntity(sysAppointmnetId, (RegBookingResVo)frontResponse.getBody(), createOrderVoReq);
                    log.info("\u9884\u7ea6\u9501\u53f7\u521b\u5efa\u8ba2\u5355\u5b58\u6570\u636e\u5e93\uff1aappointmentRecordEntity:{}", (Object)appointmentRecordEntity);
                    this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
                    log.info("\u9884\u7ea6\u9501\u53f7\u521b\u5efa\u8ba2\u5355\u5b58\u6570\u636e\u5e93\u6210\u529f");
                    if (!"0".equals(appointmentRecordEntity.getPayAmount())) break block5;
                    CancelAppointmentVoReq cancelAppointmentVoReq = new CancelAppointmentVoReq();
                    cancelAppointmentVoReq.setHospitalCode(appointmentRecordEntity.getHospitalCode());
                    cancelAppointmentVoReq.setChannelName(appointmentRecordEntity.getChannelCode());
                    cancelAppointmentVoReq.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
                    FrontRequest regBookedVoFrontRequest = this.buildCancelRegisterReq(cancelAppointmentVoReq, appointmentRecordEntity);
                    frontResponseNew = this.appointmentClient.tackNumber(regBookedVoFrontRequest);
                    log.info("0\u5143\u6302\u53f7\u51fa\u53c2:{}", (Object)frontResponseNew);
                    if (Objects.isNull(frontResponseNew)) break block6;
                    if ("1".equals(frontResponse.getCode())) break block7;
                }
                throw new AppointmentException("0\u5143\u53f7\u9884\u7ea6\u5931\u8d25");
            }
            AppointmentRecordEntity appointmentRecordEntityNew = this.appointmentRecordMapper.selectBySysAppointId(appointmentRecordEntity.getSysAppointmentId());
            appointmentRecordEntityNew.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
            appointmentRecordEntityNew.setRemark("0\u5143\u6302\u53f7\u5df2\u7ecf\u6302\u53f7\u6210\u529f");
            log.info("0\u5143\u6302\u53f7\u83b7\u53d6\u5c31\u8bca\u5730\u5740:{}", (Object)((ResultInfoVo)frontResponseNew.getBody()).getErr());
            appointmentRecordEntityNew.setAdmAddress(((ResultInfoVo)frontResponseNew.getBody()).getErr());
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntityNew);
            this.taskExecutor.execute(() -> this.pushService.appointmentCancelMsgPush(appointmentRecordEntityNew));
            return appointmentRecordEntityNew;
        }
        RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = new RabbitMqDelayedOrderVo();
        rabbitMqDelayedOrderVo.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        rabbitMqDelayedOrderVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        rabbitMqDelayedOrderVo.setOrderId(appointmentRecordEntity.getSysAppointmentId());
        RabbitMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)rabbitMqDelayedOrderVo));
        return appointmentRecordEntity;
    }

    private FrontRequest<RequestRegBookingVo> buildConfirmRegisterReq(Long sysAppointId, AppointmentCreateOrderVoReq createOrderVoReq) {
        FrontRequest frontRequest = new FrontRequest();
        RequestRegBookingVo confirmRegisterReq = new RequestRegBookingVo();
        confirmRegisterReq.setCardNo(createOrderVoReq.getPatientCardNo());
        confirmRegisterReq.setFlowNo(Convert.toStr((Object)sysAppointId));
        confirmRegisterReq.setSchemaID(createOrderVoReq.getScheduleHisId());
        confirmRegisterReq.setRegLv(createOrderVoReq.getRegTitleCode());
        confirmRegisterReq.setSourceType(createOrderVoReq.getAdmDate().equals(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd")) ? "1" : "4");
        confirmRegisterReq.setTimepointSortId(createOrderVoReq.getTimeArrangeId());
        frontRequest.setBody((Object)confirmRegisterReq);
        frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        return frontRequest;
    }

    private void checkAppointmentInfo(AppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        Integer appointmentCount = this.appointmentRecordMapper.selectPatientCurrentDateSameDeptValidAppointmentCount(createOrderVoReq.getHospitalCode(), createOrderVoReq.getPatientId(), createOrderVoReq.getDeptCode(), String.valueOf(LocalDate.now()));
        if (appointmentCount >= 1) {
            throw new AppointmentException("\u65e0\u6cd5\u9884\u7ea6, \u8be5\u5c31\u8bca\u4eba\u540c\u4e00\u79d1\u5ba4\u533b\u751f\u53ea\u80fd\u9884\u7ea6\u4e00\u4e2a");
        }
        Integer totalAppointmentCount = this.appointmentRecordMapper.selectPatientCurrentDateValidAppointCount(createOrderVoReq.getHospitalCode(), createOrderVoReq.getPatientId(), String.valueOf(LocalDate.now()));
        if (totalAppointmentCount >= 2) {
            throw new AppointmentException("\u65e0\u6cd5\u9884\u7ea6, \u8be5\u5c31\u8bca\u4eba\u4eca\u65e5\u9884\u7ea6\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650(2\u6b21\u5305\u542b\u53d6\u6d88)");
        }
    }

    private GatewayRequest<GetScheduleReqVO> buildScheduleGetwayRequest(AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) {
        GatewayRequest gatewayReq = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(appointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setEdDate(appointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setLocCode(appointmentCreateOrderVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(appointmentCreateOrderVoReq.getDocCode());
        gatewayReq.setBody((Object)getScheduleReqVO);
        gatewayReq.setChannelName(appointmentCreateOrderVoReq.getChannelName());
        gatewayReq.setChannel(appointmentCreateOrderVoReq.getChannelName());
        gatewayReq.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayReq.setKeyWord("appointmentCreateOrder");
        gatewayReq.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayReq;
    }

    private GatewayRequest<LockOrderReq> buildDayConfirmRegisterReq(long sysAppointmentId, DayAppointmentCreateOrderVoReq createOrderVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        LockOrderReq lockOrderReq = new LockOrderReq();
        lockOrderReq.setBeginTime(createOrderVoReq.getStarTime());
        lockOrderReq.setEndTime(createOrderVoReq.getEndTime());
        lockOrderReq.setScheduleCode(createOrderVoReq.getScheduleHisId());
        lockOrderReq.setPatientId(createOrderVoReq.getPatientCardNo());
        lockOrderReq.setOrderId(String.valueOf(sysAppointmentId));
        lockOrderReq.setTradeTime(DateUtils.getCurrentTime());
        lockOrderReq.setTradeDate(DateUtils.getCurrentDateSimpleToString());
        gatewayRequest.setBody((Object)lockOrderReq);
        gatewayRequest.setChannelName(createOrderVoReq.getChannelName());
        gatewayRequest.setChannel(createOrderVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("dayConfirmRegister");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private AppointmentRecordEntity buildnewSuccessAppointmentRecordEntity(long sysAppointmentId, RegBookingResVo regBookingResVo, AppointmentCreateOrderVoReq createOrderVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setScheduleType(createOrderVoReq.getAdmTimeRange());
        appointmentRecordEntity.setAppointmentId(regBookingResVo.getLockNo());
        appointmentRecordEntity.setAppointmentNo(regBookingResVo.getLockNo());
        appointmentRecordEntity.setAdmTimeRange(createOrderVoReq.getStarTime() + "-" + createOrderVoReq.getEndTime());
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        appointmentRecordEntity.setAdmRange(Integer.parseInt(createOrderVoReq.getAdmTimeRange()));
        appointmentRecordEntity.setAppointmentTime(new Date());
        appointmentRecordEntity.setAppointmentType(createOrderVoReq.getAdmDate().equals(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd")) ? 2 : 1);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(createOrderVoReq.getLocName());
        appointmentRecordEntity.setDocCode(createOrderVoReq.getDocCode());
        appointmentRecordEntity.setDocName(createOrderVoReq.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(StringUtils.isBlank((String)createOrderVoReq.getHospitalName()) ? "\u6cb3\u5357\u79d1\u6280\u5927\u5b66\u7b2c\u4e8c\u9644\u5c5e\u533b\u9662" : createOrderVoReq.getHospitalName());
        appointmentRecordEntity.setInnerChannelCode(StringUtils.isNotBlank((String)createOrderVoReq.getHospitalAreaCode()) ? createOrderVoReq.getHospitalAreaCode() : "YBB");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null != cardDetail) {
            appointmentRecordEntity.setPatientPhone(cardDetail.getTel());
            appointmentRecordEntity.setCardId(cardDetail.getCardId());
            appointmentRecordEntity.setPatientId(cardDetail.getCardNo());
            appointmentRecordEntity.setPatientIdCard(cardDetail.getCredNo());
            appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
            appointmentRecordEntity.setPatientSex(IdCardUtil.getGenderByIdCard((String)cardDetail.getCredNo()) == "M" ? 1 : 2);
            appointmentRecordEntity.setPatientName(cardDetail.getPatientName());
        }
        BigDecimal totalFee = new BigDecimal(createOrderVoReq.getRegFee()).add(new BigDecimal(createOrderVoReq.getDiagFee()));
        if (appointmentRecordEntity.getPatientAge() >= 60) {
            totalFee = totalFee.subtract(new BigDecimal("0.5"));
        }
        appointmentRecordEntity.setPayAmount(StringUtils.isNotBlank((String)regBookingResVo.getRegAmount()) ? regBookingResVo.getRegAmount() : String.valueOf(totalFee.doubleValue()));
        appointmentRecordEntity.setRegFee(new BigDecimal(createOrderVoReq.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal(createOrderVoReq.getDiagFee()));
        appointmentRecordEntity.setScheduleHisId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setSysTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        appointmentRecordEntity.setScheduleHisId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setRegTitleName(createOrderVoReq.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(createOrderVoReq.getRegTitleName());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        appointmentRecordEntity.setRemark("\u9884\u7ea6\u9501\u53f7\u6210\u529f");
        appointmentRecordEntity.setCreatetime((Date)DateUtil.date());
        appointmentRecordEntity.setUpdatetime((Date)DateUtil.date());
        appointmentRecordEntity.setTakeTime(createOrderVoReq.getStarTime());
        return appointmentRecordEntity;
    }

    public AppointmentRecordEntity getAppointmentRecordBySysAppointmentId(String sysAppointmentId) {
        return this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
    }

    public void autoCancelDelayAppointment(UpdateDelayAppointmentRecordVoReq updateDelayAppointmentRecordVo) {
        this.appointmentRecordMapper.autoCancelDelayAppointment(updateDelayAppointmentRecordVo);
    }

    private void updatePayAppointmentRecord(UpdatePayAppointmentRecordVoReq updatePayAppointmentRecordVoReq) {
        this.appointmentRecordMapper.updatePayAppointmentRecord(updatePayAppointmentRecordVoReq);
    }

    private void updateDoDayRegisterRes(DoDayAppointmentDTO doDayAppointmentDTO) {
        this.appointmentRecordMapper.updateDoDayAppointmentRecord(doDayAppointmentDTO);
    }

    public BaseResponse<String> dayAppointmentPay(DayAppointmentPayVoReq dayAppointmentPayVoReq) {
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u5165\u53c2\uff1a" + JSON.toJSONString((Object)dayAppointmentPayVoReq));
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(dayAppointmentPayVoReq.getSysAppointmentId());
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
        }
        PayRequestVoReq payRequestVoReq = new PayRequestVoReq();
        payRequestVoReq.setMchCode(this.propertiesConstant.getMchCode());
        payRequestVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        payRequestVoReq.setPayChannel(dayAppointmentPayVoReq.getPayChannel());
        payRequestVoReq.setPayType(dayAppointmentPayVoReq.getPayType());
        payRequestVoReq.setProductInfo("\u9884\u7ea6\u6302\u53f7");
        payRequestVoReq.setServiceCode(ServiceCodeEnum.DAY_APPOINTMENT.getValue());
        payRequestVoReq.setActuallyAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        payRequestVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        payRequestVoReq.setUserSign(dayAppointmentPayVoReq.getOpenId());
        payRequestVoReq.setNonceStr(SignUtil.getNonceStr());
        payRequestVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        payRequestVoReq.setPayNotifyUrl(this.propertiesConstant.getDayPayNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)payRequestVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        payRequestVoReq.setSign(sign);
        BaseResponse baseResponse = this.payUtil.payCreateOrder(payRequestVoReq);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)baseResponse));
        return baseResponse;
    }

    public static void main(String[] args) {
        FrontResponse nucleicAcidAppointmentResFrontResponse = (FrontResponse)JSON.parseObject((String)"{\"body\":{\"attention\":\"\u6838\u9178\u9884\u7ea6\u524d\u4e24\u5c0f\u65f6\u7981\u6b62\u8fdb\u98df\",\"fee\":\"4\",\"orderId\":\"22112490193\"},\"code\":\"1\",\"errCode\":null,\"message\":null,\"transactionId\":\"com.ebaiyihui.his.utils.SnowflakeIdWorker@21a913a8\"}", (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        log.info(JSON.toJSONString((Object)nucleicAcidAppointmentResFrontResponse));
    }

    public List<GetAdmissionItems> nucleicAcidAppointmentRes(DayAppointmentCreateOrderVoReq createOrderVoReq) throws Exception {
        return null;
    }

    private GetAdmissionReqVO BuildGetAdmissionReqVO(DayAppointmentCreateOrderVoReq createOrderVoReq) {
        GetAdmissionReqVO getAdmissionReqVO = new GetAdmissionReqVO();
        getAdmissionReqVO.setCardId(createOrderVoReq.getCardId());
        getAdmissionReqVO.setCardNo(createOrderVoReq.getPatientCardNo());
        getAdmissionReqVO.setOrganCode("130211");
        getAdmissionReqVO.setChannelCode("PATIENT_ALIPAY");
        getAdmissionReqVO.setBgDate(DateUtil.today());
        getAdmissionReqVO.setEdDate(DateUtil.today());
        return getAdmissionReqVO;
    }

    private nucleicAcidAppointmentReq buildNucleicAcidAppointmentReq(DayAppointmentCreateOrderVoReq createOrderVoReq) {
        nucleicAcidAppointmentReq nucleicAcidAppointmentReq2 = new nucleicAcidAppointmentReq();
        nucleicAcidAppointmentReq2.setPatientId(createOrderVoReq.getPatientId());
        nucleicAcidAppointmentReq2.setTradeId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        nucleicAcidAppointmentReq2.setTelphone(createOrderVoReq.getPhoneNo());
        nucleicAcidAppointmentReq2.setCardNO(createOrderVoReq.getPatientCardNo());
        nucleicAcidAppointmentReq2.setSchedId(createOrderVoReq.getScheduleHisId());
        return nucleicAcidAppointmentReq2;
    }

    private GatewayRequest<PayRegistrationReq> buildNucleicRegisterParams(AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PayRegistrationReq payRegistrationReq = new PayRegistrationReq();
        payRegistrationReq.setAppointId(appointmentRecordEntity.getAppointmentId());
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setPatientId(appointmentRecordEntity.getPatientId());
        payRegistrationReq.setScheduleId(appointmentRecordEntity.getScheduleHisId());
        payRegistrationReq.setAppointId(appointmentRecordEntity.getAppointmentId());
        payRegistrationReq.setAppointDate(appointmentRecordEntity.getAdmDate());
        payRegistrationReq.setPayChannel(appointmentRecordEntity.getPayChannel());
        PayRegistrationMsg payRegistrationMsg = new PayRegistrationMsg();
        payRegistrationMsg.setAccdate(appointmentRecordEntity.getAdmDate());
        payRegistrationMsg.setOrderid(appointmentRecordEntity.getSysAppointmentId());
        payRegistrationMsg.setPayment(appointmentRecordEntity.getPayAmount());
        payRegistrationMsg.setSuccess(SUCCESS);
        payRegistrationReq.setRespMsg(payRegistrationMsg);
        gatewayRequest.setBody((Object)payRegistrationReq);
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setKeyWord("nucleicRegister");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public AppointmentPayVoReq byPayData(DayAppointmentPayVoReq dayAppointmentPayVoReq, AppointmentRecordEntity appointmentRecordEntity, ServiceMerchantConfigEntity serviceMerchantConfigEntity) {
        AppointmentPayVoReq appointmentPayVoReq = new AppointmentPayVoReq();
        appointmentPayVoReq.setMchCode(this.propertiesConstant.getMchCode());
        appointmentPayVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        appointmentPayVoReq.setPayChannel(dayAppointmentPayVoReq.getPayChannel());
        appointmentPayVoReq.setPayType(dayAppointmentPayVoReq.getPayType());
        appointmentPayVoReq.setProductInfo("\u9884\u7ea6\u6302\u53f7");
        appointmentPayVoReq.setServiceCode(ServiceCodeEnum.DAY_APPOINTMENT.getValue());
        appointmentPayVoReq.setActuallyAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentPayVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentPayVoReq.setUserSign(dayAppointmentPayVoReq.getOpenId());
        appointmentPayVoReq.setNonceStr(SignUtil.getNonceStr());
        appointmentPayVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        appointmentPayVoReq.setPayNotifyUrl(this.propertiesConstant.getDayPayNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)appointmentPayVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        appointmentPayVoReq.setSign(sign);
        return appointmentPayVoReq;
    }

    public BaseResponse<String> appointmentPay(DayAppointmentPayVoReq dayAppointmentPayVoReq) {
        String key = "prepay_param_" + dayAppointmentPayVoReq.getSysAppointmentId();
        String prePayParam = this.jedisCluster.get(key);
        if (StringUtils.isNotBlank((String)prePayParam)) {
            return BaseResponse.success((Object)prePayParam);
        }
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(dayAppointmentPayVoReq.getSysAppointmentId());
        if (Objects.isNull(appointmentRecordEntity)) {
            return BaseResponse.error((String)"\u672a\u67e5\u8be2\u5230\u6302\u53f7\u8ba2\u5355\uff0c\u8bf7\u6c42\u652f\u4ed8\u5931\u8d25");
        }
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)appointmentRecordEntity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        FrontRequest request = this.buildCreateOrderRequest(appointmentRecordEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u521b\u5efa\u8ba2\u5355\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)request));
        FrontResponse createOrderFrontResponse = this.paymentClient.createOrder(request);
        if (Objects.isNull(createOrderFrontResponse) || !"1".equals(createOrderFrontResponse.getCode())) {
            log.error("\u3010\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u3011\u521b\u5efa\u4ea4\u6613\u8ba2\u5355\u5931\u8d25{}", (Object)JSON.toJSONString((Object)createOrderFrontResponse));
            return BaseResponse.error((String)"\u8c03\u7528\u6e90\u542f\u652f\u4ed8\u5e73\u53f0\uff0c\u521b\u5efa\u6536\u6b3e\u8ba2\u5355\u5931\u8d25");
        }
        CreateOrderResponse createOrderResponse = (CreateOrderResponse)createOrderFrontResponse.getBody();
        if (Objects.isNull(createOrderResponse)) {
            log.error("\u3010\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u3011\u521b\u5efa\u4ea4\u6613\u8ba2\u5355\u5931\u8d25,\u8fd4\u56de\u5b9e\u4f53\u4e3a\u7a7a");
            return BaseResponse.error((String)"\u8c03\u7528\u6e90\u542f\u652f\u4ed8\u5e73\u53f0\uff0c\u521b\u5efa\u6536\u6b3e\u8ba2\u5355\u5931\u8d25");
        }
        FrontRequest prepayRequest = this.buildPrepayRequest(dayAppointmentPayVoReq.getOpenId(), appointmentRecordEntity, createOrderResponse);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u9884\u652f\u4ed8\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)prepayRequest));
        FrontResponse prepayFrontResponse = this.paymentClient.prepay(prepayRequest);
        if (Objects.isNull(prepayFrontResponse) || !"1".equals(prepayFrontResponse.getCode())) {
            log.error("\u3010\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u3011\u9884\u652f\u4ed8\u4e0b\u5355\u5931\u8d25{}", (Object)JSON.toJSONString((Object)prepayFrontResponse));
            return BaseResponse.error((String)"\u8c03\u7528\u6e90\u542f\u652f\u4ed8\u5e73\u53f0\uff0c\u9884\u4e0b\u5355\u5931\u8d25");
        }
        PrepayResponse prepayResponse = (PrepayResponse)prepayFrontResponse.getBody();
        if (Objects.isNull(prepayResponse)) {
            log.error("\u3010\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u3011\u9884\u652f\u4ed8\u4e0b\u5355\u5931\u8d25,\u8fd4\u56de\u5b9e\u4f53\u4e3a\u7a7a");
            return BaseResponse.error((String)"\u8c03\u7528\u6e90\u542f\u652f\u4ed8\u5e73\u53f0\uff0c\u9884\u652f\u4ed8\u4e0b\u5355\u5931\u8d25");
        }
        appointmentRecordEntity.setPayPostId(createOrderResponse.getTradeNo());
        appointmentRecordEntity.setPayTransationId(prepayResponse.getTranNo());
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        String payMsg = prepayResponse.getPayMsg();
        JSONObject jsonObject = JSONObject.parseObject((String)payMsg);
        jsonObject.put("packageValue", jsonObject.get((Object)"package"));
        this.jedisCluster.set(key, jsonObject.toJSONString());
        this.jedisCluster.expire(key, 600);
        return BaseResponse.success((Object)jsonObject.toJSONString());
    }

    private FrontRequest<PrepayRequest> buildPrepayRequest(String openId, AppointmentRecordEntity appointmentRecordEntity, CreateOrderResponse body) {
        FrontRequest request = new FrontRequest();
        request.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        request.setOrganCode(appointmentRecordEntity.getInnerChannelCode());
        PrepayRequest prepayRequest = PrepayRequest.builder().requestNo(appointmentRecordEntity.getSysAppointmentId()).tradeNo(body.getTradeNo()).payType("WeChatAppletPay").payAmount(appointmentRecordEntity.getPayAmount()).macNumber("\u4e92\u533b\u5fae\u4fe1\u5c0f\u7a0b\u5e8f").notifyUrl(this.propertiesConstant.getPayNotifyUrl()).build();
        AttachParams attachParams = AttachParams.builder().callbackUrl(this.propertiesConstant.getPayNotifyUrl()).build();
        prepayRequest.setAttachParams(JSON.toJSONString((Object)attachParams));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("openid", (Object)openId);
        jsonObject.put("goods_desc", (Object)"\u9884\u7ea6\u6302\u53f7");
        prepayRequest.setBizContent(jsonObject.toJSONString());
        request.setBody((Object)prepayRequest);
        return request;
    }

    private FrontRequest<CreateOrderRequest> buildCreateOrderRequest(AppointmentRecordEntity appointmentRecordEntity) {
        FrontRequest request = new FrontRequest();
        request.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        request.setOrganCode(appointmentRecordEntity.getInnerChannelCode());
        BigDecimal amount = new BigDecimal(appointmentRecordEntity.getPayAmount());
        String goodsCode = appointmentRecordEntity.getAdmDate().equals(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd")) ? "register" : "reserve";
        CreateOrderRequest createOrderRequest = CreateOrderRequest.builder().businessId(appointmentRecordEntity.getSysAppointmentId()).goodsCode("register").identityId(appointmentRecordEntity.getPatientCardNo()).isAgency("false").macNumber("\u4e92\u533b\u5fae\u4fe1\u5c0f\u7a0b\u5e8f").name(appointmentRecordEntity.getPatientName()).operator("zwby").orderBody("\u4e92\u8054\u7f51\u533b\u9662\u5c0f\u7a0b\u5e8f\u9884\u7ea6\u6302\u53f7").payAmount(amount).totalAmount(amount).build();
        ArrayList<CreateOrderRequest.GoodsList> goodsList = new ArrayList<CreateOrderRequest.GoodsList>();
        CreateOrderRequest.GoodsList goodsListObj = CreateOrderRequest.GoodsList.builder().goodsAmount(amount).goodsName("register").goodsPrice(amount).goodsQuantity(new BigDecimal("1.0")).goodsSpec("1").build();
        goodsList.add(goodsListObj);
        createOrderRequest.setGoodsList(goodsList);
        request.setBody((Object)createOrderRequest);
        return request;
    }

    private BaseResponse<String> payCreateOrder(AppointmentPayVoReq appointmentPayVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getPayUrl(), (String)JSON.toJSONString((Object)appointmentPayVoReq));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("baseResponse: " + baseResponse);
            this.taskExecutor.execute(() -> {
                String data = (String)baseResponse.getData();
                String prepayId = data.substring(data.indexOf("prepay_id=") + 10, data.indexOf("\",\"paySign"));
                log.info("prepayId: " + prepayId);
                String sysAppointmentId = appointmentPayVoReq.getOutTradeNo();
                this.jedisCluster.set(sysAppointmentId, prepayId);
                this.jedisCluster.expire(sysAppointmentId, 518400);
            });
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u53d1\u8d77\u652f\u4ed8\u5931\u8d25" + e.getMessage());
            return BaseResponse.error((String)"\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
    }

    private void updateScheduleByDayAppointmentCreateOrderVoReq(DayAppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq) {
        this.scheduleRecordMapper.updateScheduleByDayAppointmentCreateOrderVoReq(dayAppointmentCreateOrderVoReq);
    }

    private GatewayRequest<GetScheduleReqVO> buildConfirmScheduleGetwayRequest(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayReq = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(confirmAppointmentVo.getAdmDate());
        getScheduleReqVO.setEdDate(confirmAppointmentVo.getAdmDate());
        getScheduleReqVO.setLocCode(confirmAppointmentVo.getLocCode());
        getScheduleReqVO.setDocCode(confirmAppointmentVo.getDocCode());
        gatewayReq.setBody((Object)getScheduleReqVO);
        gatewayReq.setChannelName(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setChannel(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayReq.setKeyWord("confirmAppointmentVo");
        gatewayReq.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayReq;
    }

    public BaseResponse<String> appointmentRefund(String sysAppointmentId) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(sysAppointmentId);
        if (null == appointmentPayorderEntity || null == appointmentRecordEntity) {
            return BaseResponse.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        if (!WAIT_CONFIRMED.contains((int)appointmentRecordEntity.getAppointStatus())) {
            return BaseResponse.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeq());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9000\u6b3e\u5931\u8d25");
        }
        int appointmentType = appointmentRecordEntity.getAppointmentType();
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(appointmentPayorderEntity.getDealSeq());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        requestRefundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)requestRefundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        requestRefundOrderVoReq.setSign(sign);
        BaseResponse baseResponse = this.refund(requestRefundOrderVoReq);
        if ("1".equals(baseResponse.getCode())) {
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getValue());
            appointmentRecordEntity.setRemark(AppointmentStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getDisplay());
            this.appointmentRecordMapper.updateByPrimaryKey(appointmentRecordEntity);
        } else {
            BaseResponse.error((String)"\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        return BaseResponse.success((Object)"\u53d1\u8d77\u9000\u6b3e\u6210\u529f");
    }

    public void unLock(CancelRegisterReq cancelAppointmentVoReq) {
        log.info("\u6267\u884c\u53d6\u6d88\u9501\u53f7------>{}", (Object)cancelAppointmentVoReq);
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)cancelAppointmentVoReq);
        gatewayRequest.setKeyWord("unLockRegister");
        gatewayRequest.setChannel(ChannelEnum.USER_APPLETS.getValue());
        gatewayRequest.setChannelName(ChannelEnum.USER_APPLETS.getValue());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u53d6\u6d88\u9501\u53f7\u3011\u8bf7\u6c42\u53c2\u6570 gatewayRequest: " + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse gatewayResponse = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.CANCEL_REGISTERHT.getValue(), gatewayRequest, CancelRegisterRes.class);
        log.info("\u3010\u53d6\u6d88\u9501\u53f7\u3011\u8fd4\u56de\u53c2\u6570 gatewayResponse:" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u53d6\u6d88\u9501\u53f7 unLockRegister -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u53d6\u6d88\u9501\u53f7 unLockRegister -> his\u8bf7\u6c42\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
        }
    }

    public GetAppointRecords appointmentRecord(GetAppointRecordReq getAppointRecordReq) {
        FrontRequest gatewayRequest = new FrontRequest();
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody((Object)getAppointRecordReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return null;
    }

    public BaseResponse<String> cancelAppointment(String sysAppointmentId, String authCode) throws Exception {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        if (null == appointmentRecordEntity) {
            return BaseResponse.error((String)"\u6ca1\u6709\u5f53\u524d\u6302\u53f7\u8ba2\u5355\u53d6\u6d88\u5931\u8d25");
        }
        if (!appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) {
            return BaseResponse.error((String)"\u5f53\u524d\u8ba2\u5355\u72b6\u6001\u4e0d\u53ef\u53d6\u6d88 \u8bf7\u8054\u7cfb\u7a97\u53e3\u8fdb\u884c\u53d6\u6d88");
        }
        CancelRegisterReq cancelRegisterReq = new CancelRegisterReq();
        cancelRegisterReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        String s = this.jedisCluster.get(this.hisOrderNumber + sysAppointmentId);
        if (StrUtil.isBlank((CharSequence)s)) {
            return BaseResponse.error((String)"\u83b7\u53d6\u53f7\u6e90\u5931\u8d25\u65e0\u6cd5\u53d6\u6d88");
        }
        cancelRegisterReq.setLockQueueNo(s);
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)cancelRegisterReq);
        this.jedisCluster.del(this.hisOrderNumber + sysAppointmentId);
        RegistrationPushReqVo registrationPushReqVo = new RegistrationPushReqVo();
        AlibabaMedicalPushReqVO alibabaMedicalPushReqVO = new AlibabaMedicalPushReqVO();
        alibabaMedicalPushReqVO.setData((Object)registrationPushReqVo);
        alibabaMedicalPushReqVO.setType("1");
        alibabaMedicalPushReqVO.setClientCode("ALI_JCSZXYY");
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.CANCEL.getValue());
        appointmentRecordEntity.setScheduleLevelName("8");
        appointmentRecordEntity.setUpdatetime((Date)DateUtil.date());
        int i = this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        this.jedisCluster.set(appointmentRecordEntity.getSysAppointmentId() + "_authCode", authCode, "NX", "EX", 43200L);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
        return BaseResponse.success();
    }

    public BaseResponse<String> registByQrCode(ScanCodeRegistrationReqVO reqVO) {
        String key = reqVO.getUserId() + "_" + reqVO.getPatientCardNo() + "_" + reqVO.getScheduleId();
        if (this.jedisCluster.exists(key).booleanValue()) {
            return BaseResponse.error((String)"\u8bf7\u52ff\u91cd\u590d\u70b9\u51fb");
        }
        this.jedisCluster.set(key, "1", "NX", "EX", 10L);
        ScheduleRecordEntity scheduleRecordEntity = this.scheduleRecordMapper.selectBySysScheduleId(reqVO.getScheduleId());
        if (Objects.isNull(scheduleRecordEntity)) {
            return BaseResponse.error((String)"\u5f53\u524d\u52a0\u53f7\u6392\u73ed\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u626b\u7801");
        }
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(reqVO.getCardId());
        if (Objects.isNull(cardDetail)) {
            return BaseResponse.error((String)"\u5f53\u524d\u5c31\u8bca\u5361\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5c31\u8bca\u5361");
        }
        DoctorRecordEntity doctorEntity = this.doctorRecordMapper.selectByDocCode(scheduleRecordEntity.getDocCode());
        try {
            this.registrationRules(cardDetail.getCredNo(), doctorEntity.getDeptCode(), doctorEntity.getDeptName());
        }
        catch (AppointmentException e) {
            e.printStackTrace();
        }
        String sysAppointId = Convert.toStr((Object)this.snowflakeIdWorker.nextId());
        if (reqVO.getFeeType().equals(DocAppendInfoResVO.FeeTypeEnum.FREE.getCode())) {
            if (!Objects.equals(scheduleRecordEntity.getDeptCode(), "4092")) {
                Integer limitNum = 30;
                DoctorRecordEntity doctorRecordEntity = this.doctorRecordMapper.selectByDocCode(scheduleRecordEntity.getDocCode());
                if (Objects.nonNull(doctorRecordEntity)) {
                    limitNum = doctorRecordEntity.getFreeLimit();
                }
                DateTime startDate = DateUtil.beginOfMonth((Date)new Date());
                DateTime endDate = DateUtil.endOfMonth((Date)new Date());
                Integer count = this.appointmentRecordMapper.selectAppendRegistCount(scheduleRecordEntity.getDocCode(), DateUtil.formatDate((Date)startDate), DateUtil.formatDate((Date)endDate));
                if (count >= limitNum) {
                    return BaseResponse.error((String)"\u5f53\u524d\u533b\u751f\u514d\u8d39\u53f7\u52a0\u53f7\u5df2\u4e0a\u9650");
                }
            }
            FrontRequest frontRequest = new FrontRequest();
            NoSchedulingRequestRegVo noSchedulingRequestRegVo = new NoSchedulingRequestRegVo();
            noSchedulingRequestRegVo.setCardNo(reqVO.getPatientCardNo());
            noSchedulingRequestRegVo.setDeptCode(scheduleRecordEntity.getDeptCode());
            noSchedulingRequestRegVo.setDoctCode(scheduleRecordEntity.getDocCode());
            noSchedulingRequestRegVo.setRegDate(DateUtil.formatDate((Date)scheduleRecordEntity.getScheduleDate()));
            noSchedulingRequestRegVo.setRegLv("7");
            noSchedulingRequestRegVo.setFlowNo(sysAppointId);
            noSchedulingRequestRegVo.setRegFee("0.00");
            noSchedulingRequestRegVo.setDiagFee("0.00");
            noSchedulingRequestRegVo.setOperCode("zwby");
            frontRequest.setBody((Object)noSchedulingRequestRegVo);
            log.info("\u3010\u65e0\u6392\u73ed\u6302\u53f7\u3011\u8bf7\u6c42his\u5165\u53c2\u4e3a:{}", (Object)JSON.toJSONString((Object)noSchedulingRequestRegVo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            FrontResponse frontResponse = this.appointmentClient.noSchedulingRegister(frontRequest);
            log.info("\u3010\u65e0\u6392\u73ed\u6302\u53f7\u3011his\u63a5\u53e3\u8fd4\u56de\u4e3a:{}", (Object)JSON.toJSONString((Object)frontResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
            if (Objects.isNull(frontResponse) || !"1".equals(frontResponse.getCode())) {
                return BaseResponse.error((String)"\u8c03\u7528his\u6302\u53f7\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u626b\u7801\u6302\u53f7");
            }
            AppointmentRecordEntity appointmentRecordEntity = this.getAppointmentRecordEntity(cardDetail, reqVO, (NoSchedulingRegistResVO)frontResponse.getBody(), scheduleRecordEntity);
            appointmentRecordEntity.setSysAppointmentId(sysAppointId);
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
            this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
            this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
            return BaseResponse.success((Object)appointmentRecordEntity.getSysAppointmentId());
        }
        if (reqVO.getFeeType().equals(DocAppendInfoResVO.FeeTypeEnum.CHARGE.getCode())) {
            String payKey = "prepay_param_" + sysAppointId;
            String prePayParam = this.jedisCluster.get(payKey);
            if (StringUtils.isNotBlank((String)prePayParam)) {
                return BaseResponse.success((Object)prePayParam);
            }
            this.feeRule(scheduleRecordEntity);
            if (IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()) >= 60) {
                scheduleRecordEntity.setRegFee(BigDecimal.ZERO);
            }
            AppointmentRecordEntity appointmentRecordEntity = this.getAppointmentRecordEntity(cardDetail, reqVO, null, scheduleRecordEntity);
            appointmentRecordEntity.setSysAppointmentId(sysAppointId);
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
            FrontRequest request = this.buildCreateOrderRequest(appointmentRecordEntity);
            log.info("\u52a0\u53f7\u6302\u53f7\u652f\u4ed8\u521b\u5efa\u8ba2\u5355\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)request));
            FrontResponse createOrderFrontResponse = this.paymentClient.createOrder(request);
            if (Objects.isNull(createOrderFrontResponse) || !"1".equals(createOrderFrontResponse.getCode())) {
                log.error("\u3010\u52a0\u53f7\u6302\u53f7\u652f\u4ed8\u3011\u521b\u5efa\u4ea4\u6613\u8ba2\u5355\u5931\u8d25{}", (Object)JSON.toJSONString((Object)createOrderFrontResponse));
                return BaseResponse.error((String)"\u8c03\u7528\u6e90\u542f\u652f\u4ed8\u5e73\u53f0\uff0c\u521b\u5efa\u6536\u6b3e\u8ba2\u5355\u5931\u8d25");
            }
            CreateOrderResponse createOrderResponse = (CreateOrderResponse)createOrderFrontResponse.getBody();
            if (Objects.isNull(createOrderResponse)) {
                log.error("\u3010\u52a0\u53f7\u6302\u53f7\u652f\u4ed8\u3011\u521b\u5efa\u4ea4\u6613\u8ba2\u5355\u5931\u8d25,\u8fd4\u56de\u5b9e\u4f53\u4e3a\u7a7a");
                return BaseResponse.error((String)"\u8c03\u7528\u6e90\u542f\u652f\u4ed8\u5e73\u53f0\uff0c\u521b\u5efa\u6536\u6b3e\u8ba2\u5355\u5931\u8d25");
            }
            FrontRequest prepayRequest = this.buildPrepayRequest(reqVO.getOpenId(), appointmentRecordEntity, createOrderResponse);
            log.info("\u52a0\u53f7\u6302\u53f7\u652f\u4ed8\u9884\u652f\u4ed8\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)prepayRequest));
            FrontResponse prepayFrontResponse = this.paymentClient.prepay(prepayRequest);
            if (Objects.isNull(prepayFrontResponse) || !"1".equals(prepayFrontResponse.getCode())) {
                log.error("\u3010\u52a0\u53f7\u6302\u53f7\u652f\u4ed8\u3011\u9884\u652f\u4ed8\u4e0b\u5355\u5931\u8d25{}", (Object)JSON.toJSONString((Object)prepayFrontResponse));
                return BaseResponse.error((String)"\u8c03\u7528\u6e90\u542f\u652f\u4ed8\u5e73\u53f0\uff0c\u9884\u4e0b\u5355\u5931\u8d25");
            }
            PrepayResponse prepayResponse = (PrepayResponse)prepayFrontResponse.getBody();
            if (Objects.isNull(prepayResponse)) {
                log.error("\u3010\u52a0\u53f7\u6302\u53f7\u652f\u4ed8\u3011\u9884\u652f\u4ed8\u4e0b\u5355\u5931\u8d25,\u8fd4\u56de\u5b9e\u4f53\u4e3a\u7a7a");
                return BaseResponse.error((String)"\u8c03\u7528\u6e90\u542f\u652f\u4ed8\u5e73\u53f0\uff0c\u9884\u652f\u4ed8\u4e0b\u5355\u5931\u8d25");
            }
            String payMsg = prepayResponse.getPayMsg();
            JSONObject jsonObject = JSONObject.parseObject((String)payMsg);
            jsonObject.put("packageValue", jsonObject.get((Object)"package"));
            jsonObject.put("sysAppointId", (Object)sysAppointId);
            this.jedisCluster.set(payKey, jsonObject.toJSONString(), "NX", "EX", 600L);
            appointmentRecordEntity.setPayPostId(createOrderResponse.getTradeNo());
            appointmentRecordEntity.setPayTransationId(prepayResponse.getTranNo());
            this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
            RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = new RabbitMqDelayedOrderVo();
            rabbitMqDelayedOrderVo.setHospitalCode(appointmentRecordEntity.getHospitalCode());
            rabbitMqDelayedOrderVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
            rabbitMqDelayedOrderVo.setOrderId(appointmentRecordEntity.getSysAppointmentId());
            RabbitMqUtils.senderDelayedOrder((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)rabbitMqDelayedOrderVo), (long)180000L);
            return BaseResponse.success((Object)jsonObject.toJSONString());
        }
        return BaseResponse.error((String)"\u975e\u6cd5\u7684\u6536\u8d39\u7c7b\u578b");
    }

    private ScheduleRecordEntity feeRule(ScheduleRecordEntity scheduleRecord) {
        LocalDateTime now = LocalDateTime.now();
        LocalTime currentTime = now.toLocalTime();
        LocalTime startTime1 = LocalTime.of(8, 0);
        LocalTime endTime1 = LocalTime.of(12, 0);
        LocalTime startTime2 = LocalTime.of(14, 0);
        LocalTime endTime2 = LocalTime.of(17, 30);
        LocalDateTime todayStartTime3 = now.toLocalDate().atTime(LocalTime.of(18, 0));
        LocalDateTime tomorrowEndTime3 = now.toLocalDate().plusDays(1L).atTime(LocalTime.of(8, 0));
        if (!(currentTime.isAfter(startTime1) && currentTime.isBefore(endTime1) || currentTime.isAfter(startTime2) && currentTime.isBefore(endTime2))) {
            if (scheduleRecord.getDeptName().contains("\u513f\u79d1")) {
                if (!now.isAfter(todayStartTime3) && !now.isBefore(tomorrowEndTime3)) {
                    scheduleRecord.setRegFee(new BigDecimal("0"));
                    scheduleRecord.setDiagFee(new BigDecimal("21"));
                    scheduleRecord.setRegTitelCode("100");
                    scheduleRecord.setRegTitelName("\u6025\u8bca");
                }
            } else {
                scheduleRecord.setRegFee(new BigDecimal("0"));
                scheduleRecord.setDiagFee(new BigDecimal("21"));
                scheduleRecord.setRegTitelCode("100");
                scheduleRecord.setRegTitelName("\u6025\u8bca");
            }
        }
        return scheduleRecord;
    }

    private AppointmentRecordEntity getAppointmentRecordEntity(CardDetailsInfoRespVO cardDetail, ScanCodeRegistrationReqVO reqVO, NoSchedulingRegistResVO noSchedulingRegistResVO, ScheduleRecordEntity scheduleRecordEntity) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setUserId(reqVO.getUserId());
        appointmentRecordEntity.setScheduleType("3");
        if (Objects.nonNull(noSchedulingRegistResVO)) {
            appointmentRecordEntity.setAppointmentId(noSchedulingRegistResVO.getClinicNo());
            appointmentRecordEntity.setAppointmentNo(noSchedulingRegistResVO.getClinicNo());
        }
        appointmentRecordEntity.setAdmTimeRange("00:00-23:59");
        appointmentRecordEntity.setAdmDate(DateUtil.formatDate((Date)scheduleRecordEntity.getScheduleDate()));
        appointmentRecordEntity.setAdmRange(3);
        appointmentRecordEntity.setAppointmentTime(new Date());
        appointmentRecordEntity.setAppointmentType(2);
        appointmentRecordEntity.setChannelCode(reqVO.getChannelName());
        appointmentRecordEntity.setDeptCode(scheduleRecordEntity.getDeptCode());
        appointmentRecordEntity.setDeptName(scheduleRecordEntity.getDeptName());
        appointmentRecordEntity.setDocCode(scheduleRecordEntity.getDocCode());
        appointmentRecordEntity.setDocName(scheduleRecordEntity.getDocName());
        appointmentRecordEntity.setHospitalCode(scheduleRecordEntity.getHospitalCode());
        appointmentRecordEntity.setHospitalName(StringUtils.isBlank((String)scheduleRecordEntity.getHospitalName()) ? "\u6cb3\u5357\u79d1\u6280\u5927\u5b66\u7b2c\u4e8c\u9644\u5c5e\u533b\u9662" : scheduleRecordEntity.getHospitalName());
        appointmentRecordEntity.setInnerChannelCode(StringUtils.isNotBlank((String)scheduleRecordEntity.getHospitalArea()) ? scheduleRecordEntity.getHospitalArea() : "YBB");
        appointmentRecordEntity.setKeepSource(new Byte("2"));
        appointmentRecordEntity.setPatientCardNo(reqVO.getPatientCardNo());
        if (null != cardDetail) {
            appointmentRecordEntity.setPatientPhone(cardDetail.getTel());
            appointmentRecordEntity.setCardId(cardDetail.getCardId());
            appointmentRecordEntity.setPatientId(cardDetail.getCardNo());
            appointmentRecordEntity.setPatientIdCard(cardDetail.getCredNo());
            appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
            appointmentRecordEntity.setPatientSex(IdCardUtil.getGenderByIdCard((String)cardDetail.getCredNo()) == "M" ? 1 : 2);
            appointmentRecordEntity.setPatientName(cardDetail.getPatientName());
        }
        BigDecimal totalFee = scheduleRecordEntity.getRegFee().add(scheduleRecordEntity.getDiagFee());
        if (reqVO.getFeeType().equals(DocAppendInfoResVO.FeeTypeEnum.FREE.getCode())) {
            totalFee = BigDecimal.ZERO;
        }
        appointmentRecordEntity.setPayAmount(totalFee.toPlainString());
        appointmentRecordEntity.setRegFee(scheduleRecordEntity.getRegFee());
        appointmentRecordEntity.setServiceFee(scheduleRecordEntity.getDiagFee());
        appointmentRecordEntity.setScheduleHisId(scheduleRecordEntity.getScheduleHisId());
        appointmentRecordEntity.setSysScheduleId(scheduleRecordEntity.getScheduleHisId());
        appointmentRecordEntity.setSysTimeArrangeId(scheduleRecordEntity.getScheduleHisId());
        appointmentRecordEntity.setRegTitleName(scheduleRecordEntity.getRegTitelName());
        appointmentRecordEntity.setScheduleLevelName(scheduleRecordEntity.getRegTitelCode());
        appointmentRecordEntity.setHisTimeArrangeId(scheduleRecordEntity.getScheduleHisId());
        appointmentRecordEntity.setRemark("\u4e8c\u7ef4\u7801\u6302\u53f7");
        appointmentRecordEntity.setCreatetime((Date)DateUtil.date());
        appointmentRecordEntity.setUpdatetime((Date)DateUtil.date());
        appointmentRecordEntity.setTakeTime("00:00");
        return appointmentRecordEntity;
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }

    private void checkRegistBase(String idNo, String deptCode) throws AppointmentException {
        Period period = Period.between(LocalDate.parse(IdCardUtil.getBirthByIdCard((String)idNo), DateTimeFormatter.ofPattern("yyyyMMdd")), LocalDate.now());
        if ("10248".equals(deptCode)) {
            if (period.getYears() == 0 && period.getMonths() <= 7) {
                return;
            }
            throw new AppointmentException("\u60a8\u4e0d\u7b26\u5408\u65b0\u751f\u513f\u95e8\u8bca\u6302\u53f7\u6761\u4ef6(\u5c0f\u4e8e7\u4e2a\u6708)\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u79d1\u5ba4\u6302\u53f7\u3002\u8c22\u8c22\uff01");
        }
        List<String> pediatricList = Arrays.asList("1015");
        if (pediatricList.contains(deptCode)) {
            if (period.getYears() > 14) {
                throw new AppointmentException("\u60a8\u4e0d\u7b26\u5408\u513f\u79d1\u6302\u53f7\u6761\u4ef6(\u5c0f\u4e8e14\u5c81)\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u79d1\u5ba4\u6302\u53f7\u3002\u8c22\u8c22\uff01");
            }
            return;
        }
        List<String> gynaecologyList = Arrays.asList("1044");
        if (gynaecologyList.contains(deptCode)) {
            String gender = IdCardUtil.getGenderByIdCard((String)idNo);
            if ("M".equals(gender)) {
                throw new AppointmentException("\u60a8\u4e0d\u7b26\u5408\u5987\u4ea7\u79d1\u6302\u53f7\u6761\u4ef6(\u4ec5\u9650\u5973\u6027)\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u79d1\u5ba4\u6539\u6210\u9009\u62e9\u5176\u4ed6\u5c31\u8bca\u4eba\uff01");
            }
            return;
        }
    }

    public void SynappointmentReturnNumber() {
        LocalDate today = LocalDate.now();
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");
        String formattedDate = today.format(formatter);
        Integer sum = this.appointmentRecordMapper.synappointmentReturnNumber("130005", "\u5df2\u9000\u8d39\u786e\u8ba4");
        Integer sum1 = this.appointmentRecordMapper.synappointmentReturnNumber("130005", "\u7b49\u5019\u65f6\u95f4\u8f83\u957f");
        Integer sum2 = this.appointmentRecordMapper.synappointmentReturnNumber("130005", "\u6302\u9519\u79d1\u5ba4/\u533b\u5e08");
        Integer sum3 = this.appointmentRecordMapper.synappointmentReturnNumber("130005", "\u5c31\u8bca\u4fe1\u606f\u9519\u8bef");
        Integer sum4 = this.appointmentRecordMapper.synappointmentReturnNumber("130005", "\u4e2a\u4eba\u4e34\u65f6\u6709\u4e8b");
        Integer sum5 = this.appointmentRecordMapper.synappointmentReturnNumber("130005", "\u5176\u4ed6\u5ba2\u89c2\u56e0\u7d20");
        double result1 = (double)sum1.intValue() * 100.0 / (double)sum.intValue();
        String formattedResult1 = String.format("%.2f", result1);
        double result2 = (double)sum2.intValue() * 100.0 / (double)sum.intValue();
        String formattedResult2 = String.format("%.2f", result2);
        double result3 = (double)sum3.intValue() * 100.0 / (double)sum.intValue();
        String formattedResult3 = String.format("%.2f", result3);
        double result4 = (double)sum4.intValue() * 100.0 / (double)sum.intValue();
        String formattedResult4 = String.format("%.2f", result4);
        double result5 = (double)sum5.intValue() * 100.0 / (double)sum.intValue();
        String formattedResult5 = String.format("%.2f", result5);
        if (sum > 0) {
            SmsVo smsVo = SmsVo.builder().SecretKey("fXJ6WM3H9mF2YJXA").SecretName("ZZZXY00003155").TimeStamp(null).Mobile("13938876917").Content(formattedDate + "\u9000\u53f7\u6570" + sum + "\u4e2a\uff1b\u7b49\u5019\u65f6\u95f4\u8f83\u957f" + sum1 + "\u4e2a\uff0c\u5360\u6bd4" + formattedResult1 + "%\uff1b\u6302\u9519\u79d1\u5ba4/\u533b\u5e08" + sum2 + "\u4e2a \uff0c\u5360\u6bd4" + formattedResult2 + "%\uff1b\u5c31\u8bca\u4fe1\u606f\u9519\u8bef" + sum3 + "\u4e2a \uff0c\u5360\u6bd4" + formattedResult3 + "%\uff1b\u4e2a\u4eba\u4e34\u65f6\u6709\u4e8b" + sum4 + "\u4e2a\uff0c\u5360\u6bd4" + formattedResult4 + "%\uff1b\u5176\u4ed6\u5ba2\u89c2\u56e0\u7d20" + sum5 + "\u4e2a\u5360\u6bd4" + formattedResult5 + "%").build();
            String string = HttpUtil.post((String)"https://api.028lk.com/Sms/Api/Send", (String)JSON.toJSONString((Object)smsVo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        } else {
            SmsVo smsVo = SmsVo.builder().SecretKey("fXJ6WM3H9mF2YJXA").SecretName("ZZZXY00003155").TimeStamp(null).Mobile("13938876917").Content(formattedDate + "\u9000\u53f7\u6570" + sum + "\u4e2a\uff1b").build();
            String string = HttpUtil.post((String)"https://api.028lk.com/Sms/Api/Send", (String)JSON.toJSONString((Object)smsVo, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        }
    }
}

