/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ebaiyihui.api.InHospitalClient;
import com.ebaiyihui.api.OutpatientPaymentClient;
import com.ebaiyihui.api.PaymentClient;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.hkdhisfront.api.InHospitalApi;
import com.ebaiyihui.hkdhisfront.base.FrontRequest;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.hkdhisfront.inhosp.DepositReq;
import com.ebaiyihui.hkdhisfront.inhosp.DepositRes;
import com.ebaiyihui.hkdhisfront.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.hkdhisfront.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.hkdhisfront.payment.DeliverApplyRequest;
import com.ebaiyihui.hkdhisfront.payment.DeliverNotifyRequest;
import com.ebaiyihui.hkdhisfront.payment.PayCallBackRequest;
import com.ebaiyihui.hkdhisfront.payment.TradeCancelRequest;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.BusinessTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.DayAppointRefundCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.MedicalAppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceBillTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServicePayBillStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.OrderTypeEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.OutpatientPaymentException;
import com.ebaiyihui.wisdommedical.gateway.GateWayCommonUtil;
import com.ebaiyihui.wisdommedical.gateway.RouteEnum;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.BusinessResultMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.MedicalAppointmentInfoMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpGuideEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.PaymentHistoryMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.mapper.ServicePayBillMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.BusinessResultEntity;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.InpatientPayorderEntity;
import com.ebaiyihui.wisdommedical.model.MedicalAppointmentInfoEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.OpGuideEntity;
import com.ebaiyihui.wisdommedical.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.wisdommedical.model.PaymentHistory;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.model.ServicePayBillEntity;
import com.ebaiyihui.wisdommedical.pojo.YB.BaseMoveResponse;
import com.ebaiyihui.wisdommedical.pojo.YB.CreatePayMedicalOrderRequest;
import com.ebaiyihui.wisdommedical.pojo.YB.OutpatientYbPaymentCallback;
import com.ebaiyihui.wisdommedical.pojo.YB.QueryMedicalSettlementOrderExtData;
import com.ebaiyihui.wisdommedical.pojo.YB.QueryMedicalSettlementOrderRequest;
import com.ebaiyihui.wisdommedical.pojo.YB.QueryMedicalSettlementOrderResponse;
import com.ebaiyihui.wisdommedical.pojo.YB.ResultResponse;
import com.ebaiyihui.wisdommedical.pojo.vo.PayPlatformCallBackVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRefundOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseRefundNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.PaymentCallRepVo;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.InHospitalService;
import com.ebaiyihui.wisdommedical.service.MedicalService;
import com.ebaiyihui.wisdommedical.service.PayCallBackService;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.service.impl.OutpatientPaymentServiceImpl;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetUserInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import his.pojo.vo.appoint.PayRegistrationMsg;
import his.pojo.vo.appoint.PayRegistrationReq;
import his.pojo.vo.appoint.PayRegistrationRes;
import his.pojo.vo.base.GatewayRequest;
import his.pojo.vo.base.GatewayResponse;
import his.pojo.vo.outpatient.ComfirmPayYbNewReq;
import his.pojo.vo.outpatient.HisDetailsUploadReq;
import his.pojo.vo.outpatient.respmsg.ComfirmPaySetldetailYbNewReq;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCluster;

@Service
public class PayCallBackServiceImpl
implements PayCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PayCallBackServiceImpl.class);
    public static final String ACCEPT_REQUEST = "0";
    public static final String PAY_SUCCESS = "3";
    public static final String SUCCESS = "Y";
    public static final String HIS_SUCCESS = "1";
    public static final byte TO_BE_PAID = 0;
    public static final byte PAID = 1;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private BusinessResultMapper businessResultMapper;
    @Autowired
    private AppointmentService appointmentService;
    @Autowired
    private OutpatientPaymentServiceImpl outpatientPaymentServiceImpl;
    @Autowired
    private PushService pushService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private InHospitalService inHospitalService;
    @Autowired
    private OpGuideEntityMapper opGuideEntityMapper;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private GetUserInfoUtil getUserInfoUtil;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private OutpatientPaymentClient outpatientPaymentClient;
    @Autowired
    private InHospitalApi hospitalApi;
    @Autowired
    private PaymentHistoryMapper paymentHistoryMapper;
    @Autowired
    MedicalService medicalService;
    private final String redisKeyMedicalInsuranceWithdrawal = "ybcx";
    private final String redisKeyYbHisPaymentDetails = "hisybjfmx";
    private final String yylsh = "yylsh";
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private PaymentClient paymentClient;
    @Autowired
    private InHospitalClient inHospitalClient;
    @Autowired
    private MedicalAppointmentInfoMapper medicalAppointmentInfoMapper;

    public void dayAppointmentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + JSON.toJSONString((Object)responseNotifyRestVo.toString()));
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null != serviceMerchantConfigEntity) {
            Map params = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            if (!SignUtil.checkSign((Map)params, (String)serviceMerchantConfigEntity.getApplyKey())) {
                throw new AppointmentException("\u9a8c\u7b7e\u5931\u8d25\uff0c\u652f\u4ed8\u56de\u8c03\u4fe1\u606f\u53ef\u80fd\u88ab\u7be1\u6539");
            }
        } else {
            throw new AppointmentException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
        }
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVo, appointmentRecordEntity);
        if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) {
            return;
        }
        this.waitHisConfirm(responseNotifyRestVo, appointmentRecordEntity);
        GatewayRequest gatewayRequest = this.buildDayRegisterParams(appointmentRecordEntity, responseNotifyRestVo);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u5165\u53c2================-^.^-\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse dayRegisterGatewayRes = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.REGISTERHT_PAY.getValue(), gatewayRequest, PayRegistrationRes.class);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u51fa\u53c2================-^.^-\uff1a" + JSON.toJSONString((Object)dayRegisterGatewayRes));
        if (null != dayRegisterGatewayRes) {
            businessResultEntity.setErrorCode(dayRegisterGatewayRes.getErrCode());
            businessResultEntity.setErrorMsg(dayRegisterGatewayRes.getMsg());
            businessResultEntity.setTransationId(dayRegisterGatewayRes.getTransactionId());
        }
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)dayRegisterGatewayRes));
        businessResultEntity.setStatus(new Byte(ACCEPT_REQUEST));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        if (null == dayRegisterGatewayRes) {
            log.error("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8 dayRegister -> \u8bf7\u6c42his\u4e0d\u901a,\u9000\u6b3e");
            BaseResponse baseResponse = this.appointRefund(appointmentRecordEntity, responseNotifyRestVo, serviceMerchantConfigEntity);
            if (HIS_SUCCESS.equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a,\u9000\u6b3e");
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a\uff0c\u9000\u6b3e" + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            throw new AppointmentException(dayRegisterGatewayRes.getMsg());
        }
        if (!HIS_SUCCESS.equals(dayRegisterGatewayRes.getCode())) {
            String remark = DayAppointRefundCodeEnum.getDisplay((Integer)Integer.parseInt(dayRegisterGatewayRes.getErrCode()));
            BaseResponse baseResponse = this.appointRefund(appointmentRecordEntity, responseNotifyRestVo, serviceMerchantConfigEntity);
            if (HIS_SUCCESS.equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark(remark);
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark(remark + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u5f53\u65e5\u6302\u53f7 dayRegister -> his\u6302\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)dayRegisterGatewayRes.getErrCode(), (Object)dayRegisterGatewayRes.getMsg());
            throw new AppointmentException(dayRegisterGatewayRes.getMsg());
        }
        PayRegistrationRes dayRegisterRes = (PayRegistrationRes)dayRegisterGatewayRes.getData();
        this.updateHisReturnMsg(appointmentRecordEntity, dayRegisterRes);
        this.updateAppointmentPayorder(appointmentRecordEntity, payOrderEntity, dayRegisterRes);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(appointmentRecordEntity.getHospitalCode());
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTradeNo());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
    }

    public void nucleicPayCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u6838\u9178\u6302\u53f7\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + JSON.toJSONString((Object)responseNotifyRestVo.toString()));
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null != serviceMerchantConfigEntity) {
            Map params = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            if (!SignUtil.checkSign((Map)params, (String)serviceMerchantConfigEntity.getApplyKey())) {
                throw new AppointmentException("\u9a8c\u7b7e\u5931\u8d25\uff0c\u652f\u4ed8\u56de\u8c03\u4fe1\u606f\u53ef\u80fd\u88ab\u7be1\u6539");
            }
        } else {
            throw new AppointmentException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
        }
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVo, appointmentRecordEntity);
        if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) {
            return;
        }
        this.waitHisConfirm(responseNotifyRestVo, appointmentRecordEntity);
        GatewayRequest gatewayRequest = this.buildDayNucleicRegisterParams(appointmentRecordEntity, responseNotifyRestVo);
        log.info("\u6838\u9178\u7f34\u8d39\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("======>\u8c03\u7528his\u63a5\u53e3begin");
        GatewayResponse dayRegisterGatewayRes = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.OUT_PAY.getValue(), gatewayRequest, ComfirmPayNewRes.class);
        log.info("======>\u8c03\u7528his\u63a5\u53e3end" + JSON.toJSONString((Object)dayRegisterGatewayRes));
        log.info("\u6838\u9178\u7f34\u8d39\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)dayRegisterGatewayRes));
        if (null != dayRegisterGatewayRes) {
            businessResultEntity.setErrorCode(dayRegisterGatewayRes.getErrCode());
            businessResultEntity.setErrorMsg(dayRegisterGatewayRes.getMsg());
            businessResultEntity.setTransationId(dayRegisterGatewayRes.getTransactionId());
        }
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)dayRegisterGatewayRes));
        businessResultEntity.setStatus(new Byte(ACCEPT_REQUEST));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        if (null == dayRegisterGatewayRes) {
            log.error("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8 dayRegister -> \u8bf7\u6c42his\u4e0d\u901a,\u9000\u6b3e");
            BaseResponse baseResponse = this.appointRefund(appointmentRecordEntity, responseNotifyRestVo, serviceMerchantConfigEntity);
            if (HIS_SUCCESS.equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a,\u9000\u6b3e");
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a\uff0c\u9000\u6b3e" + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            throw new AppointmentException(dayRegisterGatewayRes.getMsg());
        }
        if (!HIS_SUCCESS.equals(dayRegisterGatewayRes.getCode())) {
            String remark = DayAppointRefundCodeEnum.getDisplay((Integer)Integer.parseInt(dayRegisterGatewayRes.getErrCode()));
            BaseResponse baseResponse = this.appointRefund(appointmentRecordEntity, responseNotifyRestVo, serviceMerchantConfigEntity);
            if (HIS_SUCCESS.equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark(remark);
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark(remark + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u5f53\u65e5\u6302\u53f7 dayRegister -> his\u6302\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)dayRegisterGatewayRes.getErrCode(), (Object)dayRegisterGatewayRes.getMsg());
            throw new AppointmentException(dayRegisterGatewayRes.getMsg());
        }
        ComfirmPayNewRes data = (ComfirmPayNewRes)dayRegisterGatewayRes.getData();
        this.updateHisReturnMsgNew(appointmentRecordEntity);
        this.updateAppointmentPayorderNew(appointmentRecordEntity, payOrderEntity, data);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(appointmentRecordEntity.getHospitalCode());
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTradeNo());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
    }

    private void updateAppointmentPayorderNew(AppointmentRecordEntity appointmentRecordEntity, AppointmentPayorderEntity payOrderEntity, ComfirmPayNewRes data) {
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setBusinessByToDay(JSON.toJSONString((Object)data));
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setPatientId(appointmentRecordEntity.getPatientId());
        payOrderEntity.setPaymentSeq(appointmentRecordEntity.getPayChannelCode());
        this.appointmentPayOrderMapper.updateByPrimaryKey(payOrderEntity);
    }

    private void updateHisReturnMsgNew(AppointmentRecordEntity appointmentRecordEntity) {
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        appointmentRecordEntity.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u4fdd\u5b58his\u8fd4\u56dereceiptId\u8ba2\u5355:" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    private GatewayRequest<ComfirmPayNewReq> buildDayNucleicRegisterParams(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        ComfirmPayNewReq comfirmPayNewReq = new ComfirmPayNewReq();
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setKeyWord("comfirmPayNew");
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)appointmentRecordEntity.getChannelCode()));
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody((Object)comfirmPayNewReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public void yBdayAppointment(ResponseNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u5f53\u65e5\u6302\u53f7\u533b\u4fdd\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + JSON.toJSONString((Object)responseNotifyRestVo.toString()));
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVo, appointmentRecordEntity);
        if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) {
            return;
        }
        this.waitHisConfirm(responseNotifyRestVo, appointmentRecordEntity);
        GatewayRequest gatewayRequest = this.buildDayRegisterParams(appointmentRecordEntity, responseNotifyRestVo);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse dayRegisterGatewayRes = new GateWayCommonUtil().requestHis(String.valueOf(this.snowflakeIdWorker.nextId()), gatewayRequest.getOrganCode(), RouteEnum.DAY_REGISTERHT_PAY.getValue(), gatewayRequest, PayRegistrationRes.class);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)dayRegisterGatewayRes));
        if (null != dayRegisterGatewayRes) {
            businessResultEntity.setErrorCode(dayRegisterGatewayRes.getErrCode());
            businessResultEntity.setErrorMsg(dayRegisterGatewayRes.getMsg());
            businessResultEntity.setTransationId(dayRegisterGatewayRes.getTransactionId());
        }
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)dayRegisterGatewayRes));
        businessResultEntity.setStatus(new Byte(ACCEPT_REQUEST));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        PayRegistrationRes dayRegisterRes = (PayRegistrationRes)dayRegisterGatewayRes.getData();
        this.updateHisReturnMsg(appointmentRecordEntity, dayRegisterRes);
        this.updateAppointmentPayorder(appointmentRecordEntity, payOrderEntity, dayRegisterRes);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setOrganId(appointmentRecordEntity.getHospitalCode());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTradeNo());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
    }

    private BaseResponse<String> appointRefund(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo, ServiceMerchantConfigEntity serviceMerchantConfigEntity) {
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        requestRefundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)requestRefundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        requestRefundOrderVoReq.setSign(sign);
        log.info("\u5f53\u65e5\u6302\u53f7\u81ea\u52a8\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)requestRefundOrderVoReq));
        return this.refund(requestRefundOrderVoReq);
    }

    private BaseResponse<String> refund(RequestRefundOrderVoReq requestRefundOrderVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)requestRefundOrderVoReq));
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            return response;
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25\uff0c\u539f\u56e0\u662f:{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
    }

    private AppointmentPayorderEntity saveAppointmentPayorder(ResponseNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity) {
        AppointmentPayorderEntity payOrderEntity = new AppointmentPayorderEntity();
        payOrderEntity.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        payOrderEntity.setMerchantId(responseNotifyRestVo.getMchId());
        payOrderEntity.setBizSysSeq("ZHJYGH");
        payOrderEntity.setPaymentTime(DateUtils.getCurrentDate());
        payOrderEntity.setPayBillNo(responseNotifyRestVo.getTradeNo());
        payOrderEntity.setOrderStatus(new Byte(PAY_SUCCESS));
        payOrderEntity.setDealMoney(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        payOrderEntity.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        payOrderEntity.setBizDealSeq(String.valueOf(this.snowflakeIdWorker.nextId()));
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        this.appointmentPayOrderMapper.insertSelective(payOrderEntity);
        return payOrderEntity;
    }

    private void updateAppointmentPayorder(AppointmentRecordEntity appointmentRecordEntity, AppointmentPayorderEntity payOrderEntity, PayRegistrationRes dayRegisterRes) {
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setBusinessByToDay(JSON.toJSONString((Object)dayRegisterRes));
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setPatientId(appointmentRecordEntity.getPatientId());
        payOrderEntity.setPaymentSeq(appointmentRecordEntity.getPayChannelCode());
        this.appointmentPayOrderMapper.updateByPrimaryKey(payOrderEntity);
    }

    private void updateHisReturnMsg(AppointmentRecordEntity appointmentRecordEntity, PayRegistrationRes dayRegisterRes) {
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        appointmentRecordEntity.setAppointmentId(dayRegisterRes.getReceiptId());
        appointmentRecordEntity.setReceptId(dayRegisterRes.getReceiptId());
        appointmentRecordEntity.setAdmAddress(dayRegisterRes.getAdmitAddress());
        appointmentRecordEntity.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u4fdd\u5b58his\u8fd4\u56dereceiptId\u8ba2\u5355:" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    private void waitHisConfirm(ResponseNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity) {
        appointmentRecordEntity.setPayAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        appointmentRecordEntity.setPayTransationId(responseNotifyRestVo.getTradeNo());
        appointmentRecordEntity.setPayChannel(PayChannelEnum.getDisplay((String)responseNotifyRestVo.getPayChannel()));
        appointmentRecordEntity.setPayChannelCode(responseNotifyRestVo.getPayChannel());
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue());
        appointmentRecordEntity.setRemark(AppointmentStatusEnum.WAIT_HIS_CONFIRM.getDisplay());
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u6210\u529f\uff0c\u5f85his\u786e\u8ba4\uff1a" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    private GatewayRequest<PayRegistrationReq> buildDayRegisterParams(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PayRegistrationReq payRegistrationReq = new PayRegistrationReq();
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setAppointId(appointmentRecordEntity.getAppointmentId());
        payRegistrationReq.setPayChannel("HLWYYWXZF");
        payRegistrationReq.setFlowNo(responseNotifyRestVo.getTradeNo());
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setPatientId(appointmentRecordEntity.getPatientId());
        payRegistrationReq.setScheduleId(appointmentRecordEntity.getScheduleHisId());
        payRegistrationReq.setRegFee(appointmentRecordEntity.getPayAmount());
        PayRegistrationMsg payRegistrationMsg = new PayRegistrationMsg();
        payRegistrationMsg.setOrderid(responseNotifyRestVo.getOutTradeNo());
        payRegistrationMsg.setPayment(appointmentRecordEntity.getPayAmount());
        payRegistrationMsg.setSuccess(SUCCESS);
        payRegistrationMsg.setAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        payRegistrationReq.setRespMsg(payRegistrationMsg);
        gatewayRequest.setBody((Object)payRegistrationReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)appointmentRecordEntity.getChannelCode()));
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setKeyWord("PayRegistrationReq");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<PayRegistrationReq> appointRegisGateway(AppointmentRecordEntity appointmentRecordEntity, PaymentCallRepVo repVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PayRegistrationReq payRegistrationReq = new PayRegistrationReq();
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setPatientId(appointmentRecordEntity.getPatientId());
        payRegistrationReq.setScheduleId(appointmentRecordEntity.getScheduleHisId());
        payRegistrationReq.setAppointId(appointmentRecordEntity.getSysAppointmentId());
        payRegistrationReq.setRegFee(appointmentRecordEntity.getPayAmount());
        payRegistrationReq.setAppointDate(appointmentRecordEntity.getAdmDate());
        payRegistrationReq.setPayChannel(appointmentRecordEntity.getPayChannel());
        PayRegistrationMsg payRegistrationMsg = new PayRegistrationMsg();
        payRegistrationMsg.setOrderid(repVo.getPayFlowNo());
        payRegistrationMsg.setPayment(appointmentRecordEntity.getPayAmount());
        payRegistrationMsg.setSuccess(SUCCESS);
        payRegistrationReq.setRespMsg(payRegistrationMsg);
        gatewayRequest.setBody((Object)payRegistrationReq);
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setKeyWord("buildnewDayRegisterParams");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public void appointmentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + responseNotifyRestVo.toString());
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        log.info("\u652f\u4ed8\u6210\u529f------>{}", (Object)sysAppointmentId);
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        log.info("\u652f\u4ed8\u6210\u529f------>{}", (Object)appointmentRecordEntity);
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVo, appointmentRecordEntity);
        log.info("\u4fdd\u5b58\u652f\u4ed8\u4fe1\u606f================>END-^.^-" + JSONObject.toJSONString((Object)payOrderEntity));
        if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) {
            return;
        }
        this.waitHisConfirm(responseNotifyRestVo, appointmentRecordEntity);
        log.info("\u9884\u7ea6\u6302\u53f7his\u652f\u4ed8\u786e\u8ba4================>BEGIN-^.^-");
        this.appointmentService.payAppointmentPayToHis(appointmentRecordEntity, responseNotifyRestVo, payOrderEntity);
        log.info("\u9884\u7ea6\u6302\u53f7his\u652f\u4ed8\u786e\u8ba4================>END-^.^-");
        log.info("\u751f\u6210\u8d26\u5355\u4fe1\u606f================>BEGIN-^.^-");
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(this.propertiesConstant.getAppCode());
        servicePayBillEntity.setOrganId(appointmentRecordEntity.getHospitalCode());
        servicePayBillEntity.setWorkServiceCode("\u9884\u7ea6\u6302\u53f7");
        servicePayBillEntity.setApplyCode("");
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTradeNo());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode("\u9884\u7ea6\u6302\u53f7");
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u56de\u8c03\u7ed3\u675f================>END-^.^-");
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
    }

    public void yBappointment(ResponseNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + responseNotifyRestVo.toString());
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        log.info("\u652f\u4ed8\u6210\u529f------>{}", (Object)sysAppointmentId);
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        log.info("\u652f\u4ed8\u6210\u529f------>{}", (Object)appointmentRecordEntity);
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVo, appointmentRecordEntity);
        if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) {
            return;
        }
        this.waitHisConfirm(responseNotifyRestVo, appointmentRecordEntity);
        this.appointmentService.payAppointmentPayToHis(appointmentRecordEntity, responseNotifyRestVo, payOrderEntity);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setOrganId(appointmentRecordEntity.getHospitalCode());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTradeNo());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
    }

    public List<PayPlatformCallBackVoRes> payPlatformCallBack(String posId, String tranDate) {
        return this.appointmentRecordMapper.selectByPayPosIdAndDate(posId, tranDate, this.propertiesConstant.getOrganCode());
    }

    public void outpatientPaymentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws Exception {
        log.info("\u7f34\u8d39\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + responseNotifyRestVo.toString());
        String outPatientId = responseNotifyRestVo.getOutTradeNo();
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        if (Objects.isNull(opBusinessOrderEntity)) {
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39\u4e1a\u52a1\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
        }
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientAndOrderType(outPatientId, OrderTypeEnum.PAYMENT_ORDER.getValue().toString());
        String areaCode = opBusinessOrderEntity.getDeptName().contains("\u6d1b\u9f99") ? "LLYQ" : "YBB";
        FrontRequest request = new FrontRequest();
        request.setOrganCode(areaCode);
        String attach = responseNotifyRestVo.getAttach();
        PayCallBackRequest payCallBackRequest = (PayCallBackRequest)JSON.parseObject((String)attach, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        request.setBody((Object)DeliverApplyRequest.builder().tradeNo(opRechargePaymentOrderEntity.getPayBillNo()).payList(payCallBackRequest.getPayList()).build());
        FrontResponse deliverApplyResponseFrontResponse = this.paymentClient.deliverApply(request);
        if (Objects.isNull(deliverApplyResponseFrontResponse) || !HIS_SUCCESS.equals(deliverApplyResponseFrontResponse.getCode())) {
            log.error("\u8c03\u7528\u6e90\u542f\u652f\u4ed8-\u4ea4\u8d27\u7533\u8bf7\u63a5\u53e3\u5931\u8d25{}", (Object)JSON.toJSONString((Object)deliverApplyResponseFrontResponse));
            FrontRequest cancelRequestFrontRequest = new FrontRequest();
            cancelRequestFrontRequest.setOrganCode(areaCode);
            cancelRequestFrontRequest.setBody((Object)TradeCancelRequest.builder().orgTranNo(payCallBackRequest.getTranNo()).cancelReason("\u4ea4\u8d27\u7533\u8bf7\u5931\u8d25").build());
            FrontResponse tradeCancelResponseFrontResponse = this.paymentClient.tradeCancel(cancelRequestFrontRequest);
            if (Objects.isNull(tradeCancelResponseFrontResponse) || !HIS_SUCCESS.equals(tradeCancelResponseFrontResponse.getCode())) {
                log.error("\u8c03\u7528\u6e90\u542f\u652f\u4ed8-\u4ea4\u6613\u64a4\u9500\u63a5\u53e3\u5931\u8d25{}", (Object)JSON.toJSONString((Object)tradeCancelResponseFrontResponse));
                throw new AppointmentException("\u4ea4\u6613\u64a4\u9500\u5931\u8d25");
            }
            throw new OutpatientPaymentException("\u4ea4\u8d27\u7533\u8bf7\u5931\u8d25");
        }
        log.info("\u4ea4\u8d27\u7533\u8bf7\u6210\u529f\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)deliverApplyResponseFrontResponse));
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)1));
        opRechargePaymentOrderEntity.setBankTradeNo(responseNotifyRestVo.getTradeNo());
        opRechargePaymentOrderEntity.setPaymentTime(responseNotifyRestVo.getPayTime());
        opRechargePaymentOrderEntity.setMerchantId(responseNotifyRestVo.getMchId());
        opRechargePaymentOrderEntity.setUpdateTime(new Date());
        opRechargePaymentOrderEntity.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        opRechargePaymentOrderEntity.setRemark("\u5df2\u652f\u4ed8");
        log.info("\u66f4\u65b0\u652f\u4ed8\u4fe1\u606f\uff0c\u53c2\u6570\u4e3aopRechargePaymentOrderEntity\uff1a{}", (Object)opRechargePaymentOrderEntity);
        this.opRechargePaymentOrderEntityMapper.updateByPrimaryKey(opRechargePaymentOrderEntity);
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue());
        opBusinessOrderEntity.setPayTime(responseNotifyRestVo.getPayTime());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        FrontRequest frontRequest = this.buildComfirmPayNewReq(opBusinessOrderEntity, opRechargePaymentOrderEntity, responseNotifyRestVo);
        log.info("\u8c03\u7528his\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)frontRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        FrontResponse frontResponse = this.outpatientPaymentClient.comfirmPayNew(frontRequest);
        log.info("\u8c03\u7528his\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)frontResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (Objects.isNull(frontResponse) || !HIS_SUCCESS.equals(frontResponse.getCode())) {
            log.error("\u8c03\u7528his\u95e8\u8bca\u7f34\u8d39\u786e\u8ba4\u5931\u8d25\uff0chis\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            this.deliverNotify(areaCode, opRechargePaymentOrderEntity.getPayBillNo(), opBusinessOrderEntity.getOutPatientId(), opBusinessOrderEntity.getAdmId(), "fail");
            opBusinessOrderEntity.setRemark(frontResponse.getMessage());
            this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
            throw new OutpatientPaymentException("his\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u5931\u8d25");
        }
        this.deliverNotify(areaCode, opRechargePaymentOrderEntity.getPayBillNo(), opBusinessOrderEntity.getOutPatientId(), opBusinessOrderEntity.getAdmId(), "success");
        ComfirmPayNewRes comfirmPayNewRes = (ComfirmPayNewRes)frontResponse.getBody();
        String receiptId = comfirmPayNewRes.getReceiptId();
        opBusinessOrderEntity.setReceiptId(receiptId);
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.PAID.getValue());
        opBusinessOrderEntity.setPayTime(responseNotifyRestVo.getPayTime());
        opBusinessOrderEntity.setRemark("\u5df2\u652f\u4ed8");
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        this.taskExecutor.execute(() -> this.pushService.outPatientSuccessMsgPush(opBusinessOrderEntity, DateUtils.dateToFullString((Date)responseNotifyRestVo.getPayTime())));
        log.info("\u751f\u6210\u8d26\u5355\u4fe1\u606f================>BEGIN-^.^");
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(this.propertiesConstant.getAppCode());
        servicePayBillEntity.setOrganId(this.propertiesConstant.getOrganCode());
        servicePayBillEntity.setWorkServiceCode(this.propertiesConstant.getBizSysSeqJF());
        servicePayBillEntity.setApplyCode(this.propertiesConstant.getBizSysSeqJF());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTradeNo());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode(this.propertiesConstant.getBizSysSeqJF());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        this.jedisCluster.del(responseNotifyRestVo.getOutTradeNo());
        this.jedisCluster.del(responseNotifyRestVo.getOutTradeNo() + "_pay");
        log.info("\u751f\u6210\u8d26\u5355\u4fe1\u606f======\u56de\u8c03\u7ed3\u675f=====>END-^v^");
    }

    public void outpatientPaymentCallBackByYb(ResponseNotifyRestVo responseNotifyRestVo) throws Exception {
        log.info("\u533b\u4fdd\u7f34\u8d39\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + responseNotifyRestVo.toString());
        String outPatientId = responseNotifyRestVo.getOutTradeNo();
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        if (Objects.isNull(opBusinessOrderEntity)) {
            throw new OutpatientPaymentException("\u533b\u4fdd\u95e8\u8bca\u7f34\u8d39\u4e1a\u52a1\u8ba2\u5355\u4e0d\u5b58\u5728\uff0c\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
        }
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientAndOrderType(outPatientId, OrderTypeEnum.PAYMENT_ORDER.getValue().toString());
        String areaCode = opBusinessOrderEntity.getDeptName().contains("\u6d1b\u9f99") ? "LLYQ" : "YBB";
        FrontRequest request = new FrontRequest();
        request.setOrganCode(areaCode);
        String attach = responseNotifyRestVo.getAttach();
        PayCallBackRequest payCallBackRequest = (PayCallBackRequest)JSON.parseObject((String)attach, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        request.setBody((Object)DeliverApplyRequest.builder().tradeNo(opRechargePaymentOrderEntity.getPayBillNo()).payList(payCallBackRequest.getPayList()).build());
        FrontResponse deliverApplyResponseFrontResponse = this.paymentClient.deliverApply(request);
        if (Objects.isNull(deliverApplyResponseFrontResponse) || !HIS_SUCCESS.equals(deliverApplyResponseFrontResponse.getCode())) {
            log.error("\u8c03\u7528\u6e90\u542f\u652f\u4ed8-\u4ea4\u8d27\u7533\u8bf7\u63a5\u53e3\u5931\u8d25{}", (Object)JSON.toJSONString((Object)deliverApplyResponseFrontResponse));
            FrontRequest cancelRequestFrontRequest = new FrontRequest();
            cancelRequestFrontRequest.setOrganCode(areaCode);
            cancelRequestFrontRequest.setBody((Object)TradeCancelRequest.builder().orgTranNo(payCallBackRequest.getTranNo()).cancelReason("\u4ea4\u8d27\u7533\u8bf7\u5931\u8d25").build());
            FrontResponse tradeCancelResponseFrontResponse = this.paymentClient.tradeCancel(cancelRequestFrontRequest);
            if (Objects.isNull(tradeCancelResponseFrontResponse) || !HIS_SUCCESS.equals(tradeCancelResponseFrontResponse.getCode())) {
                log.error("\u8c03\u7528\u6e90\u542f\u652f\u4ed8-\u4ea4\u6613\u64a4\u9500\u63a5\u53e3\u5931\u8d25{}", (Object)JSON.toJSONString((Object)tradeCancelResponseFrontResponse));
                throw new AppointmentException("\u4ea4\u6613\u64a4\u9500\u5931\u8d25");
            }
            throw new OutpatientPaymentException("\u4ea4\u8d27\u7533\u8bf7\u5931\u8d25");
        }
        log.info("\u4ea4\u8d27\u7533\u8bf7\u6210\u529f\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)deliverApplyResponseFrontResponse));
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)1));
        opRechargePaymentOrderEntity.setBankTradeNo(responseNotifyRestVo.getTradeNo());
        opRechargePaymentOrderEntity.setPaymentTime(responseNotifyRestVo.getPayTime());
        opRechargePaymentOrderEntity.setMerchantId(responseNotifyRestVo.getMchId());
        opRechargePaymentOrderEntity.setUpdateTime(new Date());
        opRechargePaymentOrderEntity.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        opRechargePaymentOrderEntity.setRemark("\u5df2\u652f\u4ed8");
        log.info("\u66f4\u65b0\u652f\u4ed8\u4fe1\u606f\uff0c\u53c2\u6570\u4e3aopRechargePaymentOrderEntity\uff1a{}", (Object)opRechargePaymentOrderEntity);
        this.opRechargePaymentOrderEntityMapper.updateByPrimaryKey(opRechargePaymentOrderEntity);
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue());
        opBusinessOrderEntity.setPayTime(responseNotifyRestVo.getPayTime());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        FrontRequest frontRequest = this.buildComfirmPayNewReqByYb(opBusinessOrderEntity, opRechargePaymentOrderEntity, responseNotifyRestVo);
        log.info("\u8c03\u7528his\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)frontRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        FrontResponse frontResponse = this.outpatientPaymentClient.comfirmPayNew(frontRequest);
        log.info("\u8c03\u7528his\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)frontResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (Objects.isNull(frontResponse) || !HIS_SUCCESS.equals(frontResponse.getCode())) {
            log.error("\u8c03\u7528his\u95e8\u8bca\u7f34\u8d39\u786e\u8ba4\u5931\u8d25\uff0chis\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            this.deliverNotify(areaCode, opRechargePaymentOrderEntity.getPayBillNo(), opBusinessOrderEntity.getOutPatientId(), opBusinessOrderEntity.getAdmId(), "fail");
            opBusinessOrderEntity.setRemark(frontResponse.getMessage());
            this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
            throw new OutpatientPaymentException("his\u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u5931\u8d25");
        }
        this.deliverNotify(areaCode, opRechargePaymentOrderEntity.getPayBillNo(), opBusinessOrderEntity.getOutPatientId(), opBusinessOrderEntity.getAdmId(), "success");
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.PAID.getValue());
        opBusinessOrderEntity.setPayTime(responseNotifyRestVo.getPayTime());
        opBusinessOrderEntity.setRemark("\u5df2\u652f\u4ed8");
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        this.taskExecutor.execute(() -> this.pushService.outPatientSuccessMsgPush(opBusinessOrderEntity, DateUtils.dateToFullString((Date)responseNotifyRestVo.getPayTime())));
        log.info("\u751f\u6210\u8d26\u5355\u4fe1\u606f================>BEGIN-^.^");
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(this.propertiesConstant.getAppCode());
        servicePayBillEntity.setOrganId(this.propertiesConstant.getOrganCode());
        servicePayBillEntity.setWorkServiceCode(this.propertiesConstant.getBizSysSeqJF());
        servicePayBillEntity.setApplyCode(this.propertiesConstant.getBizSysSeqJF());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTradeNo());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode(this.propertiesConstant.getBizSysSeqJF());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        this.jedisCluster.del(responseNotifyRestVo.getOutTradeNo());
        this.jedisCluster.del(responseNotifyRestVo.getOutTradeNo() + "_pay");
        log.info("\u751f\u6210\u8d26\u5355\u4fe1\u606f======\u56de\u8c03\u7ed3\u675f=====>END-^v^");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void outpatientYbPaymentCallback(OutpatientYbPaymentCallback responseNotifyRestVo) throws Exception {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqJF());
        if (null == serviceMerchantConfigEntity) throw new OutpatientPaymentException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
        Map params = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
        if (!SignUtil.checkSign((Map)params, (String)serviceMerchantConfigEntity.getApplyKey())) {
            // empty if block
        }
        log.info("======>payment\u8868begin");
        String outPatientId = responseNotifyRestVo.getOut_trade_no();
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outPatientId);
        this.jedisCluster.del(responseNotifyRestVo.getOut_trade_no());
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue());
        opBusinessOrderEntity.setPayTime((Date)DateUtil.date());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)1));
        opRechargePaymentOrderEntity.setPayBillNo(responseNotifyRestVo.getTrade_no());
        opRechargePaymentOrderEntity.setPaymentTime(opBusinessOrderEntity.getPayTime());
        opRechargePaymentOrderEntity.setMerchantId(responseNotifyRestVo.getApp_id());
        opRechargePaymentOrderEntity.setUpdateTime(new Date());
        opRechargePaymentOrderEntity.setDealSeq(responseNotifyRestVo.getTrade_no());
        opRechargePaymentOrderEntity.setRemark("\u5df2\u652f\u4ed8");
        log.info("\u66f4\u65b0\u652f\u4ed8\u4fe1\u606f\uff0c\u53c2\u6570\u4e3aopRechargePaymentOrderEntity\uff1a{}", (Object)opRechargePaymentOrderEntity);
        this.opRechargePaymentOrderEntityMapper.updateByPrimaryKey(opRechargePaymentOrderEntity);
        log.info("======>payment\u8868end");
        log.info("======>\u7ec4\u88c5\u8c03\u7528his\u53c2\u6570begin");
        QueryMedicalSettlementOrderRequest queryMedicalSettlementOrderRequest = this.buildQueryMedicalSettlementOrderRequest(responseNotifyRestVo);
        if (BeanUtil.isEmpty((Object)queryMedicalSettlementOrderRequest, (String[])new String[0])) {
            log.error("\u83b7\u53d6\u67e5\u8be2\u533b\u4fdd\u7f34\u8d39\u8ba2\u5355\u53c2\u6570\u5931\u8d25\u7f34\u8d39\u5f02\u5e38");
            return;
        }
        PaymentHistory record = new PaymentHistory();
        int sum = 0;
        ResultResponse baseMoveResponseResultResponse = this.buildQueryMedicalSettlementOrderResponse(queryMedicalSettlementOrderRequest, sum, record);
        try {
            List paymentHistories = this.paymentHistoryMapper.selectListByOuttradeno(responseNotifyRestVo.getOut_trade_no());
            if (CollectionUtil.isEmpty((Collection)paymentHistories)) {
                record.setAppcode("JCSZXYY");
                record.setOuttradeno(responseNotifyRestVo.getOut_trade_no());
                record.setTradeno(responseNotifyRestVo.getTrade_no());
                record.setCancelbillnol(responseNotifyRestVo.getOut_trade_no());
                record.setCancelserialno(responseNotifyRestVo.getOut_trade_no());
                record.setType(Byte.valueOf((byte)2));
                record.setPaystatus(Byte.valueOf((byte)1));
                record.setOrgancode("130211");
                record.setStatus(Byte.valueOf((byte)1));
                this.paymentHistoryMapper.insert(record);
            } else {
                log.info("\u91cd\u590d\u56de\u8c03");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u589e\u52a0\u5b58\u50a8\u652f\u4ed8\u53c2\u6570\u5931\u8d25");
        }
        String s = this.jedisCluster.get("hisybjfmx" + outPatientId);
        if (StrUtil.isBlank((CharSequence)s)) {
            log.error("\u652f\u4ed8\u56de\u8c03\u5185\u83b7\u53d6\u660e\u7ec6\u4e0a\u4f20\u51fa\u53c2\u4e3a\u7a7a\u7f34\u8d39\u5f02\u5e38");
            return;
        }
        HisDetailsUploadReq hisDetailsUploadReq = (HisDetailsUploadReq)JSON.parseObject((String)s, HisDetailsUploadReq.class);
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setTransactionId(hisDetailsUploadReq.getMdtrtId());
        frontRequest.setBody((Object)hisDetailsUploadReq);
        log.info("\u8bf7\u6c42his\u660e\u7ec6\u4e0a\u4f20\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)frontRequest.getBody()));
        Object detailsUpload = null;
        log.info("\u8bf7\u6c42his\u660e\u7ec6\u4e0a\u4f20\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)detailsUpload.getBody()));
        if (ACCEPT_REQUEST.equals(detailsUpload.getCode())) {
            log.error("his\u660e\u7ec6\u4e0a\u4f20\u5931\u8d25 \u7f34\u8d39\u5f02\u5e38");
            return;
        }
        FrontRequest frontRequest1 = new FrontRequest();
        String hisyylsh = this.jedisCluster.get("yylsh" + outPatientId);
        log.info("his\u533b\u9662\u6d41\u6c34\u53f7\u4e3a->{}", (Object)hisyylsh);
        ComfirmPayYbNewReq comfirmPayYbNewReq = this.buledComfirmPayYbNewReq(baseMoveResponseResultResponse, hisyylsh, record);
        frontRequest1.setBody((Object)comfirmPayYbNewReq);
        frontRequest1.setTransactionId(comfirmPayYbNewReq.getMdtrtId());
        log.info("\u8bf7\u6c42his\u533b\u4fdd\u7ed3\u7b97\u5165\u53c2->{}", (Object)JSON.toJSONString((Object)JSON.toJSONString((Object)comfirmPayYbNewReq)));
        Object outpatientYbPaymentResDTOFrontResponse = null;
        log.info("\u8bf7\u6c42his\u533b\u4fdd\u7ed3\u7b97\u51fa\u53c2->{}", (Object)JSON.toJSONString((Object)JSON.toJSONString((Object)outpatientYbPaymentResDTOFrontResponse.getBody())));
        if (ACCEPT_REQUEST.equals(outpatientYbPaymentResDTOFrontResponse.getCode())) {
            log.error("his\u660e\u7ec6\u4e0a\u4f20\u5931\u8d25 \u7f34\u8d39\u5f02\u5e38");
            return;
        }
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.PAID.getValue());
        opBusinessOrderEntity.setPayTime(opBusinessOrderEntity.getPayTime());
        opBusinessOrderEntity.setRemark("\u5df2\u652f\u4ed8");
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        log.info("\u751f\u6210\u8d26\u5355\u4fe1\u606f================>BEGIN-^.^");
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(this.propertiesConstant.getOrganCode());
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setPayChannel("ALIPAY");
        servicePayBillEntity.setTradeTime(opBusinessOrderEntity.getPayTime());
        servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTrade_no());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOut_trade_no());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getTrade_status());
        servicePayBillEntity.setOrderAmount(Convert.toDouble((Object)responseNotifyRestVo.getTotal_amount()));
        servicePayBillEntity.setDealAmount(Convert.toDouble((Object)responseNotifyRestVo.getTotal_amount()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getTrade_no());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        log.info("\u751f\u6210\u8d26\u5355\u4fe1\u606f======\u56de\u8c03\u7ed3\u675f=====>END-^v^");
    }

    private QueryMedicalSettlementOrderRequest buildQueryMedicalSettlementOrderRequest(OutpatientYbPaymentCallback outpatientYbPaymentCallback) {
        QueryMedicalSettlementOrderRequest queryMedicalSettlementOrderRequest = new QueryMedicalSettlementOrderRequest();
        String s = this.jedisCluster.get("ybcx" + outpatientYbPaymentCallback.getOut_trade_no());
        if (null == s) {
            log.error("\u83b7\u53d6his\u533b\u4fdd\u7f34\u8d39\u4fe1\u606f\u5931\u8d25");
            return new QueryMedicalSettlementOrderRequest();
        }
        CreatePayMedicalOrderRequest createPayMedicalOrderRequest = (CreatePayMedicalOrderRequest)JSON.parseObject((String)s, CreatePayMedicalOrderRequest.class);
        queryMedicalSettlementOrderRequest.setOrganCode("130211");
        queryMedicalSettlementOrderRequest.setPayOrdId(createPayMedicalOrderRequest.getPayOrdId());
        queryMedicalSettlementOrderRequest.setOrgCodg("H62030200062");
        queryMedicalSettlementOrderRequest.setPayToken(createPayMedicalOrderRequest.getPayToken());
        queryMedicalSettlementOrderRequest.setIdNo(createPayMedicalOrderRequest.getIdNo());
        queryMedicalSettlementOrderRequest.setUserName(createPayMedicalOrderRequest.getUserName());
        queryMedicalSettlementOrderRequest.setIdType("01");
        return queryMedicalSettlementOrderRequest;
    }

    private ComfirmPayYbNewReq buledComfirmPayYbNewReq(ResultResponse<BaseMoveResponse<QueryMedicalSettlementOrderResponse>> baseMoveResponseResultResponse, String hisyylsh, PaymentHistory record) {
        ComfirmPayYbNewReq comfirmPayYbNewReq = new ComfirmPayYbNewReq();
        QueryMedicalSettlementOrderExtData queryMedicalSettlementOrderExtData = (QueryMedicalSettlementOrderExtData)JSON.parseObject((String)((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getExtData().replaceAll("\\\\", ""), QueryMedicalSettlementOrderExtData.class);
        ArrayList comfirmPaySetldetailYbNewReqList = new ArrayList();
        queryMedicalSettlementOrderExtData.getSetldetail().forEach(iter -> {
            ComfirmPaySetldetailYbNewReq comfirmPaySetldetailYbNewReq = new ComfirmPaySetldetailYbNewReq();
            comfirmPaySetldetailYbNewReq.setFundPayType(iter.getFund_pay_type());
            comfirmPaySetldetailYbNewReq.setFundPayTypeName(iter.getFund_pay_type_name());
            comfirmPaySetldetailYbNewReq.setFundPayamt(iter.getFund_payamt());
            comfirmPaySetldetailYbNewReq.setInscpScpAmt(iter.getInscp_scp_amt());
            comfirmPaySetldetailYbNewReqList.add(comfirmPaySetldetailYbNewReq);
        });
        comfirmPayYbNewReq.setSetldetail(comfirmPaySetldetailYbNewReqList);
        comfirmPayYbNewReq.setAcctMulaidPay(queryMedicalSettlementOrderExtData.getSetlinfo().getAcctMulaidPay());
        comfirmPayYbNewReq.setAcctPay(queryMedicalSettlementOrderExtData.getSetlinfo().getAcctPay());
        comfirmPayYbNewReq.setActPayDedc(queryMedicalSettlementOrderExtData.getSetlinfo().getActPayDedc());
        comfirmPayYbNewReq.setAge(queryMedicalSettlementOrderExtData.getSetlinfo().getAge());
        comfirmPayYbNewReq.setBalc(queryMedicalSettlementOrderExtData.getSetlinfo().getBalc());
        comfirmPayYbNewReq.setBrdy(queryMedicalSettlementOrderExtData.getSetlinfo().getBrdy());
        comfirmPayYbNewReq.setCertno(queryMedicalSettlementOrderExtData.getSetlinfo().getCertno());
        comfirmPayYbNewReq.setClrOptins(queryMedicalSettlementOrderExtData.getSetlinfo().getClrOptins());
        comfirmPayYbNewReq.setClrType(queryMedicalSettlementOrderExtData.getSetlinfo().getClrType());
        comfirmPayYbNewReq.setClrWay(queryMedicalSettlementOrderExtData.getSetlinfo().getClrWay());
        comfirmPayYbNewReq.setCvlservFlag(queryMedicalSettlementOrderExtData.getSetlinfo().getCvlservFlag());
        comfirmPayYbNewReq.setCvlservPay(queryMedicalSettlementOrderExtData.getSetlinfo().getCvlservPay());
        comfirmPayYbNewReq.setFulamtOwnpayAmt(queryMedicalSettlementOrderExtData.getSetlinfo().getFulamtOwnpayAmt());
        comfirmPayYbNewReq.setFundPaySumamt(queryMedicalSettlementOrderExtData.getSetlinfo().getFundPaySumamt());
        comfirmPayYbNewReq.setGend(queryMedicalSettlementOrderExtData.getSetlinfo().getGend());
        comfirmPayYbNewReq.setHifesPay(queryMedicalSettlementOrderExtData.getSetlinfo().getHifesPay());
        comfirmPayYbNewReq.setHifmiPay(queryMedicalSettlementOrderExtData.getSetlinfo().getHifmiPay());
        comfirmPayYbNewReq.setHifobPay(queryMedicalSettlementOrderExtData.getSetlinfo().getHifobPay());
        comfirmPayYbNewReq.setHifpPay(queryMedicalSettlementOrderExtData.getSetlinfo().getHifpPay());
        comfirmPayYbNewReq.setHospPartAmt(queryMedicalSettlementOrderExtData.getSetlinfo().getHospPartAmt());
        comfirmPayYbNewReq.setInscpScpAmt2(queryMedicalSettlementOrderExtData.getSetlinfo().getInscpScpAmt());
        comfirmPayYbNewReq.setInsutype(queryMedicalSettlementOrderExtData.getSetlinfo().getInsutype());
        comfirmPayYbNewReq.setMafPay(queryMedicalSettlementOrderExtData.getSetlinfo().getMafPay());
        comfirmPayYbNewReq.setMdtrtCertType(queryMedicalSettlementOrderExtData.getSetlinfo().getMdtrtCertType());
        comfirmPayYbNewReq.setMdtrtId(queryMedicalSettlementOrderExtData.getSetlinfo().getMdtrtId());
        comfirmPayYbNewReq.setMedType(queryMedicalSettlementOrderExtData.getSetlinfo().getMedType());
        comfirmPayYbNewReq.setMedfeeSumamt(queryMedicalSettlementOrderExtData.getSetlinfo().getMedfeeSumamt());
        comfirmPayYbNewReq.setMedinsSetlId(queryMedicalSettlementOrderExtData.getSetlinfo().getMedinsSetlId());
        comfirmPayYbNewReq.setNaty(queryMedicalSettlementOrderExtData.getSetlinfo().getNaty());
        comfirmPayYbNewReq.setOthPay(queryMedicalSettlementOrderExtData.getSetlinfo().getOthPay());
        comfirmPayYbNewReq.setOverlmtSelfpay(queryMedicalSettlementOrderExtData.getSetlinfo().getOverlmtSelfpay());
        comfirmPayYbNewReq.setPoolPropSelfpay(queryMedicalSettlementOrderExtData.getSetlinfo().getPoolPropSelfpay());
        comfirmPayYbNewReq.setPreselfpayAmt(queryMedicalSettlementOrderExtData.getSetlinfo().getPreselfpayAmt());
        comfirmPayYbNewReq.setPsnCashPay(queryMedicalSettlementOrderExtData.getSetlinfo().getPsnCashPay());
        comfirmPayYbNewReq.setPsnCertType(queryMedicalSettlementOrderExtData.getSetlinfo().getPsnCertType());
        comfirmPayYbNewReq.setPsnName(queryMedicalSettlementOrderExtData.getSetlinfo().getPsnName());
        comfirmPayYbNewReq.setPsnNo(queryMedicalSettlementOrderExtData.getSetlinfo().getPsnNo());
        comfirmPayYbNewReq.setPsnPartAmt(queryMedicalSettlementOrderExtData.getSetlinfo().getPsnPartAmt());
        comfirmPayYbNewReq.setPsnType(queryMedicalSettlementOrderExtData.getSetlinfo().getPsnType());
        comfirmPayYbNewReq.setSetlId(queryMedicalSettlementOrderExtData.getSetlinfo().getSetlId());
        comfirmPayYbNewReq.setSetlTime(queryMedicalSettlementOrderExtData.getSetlinfo().getSetlTime());
        comfirmPayYbNewReq.setPayChnlId(queryMedicalSettlementOrderExtData.getPayChnlInfo().getPayChnlId());
        comfirmPayYbNewReq.setPayChnlName(queryMedicalSettlementOrderExtData.getPayChnlInfo().getPayChnlName());
        comfirmPayYbNewReq.setAcctFlag(queryMedicalSettlementOrderExtData.getAcctFlag());
        comfirmPayYbNewReq.setFeeSumamt(((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getFeeSumamt());
        comfirmPayYbNewReq.setFundPay(((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getFundPay());
        comfirmPayYbNewReq.setHiChrgTime(((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getHiChrgTime());
        comfirmPayYbNewReq.setHiDocSn(((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getHiDocSn());
        comfirmPayYbNewReq.setHiPlafSn(((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getHiDocSn());
        comfirmPayYbNewReq.setHiRgstSn(((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getHiRgstSn());
        comfirmPayYbNewReq.setMedOrgOrd(hisyylsh);
        comfirmPayYbNewReq.setOrgCodg("H62030200062");
        comfirmPayYbNewReq.setOrgName("\u91d1\u660c\u5e02\u804c\u5de5\u533b\u9662");
        comfirmPayYbNewReq.setOwnpayAmt(((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getOwnPayAmt());
        comfirmPayYbNewReq.setPayOrdId(((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getPayOrdId());
        comfirmPayYbNewReq.setPsnAcctPay(((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getPsnAcctPay());
        comfirmPayYbNewReq.setRevsToken(((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getRevsToken());
        comfirmPayYbNewReq.setTraceTime(((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getTraceTime());
        comfirmPayYbNewReq.setTimestamp(String.valueOf(DateUtil.currentSeconds()));
        comfirmPayYbNewReq.setRefundAmount(record.getTotlrefdamt());
        comfirmPayYbNewReq.setOutTradeNo(record.getOuttradeno());
        comfirmPayYbNewReq.setTradeNo(record.getTradeno());
        return comfirmPayYbNewReq;
    }

    private ResultResponse<BaseMoveResponse<QueryMedicalSettlementOrderResponse>> buildQueryMedicalSettlementOrderResponse(QueryMedicalSettlementOrderRequest queryMedicalSettlementOrderRequest, int sum, PaymentHistory record) {
        QueryMedicalSettlementOrderExtData queryMedicalSettlementOrderExtData;
        if (++sum >= 20) {
            log.error("\u9012\u5f52\u5230\u6700\u5927\u6b21\u6570 \u67e5\u8be2\u5931\u8d25");
            return ResultResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            log.error("\u6682\u505c\u5931\u8d25->{}", (Throwable)e);
        }
        ResultResponse baseMoveResponseResultResponse = this.medicalService.queryMedicalSettlementOrder(queryMedicalSettlementOrderRequest);
        if (ACCEPT_REQUEST.equals(baseMoveResponseResultResponse.getCode())) {
            log.error("\u83b7\u53d6\u533b\u4fdd\u6210\u529f\u7f34\u8d39\u4fe1\u606f\u4e3a\u7a7a");
            return ResultResponse.error((String)"\u67e5\u8be2\u5931\u8d25");
        }
        String extData = ((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getExtData();
        if (StrUtil.isBlank((CharSequence)extData)) {
            this.buildQueryMedicalSettlementOrderResponse(queryMedicalSettlementOrderRequest, sum, null);
        }
        if (BeanUtil.isEmpty((Object)(queryMedicalSettlementOrderExtData = (QueryMedicalSettlementOrderExtData)JSON.parseObject((String)extData.replaceAll("\\\\", ""), QueryMedicalSettlementOrderExtData.class)), (String[])new String[0])) {
            this.buildQueryMedicalSettlementOrderResponse(queryMedicalSettlementOrderRequest, sum, null);
        }
        if (BeanUtil.isEmpty((Object)queryMedicalSettlementOrderExtData.getSetlinfo(), (String[])new String[0])) {
            this.buildQueryMedicalSettlementOrderResponse(queryMedicalSettlementOrderRequest, sum, null);
        }
        if (StrUtil.isBlank((CharSequence)queryMedicalSettlementOrderExtData.getSetlinfo().getClrOptins()) || StrUtil.isBlank((CharSequence)queryMedicalSettlementOrderExtData.getSetlinfo().getClrWay())) {
            this.buildQueryMedicalSettlementOrderResponse(queryMedicalSettlementOrderRequest, sum, null);
        }
        record.setUsername(queryMedicalSettlementOrderRequest.getUserName());
        record.setIdno(queryMedicalSettlementOrderRequest.getIdNo());
        record.setTotlrefdamt(((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getFeeSumamt());
        record.setCashrefdamt(((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getOwnPayAmt());
        record.setFundrefdamt(((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getFundPay());
        record.setPsnacctrefdamt(((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getPsnAcctPay());
        record.setPayordid(((QueryMedicalSettlementOrderResponse)((BaseMoveResponse)baseMoveResponseResultResponse.getBody()).getData()).getPayOrdId());
        return baseMoveResponseResultResponse;
    }

    public void inHospDepositPayCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws Exception {
        log.info("\u4f4f\u9662\u5145\u503c\u652f\u4ed8\u56de\u8c03responseNotifyRestVo^.^: " + responseNotifyRestVo.toString());
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(responseNotifyRestVo.getOutTradeNo());
        if (inpatientDepositDetailEntity == null) {
            log.error("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u8ba2\u5355\u4fe1\u606f");
            throw new Exception("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u8ba2\u5355\u4fe1\u606f");
        }
        String areaCode = inpatientDepositDetailEntity.getDeptName().contains("\u6d1b\u9f99") ? "LLYQ" : "YBB";
        FrontRequest request = new FrontRequest();
        request.setOrganCode(areaCode);
        String attach = responseNotifyRestVo.getAttach();
        PayCallBackRequest payCallBackRequest = (PayCallBackRequest)JSON.parseObject((String)attach, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        request.setBody((Object)DeliverApplyRequest.builder().tradeNo(inpatientDepositDetailEntity.getTradeNo()).payList(payCallBackRequest.getPayList()).build());
        FrontResponse deliverApplyResponseFrontResponse = this.paymentClient.deliverApply(request);
        if (Objects.isNull(deliverApplyResponseFrontResponse) || !HIS_SUCCESS.equals(deliverApplyResponseFrontResponse.getCode())) {
            log.error("\u8c03\u7528\u6e90\u542f\u652f\u4ed8-\u4ea4\u8d27\u7533\u8bf7\u63a5\u53e3\u5931\u8d25{}", (Object)JSON.toJSONString((Object)deliverApplyResponseFrontResponse));
            FrontRequest cancelRequestFrontRequest = new FrontRequest();
            if (inpatientDepositDetailEntity.getDeptName().contains("\u6d1b\u9f99")) {
                cancelRequestFrontRequest.setOrganCode("LLYQ");
            } else {
                cancelRequestFrontRequest.setOrganCode("YBB");
            }
            cancelRequestFrontRequest.setBody((Object)TradeCancelRequest.builder().orgTranNo(payCallBackRequest.getTranNo()).cancelReason("\u4ea4\u8d27\u7533\u8bf7\u5931\u8d25").build());
            FrontResponse tradeCancelResponseFrontResponse = this.paymentClient.tradeCancel(cancelRequestFrontRequest);
            if (Objects.isNull(tradeCancelResponseFrontResponse) || !HIS_SUCCESS.equals(tradeCancelResponseFrontResponse.getCode())) {
                log.error("\u8c03\u7528\u6e90\u542f\u652f\u4ed8-\u4ea4\u6613\u64a4\u9500\u63a5\u53e3\u5931\u8d25{}", (Object)JSON.toJSONString((Object)tradeCancelResponseFrontResponse));
                throw new AppointmentException("\u4ea4\u6613\u64a4\u9500\u5931\u8d25");
            }
            throw new OutpatientPaymentException("\u4ea4\u8d27\u7533\u8bf7\u5931\u8d25");
        }
        log.info("\u4ea4\u8d27\u7533\u8bf7\u6210\u529f\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)deliverApplyResponseFrontResponse));
        InpatientPayorderEntity inpatientPayorderEntity = this.inpatientPayorderEntityMapper.selectByInpatientDepositId(inpatientDepositDetailEntity.getId(), new Byte(HIS_SUCCESS));
        if (Objects.isNull(inpatientPayorderEntity)) {
            log.info("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f");
            inpatientPayorderEntity = new InpatientPayorderEntity();
            inpatientPayorderEntity.setInpatientDepositId(inpatientDepositDetailEntity.getId());
            inpatientPayorderEntity.setOrderType(new Byte(HIS_SUCCESS));
            inpatientPayorderEntity.setDealMoney(inpatientDepositDetailEntity.getMoney());
            inpatientPayorderEntity.setBizSysSeq(ServiceCodeEnum.DEPOSITPAY.getValue());
            inpatientPayorderEntity.setPayStatus(Byte.valueOf(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue().byteValue()));
            inpatientPayorderEntity.setMerchantSeq(this.propertiesConstant.getMchCode());
            inpatientPayorderEntity.setUserId(inpatientDepositDetailEntity.getUserId());
            inpatientPayorderEntity.setCreateTime(new Date());
            inpatientPayorderEntity.setUpdateTime(new Date());
            inpatientPayorderEntity.setPayBillNo(responseNotifyRestVo.getTradeNo());
            inpatientPayorderEntity.setBankTradeNo(responseNotifyRestVo.getTradeNo());
            inpatientPayorderEntity.setMerchantId(responseNotifyRestVo.getMchId());
            inpatientPayorderEntity.setDealSeq(responseNotifyRestVo.getDealTradeNo());
            inpatientPayorderEntity.setRemark("\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u652f\u4ed8\u5b8c\u6210");
            this.inpatientPayorderEntityMapper.insertSelective(inpatientPayorderEntity);
        } else {
            inpatientPayorderEntity.setPaymentTime(responseNotifyRestVo.getPayTime());
            inpatientPayorderEntity.setPaymentSeq(responseNotifyRestVo.getPayChannel());
            inpatientPayorderEntity.setRemark("\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u652f\u4ed8\u5b8c\u6210");
            inpatientPayorderEntity.setPayBillNo(responseNotifyRestVo.getTradeNo());
            inpatientPayorderEntity.setBankTradeNo(responseNotifyRestVo.getTradeNo());
            inpatientPayorderEntity.setInpatientDepositId(inpatientDepositDetailEntity.getId());
            inpatientPayorderEntity.setUpdateTime(new Date());
            inpatientPayorderEntity.setPayStatus(Byte.valueOf(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue().byteValue()));
            inpatientPayorderEntity.setMerchantId(responseNotifyRestVo.getMchId());
            inpatientPayorderEntity.setDealSeq(responseNotifyRestVo.getDealTradeNo());
            this.inpatientPayorderEntityMapper.updateByPrimaryKey(inpatientPayorderEntity);
        }
        inpatientDepositDetailEntity.setStatus(Byte.valueOf(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue().byteValue()));
        this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
        FrontRequest depositReqFrontRequest = this.buildDepositReq(inpatientDepositDetailEntity, responseNotifyRestVo);
        log.info("\u8c03\u7528his\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5165\u53c2{}", (Object)JSON.toJSONString((Object)depositReqFrontRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        FrontResponse frontResponse = this.inHospitalClient.deposit(depositReqFrontRequest);
        log.info("\u8c03\u7528his\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)frontResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (Objects.isNull(frontResponse) || !Objects.equals(frontResponse.getCode(), HIS_SUCCESS)) {
            log.error("\u8c03\u7528his\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u5931\u8d25");
            inpatientDepositDetailEntity.setRemark(inpatientDepositDetailEntity.getRemark() + frontResponse.getMessage());
            this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
            this.deliverNotify(areaCode, inpatientDepositDetailEntity.getTradeNo(), inpatientDepositDetailEntity.getOrderSeq(), inpatientDepositDetailEntity.getAdmissionNo(), "fail");
            return;
        }
        inpatientDepositDetailEntity.setReceiptId(((DepositRes)frontResponse.getBody()).getReceiptId());
        inpatientDepositDetailEntity.setStatus(Byte.valueOf(BusinessOrderStatusEnum.PAID.getValue().byteValue()));
        inpatientDepositDetailEntity.setUpdateTime(new Date());
        inpatientDepositDetailEntity.setRemark("\u5df2\u652f\u4ed8\uff0chis\u6210\u529f\u786e\u8ba4");
        this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
        this.deliverNotify(areaCode, inpatientDepositDetailEntity.getTradeNo(), inpatientDepositDetailEntity.getOrderSeq(), inpatientDepositDetailEntity.getAdmissionNo(), "success");
    }

    public void medicalRecordCopyingPayCallBack(ResponseNotifyRestVo responseNotifyRestVo) {
        log.info("\u75c5\u6848\u590d\u5370\u652f\u4ed8\u56de\u8c03responseNotifyRestVo^.^: " + responseNotifyRestVo.toString());
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"orderNumber", (Object)responseNotifyRestVo.getOutTradeNo());
        MedicalAppointmentInfoEntity medicalAppointmentInfoEntity = (MedicalAppointmentInfoEntity)this.medicalAppointmentInfoMapper.selectOne((Wrapper)queryWrapper);
        if (medicalAppointmentInfoEntity == null) {
            log.error("\u672a\u67e5\u8be2\u5230\u4e1a\u52a1\u8ba2\u5355\u4fe1\u606f");
            return;
        }
        FrontRequest request = new FrontRequest();
        request.setOrganCode("UNHIS");
        String attach = responseNotifyRestVo.getAttach();
        PayCallBackRequest payCallBackRequest = (PayCallBackRequest)JSON.parseObject((String)attach, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        request.setBody((Object)DeliverApplyRequest.builder().tradeNo(medicalAppointmentInfoEntity.getTransactionId()).payList(payCallBackRequest.getPayList()).build());
        FrontResponse deliverApplyResponseFrontResponse = this.paymentClient.deliverApply(request);
        if (Objects.isNull(deliverApplyResponseFrontResponse) || !HIS_SUCCESS.equals(deliverApplyResponseFrontResponse.getCode())) {
            log.error("\u75c5\u6848\u590d\u5370\u56de\u8c03\u8c03\u7528\u6e90\u542f\u652f\u4ed8-\u4ea4\u8d27\u7533\u8bf7\u63a5\u53e3\u5931\u8d25{}", (Object)JSON.toJSONString((Object)deliverApplyResponseFrontResponse));
            FrontRequest cancelRequestFrontRequest = new FrontRequest();
            cancelRequestFrontRequest.setOrganCode("UNHIS");
            cancelRequestFrontRequest.setBody((Object)TradeCancelRequest.builder().orgTranNo(payCallBackRequest.getTranNo()).cancelReason("\u4ea4\u8d27\u7533\u8bf7\u5931\u8d25").build());
            FrontResponse tradeCancelResponseFrontResponse = this.paymentClient.tradeCancel(cancelRequestFrontRequest);
            if (Objects.isNull(tradeCancelResponseFrontResponse) || !HIS_SUCCESS.equals(tradeCancelResponseFrontResponse.getCode())) {
                log.error("\u8c03\u7528\u6e90\u542f\u652f\u4ed8-\u4ea4\u6613\u64a4\u9500\u63a5\u53e3\u5931\u8d25{}", (Object)JSON.toJSONString((Object)tradeCancelResponseFrontResponse));
            }
            return;
        }
        log.info("\u4ea4\u8d27\u7533\u8bf7\u6210\u529f\uff0c\u8fd4\u56de\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)deliverApplyResponseFrontResponse));
        if (Objects.equals("\u90ae\u5bc4", medicalAppointmentInfoEntity.getAppointmentMethod())) {
            medicalAppointmentInfoEntity.setOrderStatus(MedicalAppointmentStatusEnum.WAIT_FOR_DELIVERY.getValue().toString());
            medicalAppointmentInfoEntity.setRemarks("\u590d\u5370\u5b8c\u6210\u5373\u5c06\u53d1\u8d27,\u8bf7\u60a8\u6ce8\u610f\u6d88\u606f\u901a\u77e5");
            medicalAppointmentInfoEntity.setOrderRemarks("\u590d\u5370\u5b8c\u6210\u5373\u5c06\u53d1\u8d27,\u8bf7\u60a8\u6ce8\u610f\u6d88\u606f\u901a\u77e5");
        } else {
            medicalAppointmentInfoEntity.setOrderStatus(MedicalAppointmentStatusEnum.WAITING_FOR_PICK_UP.getValue().toString());
            medicalAppointmentInfoEntity.setRemarks("\u8bf7\u60a8\u5c3d\u5feb\u53bb\u533b\u9662\u75c5\u6848\u5ba4\u9886\u53d6\u75c5\u6848");
            medicalAppointmentInfoEntity.setOrderRemarks("\u8bf7\u60a8\u5c3d\u5feb\u53bb\u533b\u9662\u75c5\u6848\u5ba4\u9886\u53d6\u75c5\u6848");
            medicalAppointmentInfoEntity.setReviewRemarks("\u81ea\u63d0\u5730\u70b9:\u88d5\u534e\u897f\u8def530\u53f7,\u897f\u95e8\u75c5\u6848\u5ba4(\u95e8\u536b\u5ba4\u508d\u8fb9)\n\u81ea\u63d0\u65f6\u95f4:\u4e0a\u5348:8:00-12:00 \u4e0b\u534814:00-17:00");
        }
        this.medicalAppointmentInfoMapper.updateById((Object)medicalAppointmentInfoEntity);
        this.deliverNotify("UNHIS", medicalAppointmentInfoEntity.getTransactionId(), medicalAppointmentInfoEntity.getOrderNumber(), medicalAppointmentInfoEntity.getInpatientNo(), "success");
    }

    private FrontRequest<DepositReq> buildDepositReq(InpatientDepositDetailEntity inpatientDepositDetailEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        FrontRequest frontRequest = new FrontRequest();
        DepositReq depositReq = new DepositReq();
        depositReq.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        depositReq.setAmount(responseNotifyRestVo.getTotalAmount().toPlainString());
        depositReq.setFlowNo(inpatientDepositDetailEntity.getTradeNo());
        depositReq.setPayChannel("WECHAT");
        depositReq.setTradeNo(responseNotifyRestVo.getTradeNo());
        frontRequest.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        frontRequest.setBody((Object)depositReq);
        return frontRequest;
    }

    private OpGuideEntity buildOpGuideEntity(OpBusinessOrderEntity opBusinessOrderEntity, GatewayResponse<ComfirmPayNewRes> gatewayResponse) {
        OpGuideEntity opGuideEntity = new OpGuideEntity();
        Date now = new Date();
        opGuideEntity.setGuideInfoId(String.valueOf(this.snowflakeIdWorker.nextId()));
        opGuideEntity.setGuideInfo(((ComfirmPayNewRes)gatewayResponse.getData()).getRemark());
        opGuideEntity.setCreateTime(now);
        opGuideEntity.setUpdateTime(now);
        opGuideEntity.setOutPatientId(opBusinessOrderEntity.getOutPatientId());
        opGuideEntity.setAdmId(opBusinessOrderEntity.getAdmId());
        opGuideEntity.setPatientId(opBusinessOrderEntity.getPatientId());
        opGuideEntity.setPatientOrganId(opBusinessOrderEntity.getPatientOrganId());
        opGuideEntity.setCardNo(opBusinessOrderEntity.getCardNo());
        opGuideEntity.setCardId(opBusinessOrderEntity.getCardId());
        opGuideEntity.setUserId(opBusinessOrderEntity.getUserId());
        opGuideEntity.setOrganCode(opBusinessOrderEntity.getOrganCode());
        opGuideEntity.setOrganName(opBusinessOrderEntity.getOrganName());
        return opGuideEntity;
    }

    private FrontRequest<ComfirmPayNewReq> buildComfirmPayNewReq(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        ComfirmPayNewReq comfirmPayNewReq = new ComfirmPayNewReq();
        comfirmPayNewReq.setCardNo(opBusinessOrderEntity.getCardNo());
        comfirmPayNewReq.setClinicNo(opBusinessOrderEntity.getAdmId());
        comfirmPayNewReq.setPactCode("01");
        comfirmPayNewReq.setFlowNo(opRechargePaymentOrderEntity.getPayBillNo());
        comfirmPayNewReq.setPayMode("QD");
        comfirmPayNewReq.setBankNo(responseNotifyRestVo.getTradeNo());
        comfirmPayNewReq.setBankName("\u5fae\u4fe1");
        comfirmPayNewReq.setMoney(opBusinessOrderEntity.getMoney().toString());
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)comfirmPayNewReq);
        frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return frontRequest;
    }

    private FrontRequest<ComfirmPayNewReq> buildComfirmPayNewReqByYb(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        ComfirmPayNewReq comfirmPayNewReq = new ComfirmPayNewReq();
        comfirmPayNewReq.setCardNo(opBusinessOrderEntity.getCardNo());
        comfirmPayNewReq.setClinicNo(opBusinessOrderEntity.getAdmId());
        comfirmPayNewReq.setPactCode("05Z");
        comfirmPayNewReq.setFlowNo(opRechargePaymentOrderEntity.getPayBillNo());
        comfirmPayNewReq.setPayMode("QD");
        comfirmPayNewReq.setBankNo(responseNotifyRestVo.getTradeNo());
        comfirmPayNewReq.setBankName("\u5fae\u4fe1");
        comfirmPayNewReq.setMoney(opBusinessOrderEntity.getMoney().toString());
        comfirmPayNewReq.setRecipeId(opBusinessOrderEntity.getAdmIds());
        comfirmPayNewReq.setYbInfo(opBusinessOrderEntity.getPayInfo() + "|" + opBusinessOrderEntity.getIdCard() + "|" + opBusinessOrderEntity.getPatientName() + "|01||");
        FrontRequest frontRequest = new FrontRequest();
        frontRequest.setBody((Object)comfirmPayNewReq);
        frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return frontRequest;
    }

    private boolean refundCallBackToHis(ResponseRefundNotifyRestVo responseRefundNotifyRestVo, String orderNo, String trandNo, String refundSerialNo) {
        return false;
    }

    private void outPatientRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, opBusinessOrderEntity.getOutPatientId(), opRechargePaymentOrderEntity.getPayBillNo(), refundSerialNo);
        if (!flag) {
            opBusinessOrderEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        }
    }

    private void inHospRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, InpatientDepositDetailEntity inpatientDepositDetailEntity, String trandNo, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, inpatientDepositDetailEntity.getOrderSeq(), trandNo, refundSerialNo);
        if (!flag) {
            inpatientDepositDetailEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
        }
    }

    private void appointRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, appointmentRecordEntity.getSysAppointmentId(), appointmentRecordEntity.getPayTransationId(), refundSerialNo);
        if (!flag) {
            appointmentRecordEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        }
    }

    private void deliverNotify(String areaCode, String tradeNo, String receiptId, String rcpNo, String flag) {
        FrontRequest deliverNoticeRequestFrontRequest = new FrontRequest();
        deliverNoticeRequestFrontRequest.setOrganCode(areaCode);
        deliverNoticeRequestFrontRequest.setBody((Object)DeliverNotifyRequest.builder().tradeNo(tradeNo).receiptStatus(flag).receiptId(receiptId).rcptNo(rcpNo).receiptTime(DateUtil.now()).build());
        this.paymentClient.deliverNotify(deliverNoticeRequestFrontRequest);
    }
}

