/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.http.HttpUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.UUIDUtils;
import com.ebaiyihui.wisdommedical.common.enums.ServiceBillTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServicePayBillStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.PaymentHistoryMapper;
import com.ebaiyihui.wisdommedical.mapper.ServicePayBillMapper;
import com.ebaiyihui.wisdommedical.model.AliPaymedicareRefundRequest;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.PaymentHistory;
import com.ebaiyihui.wisdommedical.model.ServicePayBillEntity;
import com.ebaiyihui.wisdommedical.pojo.YB.BaseMoveResponse;
import com.ebaiyihui.wisdommedical.pojo.YB.RefundOrderRequest;
import com.ebaiyihui.wisdommedical.pojo.YB.RefundOrderResponse;
import com.ebaiyihui.wisdommedical.pojo.YB.ResultResponse;
import com.ebaiyihui.wisdommedical.pojo.vo.PayRefunVo;
import com.ebaiyihui.wisdommedical.service.AlipayService;
import com.ebaiyihui.wisdommedical.service.PaymentBusinessService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class PaymentBusinessServiceImpl
implements PaymentBusinessService {
    private static final Logger log = LoggerFactory.getLogger(PaymentBusinessServiceImpl.class);
    private String medicareServiceUrl = "";
    @Autowired
    private AlipayService alipayService;
    @Autowired
    private PaymentHistoryMapper paymentHistoryMapper;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;

    public BaseResponse orderRefunds(PayRefunVo payRefunVo) {
        log.info("---->>\u8ba2\u5355\u9000\u6b3e\u5165\u53c2{}", (Object)JSON.toJSONString((Object)payRefunVo));
        log.info("---->>\u8ba2\u5355\u9000\u6b3e\u8ba2\u5355\u53f7:{}", (Object)payRefunVo.getOuttradeno());
        PaymentHistory paymentHistory = this.paymentHistoryMapper.selectByOuttradeno(payRefunVo.getOuttradeno());
        log.info("---->>\u67e5\u8be2\u7684\u8ba2\u5355\u652f\u4ed8\u4fe1\u606f{}", (Object)JSON.toJSONString((Object)paymentHistory));
        if (paymentHistory == null) {
            return BaseResponse.error((String)"---->>\u8ba2\u5355\u4e0d\u5b58\u5728");
        }
        if (paymentHistory.getStatus() != 3) {
            return BaseResponse.error((String)"---->>\u8ba2\u5355\u4e0d\u53ef\u9000\u6b3e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u4eba\u5458");
        }
        if (paymentHistory.getPaystatus() != 1) {
            return BaseResponse.error((String)"---->>\u8ba2\u5355\u5df2\u9000\u6b3e\uff0c\u4e0d\u53ef\u518d\u6b21\u64cd\u4f5c");
        }
        if (paymentHistory.getType() == 2) {
            if (org.apache.commons.lang.StringUtils.isEmpty((String)payRefunVo.getPayAuthNo())) {
                return BaseResponse.error((String)"---->>\u533b\u4fdd\u9000\u8d39\u9700\u4f20\u5165PayAuthNo");
            }
            log.info("---->>\u5f00\u59cb\u533b\u4fdd\u9000\u6b3e");
            RefundOrderRequest refundOrderRequest = new RefundOrderRequest();
            refundOrderRequest.setPayOrdId(paymentHistory.getPayordid());
            refundOrderRequest.setAppRefdSn(UUIDUtils.getUUID());
            refundOrderRequest.setAppRefdTime(DateUtils.getCurrentDateTimeString());
            refundOrderRequest.setTotlRefdAmt(paymentHistory.getTotlrefdamt());
            refundOrderRequest.setPsnAcctRefdAmt(paymentHistory.getPsnacctrefdamt());
            refundOrderRequest.setFundRefdAmt(paymentHistory.getFundrefdamt());
            refundOrderRequest.setCashRefdAmt(paymentHistory.getCashrefdamt());
            refundOrderRequest.setEcToken("");
            refundOrderRequest.setRefdType("ALL");
            refundOrderRequest.setExpContent("");
            refundOrderRequest.setPayAuthNo(payRefunVo.getPayAuthNo());
            refundOrderRequest.setUserName(paymentHistory.getUsername());
            refundOrderRequest.setIdNo(paymentHistory.getIdno());
            refundOrderRequest.setTencentRefundRequest(null);
            refundOrderRequest.setInsuplc_admdvs("");
            refundOrderRequest.setMdtrtarea_admvs("");
            refundOrderRequest.setOrganCode(paymentHistory.getOrgancode());
            ResultResponse resultResponse = this.medicalInsuranceRefund(refundOrderRequest);
            log.info("---->>\u533b\u4fdd\u9000\u6b3e\u7ed3\u675f\uff0c\u8fd4\u56de{}", (Object)JSON.toJSONString((Object)resultResponse));
            if (!"1".equals(resultResponse.getCode())) {
                return BaseResponse.error((String)"---->>\u9000\u6b3e\u5931\u8d25");
            }
            paymentHistory.setPayauthno(refundOrderRequest.getPayAuthNo());
            paymentHistory.setApprefdtime(refundOrderRequest.getAppRefdTime());
            paymentHistory.setApprefdsn(refundOrderRequest.getAppRefdSn());
            paymentHistory.setRefdtype(refundOrderRequest.getRefdType());
            log.info("---->>\u751f\u6210\u8d26\u5355\u4fe1\u606f================>BEGIN-^.^");
            ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
            servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
            servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
            servicePayBillEntity.setAppCode(paymentHistory.getAppcode());
            servicePayBillEntity.setOrganId(paymentHistory.getOrgancode());
            servicePayBillEntity.setWorkServiceCode("ZHJYTK");
            servicePayBillEntity.setApplyCode("");
            servicePayBillEntity.setPayChannel(String.valueOf(paymentHistory.getType()));
            servicePayBillEntity.setTradeTime(new Date());
            servicePayBillEntity.setTradeNo("");
            servicePayBillEntity.setOutTradeNo(payRefunVo.getOuttradeno());
            servicePayBillEntity.setTradeStatus("SUCCESS");
            servicePayBillEntity.setOrderAmount(Double.valueOf(paymentHistory.getTotlrefdamt()));
            servicePayBillEntity.setDealAmount(Double.valueOf(paymentHistory.getTotlrefdamt()));
            servicePayBillEntity.setServiceCode("");
            servicePayBillEntity.setDealTradeNo(String.valueOf(paymentHistory.getId()));
            servicePayBillEntity.setRemark("\u533b\u4fdd\u9000\u6b3e\u5168\u90e8");
            this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        }
        if (paymentHistory.getType() == 1 || paymentHistory.getType() == 2) {
            log.info("---->>\u5f00\u59cb\u652f\u4ed8\u5b9d\u9000\u6b3e");
            AliPaymedicareRefundRequest aliPaymedicareRefundRequest = new AliPaymedicareRefundRequest();
            aliPaymedicareRefundRequest.setOutTradeNo(paymentHistory.getOuttradeno());
            aliPaymedicareRefundRequest.setRefundAmount(paymentHistory.getTotlrefdamt());
            aliPaymedicareRefundRequest.setTradeNo(paymentHistory.getTradeno());
            aliPaymedicareRefundRequest.setRefundReason(payRefunVo.getRefundReason());
            String refund = this.alipayService.medicareRefund(aliPaymedicareRefundRequest);
            ResultResponse aliPayRefuntResponse = (ResultResponse)JSON.parseObject((String)refund, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            log.info("---->>\u652f\u4ed8\u5b9d\u9000\u6b3e\u7ed3\u675f\uff0c\u8fd4\u56de{}", (Object)JSON.toJSONString((Object)aliPayRefuntResponse));
            if (!"1".equals(aliPayRefuntResponse.getCode())) {
                return BaseResponse.error((String)"---->>\u9000\u6b3e\u5931\u8d25");
            }
            paymentHistory.setRefundreason(aliPaymedicareRefundRequest.getRefundReason());
        }
        String exponent = StringUtils.isEmpty((Object)paymentHistory.getExpcontent()) ? "" : paymentHistory.getExpcontent();
        paymentHistory.setExpcontent(exponent + DateUtil.date() + "\u624b\u52a8\u9000\u6b3e:" + paymentHistory.getTotlrefdamt() + ";|");
        log.info("---->>\u5168\u90e8\u9000\u6b3e\u6210\u529f\uff0c\u53d8\u66f4\u8ba2\u5355\u72b6\u6001");
        paymentHistory.setUpdateTime((Date)DateUtil.date());
        paymentHistory.setPaystatus(Byte.valueOf((byte)2));
        this.paymentHistoryMapper.updateByPrimaryKey(paymentHistory);
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(payRefunVo.getOuttradeno());
        opBusinessOrderEntity.setPayTime((Date)DateUtil.date());
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.REFUND.getValue());
        opBusinessOrderEntity.setPayTime(opBusinessOrderEntity.getPayTime());
        opBusinessOrderEntity.setRemark("\u5df2\u9000\u6b3e");
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        log.info("---->>\u9000\u6b3e\u5b8c\u6210\u3002\u8ba2\u5355\u72b6\u6001\u53d8\u66f4\u6210\u529f");
        return BaseResponse.success((Object)"\u5904\u7406\u5b8c\u6210");
    }

    public BaseResponse getStatus(PayRefunVo payRefunVo) {
        if (payRefunVo == null || org.apache.commons.lang.StringUtils.isEmpty((String)payRefunVo.getIdNo())) {
            return BaseResponse.error((String)"---->>\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List paymentHistories = this.paymentHistoryMapper.selectListByidNo(payRefunVo.getIdNo(), "3");
        if (CollectionUtils.isEmpty((Collection)paymentHistories)) {
            return BaseResponse.success((Object)"");
        }
        return BaseResponse.success((Object)((PaymentHistory)paymentHistories.get(0)).getOuttradeno());
    }

    private ResultResponse<BaseMoveResponse<RefundOrderResponse>> medicalInsuranceRefund(RefundOrderRequest refundOrderRequest) {
        log.info("---->>\u8bf7\u6c42\u533b\u4fdd\u4e2d\u53f0\u3010\u56fd\u6807\u533b\u4fdd\u9000\u8d39\u3011\u63a5\u53e3/cz/medicalBusiness/refundOrder\u5165\u53c2 = {}", (Object)JSON.toJSONString((Object)refundOrderRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        String post = HttpUtil.post((String)(this.medicareServiceUrl + "/cz/medicalBusiness/refundOrder"), (String)JSON.toJSONString((Object)refundOrderRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        log.info("---->>\u8bf7\u6c42\u533b\u4fdd\u4e2d\u53f0\u3010\u56fd\u6807\u533b\u4fdd\u9000\u8d39\u3011\u63a5\u53e3/cz/medicalBusiness/refundOrder\u51fa\u53c2 = {}", (Object)post);
        return (ResultResponse)JSON.parseObject((String)post, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
    }
}

