/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import cn.hutool.core.convert.Convert;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.doctoruser.api.pojo.base.dto.DoctorBaseInfoDTO;
import com.ebaiyihui.api.AppointmentClient;
import com.ebaiyihui.api.ScheduleClient;
import com.ebaiyihui.hkdhisfront.appoint.GetScheduleResVO;
import com.ebaiyihui.hkdhisfront.appoint.RegLv;
import com.ebaiyihui.hkdhisfront.appoint.RequestRegDoctVo;
import com.ebaiyihui.hkdhisfront.base.FrontRequest;
import com.ebaiyihui.hkdhisfront.base.FrontResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.exception.ScheduleException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DeptCategoryRelationMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleDetailRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.GetScheduleDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetNewDoctorScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetNewDoctorScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleBaseInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.ScheduleStatusResVO;
import com.ebaiyihui.wisdommedical.service.DoctorService;
import com.ebaiyihui.wisdommedical.service.ScheduleService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetDoctorInfoUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private DoctorService doctorService;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private GetDoctorInfoUtil getDoctorInfoUtil;
    @Autowired
    private ScheduleClient scheduleClient;
    @Autowired
    private StringRedisTemplate redisTemplate;
    @Resource
    private AppointmentClient appointmentClient;
    @Resource
    private DeptCategoryRelationMapper deptCategoryRelationMapper;
    private static final String HIS_ERROR = "\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94";
    private static final String HIS_QUERY_ERROR = "\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}";
    private static final String HIS_SCHEDULE_QUERY_ERROR = "\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38";
    private static final String HIS_SCHEDULE_ERROR = "\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f";
    private static final String NOT_SCHEDULE = "\u6682\u65e0\u6392\u73ed\u4fe1\u606f";
    private static final String GET_SCHEDULE = "getSchedule";

    public List<GetScheduleVoRes> getSchedule(GetScheduleVoReq getScheduleVoReq) throws ScheduleException {
        FrontRequest gatewayRequest = this.buildGetScheduleReq(getScheduleVoReq);
        FrontResponse frontResponse = this.scheduleClient.getDoctorSchedule(gatewayRequest);
        log.info("\u3010\u83b7\u53d6\u79d1\u5ba4\u6392\u73ed\u3011his\u63a5\u53e3\u8fd4\u56de frontResponse:{}", (Object)JSON.toJSONString((Object)frontResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (Objects.isNull(frontResponse) || !"1".equals(frontResponse.getCode())) {
            log.error("\u3010\u83b7\u53d6\u79d1\u5ba4\u6392\u73ed\u3011his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return null;
        }
        if (Objects.isNull(frontResponse.getBody()) || CollectionUtils.isEmpty((Collection)((GetScheduleResVO)frontResponse.getBody()).getItems())) {
            log.error("\u3010\u83b7\u53d6\u79d1\u5ba4\u6392\u73ed\u3011his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
            return null;
        }
        List items = ((GetScheduleResVO)frontResponse.getBody()).getItems();
        Map listMap = items.stream().collect(Collectors.groupingBy(GetScheduleResVO.GetScheduleResItems::getDocCode, LinkedHashMap::new, Collectors.toList()));
        ArrayList<GetScheduleVoRes> scheduleVoResList = new ArrayList<GetScheduleVoRes>();
        for (Map.Entry entry : listMap.entrySet()) {
            String docCode = (String)entry.getKey();
            List valueList = (List)entry.getValue();
            Integer appointmentCount = this.appointmentRecordMapper.selectDoctorAppointmentCount(docCode, this.propertiesConstant.getOrganCode());
            GetScheduleVoRes scheduleVoRes = GetScheduleVoRes.builder().docName(((GetScheduleResVO.GetScheduleResItems)valueList.get(0)).getDocName()).docCode(docCode).appointmentCount(appointmentCount).doctorScore(Double.valueOf(5.0)).hospitalArea(((GetScheduleResVO.GetScheduleResItems)valueList.get(0)).getHospitalArea()).hospitalAreaCode(((GetScheduleResVO.GetScheduleResItems)valueList.get(0)).getHospitalAreaCode()).locCode(((GetScheduleResVO.GetScheduleResItems)valueList.get(0)).getLocCode()).locName(((GetScheduleResVO.GetScheduleResItems)valueList.get(0)).getLocName()).regTitleCode(((GetScheduleResVO.GetScheduleResItems)valueList.get(0)).getRegTitleCode()).regTitleName(((GetScheduleResVO.GetScheduleResItems)valueList.get(0)).getRegTitleName()).admLocation(((GetScheduleResVO.GetScheduleResItems)valueList.get(0)).getAdmLocation()).build();
            DoctorRecordEntity doctorRecordEntity = this.doctorService.getDoctorRecordByDoctorCodeAndHosCode(docCode, this.propertiesConstant.getOrganCode());
            if (Objects.nonNull(doctorRecordEntity)) {
                scheduleVoRes.setDoctorHeadPortrait(doctorRecordEntity.getDocAvatar());
                scheduleVoRes.setDoctorSpeciality(doctorRecordEntity.getDocGoodAt());
            }
            ArrayList<ScheduleBaseInfoVo> scheduleBaseInfoVoList = new ArrayList<ScheduleBaseInfoVo>();
            for (GetScheduleResVO.GetScheduleResItems value : valueList) {
                BigDecimal totalFee = new BigDecimal(value.getDiagFee()).add(new BigDecimal(value.getRegFee()));
                ScheduleBaseInfoVo scheduleBaseInfoVo = ScheduleBaseInfoVo.builder().admDate(value.getAdmDate()).admTimeRange(value.getAdmTimeRange()).isAppend(value.getIsAppend()).isTimeArrange(value.getIsTimeArrange()).locTypeCode(value.getLocTypeCode()).locTypeName(value.getLocTypeName()).regAvailable(value.getRegAvailable()).regFee(value.getRegFee()).diagFee(value.getDiagFee()).totalFee(totalFee.toPlainString()).regTotal(value.getRegTotal()).replaceScheduleId(value.getReplaceScheduleId()).scheduleId(value.getScheduleId()).scheduleLevelCode(value.getScheduleLevelCode()).scheduleLevelName(value.getScheduleLevelName()).scheduleStatus(value.getScheduleStatus()).scheduleType(value.getScheduleType()).timeArrangeItems(value.getTimeArrangeItems()).validFlag(value.getValidFlag()).reged(value.getReged()).build();
                scheduleBaseInfoVoList.add(scheduleBaseInfoVo);
            }
            scheduleVoRes.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
            scheduleVoResList.add(scheduleVoRes);
        }
        return scheduleVoResList;
    }

    private FrontRequest<RequestRegDoctVo> buildGetScheduleReq(GetScheduleVoReq getScheduleVoReq) {
        String regLevelKey = this.propertiesConstant.getOrganCode() + "_reg_level";
        String regLevelIds = (String)this.redisTemplate.opsForValue().get((Object)regLevelKey);
        if (StringUtils.isBlank((CharSequence)regLevelIds)) {
            FrontResponse frontResponse = this.appointmentClient.registerLevel();
            if (Objects.isNull(frontResponse) || !"1".equals(frontResponse.getCode())) {
                log.error("\u3010\u83b7\u53d6\u6302\u53f7\u7ea7\u522b\u3011his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
                return null;
            }
            List regLvList = (List)frontResponse.getBody();
            if (CollectionUtils.isEmpty((Collection)regLvList)) {
                log.error("\u3010\u83b7\u53d6\u6302\u53f7\u7ea7\u522b\u3011his\u63a5\u53e3\u8fd4\u56de\u4e3a\u7a7a");
                return null;
            }
            regLevelIds = regLvList.stream().map(RegLv::getId).collect(Collectors.joining(","));
            this.redisTemplate.opsForValue().set((Object)regLevelKey, (Object)regLevelIds, 7L, TimeUnit.DAYS);
        }
        FrontRequest request = new FrontRequest();
        request.setTransactionId(Convert.toStr((Object)this.snowflakeIdWorker.nextId()));
        RequestRegDoctVo requestRegDoctVo = RequestRegDoctVo.builder().typeCodeList(regLevelIds).date(getScheduleVoReq.getStartDate()).deptCode(getScheduleVoReq.getDeptCode()).docCode("").pactCode("01").build();
        request.setBody((Object)requestRegDoctVo);
        request.setOrganCode(this.propertiesConstant.getOrganCode());
        return request;
    }

    public static void main(String[] args) {
        boolean b = ScheduleServiceImpl.compTime((String)"15:44:00", (String)DateUtil.format((Date)DateUtil.date(), (String)"HH:mm:ss"));
        System.out.println(b);
    }

    public static boolean compTime(String s1, String s2) {
        try {
            if (s1.indexOf(":") >= 0 && s1.indexOf(":") >= 0) {
                String[] array2;
                int total2;
                String[] array1 = s1.split(":");
                int total1 = Integer.valueOf(array1[0]) * 3600 + Integer.valueOf(array1[1]) * 60 + Integer.valueOf(array1[2]);
                return total1 - (total2 = Integer.valueOf((array2 = s2.split(":"))[0]) * 3600 + Integer.valueOf(array2[1]) * 60 + Integer.valueOf(array2[2])) > 0;
            }
            System.out.println("\u683c\u5f0f\u4e0d\u6b63\u786e");
        }
        catch (NumberFormatException e) {
            return true;
        }
        return false;
    }

    public GetDoctorScheduleVoRes getDoctorSchedule(GetDoctorScheduleVoReq getDoctorScheduleVoReq) throws ScheduleException {
        return null;
    }

    public List<ScheduleStatusResVO> getScheduleStatus(GetScheduleVoReq getScheduleVoReq) throws ScheduleException {
        return null;
    }

    public List<ScheduleStatusResVO> getAcidScheduleStatus(GetScheduleVoReq getScheduleVoReq) throws ScheduleException {
        return null;
    }

    public List<ScheduleStatusResVO> schduleIsnull() {
        ArrayList<ScheduleStatusResVO> list = new ArrayList<ScheduleStatusResVO>();
        String admDate = DateUtils.getCurrentDateSimpleToString();
        for (int i = 0; i < 7; ++i) {
            ScheduleStatusResVO scheduleStatusResVO = new ScheduleStatusResVO();
            scheduleStatusResVO.setStatus("-1");
            scheduleStatusResVO.setAdmDate(admDate);
            if (admDate.equals(DateUtils.getCurrentDateSimpleToString())) {
                scheduleStatusResVO.setWeek("\u4eca\u5929");
            } else {
                scheduleStatusResVO.setWeek(DateUtils.getWeekSimpleChinese((String)admDate));
            }
            scheduleStatusResVO.setViewDate(admDate.replace("-", ".").substring(5));
            list.add(scheduleStatusResVO);
            admDate = DateUtils.getNextDayToString((String)admDate);
        }
        return list;
    }

    private List<DoctorBaseInfoDTO> getDoctorInfoList(String organId, List<Long> doctorIdList) throws ScheduleException {
        if (CollectionUtils.isEmpty(doctorIdList)) {
            return new ArrayList<DoctorBaseInfoDTO>();
        }
        log.info("\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570\uff1a" + doctorIdList);
        List doctorBaseInfoDTOList = this.getDoctorInfoUtil.getDoctorInfoList(doctorIdList, organId);
        if (doctorBaseInfoDTOList == null) {
            return new ArrayList<DoctorBaseInfoDTO>();
        }
        return doctorBaseInfoDTOList;
    }

    private List<ScheduleRecordEntity> getScheduleByScheduleDTO(GetScheduleDTO getScheduleDTO) {
        return this.scheduleRecordMapper.selectByGetScheduleDTO(getScheduleDTO);
    }

    private List<ScheduleDetailRecordEntity> getScheduleDetailRecord(String hisScheduleId, String organCode) {
        return this.scheduleDetailRecordMapper.selectByHisScheduleId(hisScheduleId, organCode);
    }

    public List<GetNewDoctorScheduleVoRes> getNewDoctorSchedule(GetNewDoctorScheduleVoReq getScheduleVoReq) throws ScheduleException, ParseException {
        return null;
    }
}

