/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.MediaType;
import org.springframework.http.MediaTypeFactory;
import org.springframework.mock.web.MockMultipartFile;
import org.springframework.util.ObjectUtils;
import org.springframework.web.multipart.MultipartFile;

/*
 * Exception performing whole class analysis ignored.
 */
public class UnZipUtils {
    private static Logger log = LoggerFactory.getLogger(UnZipUtils.class);

    public static List<MultipartFile> unZip(MultipartFile File2) {
        File srcFile = UnZipUtils.multipartFileToFile((MultipartFile)File2);
        ArrayList<MultipartFile> multipartList = new ArrayList<MultipartFile>();
        if (!srcFile.exists()) {
            log.error("\u6b64\u6587\u4ef6\u4e0d\u5b58\u5728\uff1a{}", (Object)srcFile.getPath());
        }
        try (ZipFile zipFile = new ZipFile(srcFile, Charset.forName("GBK"));){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                if (entry.isDirectory()) continue;
                String fileName = entry.getName();
                InputStream is = zipFile.getInputStream(entry);
                String contentType = MediaTypeFactory.getMediaType((String)entry.getName()).orElse(MediaType.APPLICATION_OCTET_STREAM).toString();
                MockMultipartFile file = new MockMultipartFile(fileName, entry.getName(), contentType, is);
                String s = UUID.randomUUID().toString().replaceAll("-", "");
                if (ObjectUtils.isEmpty((Object)file)) continue;
                multipartList.add((MultipartFile)file);
            }
        }
        catch (Exception e) {
            log.error("\u89e3\u538b\u5931\u8d25", (Throwable)e);
        }
        return multipartList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File multipartFileToFile(MultipartFile multipartFile) {
        File file = null;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            inputStream = multipartFile.getInputStream();
            file = new File(multipartFile.getOriginalFilename());
            outputStream = new FileOutputStream(file);
            UnZipUtils.write((InputStream)inputStream, (OutputStream)outputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return file;
    }

    public static void write(InputStream inputStream, OutputStream outputStream) {
        byte[] buffer = new byte[4096];
        try {
            int count = inputStream.read(buffer, 0, buffer.length);
            while (count != -1) {
                outputStream.write(buffer, 0, count);
                count = inputStream.read(buffer, 0, buffer.length);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }
}

