/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.appointment;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.ScheduleException;
import com.ebaiyihui.wisdommedical.pojo.dto.RegisterationQueryParamsDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordDetailVo;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ConfirmAppointmentVo;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentPayVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.FlowModulationCreateVo;
import com.ebaiyihui.wisdommedical.pojo.vo.GetConfirmPayInfoVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.WithdrawNumberVoReq;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.ExamineService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u6302\u53f7api"})
@RequestMapping(value={"/api/v1/appoint"})
public class AppointmentController {
    private static final Logger log = LoggerFactory.getLogger(AppointmentController.class);
    @Autowired
    private AppointmentService appointmentService;
    @Autowired
    private ExamineService examineService;

    @DisableAuthConfig
    @ApiOperation(value="\u9884\u7ea6\u6302\u53f7\u786e\u8ba4", notes="\u9884\u7ea6\u6302\u53f7\u53ef\u7528")
    @PostMapping(value={"confirmAppointment"})
    public BaseResponse<String> confirmAppointment(@RequestBody ConfirmAppointmentVo confirmAppointmentVo) {
        String confirmAppointmentId = null;
        try {
            confirmAppointmentId = this.appointmentService.confirmAppointment(confirmAppointmentVo);
        }
        catch (ScheduleException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)confirmAppointmentId);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u83b7\u53d6\u9884\u7ea6\u6302\u53f7\u786e\u8ba4\u4fe1\u606f", notes="\u9884\u7ea6\u6302\u53f7\u53ef\u7528")
    @GetMapping(value={"getConfirmAppointment"})
    public BaseResponse<ConfirmAppointmentVo> getConfirmAppointment(String confirmAppointmentId) {
        ConfirmAppointmentVo confirmAppointmentVo = this.appointmentService.getConfirmAppointment(confirmAppointmentId);
        return BaseResponse.success((Object)confirmAppointmentVo);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u6302\u53f7\u6302\u53f7\u786e\u8ba4", notes="\u6302\u53f7\u53ef\u7528")
    @PostMapping(value={"dayAppointmentCreateOrder"})
    public BaseResponse<String> dayAppointmentCreateOrder(@Valid @RequestBody AppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq) {
        String sysAppointmentId = null;
        try {
            sysAppointmentId = this.appointmentService.appointmentCreateOrder(dayAppointmentCreateOrderVoReq);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)sysAppointmentId);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u67e5\u8be2\u786e\u8ba4\u652f\u4ed8\u7684\u4fe1\u606f", notes="\u67e5\u8be2\u786e\u8ba4\u652f\u4ed8\u7684\u4fe1\u606f")
    @GetMapping(value={"getConfirmPayInfo"})
    public BaseResponse<GetConfirmPayInfoVoRes> getConfirmPayInfo(@RequestParam(value="sysAppointmentId") String sysAppointmentId) {
        GetConfirmPayInfoVoRes getConfirmPayInfoVoRes = this.appointmentService.getConfirmPayInfo(sysAppointmentId);
        return BaseResponse.success((Object)getConfirmPayInfoVoRes);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u6302\u53f7\u652f\u4ed8", notes="\u6302\u53f7\u652f\u4ed8")
    @PostMapping(value={"dayAppointmentPay"})
    public BaseResponse<String> dayAppointmentPay(@Valid @RequestBody DayAppointmentPayVoReq dayAppointmentPayVoReq) {
        BaseResponse baseResponse = this.appointmentService.appointmentPay(dayAppointmentPayVoReq);
        return baseResponse;
    }

    @DisableAuthConfig
    @ApiOperation(value="\u6211\u7684\u6302\u53f7\u5217\u8868", notes="\u6302\u53f7")
    @GetMapping(value={"getMyRegistrationList"})
    public BaseResponse<List<AppointmentRecordVo>> getMyRegistrationList(String userId, String hospitalCode, String cardId, String deptCode) {
        RegisterationQueryParamsDTO registerationQueryParamsDTO = new RegisterationQueryParamsDTO();
        registerationQueryParamsDTO.setUserId(userId);
        registerationQueryParamsDTO.setHospitalCode(hospitalCode);
        registerationQueryParamsDTO.setCardId(cardId);
        registerationQueryParamsDTO.setDeptCode(deptCode);
        List appointmentRecordVoList = null;
        try {
            appointmentRecordVoList = this.appointmentService.getMyRegistrationList(registerationQueryParamsDTO);
        }
        catch (Exception e) {
            return BaseResponse.error((String)"\u83b7\u53d6\u6211\u7684\u6302\u53f7\u8bb0\u5f55\u6570\u636e\u5f02\u5e38");
        }
        return BaseResponse.success((Object)appointmentRecordVoList);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u6211\u7684\u6302\u53f7\u8be6\u60c5", notes="\u6302\u53f7")
    @GetMapping(value={"getMyRegistrationDetail"})
    public BaseResponse<AppointmentRecordDetailVo> getMyRegistrationDetail(String sysAppointmentId) {
        if (StringUtils.isBlank((String)sysAppointmentId)) {
            BaseResponse.error((String)"sysAppointmentId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        AppointmentRecordDetailVo appointmentRecordDetailVo = null;
        try {
            appointmentRecordDetailVo = this.appointmentService.getMyRegistrationDetail(sysAppointmentId);
        }
        catch (AppointmentException e) {
            BaseResponse.error((String)"\u67e5\u8be2\u6211\u7684\u6302\u53f7\u8be6\u60c5\u5931\u8d25");
        }
        return BaseResponse.success((Object)appointmentRecordDetailVo);
    }

    @DisableAuthConfig
    @ApiOperation(value="\u53d6\u6d88\u9884\u7ea6 \u672a\u652f\u4ed8\u53ea\u9000\u53f7", notes="\u53d6\u6d88\u9884\u7ea6 \u672a\u652f\u4ed8\u53ea\u9000\u53f7")
    @GetMapping(value={"withdrawNumber/callbackNumber"})
    public BaseResponse<String> withdrawNumber(String sysAppointmentId) {
        BaseResponse baseResponse = null;
        try {
            baseResponse = this.appointmentService.callBackNumber(sysAppointmentId);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return baseResponse;
    }

    @DisableAuthConfig
    @ApiOperation(value="\u53d6\u6d88\u9884\u7ea6 \u9000\u53f7\u9000\u6b3e", notes="\u53d6\u6d88\u9884\u7ea6 \u9000\u53f7\u9000\u6b3e")
    @PostMapping(value={"withdrawNumber"})
    public BaseResponse<String> withdrawNumber(@Valid @RequestBody WithdrawNumberVoReq withdrawNumberVoReq, BindingResult bindingResult) {
        if (bindingResult.hasErrors()) {
            return BaseResponse.error((String)bindingResult.getFieldError().getDefaultMessage());
        }
        BaseResponse baseResponse = null;
        try {
            baseResponse = this.appointmentService.withdrawNumber(withdrawNumberVoReq);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return baseResponse;
    }

    @DisableAuthConfig
    @ApiOperation(value="\u7ba1\u7406\u5458\u7aef\u9000\u6b3e,\u5305\u62ec\u5f53\u65e5\u6302\u53f7\u548c\u9884\u7ea6\u6302\u53f7", notes="\u7ba1\u7406\u5458\u7aef\u9000\u6b3e")
    @GetMapping(value={"appointmentRefund"})
    public BaseResponse<String> appointmentRefund(String sysAppointmentId) {
        if (StringUtils.isBlank((String)sysAppointmentId)) {
            BaseResponse.error((String)"sysAppointmentId\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BaseResponse baseResponse = this.appointmentService.appointmentRefund(sysAppointmentId);
        return baseResponse;
    }

    @DisableAuthConfig
    @ApiOperation(value="\u6838\u9178\u6d41\u8c03\u4fe1\u606f", notes="\u6838\u9178\u6d41\u8c03\u4fe1\u606f")
    @PostMapping(value={"examine"})
    public BaseResponse<String> examine(@RequestBody FlowModulationCreateVo flowModulationCreateVo) {
        Map map = this.examineService.careteExamine(flowModulationCreateVo);
        if (map.get("code").equals(0)) {
            return BaseResponse.error((String)map.get("msg").toString());
        }
        return BaseResponse.success((Object)map.get("msg").toString());
    }

    @DisableAuthConfig
    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u65f6\u95f4", notes="\u67e5\u8be2\u5f53\u524d\u65f6\u95f4")
    @GetMapping(value={"/getCurrentDate"})
    public BaseResponse<Date> getCurrentDate() {
        return BaseResponse.success((Object)new Date());
    }
}

