/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.appointment;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.mapper.DeptRecordMapper;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDeptListVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.ReponseRegLvVo;
import com.ebaiyihui.wisdommedical.service.DepartmentService;
import com.ebaiyihui.wisdommedical.util.GetDoctorInfoUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u79d1\u5ba4api"})
@RequestMapping(value={"api/v1/dept"})
public class DepartmentController {
    private static final Logger log = LoggerFactory.getLogger(DepartmentController.class);
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private DeptRecordMapper deptRecordMapper;
    @Autowired
    private ProPropertiesConstant proPropertiesConstant;
    @Autowired
    private GetDoctorInfoUtil getDoctorInfoUtil;

    @DisableAuthConfig
    @GetMapping(value={"/register/level"})
    @ApiOperation(value="\u83b7\u53d6\u6302\u53f7\u7ea7\u522b")
    public ReponseRegLvVo registerLevel() {
        return this.departmentService.registerLevel();
    }

    @DisableAuthConfig
    @ApiOperation(value="\u83b7\u53d6\u6392\u73ed\u79d1\u5ba4", notes="\u83b7\u53d6\u6392\u73ed\u79d1\u5ba4")
    @GetMapping(value={"/getDeptList"})
    public BaseResponse<List<GetDeptListVoRes>> getDeptList(@RequestParam(value="organCode") String organCode, @RequestParam(value="userId") String userId) {
        List getDeptListVoResList = null;
        try {
            getDeptListVoResList = this.departmentService.getDeptList(organCode, userId);
        }
        catch (AppointmentException e) {
            return BaseResponse.error((String)e.getMessage());
        }
        return BaseResponse.success((Object)getDeptListVoResList);
    }
}

