/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.controller.appointment;

import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.config.DisableAuthConfig;
import com.ebaiyihui.wisdommedical.pojo.dto.RequestRegDoctDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoRes;
import com.ebaiyihui.wisdommedical.service.DepartmentService;
import com.ebaiyihui.wisdommedical.service.DoctorService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u533b\u751fapi"})
@RequestMapping(value={"/api/v1/doctor"})
public class DoctorController {
    private static final Logger log = LoggerFactory.getLogger(DoctorController.class);
    @Autowired
    private DoctorService doctorService;
    @Autowired
    private DepartmentService departmentService;

    @DisableAuthConfig
    @PostMapping(value={"/getDeptDoctor"})
    @ApiOperation(value="\u67e5\u8be2\u533b\u751f\u6392\u73ed")
    public BaseResponse<List<GetScheduleVoRes>> getDeptDoctor(@RequestBody RequestRegDoctDTO requestRegDoctDTO) {
        long startTime = System.currentTimeMillis();
        if (requestRegDoctDTO.getDeptCode() == null || StringUtils.isEmpty((CharSequence)requestRegDoctDTO.getDeptCode())) {
            requestRegDoctDTO.setDeptCode("0034");
        }
        List list = this.departmentService.getDeptDoctor(requestRegDoctDTO);
        long endTime = System.currentTimeMillis();
        log.info("\u67e5\u8be2\u533b\u751f\u6392\u73ed ==>\u7a0b\u5e8f\u8fd0\u884c\u65f6\u95f4\uff1a" + (endTime - startTime) + "ms");
        return BaseResponse.success((Object)list);
    }
}

