/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.rabbitmq;

import com.alibaba.fastjson.JSON;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.CancelAppointmentVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.RabbitMqDelayedOrderVo;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.annotation.RabbitHandler;
import org.springframework.amqp.rabbit.annotation.RabbitListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DelayedAppointmentRecordReceiver {
    private static final Logger log = LoggerFactory.getLogger(DelayedAppointmentRecordReceiver.class);
    public static final int NO_PAY_AUTO_CANCEL_APPOINTMENT = 2;
    @Autowired
    private AppointmentService appointmentService;

    @RabbitListener(queues={"wisdommedical.appointment.delayed.order.jlrmyy"})
    @RabbitHandler
    public void process(String rabbitMqDelayedOrderVoStr) throws AppointmentException {
        log.info("Fetch appointment info from rabbit mq\uff1a " + rabbitMqDelayedOrderVoStr);
        RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = (RabbitMqDelayedOrderVo)JSON.parseObject((String)rabbitMqDelayedOrderVoStr, RabbitMqDelayedOrderVo.class);
        String orderId = rabbitMqDelayedOrderVo.getOrderId();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentService.getAppointmentRecordByPkId(orderId);
        if (appointmentRecordEntity == null) {
            log.info("\u67e5\u8be2\u8be5\u6302\u53f7\u8ba2\u5355\u4e3a\u7a7a\uff1a" + orderId);
            return;
        }
        log.info("\u67e5\u8be2\u8be5\u6302\u53f7\u8ba2\u5355\u4e3a\uff1a " + JSON.toJSONString((Object)appointmentRecordEntity));
        if (appointmentRecordEntity.getAppointStatus().intValue() == AppointmentStatusEnum.WAIT_PAY.getValue().intValue()) {
            try {
                log.info("\u5f53\u65e5\u6302\u53f7\u8d85\u65f6\u672a\u4ed8\u6b3e\u81ea\u52a8\u53d6\u6d88 -> " + orderId);
                CancelAppointmentVoReq cancelRegisterReq = new CancelAppointmentVoReq();
                cancelRegisterReq.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
                this.appointmentService.cancelAppointment(cancelRegisterReq);
            }
            catch (Exception e) {
                log.info("\u8ba2\u5355\u53f7\uff1a" + orderId + "\u81ea\u52a8\u53d6\u6d88\u5f02\u5e38");
            }
        }
    }
}

