/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.common.pojo.vo.card.UcCardListReqVO;
import com.ebaiyihui.common.pojo.vo.card.UserCardListRespVO;
import com.ebaiyihui.common.pojo.vo.card.UserPatientListRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.his.api.AppointApi;
import com.ebaiyihui.his.api.MedicalCardApi;
import com.ebaiyihui.his.api.ScheduleApi;
import com.ebaiyihui.his.pojo.vo.appoint.CancelRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.CancelRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterReq;
import com.ebaiyihui.his.pojo.vo.appoint.ConfirmRegisterRes;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationReq;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationRes;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.TimeArrangeItems;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.BusinessTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.CancelTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundChannelCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.ScheduleException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.BusinessResultMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalConfigMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.BusinessResultEntity;
import com.ebaiyihui.wisdommedical.model.HospitalConfigEntity;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.DoDayAppointmentDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.RegisterationQueryParamsDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.UpdateScheduleDetailDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentPayVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordDetailVo;
import com.ebaiyihui.wisdommedical.pojo.vo.AppointmentRecordVo;
import com.ebaiyihui.wisdommedical.pojo.vo.CancelAppointmentVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ConfirmAppointmentVo;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentCreateOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.DayAppointmentPayVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.DoctorVo;
import com.ebaiyihui.wisdommedical.pojo.vo.GetConfirmPayInfoVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.RabbitMqDelayedOrderVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RegRecord;
import com.ebaiyihui.wisdommedical.pojo.vo.ReponseRegDoctVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ReponseRegVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ReponseRegisterRecordVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestCancelRegVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestCardNoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRefundOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRegDoctVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRegVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ResultInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdateDelayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.UpdatePayAppointmentRecordVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.WithdrawNumberVoReq;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.RabbitMqUtils;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.Period;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class AppointmentServiceImpl
implements AppointmentService {
    private static final Logger log = LoggerFactory.getLogger(AppointmentServiceImpl.class);
    public static final int TWO_HOURS = 7200;
    public static final int CURRENT_DAY_APPOINTMENT = 2;
    public static final int NOT_CURRENT_DAY_APPOINTMENT = 1;
    public static final String YES_TOPAY = "1";
    public static final String NOT_TOPAY = "0";
    public static final String SUCCESS = "Y";
    public static final int HAVE_TIME_ARRANGE_FLAG = 1;
    public static final String HIS_MORNING = "0";
    public static final String HIS_AFTERNOON = "1";
    public static final String dayAppointType = "1";
    public static final String appointType = "2";
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private ScheduleApi scheduleApi;
    @Autowired
    private AppointApi appointApi;
    @Autowired
    private MedicalCardApi medicalCardApi;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private HospitalConfigMapper hospitalConfigMapper;
    @Autowired
    private RabbitTemplate rabbitTemplate;
    @Autowired
    private BusinessResultMapper businessResultMapper;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private PushService pushService;
    public static final List<Integer> WAIT_CONFIRMED = Arrays.asList(11, 15, 16, 17, 18);
    public static final List<Integer> WAIT_CONFIRMED_BACK = Arrays.asList(7, 11, 16);
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private ProPropertiesConstant projProperties;

    public String confirmAppointment(ConfirmAppointmentVo confirmAppointmentVo) throws ScheduleException {
        if (StringUtils.isNotEmpty((String)confirmAppointmentVo.getAdmDate())) {
            confirmAppointmentVo.setAdmDate(this.dateFormat(confirmAppointmentVo.getAdmDate()));
        }
        String admDate = confirmAppointmentVo.getAdmDate();
        String now = DateUtils.getCurrentTime();
        String confirmAppointmentId = String.valueOf(this.snowflakeIdWorker.nextId());
        if (String.valueOf(LocalDate.now()).equals(admDate)) {
            confirmAppointmentVo.setAppointmentType(2);
        } else {
            confirmAppointmentVo.setAppointmentType(1);
        }
        String confirmAppointmentVoStr = JSON.toJSONString((Object)confirmAppointmentVo);
        this.jedisCluster.set(confirmAppointmentId, confirmAppointmentVoStr);
        this.jedisCluster.expire(confirmAppointmentId, 7200);
        return confirmAppointmentId;
    }

    public String dayAppointmentCreateOrder(DayAppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null == cardDetail) {
            throw new AppointmentException("\u83b7\u53d6\u60a3\u8005\u5c31\u8bca\u5361\u4fe1\u606f\u5931\u8d25\uff0c\u6302\u53f7\u5f02\u5e38!");
        }
        GatewayRequest gatewayRequest = this.buildGetScheduleGatewayReq(createOrderVoReq);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u5165\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(gatewayRequest);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException("\u8be5\u65f6\u95f4\u6bb5\u53f7\u6e90\u5df2\u88ab\u5360\u7528\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5");
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new AppointmentException("\u6392\u73ed\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u91cd\u8bd5");
        }
        List scheduleResItemsList = getScheduleResVO.getItems();
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728\u8fc7\u6ee4\u524d\u533b\u751f\u6392\u73ed\uff1a" + scheduleResItemsList);
        scheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getScheduleId().equals(createOrderVoReq.getScheduleHisId())).collect(Collectors.toList());
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728\u6839\u636e\u533b\u751fcode\u8fc7\u6ee4\u51fa\u8be5\u533b\u751f\u6392\u73ed\uff1a" + scheduleResItemsList);
        if (CollectionUtils.isEmpty(scheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return null;
        }
        GetScheduleResItems getScheduleResItem = (GetScheduleResItems)scheduleResItemsList.get(0);
        AppointmentRecordEntity appointmentRecordEntity = null;
        long sysAppointmentId = this.snowflakeIdWorker.nextId();
        GatewayRequest dayGatewayRequest = this.buildDayConfirmRegisterReq(cardDetail, sysAppointmentId, createOrderVoReq);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u9501\u53f7 \u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)dayGatewayRequest));
        GatewayResponse dayGatewayResponse = this.appointApi.lock(dayGatewayRequest);
        log.info("\u5f53\u65e5\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u9501\u53f7 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)dayGatewayResponse));
        if (null == dayGatewayResponse) {
            log.error("\u5f53\u65e5\u6302\u53f7 \u9501\u53f7\u5931\u8d25 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u9501\u53f7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
        if (!"1".equals(dayGatewayResponse.getCode())) {
            log.error("\u5f53\u65e5\u6302\u53f7 \u9501\u53f7\u5931\u8d25 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)dayGatewayResponse.getErrCode(), (Object)dayGatewayResponse.getMsg());
            throw new AppointmentException("\u9501\u53f7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u53bb\u4eba\u5de5\u7a97\u53e3\u8fdb\u884c\u6302\u53f7");
        }
        if (null == dayGatewayResponse.getData()) {
            log.error("\u5f53\u65e5\u6302\u53f7 \u9501\u53f7\u5931\u8d25 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException("\u9501\u53f7\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u6216\u53bb\u4eba\u5de5\u7a97\u53e3\u8fdb\u884c\u6302\u53f7");
        }
        ConfirmRegisterRes dayRegisterRes = (ConfirmRegisterRes)dayGatewayResponse.getData();
        appointmentRecordEntity = this.buildLockSourceAppointmentRecordEntity(sysAppointmentId, dayRegisterRes, getScheduleResItem, createOrderVoReq);
        Long orderId = this.snowflakeIdWorker.nextId();
        appointmentRecordEntity.setId(orderId);
        this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
        RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = new RabbitMqDelayedOrderVo();
        rabbitMqDelayedOrderVo.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        rabbitMqDelayedOrderVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        rabbitMqDelayedOrderVo.setOrderId(String.valueOf(orderId));
        RabbitMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)rabbitMqDelayedOrderVo));
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private AppointmentRecordEntity buildAppointmentRecordEntity(long sysAppointmentId, GetScheduleResItems getScheduleResItem, DayAppointmentCreateOrderVoReq createOrderVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setAdmAddress(StringUtils.isEmpty((String)getScheduleResItem.getAdmLocation()) ? "null" : getScheduleResItem.getAdmLocation());
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        appointmentRecordEntity.setAdmRange((int)Byte.valueOf(createOrderVoReq.getAdmTimeRange()).byteValue());
        appointmentRecordEntity.setAppointmentTime(new Date());
        appointmentRecordEntity.setAppointmentType(2);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(getScheduleResItem.getLocName());
        appointmentRecordEntity.setDocCode(getScheduleResItem.getDocCode());
        appointmentRecordEntity.setDocName(getScheduleResItem.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(getScheduleResItem.getHospitalArea());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null != cardDetail) {
            appointmentRecordEntity.setPatientIdCard(cardDetail.getCredNo());
            appointmentRecordEntity.setPatientName(cardDetail.getPatientName());
            appointmentRecordEntity.setPatientPhone(cardDetail.getTel());
            appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
            appointmentRecordEntity.setPatientSex((int)cardDetail.getGender().shortValue());
            appointmentRecordEntity.setPatientId(cardDetail.getPatientId());
        }
        BigDecimal totalFee = new BigDecimal(getScheduleResItem.getRegFee()).add(new BigDecimal(getScheduleResItem.getDiagFee()));
        appointmentRecordEntity.setPayAmount(totalFee.toString());
        appointmentRecordEntity.setRegFee(new BigDecimal(getScheduleResItem.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal("0"));
        appointmentRecordEntity.setScheduleHisId(getScheduleResItem.getScheduleId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItem.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItem.getScheduleLevelName());
        appointmentRecordEntity.setScheduleType(getScheduleResItem.getScheduleType().toString());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        return appointmentRecordEntity;
    }

    private AppointmentRecordEntity buildLockSourceAppointmentRecordEntity(long sysAppointmentId, ConfirmRegisterRes dayRegisterRes, GetScheduleResItems getScheduleResItem, DayAppointmentCreateOrderVoReq createOrderVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setAppointmentId(dayRegisterRes.getAppointId());
        appointmentRecordEntity.setAppointmentNo(dayRegisterRes.getNo());
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setAdmAddress(getScheduleResItem.getAdmLocation());
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        appointmentRecordEntity.setAdmRange((int)Byte.valueOf(createOrderVoReq.getAdmTimeRange()).byteValue());
        appointmentRecordEntity.setAppointmentTime(DateUtils.stringToSimpleDate((String)getScheduleResItem.getAdmDate()));
        appointmentRecordEntity.setAppointmentType(2);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(getScheduleResItem.getLocName());
        appointmentRecordEntity.setDocCode(getScheduleResItem.getDocCode());
        appointmentRecordEntity.setDocName(getScheduleResItem.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(getScheduleResItem.getHospitalArea());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setAdmTimeRange(createOrderVoReq.getTimeArrange());
        CardDetailsInfoRespVO cardDetail = this.getCardDetail(createOrderVoReq.getCardId());
        if (null != cardDetail) {
            appointmentRecordEntity.setPatientIdCard(cardDetail.getCredNo());
            appointmentRecordEntity.setPatientName(cardDetail.getPatientName());
            appointmentRecordEntity.setPatientPhone(cardDetail.getTel());
            appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)cardDetail.getCredNo()));
            appointmentRecordEntity.setPatientSex((int)cardDetail.getGender().shortValue());
            appointmentRecordEntity.setPatientId(cardDetail.getOrganPmi());
        }
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        BigDecimal totalFee = new BigDecimal(getScheduleResItem.getRegFee()).add(new BigDecimal(getScheduleResItem.getDiagFee()));
        appointmentRecordEntity.setPayAmount(String.valueOf(totalFee.doubleValue()));
        appointmentRecordEntity.setRegFee(new BigDecimal(getScheduleResItem.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal("0"));
        appointmentRecordEntity.setScheduleHisId(getScheduleResItem.getScheduleId());
        appointmentRecordEntity.setRegTitleName(getScheduleResItem.getRegTitleName());
        appointmentRecordEntity.setScheduleLevelName(getScheduleResItem.getScheduleLevelName());
        appointmentRecordEntity.setScheduleType(getScheduleResItem.getScheduleType().toString());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setHisTimeArrangeId(String.valueOf(getScheduleResItem.getIsTimeArrange()));
        appointmentRecordEntity.setRemark("\u5f53\u65e5\u6302\u53f7\u9501\u53f7\u6210\u529f");
        return appointmentRecordEntity;
    }

    public ConfirmAppointmentVo getConfirmAppointment(String confirmAppointmentId) {
        String confirmAppointmentVoStr = this.jedisCluster.get(confirmAppointmentId);
        ConfirmAppointmentVo confirmAppointmentVo = (ConfirmAppointmentVo)JSON.parseObject((String)confirmAppointmentVoStr, ConfirmAppointmentVo.class);
        List timeArrangeItemsList = null;
        if (null != confirmAppointmentVo && !CollectionUtils.isEmpty((Collection)confirmAppointmentVo.getTimeArrangeItems())) {
            timeArrangeItemsList = confirmAppointmentVo.getTimeArrangeItems();
            timeArrangeItemsList.sort(Comparator.comparing(TimeArrangeItems::getStartTime));
        }
        return confirmAppointmentVo;
    }

    public GetConfirmPayInfoVoRes getConfirmPayInfo(String sysAppointmentId) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        GetConfirmPayInfoVoRes getConfirmPayInfoVoRes = new GetConfirmPayInfoVoRes();
        getConfirmPayInfoVoRes.setCreateTime(appointmentRecordEntity.getCreatetime());
        getConfirmPayInfoVoRes.setPayAccount(appointmentRecordEntity.getPayAmount());
        getConfirmPayInfoVoRes.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        getConfirmPayInfoVoRes.setAppointmentType(appointmentRecordEntity.getAppointmentType());
        getConfirmPayInfoVoRes.setPatientName(appointmentRecordEntity.getPatientName());
        return getConfirmPayInfoVoRes;
    }

    public List<AppointmentRecordVo> selectByUserIdAndStatus(Map<String, Object> queryMap, String appCode, String channelCode) throws Exception {
        UcCardListReqVO reqVo = new UcCardListReqVO();
        reqVo.setUserId((String)queryMap.get("userId"));
        reqVo.setOrganCode((String)queryMap.get("hospitalCode"));
        reqVo.setAppCode(appCode);
        reqVo.setChannelCode(channelCode);
        List cardIdList = this.getCardIdList(reqVo);
        List appointmentRecordEntityList = null;
        if (cardIdList.size() < 1) {
            return new ArrayList<AppointmentRecordVo>();
        }
        queryMap.put("cardIdList", cardIdList);
        appointmentRecordEntityList = this.appointmentRecordMapper.selectByUserIdAndStatus(queryMap);
        return this.buildAppointmentRecordVo(appointmentRecordEntityList);
    }

    private GatewayRequest<GetScheduleReqVO> buildGetScheduleGatewayReq(DayAppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(dayAppointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setEdDate(dayAppointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setLocCode(dayAppointmentCreateOrderVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(dayAppointmentCreateOrderVoReq.getDocCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(dayAppointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setChannel(dayAppointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("dayAppointmentCreateOrder");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public List<AppointmentRecordVo> getAppointRecordByCardList(String userId, String hospitalCode, String appCode, String channelCode) throws AppointmentException {
        UcCardListReqVO reqVo = new UcCardListReqVO();
        reqVo.setUserId(userId);
        reqVo.setOrganCode(hospitalCode);
        reqVo.setAppCode(appCode);
        reqVo.setChannelCode(channelCode);
        List cardIdList = this.getCardIdList(reqVo);
        if (CollectionUtils.isEmpty((Collection)cardIdList)) {
            return new ArrayList<AppointmentRecordVo>();
        }
        List appointmentRecordEntityList = null;
        Date startDate = DateUtils.getCurrentDate();
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        queryMap.put("admDateStart", DateUtils.dateToSimpleString((Date)startDate));
        queryMap.put("admDateEnd", DateUtils.dateToSimpleString((Date)DateUtils.getDateAfter((Date)startDate, (int)7)));
        queryMap.put("userId", userId);
        ArrayList<Integer> appointStatusList = new ArrayList<Integer>();
        appointStatusList.add(AppointmentStatusEnum.PAY.getValue());
        appointStatusList.add(AppointmentStatusEnum.WAIT_PAY.getValue());
        queryMap.put("appointStatus", appointStatusList);
        queryMap.put("now", DateUtils.dateToSimpleString((Date)startDate));
        queryMap.put("hospitalCode", hospitalCode);
        queryMap.put("cardIdList", cardIdList);
        appointmentRecordEntityList = this.appointmentRecordMapper.selectByUserIdAndStatus(queryMap);
        appointmentRecordEntityList = appointmentRecordEntityList.stream().filter(appointmentRecordEntity -> appointmentRecordEntity.getAppointmentType() != AppointmentTypeEnums.DAY_APPOINTMENT.getValue().intValue() || !appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.WAIT_PAY.getValue())).collect(Collectors.toList());
        return this.buildAppointmentRecordVo(appointmentRecordEntityList);
    }

    private List<String> getCardIdList(UcCardListReqVO reqVo) throws AppointmentException {
        ArrayList<String> cardIdList = new ArrayList<String>();
        log.error("getCardIdList start-------reqVo:{}", (Object)reqVo);
        BaseResponse resp = this.getCardInfoUtil.getUserCardList(reqVo);
        List UserPatientListRespVOList = JSONObject.parseArray((String)JSONObject.toJSONString((Object)resp.getData()), UserPatientListRespVO.class);
        for (UserPatientListRespVO userPatientListRespVO : UserPatientListRespVOList) {
            List userCardListRespVOList = userPatientListRespVO.getUserCardListRespVOS();
            if (userCardListRespVOList == null && userCardListRespVOList.size() <= 0) continue;
            for (UserCardListRespVO userCardListRespVO : userCardListRespVOList) {
                if (userCardListRespVO == null || userCardListRespVO.getCardId() == null || "".equals(userCardListRespVO.getCardId())) continue;
                cardIdList.add(userCardListRespVO.getCardId());
            }
        }
        return cardIdList;
    }

    public List<AppointmentRecordVo> getMyRegistrationList(RegisterationQueryParamsDTO registerationQueryParamsDTO) throws Exception {
        log.info("\u6211\u7684\u6302\u53f7\u8bb0\u5f55  \u5165\u53c2\uff1a" + JSON.toJSONString((Object)registerationQueryParamsDTO));
        String hospitalCode = registerationQueryParamsDTO.getHospitalCode();
        List appointmentRecordEntityList = this.appointmentRecordMapper.getMyRegistrationList(registerationQueryParamsDTO);
        log.info("\u6211\u7684\u6302\u53f7\u8bb0\u5f55  \u67e5\u8be2\u7ed3\u679c\uff1a" + JSON.toJSONString((Object)appointmentRecordEntityList));
        List appointmentRecordVoList = this.buildAppointmentRecordVo(appointmentRecordEntityList);
        HospitalConfigEntity hospitalConfigEntity = this.hospitalConfigMapper.selectByHospitalCode(hospitalCode);
        for (int i = 0; i < appointmentRecordVoList.size(); ++i) {
            AppointmentRecordVo appointmentRecordVo = (AppointmentRecordVo)appointmentRecordVoList.get(i);
            String admDate = appointmentRecordVo.getAdmDate();
            boolean flag = DateUtils.judgeDate((String)appointmentRecordVo.getAdmDate(), (String)String.valueOf(LocalDate.now()));
            if (admDate.equals(String.valueOf(LocalDate.now()))) {
                appointmentRecordVo.setIsTheDay(0L);
            } else if (flag) {
                appointmentRecordVo.setIsTheDay(1L);
            } else if (!flag) {
                appointmentRecordVo.setIsTheDay(-1L);
            }
            if (hospitalConfigEntity != null && hospitalConfigEntity.getAppointAutoCancelMin() != null) {
                int appointAutoCancelMin = hospitalConfigEntity.getAppointAutoCancelMin();
                appointmentRecordVo.setExpiredtime((long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60));
                appointmentRecordVo.setExpiredendtime(appointmentRecordVo.getCreatetime() + (long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60 * 1000));
                continue;
            }
            appointmentRecordVo.setExpiredtime(1800L);
            appointmentRecordVo.setExpiredendtime(appointmentRecordVo.getCreatetime() + appointmentRecordVo.getExpiredtime() * 1000L);
        }
        log.info("\u6211\u7684\u6302\u53f7\u8bb0\u5f55  \u8fd4\u56de\u5bf9\u8c61 \uff1a" + JSON.toJSONString((Object)appointmentRecordVoList));
        return appointmentRecordVoList;
    }

    private List<AppointmentRecordVo> buildAppointmentRecordVo(List<AppointmentRecordEntity> appointmentRecordEntityList) throws AppointmentException {
        if (CollectionUtils.isEmpty(appointmentRecordEntityList)) {
            return new ArrayList<AppointmentRecordVo>();
        }
        log.info("\u672c\u4eba\u8bca\u7597\u6302\u53f7\u6570\u636e ------>{}", appointmentRecordEntityList);
        ArrayList<AppointmentRecordVo> appointmentRecordVoList = new ArrayList<AppointmentRecordVo>();
        for (int i = 0; i < appointmentRecordEntityList.size(); ++i) {
            AppointmentRecordEntity appointmentRecordEntity = appointmentRecordEntityList.get(i);
            if (StringUtils.isEmpty((String)appointmentRecordEntity.getPayAmount())) continue;
            AppointmentRecordVo appointmentRecordVo = new AppointmentRecordVo();
            appointmentRecordVo.setAdmDate(appointmentRecordEntity.getAdmDate());
            appointmentRecordVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
            Integer appointStatus = appointmentRecordEntity.getAppointStatus();
            if (WAIT_CONFIRMED.contains(appointStatus)) {
                appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
            }
            appointmentRecordVo.setAppointStatus(appointStatus);
            appointmentRecordVo.setDeptName(appointmentRecordEntity.getDeptName());
            appointmentRecordVo.setDocName(appointmentRecordEntity.getDocName());
            appointmentRecordVo.setPatientIdCard(appointmentRecordEntity.getCardId());
            appointmentRecordVo.setUserId(appointmentRecordEntity.getUserId());
            appointmentRecordVo.setPatientName(appointmentRecordEntity.getPatientName());
            appointmentRecordVo.setAdmRange(appointmentRecordEntity.getAdmRange());
            appointmentRecordVo.setRegFee(new BigDecimal(appointmentRecordEntity.getPayAmount()));
            appointmentRecordVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
            appointmentRecordVo.setAppointmentType(appointmentRecordEntity.getAppointmentType());
            if (appointmentRecordEntity.getCreatetime() != null) {
                long createtime = appointmentRecordEntity.getCreatetime().getTime();
                appointmentRecordVo.setCreatetime(createtime);
            }
            long daysRemaining = 0L;
            try {
                daysRemaining = DateUtils.getDistanceDays((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            }
            catch (Exception e) {
                log.error("-------\u8ba1\u7b97\u8ddd\u79bb\u5c31\u8bca\u65e5\u5931\u8d25-------");
            }
            appointmentRecordVo.setDaysRemaining(daysRemaining);
            boolean flag = DateUtils.judgeDate((String)appointmentRecordEntity.getAdmDate(), (String)String.valueOf(LocalDate.now()));
            appointmentRecordVo.setIsTheDay(flag ? 1L : -1L);
            CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
            cardDetailsInfoReqVO.setCardId(appointmentRecordEntity.getCardId());
            cardDetailsInfoReqVO.setChannelCode("app");
            CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
            if (cardDetailsInfoRespVO != null && cardDetailsInfoRespVO.getCardTypeName() != null) {
                appointmentRecordVo.setPatientCardName(cardDetailsInfoRespVO.getCardTypeName());
            }
            appointmentRecordVoList.add(appointmentRecordVo);
        }
        return appointmentRecordVoList;
    }

    public AppointmentRecordDetailVo getMyRegistrationDetail(String sysAppointmentId) throws AppointmentException {
        log.info("AppointmentServiceImpl.getMyRegistrationDetail->\u8bf7\u6c42\u53c2\u6570sysAppointmentId:{}", (Object)sysAppointmentId);
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        if (null == appointmentRecordEntity) {
            log.error("AppointmentServiceImpl.getMyRegistrationDetail->\u67e5\u8be2\u7ed3\u679c\u4e3a\u7a7a\uff0c\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570sysAppointmentId\u4e3a:{}", (Object)sysAppointmentId);
            throw new AppointmentException();
        }
        String hospitalCode = appointmentRecordEntity.getHospitalCode();
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(appointmentRecordEntity.getCardId());
        cardDetailsInfoReqVO.setChannelCode("app");
        AppointmentRecordDetailVo appointmentRecordDetailVo = new AppointmentRecordDetailVo();
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        if (cardDetailsInfoRespVO != null && cardDetailsInfoRespVO.getCardTypeName() != null) {
            appointmentRecordDetailVo.setPatientCardName(cardDetailsInfoRespVO.getCardTypeName());
            int age = 0;
            try {
                age = DateUtils.getAgeByBirth((Date)DateUtils.stringToSimpleDate((String)cardDetailsInfoRespVO.getBirth()));
            }
            catch (ParseException e) {
                throw new AppointmentException("\u5e74\u9f84\u8f6c\u5316\u5f02\u5e38\uff01");
            }
            appointmentRecordDetailVo.setPatientAge(Integer.valueOf(age));
            appointmentRecordDetailVo.setPatientSex(Integer.valueOf(cardDetailsInfoRespVO.getGender().intValue()));
        }
        this.buildAppointmentRecordDetailVo(appointmentRecordDetailVo, appointmentRecordEntity, hospitalCode);
        return appointmentRecordDetailVo;
    }

    private void buildAppointmentRecordDetailVo(AppointmentRecordDetailVo appointmentRecordDetailVo, AppointmentRecordEntity appointmentRecordEntity, String hospitalCode) {
        appointmentRecordDetailVo.setId(appointmentRecordEntity.getId());
        appointmentRecordDetailVo.setPatientName(appointmentRecordEntity.getPatientName());
        appointmentRecordDetailVo.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        Date admDate = DateUtils.stringToSimpleDate((String)appointmentRecordEntity.getAdmDate());
        appointmentRecordDetailVo.setAdmDate(DateUtils.dateToYMDString((Date)admDate));
        appointmentRecordDetailVo.setAdmTimeRange(appointmentRecordEntity.getAdmTimeRange());
        appointmentRecordDetailVo.setWeekday(DateUtils.getWeekZhou((String)appointmentRecordEntity.getAdmDate()));
        if (appointmentRecordEntity.getAppointStatus() == AppointmentStatusEnum.WAIT_PAY.getValue()) {
            Date addDate = DateUtils.dateAddMinutes((Date)appointmentRecordEntity.getCreatetime(), (int)30);
            SimpleDateFormat formatter = new SimpleDateFormat("HH:mm:ss");
            String dateString = formatter.format(addDate);
            appointmentRecordDetailVo.setAdmEndTime(dateString);
        }
        appointmentRecordDetailVo.setDocName(appointmentRecordEntity.getDocName());
        appointmentRecordDetailVo.setDeptName(appointmentRecordEntity.getDeptName());
        appointmentRecordDetailVo.setAdmAddress(appointmentRecordEntity.getHospitalName() + " " + appointmentRecordEntity.getDeptName());
        appointmentRecordDetailVo.setPatientCardNo(appointmentRecordEntity.getPatientCardNo());
        appointmentRecordDetailVo.setCreatetime(appointmentRecordEntity.getCreatetime().getTime());
        appointmentRecordDetailVo.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        appointmentRecordDetailVo.setPatientIdCard(appointmentRecordEntity.getPatientIdCard());
        HospitalConfigEntity hospitalConfigEntity = this.hospitalConfigMapper.selectByHospitalCode(hospitalCode);
        if (hospitalConfigEntity != null && hospitalConfigEntity.getAppointAutoCancelMin() != null) {
            int appointAutoCancelMin = hospitalConfigEntity.getAppointAutoCancelMin();
            appointmentRecordDetailVo.setExpiredtime((long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60));
            appointmentRecordDetailVo.setExpiredendtime(appointmentRecordDetailVo.getCreatetime() + (long)(hospitalConfigEntity.getAppointAutoCancelMin() * 60 * 1000));
        } else {
            appointmentRecordDetailVo.setExpiredtime(1800L);
            appointmentRecordDetailVo.setExpiredendtime(appointmentRecordEntity.getCreatetime().getTime() + 1740000L);
        }
        appointmentRecordDetailVo.setAppointmentType(appointmentRecordEntity.getAppointmentType());
        appointmentRecordDetailVo.setAdmRange(appointmentRecordEntity.getAdmRange());
        appointmentRecordDetailVo.setRegTitleName(appointmentRecordEntity.getRegTitleName());
        appointmentRecordDetailVo.setTakeTime(appointmentRecordEntity.getTakeTime());
        appointmentRecordDetailVo.setTakeAddress(appointmentRecordEntity.getTakeAddress());
        appointmentRecordDetailVo.setScheduleLevelName(appointmentRecordEntity.getScheduleLevelName());
        appointmentRecordDetailVo.setRegFee(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentRecordDetailVo.setAppointmentNo(appointmentRecordEntity.getAppointmentNo());
        appointmentRecordDetailVo.setPayAccdate(appointmentRecordEntity.getPayAccdate());
        appointmentRecordDetailVo.setRefundTime(appointmentRecordEntity.getReturnAccdate());
        Integer appointStatus = appointmentRecordEntity.getAppointStatus();
        if (WAIT_CONFIRMED.contains(appointStatus)) {
            appointStatus = AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue();
        }
        String ade = appointmentRecordEntity.getAdmDate();
        boolean flag = DateUtils.judgeDate((String)appointmentRecordEntity.getAdmDate(), (String)String.valueOf(LocalDate.now()));
        if (ade.equals(String.valueOf(LocalDate.now()))) {
            appointmentRecordDetailVo.setIsTheDay(0L);
        } else if (flag) {
            appointmentRecordDetailVo.setIsTheDay(1L);
        } else if (!flag) {
            appointmentRecordDetailVo.setIsTheDay(-1L);
        }
        try {
            long daysRemaining = DateUtils.getDistanceDays((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            appointmentRecordDetailVo.setDaysRemaining(daysRemaining);
        }
        catch (Exception e) {
            log.error("======\u8ba1\u7b97\u8ddd\u8bca\u65ad\u65e5\u8fd8\u5269\u4e0b\u5929\u6570\u5931\u8d25=====");
        }
        appointmentRecordDetailVo.setAppointStatus(appointStatus.intValue());
        appointmentRecordDetailVo.setRefundMoney(appointmentRecordEntity.getReturnAmount());
        appointmentRecordDetailVo.setRefundTime(appointmentRecordEntity.getReturnAccdate());
        appointmentRecordDetailVo.setCancelType(Integer.valueOf(appointmentRecordEntity.getCancleType()));
    }

    public void cancelAppointment(CancelAppointmentVoReq cancelAppointmentVoReq) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(cancelAppointmentVoReq.getSysAppointmentId());
        List<Integer> cancelAble = Arrays.asList(2, 20);
        if (null == appointmentRecordEntity || !cancelAble.contains(appointmentRecordEntity.getAppointStatus())) {
            throw new AppointmentException("\u6b64\u8ba2\u5355\u4e0d\u53ef\u53d6\u6d88\uff01");
        }
        if (AppointmentStatusEnum.APPOINT_SUCCESS.getValue().equals(appointmentRecordEntity.getAppointStatus())) {
            if (StringUtils.isEmpty((String)appointmentRecordEntity.getAdmId())) {
                ReponseRegisterRecordVo reponseRegisterRecordVo;
                FrontRequest gatewayRequestCard = this.buildPayRegistrationReq(appointmentRecordEntity);
                BusinessResultEntity businessResult = new BusinessResultEntity();
                businessResult.setChannelCode(appointmentRecordEntity.getChannelCode());
                businessResult.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
                businessResult.setHisRequest(JSON.toJSONString((Object)gatewayRequestCard));
                this.businessResultMapper.insertSelective(businessResult);
                log.info("\u6839\u636e\u5361\u53f7\u83b7\u53d6\u6302\u53f7\u8bb0\u5f55 \u5165\u53c2 gatewayRequest{}", (Object)JSON.toJSONString((Object)gatewayRequestCard));
                String responseCard = null;
                try {
                    responseCard = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "card/acquire/registered/record"), (String)JSON.toJSONString((Object)gatewayRequestCard));
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (ExecutionException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                log.info("\u3010\u6839\u636e\u5361\u53f7\u83b7\u53d6\u6302\u53f7\u8bb0\u5f55\u3011\u8bf7\u6c42his\u5165\u53c2{}\uff0c\u8fd4\u56de\u7ed3\u679c{}", responseCard, responseCard);
                FrontResponse frontResponseCard = (FrontResponse)JSON.parseObject((String)responseCard, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
                businessResult.setErrorCode(frontResponseCard.getErrCode());
                businessResult.setErrorMsg(frontResponseCard.getMessage());
                businessResult.setHisResponse(JSON.toJSONString((Object)frontResponseCard));
                businessResult.setTransationId(appointmentRecordEntity.getSysAppointmentId());
                businessResult.setStatus(new Byte("0"));
                this.businessResultMapper.updateByPrimaryKeySelective(businessResult);
                if (frontResponseCard != null && (reponseRegisterRecordVo = (ReponseRegisterRecordVo)frontResponseCard.getBody()) != null && reponseRegisterRecordVo.getRegRecordList().size() > 0) {
                    RegRecord regRecord = (RegRecord)reponseRegisterRecordVo.getRegRecordList().get(0);
                    appointmentRecordEntity.setAdmId(regRecord.getClinicNo());
                }
            }
            FrontRequest gatewayRequest = this.buildWithdrawNumberGatewayReq(appointmentRecordEntity, appointmentRecordEntity.getAppointmentId());
            BusinessResultEntity businessResultEntity = new BusinessResultEntity();
            businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
            businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.REFUND_WRITE.getValue().toString()));
            businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
            this.businessResultMapper.insertSelective(businessResultEntity);
            String response = null;
            try {
                response = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "appoint/back/number"), (String)JSON.toJSONString((Object)gatewayRequest));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            FrontResponse frontResponse = (FrontResponse)JSON.parseObject(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            businessResultEntity.setErrorCode(frontResponse.getCode());
            businessResultEntity.setErrorMsg(frontResponse.getMessage());
            businessResultEntity.setHisResponse(JSON.toJSONString((Object)frontResponse));
            businessResultEntity.setTransationId(frontResponse.getTransactionId());
            businessResultEntity.setStatus(new Byte("0"));
            this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        }
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.CANCEL.getValue());
        appointmentRecordEntity.setCancleTime(new Date());
        appointmentRecordEntity.setCancleType(CancelTypeEnum.CHANNEL_CANCEL.getValue().intValue());
        appointmentRecordEntity.setCancleReason("\u8d85\u65f6\u672a\u4ed8\u6b3e\u6216\u7528\u6237\u4e3b\u52a8\u53d6\u6d88");
        appointmentRecordEntity.setRemark("\u8d85\u65f6\u672a\u4ed8\u6b3e\u6216\u7528\u6237\u4e3b\u52a8\u53d6\u6d88");
        appointmentRecordEntity.setCancleChannelCode(cancelAppointmentVoReq.getChannelName());
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    private FrontRequest<RequestCancelRegVo> buildWithdrawNumberGatewayReq(AppointmentRecordEntity appointmentRecordEntity, String appointmentId) {
        FrontRequest frontRequest = new FrontRequest();
        RequestCancelRegVo requestCancelRegVo = new RequestCancelRegVo();
        requestCancelRegVo.setClinicNo(appointmentRecordEntity.getAdmId());
        requestCancelRegVo.setFlowNo(appointmentRecordEntity.getSysAppointmentId());
        requestCancelRegVo.setUserId("002005");
        frontRequest.setBody((Object)requestCancelRegVo);
        frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return frontRequest;
    }

    public BaseResponse<String> withdrawNumber(WithdrawNumberVoReq withdrawNumberVoReq) throws AppointmentException {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity;
        boolean overdueRefundDate;
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(withdrawNumberVoReq.getSysAppointmentId());
        if (appointmentRecordEntity == null || appointmentRecordEntity.getAppointStatus() == null) {
            throw new AppointmentException("\u5f53\u524d\u6302\u53f7\u8bb0\u5f55\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        if (!appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) {
            throw new AppointmentException("\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e");
        }
        if ("1".equals(withdrawNumberVoReq.getReturnType())) {
            overdueRefundDate = DateUtils.judgeDate((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            if (!overdueRefundDate) {
                throw new AppointmentException("\u5c31\u8bca\u5f53\u65e5\u4e0d\u80fd\u9000\u53f7\uff0c\u5982\u9700\u9000\u53f7\u8bf7\u81f3\u533b\u9662\u7a97\u53e3\u54a8\u8be2\u529e\u7406\u3002");
            }
        } else {
            overdueRefundDate = DateUtils.judgeDate((String)String.valueOf(LocalDate.now()), (String)appointmentRecordEntity.getAdmDate());
            if (!overdueRefundDate) {
                throw new AppointmentException("\u5c31\u8bca\u65f6\u95f4\u5df2\u8fc7\uff0c\u5982\u9700\u9000\u53f7\u8bf7\u81f3\u533b\u9662\u7a97\u53e3\u54a8\u8be2\u529e\u7406\u3002");
            }
        }
        if (null == (serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH()))) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9000\u6b3e\u5931\u8d25");
        }
        FrontRequest gatewayRequest = this.buildWithdrawNumberGatewayReq(appointmentRecordEntity);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.REFUND_WRITE.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        businessResultEntity.setTransationId(appointmentRecordEntity.getSysAppointmentId());
        this.businessResultMapper.insertSelective(businessResultEntity);
        String message = "\u53d6\u6d88\u9884\u7ea6 \u9000\u53f7 withdrawNumber";
        String response = null;
        try {
            response = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "appoint/back/number"), (String)JSON.toJSONString((Object)gatewayRequest));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        businessResultEntity.setErrorCode(frontResponse.getErrCode());
        businessResultEntity.setErrorMsg(frontResponse.getMessage());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)frontResponse));
        businessResultEntity.setStatus(new Byte("0"));
        String sysAppointmentId = appointmentRecordEntity.getSysAppointmentId();
        AppointmentPayorderEntity appointmentPayorderEntity = new AppointmentPayorderEntity();
        appointmentPayorderEntity.setSysAppointmentId(sysAppointmentId);
        appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.SUCCESSFUL_APPLICATION_AWAITS_CONFIRMATION.getValue().intValue()));
        appointmentPayorderEntity.setRefundChannelCode(Byte.valueOf((byte)RefundChannelCodeEnum.CURRENT_SYSTEM_REFUND.getValue().intValue()));
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue());
        appointmentRecordEntity.setCancleTime(new Date());
        appointmentRecordEntity.setRemark("\u9000\u53f7\u6210\u529f\uff0c\u7b49\u5f85\u9000\u6b3e");
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        AppointmentPayorderEntity payorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(sysAppointmentId);
        if (payorderEntity == null || payorderEntity.getDealSeq() == null || "".equals(payorderEntity.getDealSeq())) {
            throw new AppointmentException("DealSeq\u4e3a\u7a7a\uff01");
        }
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(withdrawNumberVoReq.getPayChannel());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(payorderEntity.getDealSeq());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        requestRefundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
        requestRefundOrderVoReq.setOutRefundNo(String.valueOf(this.snowflakeIdWorker.nextId()));
        Map map = SignUtil.getKeyAndValue((Object)requestRefundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        requestRefundOrderVoReq.setSign(sign);
        log.info("refund method--------> begain");
        log.info("\u8bf7\u6c42\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\uff1a" + JSON.toJSONString((Object)requestRefundOrderVoReq));
        BaseResponse baseResponse = this.refund(requestRefundOrderVoReq);
        log.info("refund\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.REFUND_AND_CONFIRMATION.getValue().intValue()));
        appointmentPayorderEntity.setRefundTime(new Date());
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
        businessResultEntity.setPlatformResponse(JSON.toJSONString((Object)baseResponse));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        return baseResponse;
    }

    public BaseResponse<String> callBackNumber(String sysAppointmentId) throws AppointmentException {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        if (appointmentRecordEntity == null || appointmentRecordEntity.getAppointStatus() == null) {
            throw new AppointmentException("\u5f53\u524d\u6302\u53f7\u8bb0\u5f55\u67e5\u8be2\u4e3a\u7a7a\uff01");
        }
        if (!appointmentRecordEntity.getAppointStatus().equals(AppointmentStatusEnum.PAY.getValue())) {
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.CANCEL.getValue());
            appointmentRecordEntity.setCancleTime(new Date());
            appointmentRecordEntity.setRemark("\u53d6\u6d88\u9884\u7ea6");
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            FrontResponse frontResponse = this.callbackNumber(appointmentRecordEntity);
            ResultInfoVo resultInfoVo = (ResultInfoVo)frontResponse.getBody();
        }
        return BaseResponse.success();
    }

    public FrontResponse<ResultInfoVo> callbackNumber(AppointmentRecordEntity appointmentRecordEntity) throws AppointmentException {
        FrontRequest gatewayRequest = this.buildWithdrawNumberGatewayReq(appointmentRecordEntity);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.REFUND_WRITE.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        businessResultEntity.setTransationId(appointmentRecordEntity.getSysAppointmentId());
        this.businessResultMapper.insertSelective(businessResultEntity);
        String message = "\u53d6\u6d88\u9884\u7ea6 \u9000\u53f7 withdrawNumber";
        String response = null;
        try {
            response = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "appoint/back/number"), (String)JSON.toJSONString((Object)gatewayRequest));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        businessResultEntity.setErrorCode(frontResponse.getErrCode());
        businessResultEntity.setErrorMsg(frontResponse.getMessage());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)frontResponse));
        businessResultEntity.setStatus(new Byte("0"));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        if (response == null) {
            throw new AppointmentException("\u9000\u53f7\u5931\u8d25");
        }
        if (frontResponse == null) {
            throw new AppointmentException("\u9000\u53f7\u5931\u8d25" + frontResponse.getMessage());
        }
        if (!"1".equals(frontResponse.getCode())) {
            throw new AppointmentException("\u9000\u53f7\u5931\u8d25" + frontResponse.getMessage());
        }
        return frontResponse;
    }

    private BaseResponse<String> refund(RequestRefundOrderVoReq requestRefundOrderVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)requestRefundOrderVoReq));
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            return response;
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25\uff0c\u539f\u56e0\u662f:{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
    }

    public String payAppointmentPayToHis(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo, AppointmentPayorderEntity payOrderEntity) throws AppointmentException {
        BaseResponse baseResponse;
        FrontRequest gatewayRequest = this.buildPayRegistrationReq(appointmentRecordEntity);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 \u5165\u53c2 gatewayRequest{}", (Object)JSON.toJSONString((Object)gatewayRequest));
        String response = null;
        try {
            response = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "card/acquire/registered/record"), (String)JSON.toJSONString((Object)gatewayRequest));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.info("\u3010\u68c0\u9a8c\u68c0\u67e5\u652f\u4ed8\u540e\u786e\u8ba4\u9884\u7ea6\u3011\u8bf7\u6c42his\u5165\u53c2{}\uff0c\u8fd4\u56de\u7ed3\u679c{}", response, response);
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject((String)response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        businessResultEntity.setErrorCode(frontResponse.getErrCode());
        businessResultEntity.setErrorMsg(frontResponse.getMessage());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)frontResponse));
        businessResultEntity.setTransationId(appointmentRecordEntity.getSysAppointmentId());
        businessResultEntity.setStatus(new Byte("0"));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 \u51fa\u53c2 PayRegistrationRes{}", (Object)JSON.toJSONString((Object)frontResponse));
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null != serviceMerchantConfigEntity) {
            requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
            requestRefundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
            requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
            Map map = SignUtil.getKeyAndValue((Object)requestRefundOrderVoReq);
            String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
            requestRefundOrderVoReq.setSign(sign);
        }
        log.info("\u9884\u7ea6\u6302\u53f7\u81ea\u52a8\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)requestRefundOrderVoReq));
        if (frontResponse == null) {
            baseResponse = this.refund(requestRefundOrderVoReq);
            if ("1".equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u786e\u8ba4\u6302\u53f7\u5931\u8d25,\u81ea\u52a8\u9000\u6b3e\u6210\u529f");
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a\uff0c\u9000\u6b3e" + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 PayRegistrationRes -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(frontResponse.getMessage());
        }
        if (!"1".equals(frontResponse.getCode())) {
            baseResponse = this.refund(requestRefundOrderVoReq);
            if ("1".equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u786e\u8ba4\u6302\u53f7\u5931\u8d25,\u81ea\u52a8\u9000\u6b3e\u6210\u529f" + frontResponse.getMessage());
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark(frontResponse.getMessage() + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8his\u786e\u8ba4 PayRegistrationRes -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)frontResponse.getErrCode(), (Object)frontResponse.getMessage());
            throw new AppointmentException(frontResponse.getMessage());
        }
        ReponseRegisterRecordVo reponseRegisterRecordVo = (ReponseRegisterRecordVo)frontResponse.getBody();
        appointmentRecordEntity.setPayAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        appointmentRecordEntity.setPayPostId(responseNotifyRestVo.getMchId());
        appointmentRecordEntity.setPayTransationId(responseNotifyRestVo.getTradeNo());
        appointmentRecordEntity.setPayChannel(PayChannelEnum.getDisplay((String)responseNotifyRestVo.getPayChannel()));
        if (null != reponseRegisterRecordVo) {
            appointmentRecordEntity.setReceptId("");
        }
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        appointmentRecordEntity.setPayChannelCode(responseNotifyRestVo.getPayChannel());
        appointmentRecordEntity.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setPatientId(appointmentRecordEntity.getPatientId());
        payOrderEntity.setPaymentSeq(appointmentRecordEntity.getPayChannelCode());
        this.appointmentPayOrderMapper.updateByPrimaryKey(payOrderEntity);
        return appointmentRecordEntity.getSysAppointmentId();
    }

    private GatewayResponse<CancelRegisterRes> invokeHisCancelRegister(GatewayRequest<CancelRegisterReq> gatewayRequest, String message) throws AppointmentException {
        GatewayResponse gatewayResponse = this.appointApi.cancelRegister(gatewayRequest);
        if (gatewayResponse == null) {
            log.error(message + "-> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error(message + " -> his\u53d6\u6d88\u6302\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error(message + " -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        return gatewayResponse;
    }

    private GatewayResponse<PayRegistrationRes> invokeHisReturnRegister(GatewayRequest<PayRegistrationReq> gatewayRequest, String message) throws AppointmentException {
        log.info("his\u9000\u53f7\u5165\u53c2{}", (Object)JSON.toJSONString(gatewayRequest, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        GatewayResponse gatewayResponse = this.appointApi.returnRegisterJK(gatewayRequest);
        log.info("his\u9000\u53f7\u51fa\u53c2{}", (Object)JSON.toJSONString((Object)gatewayResponse, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (gatewayResponse.getCode() == null) {
            log.error(message + "-> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if ("0".equals(gatewayResponse.getCode())) {
            log.error(message + " -> his\u9000\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        return gatewayResponse;
    }

    private GatewayRequest<CancelRegisterReq> buildCancelRegisterGatewayReq(CancelAppointmentVoReq cancelAppointmentVoReq, AppointmentRecordEntity appointmentRecordEntity) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        CancelRegisterReq cancelRegisterReq = new CancelRegisterReq();
        cancelRegisterReq.setTradeId(appointmentRecordEntity.getSysAppointmentId());
        cancelRegisterReq.setPatientId(appointmentRecordEntity.getPatientId());
        cancelRegisterReq.setOrderId(appointmentRecordEntity.getAppointmentId());
        gatewayRequest.setBody((Object)cancelRegisterReq);
        gatewayRequest.setChannelName(cancelAppointmentVoReq.getChannelName());
        gatewayRequest.setChannel(cancelAppointmentVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("cancelAppointment");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private FrontRequest<RequestCancelRegVo> buildWithdrawNumberGatewayReq(AppointmentRecordEntity appointmentRecordEntity) {
        FrontRequest frontRequest = new FrontRequest();
        RequestCancelRegVo requestCancelRegVo = new RequestCancelRegVo();
        requestCancelRegVo.setClinicNo(appointmentRecordEntity.getAdmId());
        requestCancelRegVo.setFlowNo(appointmentRecordEntity.getSysAppointmentId());
        requestCancelRegVo.setUserId("002005");
        frontRequest.setBody((Object)requestCancelRegVo);
        frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return frontRequest;
    }

    public String dateFormat(String date) {
        if (org.springframework.util.StringUtils.isEmpty((Object)date)) {
            return date;
        }
        String strDateFormat = "yyyy-MM-dd";
        SimpleDateFormat f = new SimpleDateFormat(strDateFormat);
        return f.format(new Date(date));
    }

    public String appointmentCreateOrder(AppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        long sysAppointmnetId = this.snowflakeIdWorker.nextId();
        FrontRequest frontRequestRequestRegDoctVo = this.buildDoctorInfo(createOrderVoReq);
        String responseRegDoctVo = null;
        try {
            responseRegDoctVo = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "schedule/getDeptDoctor"), (String)JSON.toJSONString((Object)frontRequestRequestRegDoctVo));
            if (responseRegDoctVo == null) {
                log.error("\u6392\u73ed  -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
                throw new AppointmentException("\u6682\u65e0\u6b64\u6392\u73ed");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        FrontResponse frontResponseReponseRegDoctVo = (FrontResponse)JSON.parseObject(responseRegDoctVo, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (!"1".equals(frontResponseReponseRegDoctVo.getCode())) {
            log.error("\u6392\u73ed  -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u6682\u65e0\u6b64\u6392\u73ed");
        }
        ReponseRegDoctVo reponseRegDoctVo = (ReponseRegDoctVo)frontResponseReponseRegDoctVo.getBody();
        if (reponseRegDoctVo.getDoctor().size() < 1) {
            log.error("\u6392\u73ed  -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u6682\u65e0\u6b64\u6392\u73ed");
        }
        List doctorVoList = reponseRegDoctVo.getDoctor().stream().filter(a -> createOrderVoReq.getScheduleHisId().equals(a.getSchemaID())).collect(Collectors.toList());
        if (doctorVoList.size() < 1) {
            log.error("\u6392\u73ed  -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException("\u6682\u65e0\u6b64\u6392\u73ed");
        }
        DoctorVo doctorVo = (DoctorVo)doctorVoList.get(0);
        FrontRequest frontRequest = this.buildConfirmRegisterReq(sysAppointmnetId, createOrderVoReq);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(createOrderVoReq.getChannelName());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.APPOINTMENT.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)frontRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u9884\u7ea6\u6302\u53f7 \u8bf7\u6c42his\u5165\u53c2\uff1agatewayRequest:{}", (Object)frontRequest);
        String response = null;
        try {
            response = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "appoint/register/confirm"), (String)JSON.toJSONString((Object)frontRequest));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.info("\u3010\u9884\u7ea6\u6302\u53f7\u3011\u8bf7\u6c42his\u5165\u53c2{}\uff0c\u8fd4\u56de\u7ed3\u679c{}", response, response);
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject((String)response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        log.info("\u9884\u7ea6\u6302\u53f7 \u8bf7\u6c42his\u51fa\u53c2\uff1aConfirmRegisterRes:{}", frontResponse.getBody());
        businessResultEntity.setErrorCode(frontResponse.getErrCode());
        businessResultEntity.setErrorMsg(frontResponse.getMessage());
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)frontResponse));
        businessResultEntity.setTransationId(frontResponse.getTransactionId());
        businessResultEntity.setStatus(new Byte("0"));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        if (frontResponse == null) {
            log.error("\u9884\u7ea6\u6302\u53f7 confirmRegister -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(frontResponse.getMessage());
        }
        if (!"1".equals(frontResponse.getCode())) {
            log.error("\u9884\u7ea6\u6302\u53f7 confirmRegister -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)frontResponse.getErrCode(), (Object)frontResponse.getMessage());
            throw new AppointmentException("\u8bf7\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5\u6302\u53f7");
        }
        if (frontResponse.getBody() == null) {
            log.error("\u9884\u7ea6\u6302\u53f7 confirmRegister -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException("\u8bf7\u9009\u62e9\u5176\u4ed6\u65f6\u95f4\u6bb5\u6302\u53f7");
        }
        ReponseRegVo reponseRegDeptVo = (ReponseRegVo)frontResponse.getBody();
        if (!"1".equals(reponseRegDeptVo.getResult())) {
            log.error("\u9884\u7ea6\u6302\u53f7 confirmRegister -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(reponseRegDeptVo.getErr());
        }
        AppointmentRecordEntity appointmentRecordEntity = this.buildSuccessAppointmentRecordEntity(sysAppointmnetId, reponseRegDeptVo, createOrderVoReq, doctorVo);
        this.appointmentRecordMapper.insertSelective(appointmentRecordEntity);
        AppointmentRecordEntity appointmentRecord = this.appointmentRecordMapper.selectBySysAppointId(appointmentRecordEntity.getSysAppointmentId());
        AppointmentRecordEntity appointment = this.selectappointment(appointmentRecord);
        if (appointmentRecord != null) {
            RabbitMqDelayedOrderVo rabbitMqDelayedOrderVo = new RabbitMqDelayedOrderVo();
            rabbitMqDelayedOrderVo.setHospitalCode(appointmentRecord.getHospitalCode());
            rabbitMqDelayedOrderVo.setSysAppointmentId(appointmentRecord.getSysAppointmentId());
            rabbitMqDelayedOrderVo.setOrderId(appointmentRecord.getId().toString());
            RabbitMqUtils.senderDelayedOrderOutTradeNo((RabbitTemplate)this.rabbitTemplate, (String)JSON.toJSONString((Object)rabbitMqDelayedOrderVo));
        }
        return appointmentRecordEntity.getSysAppointmentId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public AppointmentRecordEntity selectappointment(AppointmentRecordEntity appointmentRecordEntity) throws AppointmentException {
        FrontRequest gatewayRequestCard = this.buildPayRegistrationReq(appointmentRecordEntity);
        BusinessResultEntity businessResult = new BusinessResultEntity();
        businessResult.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResult.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResult.setHisRequest(JSON.toJSONString((Object)gatewayRequestCard));
        this.businessResultMapper.insertSelective(businessResult);
        log.info("\u6839\u636e\u5361\u53f7\u83b7\u53d6\u6302\u53f7\u8bb0\u5f55 \u5165\u53c2 gatewayRequest{}", (Object)JSON.toJSONString((Object)gatewayRequestCard));
        String responseCard = null;
        try {
            responseCard = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "card/acquire/registered/record"), (String)JSON.toJSONString((Object)gatewayRequestCard));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.info("\u3010\u6839\u636e\u5361\u53f7\u83b7\u53d6\u6302\u53f7\u8bb0\u5f55\u3011\u8bf7\u6c42his\u5165\u53c2{}\uff0c\u8fd4\u56de\u7ed3\u679c{}", responseCard, responseCard);
        FrontResponse frontResponseCard = (FrontResponse)JSON.parseObject((String)responseCard, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        businessResult.setErrorCode(frontResponseCard.getErrCode());
        businessResult.setErrorMsg(frontResponseCard.getMessage());
        businessResult.setHisResponse(JSON.toJSONString((Object)frontResponseCard));
        businessResult.setTransationId(appointmentRecordEntity.getSysAppointmentId());
        businessResult.setStatus(new Byte("0"));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResult);
        if (responseCard == null) {
            throw new AppointmentException("\u6ca1\u6709\u67e5\u8be2\u5230\u6302\u53f7\u8bb0\u5f55");
        }
        if (frontResponseCard == null) throw new AppointmentException("\u6ca1\u6709\u67e5\u8be2\u5230\u6302\u53f7\u8bb0\u5f55");
        ReponseRegisterRecordVo reponseRegisterRecordVo = (ReponseRegisterRecordVo)frontResponseCard.getBody();
        if (reponseRegisterRecordVo == null) throw new AppointmentException("\u6ca1\u6709\u67e5\u8be2\u5230\u6302\u53f7\u8bb0\u5f55");
        if (reponseRegisterRecordVo.getRegRecordList().size() <= 0) {
            throw new AppointmentException("\u6ca1\u6709\u67e5\u8be2\u5230\u6302\u53f7\u8bb0\u5f55");
        }
        RegRecord regRecord = (RegRecord)reponseRegisterRecordVo.getRegRecordList().get(0);
        appointmentRecordEntity.setAdmId(regRecord.getClinicNo());
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        return appointmentRecordEntity;
    }

    private FrontRequest<RequestRegDoctVo> buildDoctorInfo(AppointmentCreateOrderVoReq createOrderVoReq) {
        FrontRequest param = new FrontRequest();
        RequestRegDoctVo requestRegDoctVo = new RequestRegDoctVo();
        requestRegDoctVo.setDate(createOrderVoReq.getAdmDate());
        requestRegDoctVo.setPactCode("01");
        requestRegDoctVo.setTypeCodeList("1,2,3,4,5,6,7,8,9,10,11,12,13");
        requestRegDoctVo.setDeptCode(createOrderVoReq.getDeptCode());
        param.setBody((Object)requestRegDoctVo);
        param.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return param;
    }

    private void waitHisConfirm(ResponseNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity) {
        appointmentRecordEntity.setPayAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        appointmentRecordEntity.setPayPostId(responseNotifyRestVo.getMchId());
        appointmentRecordEntity.setPayTransationId(responseNotifyRestVo.getTradeNo());
        appointmentRecordEntity.setPayChannel(PayChannelEnum.getDisplay((String)responseNotifyRestVo.getPayChannel()));
        appointmentRecordEntity.setPayChannelCode(responseNotifyRestVo.getPayChannel());
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue());
        appointmentRecordEntity.setRemark(AppointmentStatusEnum.WAIT_HIS_CONFIRM.getDisplay());
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u6210\u529f\uff0c\u5f85his\u786e\u8ba4\uff1a" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    private void checkAppointmentInfo(AppointmentCreateOrderVoReq createOrderVoReq) throws AppointmentException {
        Integer appointmentCount = this.appointmentRecordMapper.selectPatientCurrentDateSameDeptValidAppointmentCount(createOrderVoReq.getHospitalCode(), createOrderVoReq.getPatientId(), createOrderVoReq.getDeptCode(), String.valueOf(LocalDate.now()));
        if (appointmentCount >= 1) {
            throw new AppointmentException("\u65e0\u6cd5\u9884\u7ea6, \u8be5\u5c31\u8bca\u4eba\u540c\u4e00\u79d1\u5ba4\u533b\u751f\u53ea\u80fd\u9884\u7ea6\u4e00\u4e2a");
        }
        Integer totalAppointmentCount = this.appointmentRecordMapper.selectPatientCurrentDateValidAppointCount(createOrderVoReq.getHospitalCode(), createOrderVoReq.getPatientId(), String.valueOf(LocalDate.now()));
        if (totalAppointmentCount >= 2) {
            throw new AppointmentException("\u65e0\u6cd5\u9884\u7ea6, \u8be5\u5c31\u8bca\u4eba\u4eca\u65e5\u9884\u7ea6\u6b21\u6570\u5df2\u8fbe\u4e0a\u9650(2\u6b21\u5305\u542b\u53d6\u6d88)");
        }
    }

    private GetScheduleResItems isHasAppointmentInfo(AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) throws AppointmentException {
        GatewayRequest gatewayRequest = this.buildScheduleGetwayRequest(appointmentCreateOrderVoReq);
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayRequest);
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(gatewayRequest);
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728 \u8bf7\u6c42his\u51fa\u53c2\uff1a" + gatewayResponse);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new AppointmentException(gatewayResponse.getMsg());
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (getScheduleResVO.getItems() == null || getScheduleResVO.getItems().isEmpty()) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new AppointmentException("\u6682\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        List scheduleResItemsList = getScheduleResVO.getItems();
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728\u8fc7\u6ee4\u524d\u533b\u751f\u6392\u73ed\uff1a" + scheduleResItemsList);
        scheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> appointmentCreateOrderVoReq.getScheduleHisId().equals(getScheduleResItems.getScheduleId())).collect(Collectors.toList());
        log.info("\u9884\u7ea6\u6302\u53f7\u521b\u5efa\u8ba2\u5355 \u67e5\u8be2\u53f7\u6e90\u662f\u5426\u5b58\u5728\u6839\u636e\u6392\u73edid\u8fc7\u6ee4\u51fa\u8be5\u533b\u751f\u6392\u73ed\uff1a" + scheduleResItemsList);
        if (CollectionUtils.isEmpty(scheduleResItemsList)) {
            return null;
        }
        return (GetScheduleResItems)scheduleResItemsList.get(0);
    }

    private GatewayRequest<GetScheduleReqVO> buildScheduleGetwayRequest(AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) {
        GatewayRequest gatewayReq = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(appointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setEdDate(appointmentCreateOrderVoReq.getAdmDate());
        getScheduleReqVO.setLocCode(appointmentCreateOrderVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(appointmentCreateOrderVoReq.getDocCode());
        gatewayReq.setBody((Object)getScheduleReqVO);
        gatewayReq.setChannelName(appointmentCreateOrderVoReq.getChannelName());
        gatewayReq.setChannel(appointmentCreateOrderVoReq.getChannelName());
        gatewayReq.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayReq.setKeyWord("appointmentCreateOrder");
        gatewayReq.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayReq;
    }

    private FrontRequest<RequestRegVo> buildConfirmRegisterReq(long sysAppointmentId, AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) {
        FrontRequest frontRequest = new FrontRequest();
        RequestRegVo requestRegVo = new RequestRegVo();
        requestRegVo.setCardNo(appointmentCreateOrderVoReq.getPatientCardNo());
        requestRegVo.setSchemaID(appointmentCreateOrderVoReq.getScheduleHisId());
        requestRegVo.setPactCode("01");
        requestRegVo.setUserID("002005");
        requestRegVo.setFlowNo(String.valueOf(sysAppointmentId));
        requestRegVo.setRegLv("\u65e0");
        requestRegVo.setPayMode("YZ");
        requestRegVo.setBankCode("Wechat");
        requestRegVo.setBankName("\u5fae\u4fe1");
        frontRequest.setBody((Object)requestRegVo);
        frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return frontRequest;
    }

    private GatewayRequest<ConfirmRegisterReq> buildDayConfirmRegisterReq(CardDetailsInfoRespVO cardDetail, long sysAppointmentId, DayAppointmentCreateOrderVoReq appointmentCreateOrderVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        ConfirmRegisterReq confirmRegisterReq = new ConfirmRegisterReq();
        confirmRegisterReq.setAppointType("1");
        confirmRegisterReq.setTradeId(String.valueOf(sysAppointmentId));
        confirmRegisterReq.setSchedId(appointmentCreateOrderVoReq.getScheduleHisId());
        if (StringUtils.isNotBlank((String)appointmentCreateOrderVoReq.getTimeArrange())) {
            String[] split = appointmentCreateOrderVoReq.getTimeArrange().split("-");
            confirmRegisterReq.setStartTime(split[0]);
            confirmRegisterReq.setEndTime(split[1]);
        }
        if (null != cardDetail) {
            confirmRegisterReq.setPatientId(cardDetail.getOrganPmi());
            confirmRegisterReq.setPhone(cardDetail.getTel());
            confirmRegisterReq.setCardNo(cardDetail.getCredNo());
        }
        gatewayRequest.setBody((Object)confirmRegisterReq);
        gatewayRequest.setChannelName(appointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setChannel(appointmentCreateOrderVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("appointmentCreateOrder");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private AppointmentRecordEntity buildSuccessAppointmentRecordEntity(long sysAppointmentId, ReponseRegVo reponseRegVo, AppointmentCreateOrderVoReq createOrderVoReq, DoctorVo doctorVo) {
        AppointmentRecordEntity appointmentRecordEntity = new AppointmentRecordEntity();
        appointmentRecordEntity.setScheduleType(createOrderVoReq.getAdmTimeRange());
        appointmentRecordEntity.setAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setAdmAddress(reponseRegVo.getSeeAddress());
        appointmentRecordEntity.setTakeAddress(reponseRegVo.getSeeAddress());
        appointmentRecordEntity.setTakeTime(createOrderVoReq.getAdmTimeRange());
        appointmentRecordEntity.setAdmTimeRange(createOrderVoReq.getTimeArrange());
        appointmentRecordEntity.setAppointmentNo(reponseRegVo.getSeeNO());
        appointmentRecordEntity.setAdmDate(createOrderVoReq.getAdmDate());
        appointmentRecordEntity.setAdmRange(Integer.parseInt(createOrderVoReq.getAdmTimeRange()));
        appointmentRecordEntity.setAppointmentTime(new Date());
        appointmentRecordEntity.setAppointmentType(createOrderVoReq.getAppointType().intValue());
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_PAY.getValue());
        appointmentRecordEntity.setCardId(createOrderVoReq.getCardId());
        appointmentRecordEntity.setChannelCode(createOrderVoReq.getChannelName());
        appointmentRecordEntity.setDeptCode(createOrderVoReq.getDeptCode());
        appointmentRecordEntity.setDeptName(createOrderVoReq.getLocName());
        appointmentRecordEntity.setDocCode(createOrderVoReq.getDocCode());
        appointmentRecordEntity.setDocName(createOrderVoReq.getDocName());
        appointmentRecordEntity.setHospitalCode(createOrderVoReq.getHospitalCode());
        appointmentRecordEntity.setHospitalName(createOrderVoReq.getHospitalName());
        appointmentRecordEntity.setInnerChannelCode("\u533b\u9662\u6e20\u9053\u7f16\u7801");
        appointmentRecordEntity.setKeepSource(new Byte("1"));
        appointmentRecordEntity.setPatientCardNo(createOrderVoReq.getPatientCardNo());
        appointmentRecordEntity.setPatientId(createOrderVoReq.getPatientId());
        appointmentRecordEntity.setPatientIdCard(createOrderVoReq.getIdNo());
        appointmentRecordEntity.setPatientName(createOrderVoReq.getPatientName());
        appointmentRecordEntity.setPatientPhone(createOrderVoReq.getPhone());
        appointmentRecordEntity.setPatientAge(IdCardUtil.getAgeByIdCard((String)createOrderVoReq.getIdNo()));
        appointmentRecordEntity.setPatientSex(IdCardUtil.getGenderByIdCard((String)createOrderVoReq.getIdNo()) == "M" ? 1 : 2);
        BigDecimal totalFee = new BigDecimal(doctorVo.getRegFee()).add(new BigDecimal(doctorVo.getDiagFee()));
        appointmentRecordEntity.setPayAmount(totalFee.toString());
        appointmentRecordEntity.setRegFee(new BigDecimal(doctorVo.getRegFee()));
        appointmentRecordEntity.setServiceFee(new BigDecimal("0"));
        appointmentRecordEntity.setScheduleHisId(createOrderVoReq.getScheduleHisId());
        appointmentRecordEntity.setSysAppointmentId(String.valueOf(sysAppointmentId));
        appointmentRecordEntity.setSysScheduleId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setSysTimeArrangeId(String.valueOf(this.snowflakeIdWorker.nextId()));
        appointmentRecordEntity.setUserId(createOrderVoReq.getUserId());
        appointmentRecordEntity.setRegTitleName(doctorVo.getReglevelName());
        appointmentRecordEntity.setScheduleLevelName(doctorVo.getReglevelName());
        appointmentRecordEntity.setHisTimeArrangeId(createOrderVoReq.getTimeArrangeId());
        appointmentRecordEntity.setRemark("\u9884\u7ea6\u6302\u53f7\u6210\u529f\uff0c\u5f85\u652f\u4ed8");
        return appointmentRecordEntity;
    }

    public AppointmentRecordEntity getAppointmentRecordBySysAppointmentId(String sysAppointmentId) {
        return this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
    }

    public AppointmentRecordEntity getAppointmentRecordByPkId(String ordeId) {
        return this.appointmentRecordMapper.selectByPkId(ordeId);
    }

    public void autoCancelDelayAppointment(UpdateDelayAppointmentRecordVoReq updateDelayAppointmentRecordVo) {
        this.appointmentRecordMapper.autoCancelDelayAppointment(updateDelayAppointmentRecordVo);
    }

    private void updatePayAppointmentRecord(UpdatePayAppointmentRecordVoReq updatePayAppointmentRecordVoReq) {
        this.appointmentRecordMapper.updatePayAppointmentRecord(updatePayAppointmentRecordVoReq);
    }

    private void updateDoDayRegisterRes(DoDayAppointmentDTO doDayAppointmentDTO) {
        this.appointmentRecordMapper.updateDoDayAppointmentRecord(doDayAppointmentDTO);
    }

    public BaseResponse<String> dayAppointmentPay(DayAppointmentPayVoReq dayAppointmentPayVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(dayAppointmentPayVoReq.getSysAppointmentId());
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
        }
        AppointmentPayVoReq appointmentPayVoReq = new AppointmentPayVoReq();
        appointmentPayVoReq.setMchCode(this.propertiesConstant.getMchCode());
        appointmentPayVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        appointmentPayVoReq.setPayChannel(dayAppointmentPayVoReq.getPayChannel());
        appointmentPayVoReq.setPayType(dayAppointmentPayVoReq.getPayType());
        appointmentPayVoReq.setProductInfo("\u9884\u7ea6\u6302\u53f7");
        appointmentPayVoReq.setServiceCode(ServiceCodeEnum.DAY_APPOINTMENT.getValue());
        appointmentPayVoReq.setActuallyAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentPayVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentPayVoReq.setUserSign(dayAppointmentPayVoReq.getOpenId());
        appointmentPayVoReq.setNonceStr(SignUtil.getNonceStr());
        appointmentPayVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        appointmentPayVoReq.setPayNotifyUrl(this.propertiesConstant.getDayPayNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)appointmentPayVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        appointmentPayVoReq.setSign(sign);
        BaseResponse baseResponse = this.payCreateOrder(appointmentPayVoReq);
        return baseResponse;
    }

    public BaseResponse<String> appointmentPay(DayAppointmentPayVoReq dayAppointmentPayVoReq) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(dayAppointmentPayVoReq.getSysAppointmentId());
        if (appointmentRecordEntity != null && AppointmentStatusEnum.CANCEL.getValue().equals(appointmentRecordEntity.getAppointStatus())) {
            return BaseResponse.error((String)"\u6b64\u72b6\u6001\u4e0d\u80fd\u652f\u4ed8,\u8bf7\u5237\u65b0\u67e5\u770b");
        }
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
        }
        AppointmentPayVoReq appointmentPayVoReq = new AppointmentPayVoReq();
        appointmentPayVoReq.setMchCode(this.propertiesConstant.getMchCode());
        appointmentPayVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        appointmentPayVoReq.setPayChannel(dayAppointmentPayVoReq.getPayChannel());
        appointmentPayVoReq.setPayType(dayAppointmentPayVoReq.getPayType());
        appointmentPayVoReq.setProductInfo("\u9884\u7ea6\u6302\u53f7");
        appointmentPayVoReq.setServiceCode(ServiceCodeEnum.APPOINTMENT.getValue());
        appointmentPayVoReq.setActuallyAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentPayVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        appointmentPayVoReq.setUserSign(dayAppointmentPayVoReq.getOpenId());
        appointmentPayVoReq.setNonceStr(SignUtil.getNonceStr());
        appointmentPayVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        appointmentPayVoReq.setPayNotifyUrl(this.propertiesConstant.getPayNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)appointmentPayVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        appointmentPayVoReq.setSign(sign);
        BaseResponse baseResponse = this.payCreateOrder(appointmentPayVoReq);
        return baseResponse;
    }

    private BaseResponse<String> payCreateOrder(AppointmentPayVoReq appointmentPayVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getPayUrl(), (String)JSON.toJSONString((Object)appointmentPayVoReq));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("baseResponse: " + baseResponse);
            return baseResponse;
        }
        catch (Exception e) {
            log.error("\u53d1\u8d77\u652f\u4ed8\u5931\u8d25" + e.getMessage());
            return BaseResponse.error((String)"\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
        }
    }

    private FrontRequest<RequestCardNoVo> buildPayRegistrationReq(AppointmentRecordEntity appointmentRecordEntity) {
        FrontRequest frontRequest = new FrontRequest();
        RequestCardNoVo requestCardNoVo = new RequestCardNoVo();
        requestCardNoVo.setCardNo(appointmentRecordEntity.getPatientCardNo() + "|" + appointmentRecordEntity.getSysAppointmentId());
        frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        frontRequest.setBody((Object)requestCardNoVo);
        return frontRequest;
    }

    private void updateScheduleSourceNo(GetScheduleResItems getScheduleResItems, AppointmentCreateOrderVoReq appointmentCreateOrderVoReq) {
        UpdateScheduleDetailDTO updateScheduleDetailDTO = new UpdateScheduleDetailDTO();
        ArrayList<String> timeArrangeIdList = new ArrayList<String>();
        updateScheduleDetailDTO.setHospitalCode(appointmentCreateOrderVoReq.getHospitalCode());
        updateScheduleDetailDTO.setScheduleId(getScheduleResItems.getScheduleId());
        for (TimeArrangeItems timeArrangeItems : getScheduleResItems.getTimeArrangeItems()) {
            timeArrangeIdList.add(timeArrangeItems.getTimeArrangeId());
        }
        String timeArrangeId = "'" + StringUtils.join(timeArrangeIdList, (String)"','") + "'";
        updateScheduleDetailDTO.setTimeArrangeId(timeArrangeId);
        this.scheduleDetailRecordMapper.updateByGetScheduleResItems(updateScheduleDetailDTO);
    }

    private void updateScheduleByDayAppointmentCreateOrderVoReq(DayAppointmentCreateOrderVoReq dayAppointmentCreateOrderVoReq) {
        this.scheduleRecordMapper.updateScheduleByDayAppointmentCreateOrderVoReq(dayAppointmentCreateOrderVoReq);
    }

    private GatewayRequest<GetScheduleReqVO> buildConfirmScheduleGetwayRequest(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayReq = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(confirmAppointmentVo.getAdmDate());
        getScheduleReqVO.setEdDate(confirmAppointmentVo.getAdmDate());
        getScheduleReqVO.setLocCode(confirmAppointmentVo.getLocCode());
        getScheduleReqVO.setDocCode(confirmAppointmentVo.getDocCode());
        gatewayReq.setBody((Object)getScheduleReqVO);
        gatewayReq.setChannelName(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setChannel(ChannelEnum.USER_APPLETS.getValue());
        gatewayReq.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayReq.setKeyWord("confirmAppointmentVo");
        gatewayReq.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayReq;
    }

    private List<GetScheduleResItems> getHisDaySchedule(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayRequest = this.buildConfirmScheduleGetwayRequest(confirmAppointmentVo);
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(gatewayRequest);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetScheduleResItems>();
        }
        List<GetScheduleResItems> getScheduleResItemsList = ((GetScheduleResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return new ArrayList<GetScheduleResItems>();
        }
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getScheduleId().equals(confirmAppointmentVo.getScheduleHisId())).collect(Collectors.toList());
        return getScheduleResItemsList;
    }

    private List<GetScheduleResItems> getHisSchedule(ConfirmAppointmentVo confirmAppointmentVo) {
        GatewayRequest gatewayRequest = this.buildConfirmScheduleGetwayRequest(confirmAppointmentVo);
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(gatewayRequest);
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetScheduleResItems>();
        }
        List<GetScheduleResItems> getScheduleResItemsList = ((GetScheduleResVO)gatewayResponse.getData()).getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return new ArrayList<GetScheduleResItems>();
        }
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getAdmTimeRange().equals(confirmAppointmentVo.getAdmTimeRange())).collect(Collectors.toList());
        return getScheduleResItemsList;
    }

    private ConfirmAppointmentVo buildConfirmAppointmentVo(GetScheduleResItems getScheduleResItems, ConfirmAppointmentVo confirmAppointVo) {
        ConfirmAppointmentVo confirmAppointmentVo = new ConfirmAppointmentVo();
        confirmAppointmentVo.setDoctorHeadPortrait(confirmAppointVo.getDoctorHeadPortrait());
        confirmAppointmentVo.setAdmDate(confirmAppointVo.getAdmDate());
        confirmAppointmentVo.setAdmTimeRange(confirmAppointVo.getAdmTimeRange());
        confirmAppointmentVo.setDocCode(confirmAppointVo.getDocCode());
        confirmAppointmentVo.setDocName(confirmAppointVo.getDocName());
        confirmAppointmentVo.setHospitalName(confirmAppointVo.getHospitalName());
        confirmAppointmentVo.setIsAppend(confirmAppointVo.getIsAppend());
        confirmAppointmentVo.setIsTimeArrange(confirmAppointVo.getIsTimeArrange());
        confirmAppointmentVo.setLocCode(confirmAppointVo.getLocCode());
        confirmAppointmentVo.setLocName(confirmAppointVo.getLocName());
        confirmAppointmentVo.setRegFee(getScheduleResItems.getRegFee());
        confirmAppointmentVo.setDiagFee(getScheduleResItems.getDiagFee());
        confirmAppointmentVo.setTotalFee(confirmAppointVo.getTotalFee());
        confirmAppointmentVo.setRegTitleCode(confirmAppointVo.getRegTitleCode());
        confirmAppointmentVo.setRegTitleName(confirmAppointVo.getRegTitleName());
        confirmAppointmentVo.setScheduleHisId(confirmAppointVo.getScheduleHisId());
        confirmAppointmentVo.setScheduleLevelName(confirmAppointVo.getScheduleLevelName());
        List timeArrangeItemsList = getScheduleResItems.getTimeArrangeItems();
        if (CollectionUtils.isEmpty((Collection)timeArrangeItemsList)) {
            confirmAppointmentVo.setTimeArrangeItems(new ArrayList());
        }
        confirmAppointmentVo.setTimeArrangeItems(timeArrangeItemsList);
        return confirmAppointmentVo;
    }

    public BaseResponse<String> appointmentRefund(String sysAppointmentId) {
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(sysAppointmentId);
        if (null == appointmentPayorderEntity || null == appointmentRecordEntity) {
            return BaseResponse.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        if (!WAIT_CONFIRMED_BACK.contains((int)appointmentRecordEntity.getAppointStatus())) {
            return BaseResponse.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u80fd\u9000\u6b3e\uff01");
        }
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeq());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9000\u6b3e\u5931\u8d25");
        }
        int appointmentType = appointmentRecordEntity.getAppointmentType();
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(appointmentPayorderEntity.getDealSeq());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        requestRefundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)requestRefundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        requestRefundOrderVoReq.setSign(sign);
        BaseResponse baseResponse = this.refund(requestRefundOrderVoReq);
        if ("1".equals(baseResponse.getCode())) {
            try {
                this.callbackNumber(appointmentRecordEntity);
            }
            catch (AppointmentException e) {
                e.printStackTrace();
            }
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getValue());
            appointmentRecordEntity.setRemark(AppointmentStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getDisplay());
            this.appointmentRecordMapper.updateByPrimaryKey(appointmentRecordEntity);
        } else {
            BaseResponse.error((String)"\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        return BaseResponse.success((Object)"\u53d1\u8d77\u9000\u6b3e\u6210\u529f");
    }

    public void unLock(CancelRegisterReq cancelAppointmentVoReq) {
        log.info("\u6267\u884c\u53d6\u6d88\u9501\u53f7------>{}", (Object)cancelAppointmentVoReq);
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setBody((Object)cancelAppointmentVoReq);
        gatewayRequest.setKeyWord("unLockRegister");
        gatewayRequest.setChannel(ChannelEnum.USER_APPLETS.getValue());
        gatewayRequest.setChannelName(ChannelEnum.USER_APPLETS.getValue());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u3010\u53d6\u6d88\u9501\u53f7\u3011\u8bf7\u6c42\u53c2\u6570 gatewayRequest: " + JSON.toJSONString((Object)gatewayRequest));
        Object gatewayResponse = null;
        log.info("\u3010\u53d6\u6d88\u9501\u53f7\u3011\u8fd4\u56de\u53c2\u6570 gatewayResponse:" + JSON.toJSONString(gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u53d6\u6d88\u9501\u53f7 unLockRegister -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u53d6\u6d88\u9501\u53f7 unLockRegister -> his\u8bf7\u6c42\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
        }
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }

    private void checkRegistBase(String idNo, String deptCode) throws AppointmentException {
        Period period = Period.between(LocalDate.parse(IdCardUtil.getBirthByIdCard((String)idNo), DateTimeFormatter.ofPattern("yyyyMMdd")), LocalDate.now());
        if ("10248".equals(deptCode)) {
            if (period.getYears() == 0 && period.getMonths() <= 7) {
                return;
            }
            throw new AppointmentException("\u60a8\u4e0d\u7b26\u5408\u65b0\u751f\u513f\u95e8\u8bca\u6302\u53f7\u6761\u4ef6(\u5c0f\u4e8e7\u4e2a\u6708)\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u79d1\u5ba4\u6302\u53f7\u3002\u8c22\u8c22\uff01");
        }
        List<String> pediatricList = Arrays.asList("1009", "1087", "10244");
        if (pediatricList.contains(deptCode)) {
            if (period.getYears() > 14) {
                throw new AppointmentException("\u60a8\u4e0d\u7b26\u5408\u513f\u79d1\u6302\u53f7\u6761\u4ef6(\u5c0f\u4e8e14\u5c81)\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u79d1\u5ba4\u6302\u53f7\u3002\u8c22\u8c22\uff01");
            }
            return;
        }
        List<String> gynaecologyList = Arrays.asList("1010", "1011", "10177", "1092", "1083");
        if (gynaecologyList.contains(deptCode)) {
            String gender = IdCardUtil.getGenderByIdCard((String)idNo);
            if ("M".equals(gender)) {
                throw new AppointmentException("\u60a8\u4e0d\u7b26\u5408\u5987\u4ea7\u79d1\u6302\u53f7\u6761\u4ef6(\u4ec5\u9650\u5973\u6027)\uff0c\u8bf7\u9009\u62e9\u5176\u4ed6\u79d1\u5ba4\u6539\u6210\u9009\u62e9\u5176\u4ed6\u5c31\u8bca\u4eba\uff01");
            }
            return;
        }
    }
}

