/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.doctoruser.api.pojo.base.dto.OrganIdReq;
import com.doctoruser.api.pojo.base.entity.DepartmentEntity;
import com.doctoruser.api.pojo.base.vo.doctor.OrganDeptInfoVO;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.schedule.items.TimeArrangeItems;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DeptCategoryMapper;
import com.ebaiyihui.wisdommedical.mapper.DeptRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalAreaRecordMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.HospitalAreaRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.RequestRegDoctDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDeptListVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.HospitalDeptVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ReponseRegDoctVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ReponseRegLvVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRegDoctVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleBaseInfoVo;
import com.ebaiyihui.wisdommedical.service.DepartmentService;
import com.ebaiyihui.wisdommedical.util.GetDoctorInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.io.IOException;
import java.math.BigDecimal;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class DepartmentServiceImpl
implements DepartmentService {
    private static final Logger log = LoggerFactory.getLogger(DepartmentServiceImpl.class);
    public static final String POP_DEPT = "\u63a8\u8350\u79d1\u5ba4";
    public static final int ALREADY_VISITING = 1;
    public static final int NOT_VISITING = 0;
    public static final String[] NOT_INCLUDED_DEPT = new String[]{"\u5f85\u5212\u5206", "\u65b0\u7684\u79d1\u5ba4", "ceshi\u79d1\u5ba4", "\u63a8\u8350\u79d1\u5ba4"};
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private DeptCategoryMapper deptCategoryMapper;
    @Autowired
    private DeptRecordMapper deptRecordMapper;
    @Autowired
    private GetDoctorInfoUtil getDoctorInfoUtil;
    @Autowired
    private StringRedisTemplate redisTemplate;
    private static int RECENT_SEARCH_RECORD_SIZE = 5;
    @Autowired
    private ProPropertiesConstant projProperties;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private HospitalAreaRecordMapper hospitalAreaRecordMapper;

    public List<GetDeptListVoRes> getDeptList(String organCode, String userId, String hospitalId) throws AppointmentException {
        ArrayList<GetDeptListVoRes> getDeptListVoResList = new ArrayList<GetDeptListVoRes>();
        List organDeptInfoVOList = this.getOrganDeptList(hospitalId, organCode);
        List departmentEntityList = this.getPopOrganDept(hospitalId);
        GetDeptListVoRes deptListVoRes = new GetDeptListVoRes();
        deptListVoRes.setFirstDepName(POP_DEPT);
        List appointmentRecordEntityList = this.appointmentRecordMapper.selectByUserIdAndOrganCode(userId, organCode);
        appointmentRecordEntityList = appointmentRecordEntityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<AppointmentRecordEntity>(Comparator.comparing(AppointmentRecordEntity::getDeptName))), ArrayList::new));
        List visitingDeptCodeList = appointmentRecordEntityList.stream().map(AppointmentRecordEntity::getDeptCode).collect(Collectors.toList());
        List hospitalDeptVoList = appointmentRecordEntityList.stream().map(appointmentRecordEntity -> {
            HospitalDeptVo hospitalDeptVo = new HospitalDeptVo();
            hospitalDeptVo.setHospitalDepCode(appointmentRecordEntity.getDeptCode());
            hospitalDeptVo.setHospitalDepName(appointmentRecordEntity.getDeptName());
            hospitalDeptVo.setVisiting(1);
            return hospitalDeptVo;
        }).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty((Collection)departmentEntityList)) {
            hospitalDeptVoList.addAll(this.getHospitalDeptVo(visitingDeptCodeList, departmentEntityList));
            hospitalDeptVoList = hospitalDeptVoList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<HospitalDeptVo>(Comparator.comparing(HospitalDeptVo::getHospitalDepCode))), ArrayList::new));
            deptListVoRes.setHospitalDepVoResList(hospitalDeptVoList);
        } else {
            deptListVoRes.setHospitalDepVoResList(hospitalDeptVoList);
        }
        getDeptListVoResList.add(deptListVoRes);
        if (!CollectionUtils.isEmpty((Collection)organDeptInfoVOList)) {
            organDeptInfoVOList.forEach(organDeptInfoVO -> {
                GetDeptListVoRes getDeptListVoRes = new GetDeptListVoRes();
                getDeptListVoRes.setFirstDepName(organDeptInfoVO.getFirstStandDeptName());
                getDeptListVoRes.setFirstDepId(organDeptInfoVO.getFirstStandDeptId());
                getDeptListVoRes.setHospitalDepVoResList(this.getHospitalDeptVo(visitingDeptCodeList, organDeptInfoVO.getDepartmentEntities()));
                getDeptListVoResList.add(getDeptListVoRes);
            });
        }
        if (CollectionUtils.isEmpty(getDeptListVoResList)) {
            return new ArrayList<GetDeptListVoRes>();
        }
        List<GetDeptListVoRes> deptListVoResList = getDeptListVoResList.stream().filter(getDeptListVoRes -> !Arrays.asList(NOT_INCLUDED_DEPT).contains(getDeptListVoRes.getFirstDepName())).collect(Collectors.toList());
        deptListVoResList = deptListVoResList.stream().filter(departmentEntity -> !CollectionUtils.isEmpty((Collection)departmentEntity.getHospitalDepVoResList())).collect(Collectors.toList());
        return deptListVoResList;
    }

    public List<GetDeptListVoRes> getDeptList(String organCode, String userId) throws AppointmentException {
        List<Object> getDeptListVoResList = new ArrayList();
        List firstDeptList = this.deptCategoryMapper.selectAllDept();
        if (CollectionUtils.isEmpty((Collection)firstDeptList)) {
            log.error("*****************\u4e00\u7ea7\u79d1\u5ba4\u672a\u914d\u7f6e***************");
            return new ArrayList<GetDeptListVoRes>();
        }
        List secondDeptList = this.deptRecordMapper.selectListByHospitalCode(organCode);
        if (CollectionUtils.isEmpty((Collection)secondDeptList)) {
            log.error("*****************\u672a\u67e5\u8be2\u5230\u533b\u9662\u79d1\u5ba4\u4fe1\u606f***************");
            return new ArrayList<GetDeptListVoRes>();
        }
        List deptListFilter = secondDeptList.stream().filter(deptRecordEntity -> !StringUtils.isEmpty((Object)deptRecordEntity.getFirstDeptId())).collect(Collectors.toList());
        List appointmentRecordEntityList = this.appointmentRecordMapper.selectByUserIdAndOrganCode(userId, organCode);
        appointmentRecordEntityList = appointmentRecordEntityList.stream().collect(Collectors.collectingAndThen(Collectors.toCollection(() -> new TreeSet<AppointmentRecordEntity>(Comparator.comparing(AppointmentRecordEntity::getDeptName))), ArrayList::new));
        List visitingDeptCodeList = appointmentRecordEntityList.stream().map(AppointmentRecordEntity::getDeptCode).collect(Collectors.toList());
        getDeptListVoResList = firstDeptList.stream().map(deptCategoryEntity -> {
            GetDeptListVoRes getDeptListVoRes = new GetDeptListVoRes();
            getDeptListVoRes.setFirstDepId(deptCategoryEntity.getDeptCategoryCode());
            getDeptListVoRes.setFirstDepName(deptCategoryEntity.getDeptCategoryName());
            List deptList = deptListFilter.stream().filter(deptRecordEntity -> deptRecordEntity.getFirstDeptId().equals(deptCategoryEntity.getId())).collect(Collectors.toList());
            List hospitalDeptVoList = deptList.stream().map(deptRecordEntity -> {
                HospitalDeptVo hospitalDeptVo = new HospitalDeptVo();
                String deptCode = deptRecordEntity.getDeptCode();
                hospitalDeptVo.setHospitalDepCode(deptCode);
                hospitalDeptVo.setHospitalDepName(deptRecordEntity.getDeptName());
                if (!CollectionUtils.isEmpty((Collection)visitingDeptCodeList) && visitingDeptCodeList.contains(deptCode)) {
                    hospitalDeptVo.setVisiting(1);
                } else {
                    hospitalDeptVo.setVisiting(0);
                }
                return hospitalDeptVo;
            }).collect(Collectors.toList());
            getDeptListVoRes.setHospitalDepVoResList(hospitalDeptVoList);
            return getDeptListVoRes;
        }).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(getDeptListVoResList)) {
            return new ArrayList<GetDeptListVoRes>();
        }
        List<GetDeptListVoRes> deptListVoResList = getDeptListVoResList.stream().filter(getDeptListVoRes -> !Arrays.asList(NOT_INCLUDED_DEPT).contains(getDeptListVoRes.getFirstDepName())).collect(Collectors.toList());
        deptListVoResList = deptListVoResList.stream().filter(departmentEntity -> !CollectionUtils.isEmpty((Collection)departmentEntity.getHospitalDepVoResList())).collect(Collectors.toList());
        return deptListVoResList;
    }

    private List<HospitalDeptVo> getHospitalDeptVo(List<String> visitingDeptCodeList, List<DepartmentEntity> departmentEntityList) {
        ArrayList<HospitalDeptVo> hospitalDeptVoList = new ArrayList<HospitalDeptVo>();
        if (CollectionUtils.isEmpty(departmentEntityList)) {
            return hospitalDeptVoList;
        }
        return departmentEntityList.stream().map(departmentEntity -> {
            HospitalDeptVo hospitalDepVo = new HospitalDeptVo();
            String deptCode = departmentEntity.getDeptCode();
            hospitalDepVo.setHospitalDepCode(deptCode);
            hospitalDepVo.setHospitalDepName(departmentEntity.getDeptName());
            if (!CollectionUtils.isEmpty((Collection)visitingDeptCodeList) && visitingDeptCodeList.contains(deptCode)) {
                hospitalDepVo.setVisiting(1);
            } else {
                hospitalDepVo.setVisiting(0);
            }
            hospitalDeptVoList.add(hospitalDepVo);
            return hospitalDepVo;
        }).collect(Collectors.toList());
    }

    private List<DepartmentEntity> getPopOrganDept(String organId) throws AppointmentException {
        List departmentEntityList = this.getDoctorInfoUtil.getHotDepartmentList(organId);
        return departmentEntityList;
    }

    private List<OrganDeptInfoVO> getOrganDeptList(String organId, String organCode) throws AppointmentException {
        OrganIdReq organIdReq = new OrganIdReq();
        organIdReq.setOrganId(organId);
        organIdReq.setOrganCode(organCode);
        List organDeptInfoVOList = this.getDoctorInfoUtil.getListOrganDept(organIdReq);
        return organDeptInfoVOList;
    }

    public void saveSearchRecord(String organCode, String userId, String keyword) throws AppointmentException {
        String redisKey = organCode + userId;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        zSetOperations.add((Object)redisKey, (Object)keyword, (double)System.currentTimeMillis());
        log.info("\u3010redis\u5b58\u50a8\u79d1\u5ba4\u641c\u7d22\u8bb0\u5f55\u3011key:{}, value:{}", (Object)redisKey, (Object)keyword);
        Long size = zSetOperations.size((Object)redisKey);
        if (size > (long)RECENT_SEARCH_RECORD_SIZE) {
            zSetOperations.removeRange((Object)redisKey, 0L, size - (long)RECENT_SEARCH_RECORD_SIZE - 1L);
        }
        this.redisTemplate.expire((Object)redisKey, 30L, TimeUnit.DAYS);
    }

    public List<HospitalDeptVo> searchDept(String organCode, String userId, String key) throws AppointmentException {
        this.saveSearchRecord(organCode, userId, key);
        List list = this.deptRecordMapper.selectByNameAndHospitalCode(organCode, key);
        return list;
    }

    public List<String> getRecentSearchDeptList(String organCode, String userId) throws AppointmentException {
        ArrayList<String> list = new ArrayList<String>();
        String key = organCode + userId;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        Set range = zSetOperations.reverseRangeWithScores((Object)key, 0L, (long)(RECENT_SEARCH_RECORD_SIZE - 1));
        log.info("\u3010redis\u83b7\u53d6\u79d1\u5ba4\u641c\u7d22\u8bb0\u5f55\u3011key:{}, object:{} ", (Object)key, (Object)JSON.toJSONString((Object)range));
        for (ZSetOperations.TypedTuple tuple : range) {
            list.add((String)tuple.getValue());
        }
        return list;
    }

    public void deleteOneSearchRecord(String organCode, String userId, String keyword) throws AppointmentException {
        String key = organCode + userId;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        zSetOperations.remove((Object)key, new Object[]{keyword});
        log.info("\u3010redis\u5220\u9664\u6307\u5b9a\u79d1\u5ba4\u641c\u7d22\u5386\u53f2\u8bb0\u5f55\u3011key:{}, value:{} ", (Object)key, (Object)keyword);
    }

    public void deleteAllSearchRecords(String organCode, String userId) throws AppointmentException {
        String key = organCode + userId;
        ZSetOperations zSetOperations = this.redisTemplate.opsForZSet();
        zSetOperations.removeRange((Object)key, 0L, (long)(RECENT_SEARCH_RECORD_SIZE - 1));
        log.info("\u3010redis\u5220\u9664\u6240\u6709\u79d1\u5ba4\u641c\u7d22\u5386\u53f2\u8bb0\u5f55\u3011key:{}", (Object)key);
    }

    public ReponseRegLvVo registerLevel() {
        ReponseRegLvVo reponseRegLvVo = null;
        try {
            String response = HttpKit.get((String)(this.projProperties.getHisFrontUrl() + "appoint/register/level"));
            log.info("\u83b7\u53d6\u79d1\u5ba4\u6392\u73ed\u8bf7\u6c42\u53c2\u6570:{}\uff0c\u8fd4\u56de\u7ed3\u679c{}", null, (Object)response);
            FrontResponse frontResponse = (FrontResponse)JSON.parseObject((String)response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            reponseRegLvVo = (ReponseRegLvVo)frontResponse.getBody();
        }
        catch (KeyManagementException e) {
            e.printStackTrace();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchProviderException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        return reponseRegLvVo;
    }

    public List<GetScheduleVoRes> getDeptDoctor(RequestRegDoctDTO requestRegDoctDTO) {
        FrontRequest param = new FrontRequest();
        RequestRegDoctVo requestRegDoctVo = RequestRegDoctVo.builder().deptCode(requestRegDoctDTO.getDeptCode()).date(requestRegDoctDTO.getDate()).pactCode(requestRegDoctDTO.getPactCode()).typeCodeList(requestRegDoctDTO.getTypeCodeList()).build();
        param.setBody((Object)requestRegDoctVo);
        param.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        ReponseRegDoctVo body = null;
        try {
            String response = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "schedule/getDeptDoctor"), (String)JSON.toJSONString((Object)param));
            log.info("\u83b7\u53d6\u79d1\u5ba4\u6392\u73ed\u8bf7\u6c42\u53c2\u6570:{}\uff0c\u8fd4\u56de\u7ed3\u679c{}", (Object)param, (Object)response);
            FrontResponse frontResponse = (FrontResponse)JSON.parseObject((String)response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
            if (!"1".equals(frontResponse.getCode())) {
                return new ArrayList<GetScheduleVoRes>();
            }
            body = (ReponseRegDoctVo)frontResponse.getBody();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        ArrayList<GetScheduleVoRes> reList = new ArrayList<GetScheduleVoRes>();
        if ("1".equals(body.getResult())) {
            ArrayList getDeptListVoResList = new ArrayList();
            HospitalAreaRecordEntity hospitalAreaRecordEntity = this.hospitalAreaRecordMapper.selectOneByhospitalCode("130212");
            body.getDoctor().forEach(a -> {
                GetScheduleVoRes getScheduleVoRes = new GetScheduleVoRes();
                if (hospitalAreaRecordEntity != null) {
                    getScheduleVoRes.setHospitalAreaCode(hospitalAreaRecordEntity.getHospitalAreaCode());
                    getScheduleVoRes.setHospitalArea(hospitalAreaRecordEntity.getHospitalAreaName());
                }
                getScheduleVoRes.setDocCode(a.getDoctorCode());
                getScheduleVoRes.setDocName(a.getDoctorName());
                getScheduleVoRes.setLocCode(a.getDeptCode());
                getScheduleVoRes.setLocName(a.getDeptName());
                getScheduleVoRes.setAdmLocation("");
                getScheduleVoRes.setRegTitleCode(a.getReglevelCode());
                getScheduleVoRes.setRegTitleName(a.getReglevelName());
                Integer appointmentCount = this.appointmentRecordMapper.selectDoctorAppointmentCount(getScheduleVoRes.getDocCode(), hospitalAreaRecordEntity.getHospitalCode());
                getScheduleVoRes.setAppointmentCount(appointmentCount);
                ArrayList<ScheduleBaseInfoVo> scheduleBaseInfoVoList = new ArrayList<ScheduleBaseInfoVo>();
                ScheduleBaseInfoVo scheduleBaseInfoVo = new ScheduleBaseInfoVo();
                scheduleBaseInfoVo.setScheduleId(a.getSchemaID());
                scheduleBaseInfoVo.setScheduleType(Integer.valueOf(1));
                scheduleBaseInfoVo.setAdmDate(a.getBeginTime());
                scheduleBaseInfoVo.setAdmTimeRange(a.getNoon());
                scheduleBaseInfoVo.setRegFee(a.getRegFee());
                scheduleBaseInfoVo.setDiagFee(a.getDiagFee());
                scheduleBaseInfoVo.setCheckFee(a.getCheckFee());
                scheduleBaseInfoVo.setOtherFee(a.getOtherFee());
                BigDecimal totalFee = new BigDecimal(a.getRegFee()).add(new BigDecimal(a.getDiagFee())).add(new BigDecimal(a.getCheckFee())).add(new BigDecimal(a.getOtherFee()));
                scheduleBaseInfoVo.setTotalFee(totalFee.toString());
                scheduleBaseInfoVo.setIsAppend("1");
                scheduleBaseInfoVo.setScheduleLevelCode(a.getReglevelCode());
                scheduleBaseInfoVo.setScheduleLevelName(a.getReglevelName());
                scheduleBaseInfoVo.setLocTypeCode(a.getDeptCode());
                scheduleBaseInfoVo.setLocTypeName(a.getDeptName());
                scheduleBaseInfoVo.setRegAvailable(Integer.valueOf(100));
                scheduleBaseInfoVo.setRegTotal(Integer.valueOf(100));
                scheduleBaseInfoVo.setAppStartNo("1");
                scheduleBaseInfoVo.setScheduleStatus("0");
                scheduleBaseInfoVo.setIsTimeArrange(Integer.valueOf(0));
                scheduleBaseInfoVo.setReplaceScheduleId(a.getSchemaID());
                ArrayList<TimeArrangeItems> timeArrangeItems = new ArrayList<TimeArrangeItems>();
                TimeArrangeItems timeArrangeItems1 = new TimeArrangeItems();
                timeArrangeItems1.setStartNo(Integer.valueOf(1));
                timeArrangeItems1.setEndNo(Integer.valueOf(100));
                timeArrangeItems1.setStartTime(this.dateFormat(a.getBeginTime()));
                timeArrangeItems1.setEndTime(this.dateFormat(a.getEndTime()));
                timeArrangeItems1.setTimeArrangeId("1");
                timeArrangeItems1.setAvailablNo(scheduleBaseInfoVo.getRegAvailable().toString());
                timeArrangeItems1.setTotalNo(scheduleBaseInfoVo.getRegTotal().toString());
                timeArrangeItems.add(timeArrangeItems1);
                scheduleBaseInfoVo.setTimeArrangeItems(timeArrangeItems);
                scheduleBaseInfoVoList.add(scheduleBaseInfoVo);
                getScheduleVoRes.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
                getDeptListVoResList.add(getScheduleVoRes);
            });
            Map<String, List<GetScheduleVoRes>> getScheduleResItemMap = getDeptListVoResList.stream().collect(Collectors.groupingBy(GetScheduleVoRes::getDocCode));
            Set<Map.Entry<String, List<GetScheduleVoRes>>> entries = getScheduleResItemMap.entrySet();
            for (Map.Entry<String, List<GetScheduleVoRes>> entry : entries) {
                if (entry.getValue().size() > 1) {
                    GetScheduleVoRes getScheduleVoRes = new GetScheduleVoRes();
                    BeanUtils.copyProperties((Object)entry.getValue().get(0), (Object)getScheduleVoRes);
                    getScheduleVoRes.setScheduleBaseInfoVoList(new ArrayList());
                    List<GetScheduleVoRes> list = entry.getValue();
                    ArrayList scheduleBaseInfoVoList = new ArrayList();
                    for (GetScheduleVoRes ent : list) {
                        scheduleBaseInfoVoList.add(ent.getScheduleBaseInfoVoList().get(0));
                    }
                    getScheduleVoRes.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
                    reList.add(getScheduleVoRes);
                    continue;
                }
                reList.add(entry.getValue().get(0));
            }
        }
        return reList;
    }

    public String dateFormat(String date) {
        if (StringUtils.isEmpty((Object)date)) {
            return date;
        }
        String strDateFormat = "HH:mm";
        SimpleDateFormat f = new SimpleDateFormat(strDateFormat);
        return f.format(new Date(date));
    }
}

