/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.ebaiyihui.wisdommedical.common.enums.AdmTimeRangeEnum;
import com.ebaiyihui.wisdommedical.exception.DoctorScheduleException;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleDetailRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.DocScheduleByDeptVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.DocScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.TimeFrameItemVo;
import com.ebaiyihui.wisdommedical.service.DoctorScheduleService;
import com.ebaiyihui.wisdommedical.service.DoctorService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DoctorScheduleServiceImpl
implements DoctorScheduleService {
    private static final Logger log = LoggerFactory.getLogger(DoctorScheduleServiceImpl.class);
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private DoctorService doctorService;

    public List<DocScheduleByDeptVoRes> getDoctorScheduleVoRes(String organCode, String doctorId) throws DoctorScheduleException {
        DoctorRecordEntity doctorRecordEntity = this.doctorService.getDoctorRecordEntity(doctorId, organCode);
        if (null == doctorRecordEntity || StringUtils.isEmpty((String)doctorRecordEntity.toString())) {
            log.info("\u6ca1\u6709\u627e\u5230\u8be5\u533b\u9662\u8be5\u533b\u751fid \u7684\u533b\u751f\u7f16\u53f7: doctorId:{},organCode:{}", (Object)doctorId, (Object)organCode);
            return null;
        }
        Integer allowDays = 7;
        String scheduleDate = DateUtils.getCurrentDate((String)"yyyy-MM-dd");
        ArrayList<Object> getDoctorScheduleVoResList = new ArrayList<Object>();
        for (int i = 0; i < allowDays; ++i) {
            DocScheduleVoRes doctorScheduleVoRes = this.getGetDoctorScheduleVoResList(organCode, doctorRecordEntity.getDocCode(), scheduleDate);
            if (null == doctorScheduleVoRes) {
                scheduleDate = DateUtils.getNextDayToString((String)scheduleDate);
                continue;
            }
            scheduleDate = DateUtils.getNextDayToString((String)scheduleDate);
            getDoctorScheduleVoResList.add(doctorScheduleVoRes);
        }
        HashMap map = new HashMap();
        for (DocScheduleVoRes docScheduleVoRes : getDoctorScheduleVoResList) {
            String dept = docScheduleVoRes.getDeptName();
            if (map.containsKey(dept)) {
                ((List)map.get(dept)).add(docScheduleVoRes);
                continue;
            }
            ArrayList<DocScheduleVoRes> list = new ArrayList<DocScheduleVoRes>();
            list.add(docScheduleVoRes);
            map.put(dept, list);
        }
        ArrayList<DocScheduleByDeptVoRes> docScheduleByDeptVoResList = new ArrayList<DocScheduleByDeptVoRes>();
        for (Map.Entry entry : map.entrySet()) {
            DocScheduleByDeptVoRes docScheduleByDeptVoRes = new DocScheduleByDeptVoRes();
            docScheduleByDeptVoRes.setDeptName((String)entry.getKey());
            docScheduleByDeptVoRes.setDocScheduleVoResList((List)entry.getValue());
            docScheduleByDeptVoResList.add(docScheduleByDeptVoRes);
        }
        return docScheduleByDeptVoResList;
    }

    private TimeFrameItemVo getTimeFrameItemVo(String organCode, ScheduleRecordEntity scheduleRecordEntity) throws DoctorScheduleException {
        TimeFrameItemVo timeFrameItemVo = new TimeFrameItemVo();
        List detailRecordEntityList = this.scheduleDetailRecordMapper.selectByHisScheduleId(scheduleRecordEntity.getScheduleHisId(), organCode);
        Integer available = 0;
        if (null == detailRecordEntityList || detailRecordEntityList.isEmpty()) {
            if (scheduleRecordEntity.getScheduleRange().byteValue() == AdmTimeRangeEnum.MORNING.getValue().byteValue()) {
                timeFrameItemVo.setStartTime("08:00");
                timeFrameItemVo.setEndTime("12:00");
            } else if (scheduleRecordEntity.getScheduleRange().byteValue() == AdmTimeRangeEnum.AFTERNOON.getValue().byteValue()) {
                timeFrameItemVo.setStartTime("13:00");
                timeFrameItemVo.setEndTime("17:00");
            } else if (scheduleRecordEntity.getScheduleRange().byteValue() == AdmTimeRangeEnum.ALL_DAY.getValue().byteValue()) {
                timeFrameItemVo.setStartTime("08:00");
                timeFrameItemVo.setEndTime("17:00");
            } else if (scheduleRecordEntity.getScheduleRange().byteValue() == AdmTimeRangeEnum.NIGHT.getValue().byteValue()) {
                timeFrameItemVo.setStartTime("18:00");
                timeFrameItemVo.setEndTime("21:00");
            }
        } else {
            String startTime = ((ScheduleDetailRecordEntity)detailRecordEntityList.get(0)).getStartTime();
            String endTime = ((ScheduleDetailRecordEntity)detailRecordEntityList.get(detailRecordEntityList.size() - 1)).getEndTime();
            timeFrameItemVo.setStartTime(startTime);
            timeFrameItemVo.setEndTime(endTime);
        }
        BigDecimal totalFee = scheduleRecordEntity.getRegFee().add(scheduleRecordEntity.getDiagFee());
        timeFrameItemVo.setRegFee(totalFee.toString());
        timeFrameItemVo.setRegAvailable(scheduleRecordEntity.getAvailableCount());
        timeFrameItemVo.setAdmTimeRange(scheduleRecordEntity.getScheduleRange().toString());
        timeFrameItemVo.setScheduleLevelName(scheduleRecordEntity.getScheduleLevel());
        return timeFrameItemVo;
    }

    private DocScheduleVoRes getGetDoctorScheduleVoResList(String organCode, String docCode, String scheduleDate) throws DoctorScheduleException {
        DocScheduleVoRes doctorScheduleVoRes = new DocScheduleVoRes();
        ArrayList<TimeFrameItemVo> listTimeFrame = new ArrayList<TimeFrameItemVo>();
        TimeFrameItemVo timeFrameItemVo = null;
        int tatolnum = 0;
        List recordEntityList = this.scheduleRecordMapper.selectByDocCodeAndDate(organCode, docCode, scheduleDate);
        if (null == recordEntityList || recordEntityList.isEmpty()) {
            return null;
        }
        for (ScheduleRecordEntity scheduleRecordEntity : recordEntityList) {
            timeFrameItemVo = this.getTimeFrameItemVo(organCode, scheduleRecordEntity);
            listTimeFrame.add(timeFrameItemVo);
            tatolnum += scheduleRecordEntity.getTotalCount().intValue();
        }
        doctorScheduleVoRes.setTimeFrameItemVos(listTimeFrame);
        doctorScheduleVoRes.setScheduleDate(String.valueOf(DateUtils.stringToSimpleDate((String)scheduleDate).getTime()));
        doctorScheduleVoRes.setTotalCount(Integer.valueOf(tatolnum));
        doctorScheduleVoRes.setDeptName(((ScheduleRecordEntity)recordEntityList.get(0)).getDeptName());
        doctorScheduleVoRes.setOrganName(((ScheduleRecordEntity)recordEntityList.get(0)).getHospitalName());
        return doctorScheduleVoRes;
    }
}

