/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.api.HospitalizationApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetIPDepositRecordsReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetIPDepositRecordsRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpAdmissionReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetInpAdmissionRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetOrdItemsReq;
import com.ebaiyihui.his.pojo.vo.hospitalization.GetOrdItemsRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetIPDepositRecordsItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetInpAdmissionResItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.items.GetOrdItemsResItems;
import com.ebaiyihui.his.pojo.vo.hospitalization.respmsg.DepositRespmsg;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.mapper.DepositSetEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.InpatientPayorderEntity;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetIhHospitalOrderItemsResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.IhHospitalOrderFreeTypeVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.InHospDepositCreateOrderResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.InHospitalRechargeDetailResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.DepositPayReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetIhHospitalOrderItemsReqVo;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetInpAdmissionReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospDepositCreateOrderReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospDepositPayReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.InHospitalRechargeDetailReqVO;
import com.ebaiyihui.wisdommedical.service.InHospitalService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class InHospitalServiceImpl
implements InHospitalService {
    private static final Logger log = LoggerFactory.getLogger(InHospitalServiceImpl.class);
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private HospitalizationApi hospitalizationApi;
    @Autowired
    private DepositSetEntityMapper depositSetEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;

    public List<GetInpAdmissionResItems> getInpAdmissionItems(GetInpAdmissionReqVO getInpAdmissionReqVO) throws InHospitalException {
        GatewayRequest gatewayRequest = this.buildGetInpAdmissionReq(getInpAdmissionReqVO);
        List getInpAdmissionResItemsList = this.getInpAdmission(gatewayRequest);
        if (CollectionUtils.isEmpty((Collection)getInpAdmissionResItemsList)) {
            return new ArrayList<GetInpAdmissionResItems>();
        }
        return getInpAdmissionResItemsList;
    }

    public InHospitalRechargeDetailResVO getRechargeDetail(InHospitalRechargeDetailReqVO inHospitalRechargeDetailReqVO) throws InHospitalException {
        InHospitalRechargeDetailResVO inHospitalRechargeDetailResVO = new InHospitalRechargeDetailResVO();
        BigDecimal detailTotalMoney = new BigDecimal("0");
        GatewayRequest gatewayRequest = this.buildGetRechargeDetailReq(inHospitalRechargeDetailReqVO);
        List rechargeDetailList = this.getRechargeDetail(gatewayRequest);
        if (CollectionUtils.isEmpty((Collection)rechargeDetailList)) {
            throw new InHospitalException("\u672a\u67e5\u8be2\u5230\u9884\u4ea4\u91d1\u5145\u503c\u660e\u7ec6\u8bb0\u5f55");
        }
        for (GetIPDepositRecordsItems items : rechargeDetailList) {
            detailTotalMoney = detailTotalMoney.add(new BigDecimal(items.getAmout()));
        }
        rechargeDetailList.sort(Comparator.comparing(GetIPDepositRecordsItems::getPrePayDateTime).reversed());
        inHospitalRechargeDetailResVO.setDetailTotalMoney(String.valueOf(detailTotalMoney));
        inHospitalRechargeDetailResVO.setDetailRechargeList(rechargeDetailList);
        return inHospitalRechargeDetailResVO;
    }

    public GetIhHospitalOrderItemsResVo getIhHospitalOrderItems(GetIhHospitalOrderItemsReqVo getHospitalOrderItemsReqVo) throws InHospitalException {
        GatewayRequest getOrdItemsReqGatewayRequest = this.buildGetInHospitalOrderItemDetailReq(getHospitalOrderItemsReqVo);
        GetOrdItemsRes getOrdItemsRes = this.getInHospFeeDetail(getOrdItemsReqGatewayRequest);
        if (null == getOrdItemsRes) {
            new GetOrdItemsRes();
        }
        GetIhHospitalOrderItemsResVo getIhHospitalOrderItemsResVo = new GetIhHospitalOrderItemsResVo();
        BeanUtils.copyProperties((Object)getOrdItemsRes, (Object)getIhHospitalOrderItemsResVo);
        List getOrdItemsResItemsList = getOrdItemsRes.getOrdItem();
        if (CollectionUtils.isEmpty((Collection)getOrdItemsResItemsList)) {
            return getIhHospitalOrderItemsResVo;
        }
        if (StringUtils.isBlank((CharSequence)getHospitalOrderItemsReqVo.getFreeDate())) {
            String lastFreeDate = ((GetOrdItemsResItems)getOrdItemsResItemsList.stream().sorted(Comparator.comparing(GetOrdItemsResItems::getFeeDate).reversed()).collect(Collectors.toList()).get(0)).getFeeDate();
            getOrdItemsResItemsList = getOrdItemsResItemsList.stream().filter(getOrdItemsResItem -> getOrdItemsResItem.getFeeDate().split(" ")[0].equals(lastFreeDate.split(" ")[0])).collect(Collectors.toList());
        } else {
            getOrdItemsResItemsList = getOrdItemsResItemsList.stream().filter(getOrdItemsResItem -> getOrdItemsResItem.getFeeDate().split(" ")[0].equals(getHospitalOrderItemsReqVo.getFreeDate())).collect(Collectors.toList());
        }
        List amountList = getOrdItemsResItemsList.stream().map(getOrdItemsResItems -> new BigDecimal(getOrdItemsResItems.getAmount())).collect(Collectors.toList());
        BigDecimal totalMoney = new BigDecimal("0");
        for (BigDecimal amount : amountList) {
            totalMoney = totalMoney.add(amount);
        }
        Map<String, List<GetOrdItemsResItems>> getOrdItemsResItemsMap = getOrdItemsResItemsList.stream().collect(Collectors.groupingBy(GetOrdItemsResItems::getFeeType));
        ArrayList ihHospitalOrderFreeTypeVoList = new ArrayList();
        getOrdItemsResItemsMap.keySet().forEach(freeType -> {
            IhHospitalOrderFreeTypeVo ihHospitalOrderFreeTypeVo = new IhHospitalOrderFreeTypeVo();
            ihHospitalOrderFreeTypeVo.setFreeType(freeType);
            ihHospitalOrderFreeTypeVo.setGetOrdItemsResItemsList((List)getOrdItemsResItemsMap.get(freeType));
            ihHospitalOrderFreeTypeVoList.add(ihHospitalOrderFreeTypeVo);
        });
        getIhHospitalOrderItemsResVo.setTotalMoney(totalMoney);
        getIhHospitalOrderItemsResVo.setIhHospitalOrderFreeTypeVoList(ihHospitalOrderFreeTypeVoList);
        return getIhHospitalOrderItemsResVo;
    }

    public InHospDepositCreateOrderResVO inHospDepositCreateOrder(InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO) throws InHospitalException {
        GetInpAdmissionReqVO getInpAdmissionReqVO = new GetInpAdmissionReqVO();
        getInpAdmissionReqVO.setOrganCode(this.propertiesConstant.getOrganCode());
        getInpAdmissionReqVO.setChannelCode(inHospDepositCreateOrderReqVO.getChannelCode());
        getInpAdmissionReqVO.setHospitalCode(inHospDepositCreateOrderReqVO.getHospitalCode());
        getInpAdmissionReqVO.setInHospNo(inHospDepositCreateOrderReqVO.getInHospNo());
        getInpAdmissionReqVO.setCardNo(inHospDepositCreateOrderReqVO.getInHospNo());
        GatewayRequest gatewayRequest = this.buildGetInpAdmissionReq(getInpAdmissionReqVO);
        List getInpAdmissionResItemsList = this.getInpAdmission(gatewayRequest);
        if (CollectionUtils.isEmpty((Collection)getInpAdmissionResItemsList)) {
            throw new InHospitalException("\u901a\u8fc7\u4f4f\u9662\u53f7\u672a\u83b7\u53d6\u5230\u4f4f\u9662\u4fe1\u606f,\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
        }
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.buildInpatientDepositDetailEntity((GetInpAdmissionResItems)getInpAdmissionResItemsList.get(0), inHospDepositCreateOrderReqVO);
        try {
            this.inpatientDepositDetailEntityMapper.insertSelective(inpatientDepositDetailEntity);
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25 " + e.getMessage());
            throw new InHospitalException("\u4e1a\u52a1\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
        }
        InpatientPayorderEntity inpatientPayorderEntity = this.buildInpatientPayorderEntity(inHospDepositCreateOrderReqVO, inpatientDepositDetailEntity.getId());
        try {
            this.inpatientPayorderEntityMapper.insertSelective(inpatientPayorderEntity);
        }
        catch (Exception e) {
            log.error("\u4e1a\u52a1\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25 " + e.getMessage());
            throw new InHospitalException("pay\u8ba2\u5355\u5199\u5165\u6570\u636e\u5e93\u5f02\u5e38\uff0c\u521b\u5efa\u8ba2\u5355\u5931\u8d25");
        }
        InHospDepositCreateOrderResVO inHospDepositCreateOrderResVO = new InHospDepositCreateOrderResVO();
        inHospDepositCreateOrderResVO.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        inHospDepositCreateOrderResVO.setCreateTime(DateUtils.dateToFullString((Date)inpatientDepositDetailEntity.getCreateTime()));
        inHospDepositCreateOrderResVO.setOrderSeq(inpatientDepositDetailEntity.getOrderSeq());
        inHospDepositCreateOrderResVO.setPatientName(inpatientDepositDetailEntity.getPatientName());
        inHospDepositCreateOrderResVO.setRechargeMoney(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        return inHospDepositCreateOrderResVO;
    }

    public BaseResponse<String> InHospDepositPay(InHospDepositPayReqVO inHospDepositPayReqVO) {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqZY());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
        }
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(inHospDepositPayReqVO.getOrderSeq());
        DepositPayReqVO depositPayReqVO = new DepositPayReqVO();
        depositPayReqVO.setActuallyAmount(inpatientDepositDetailEntity.getMoney());
        depositPayReqVO.setMchCode(this.propertiesConstant.getMchCode());
        depositPayReqVO.setOutTradeNo(inHospDepositPayReqVO.getOrderSeq());
        depositPayReqVO.setPayChannel(inHospDepositPayReqVO.getPayChannel());
        depositPayReqVO.setPayType(inHospDepositPayReqVO.getPayType());
        depositPayReqVO.setProductInfo("\u4f4f\u9662\u9884\u4ea4\u91d1");
        depositPayReqVO.setServiceCode(ServiceCodeEnum.DEPOSITPAY.getValue());
        depositPayReqVO.setTotalAmount(inpatientDepositDetailEntity.getMoney());
        depositPayReqVO.setUserSign(inHospDepositPayReqVO.getOpenId());
        depositPayReqVO.setNonceStr(SignUtil.getNonceStr());
        depositPayReqVO.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        depositPayReqVO.setPayNotifyUrl(this.propertiesConstant.getInHospitalPayNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)depositPayReqVO);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        depositPayReqVO.setSign(sign);
        return this.payCreateOrder(depositPayReqVO);
    }

    public DepositRes InHospDeposit(InpatientDepositDetailEntity inpatientDepositDetailEntity, ResponseNotifyRestVo responseNotifyRestVo) throws InHospitalException {
        GatewayRequest gatewayRequest = this.buildDepositReqGetWay(inpatientDepositDetailEntity, responseNotifyRestVo);
        return this.getDepositRes(gatewayRequest);
    }

    public List<String> getMoneyList(String hospitalCode) {
        List depositSetEntityList = null;
        depositSetEntityList = this.depositSetEntityMapper.selectByOrganCode(hospitalCode);
        if (null == depositSetEntityList || depositSetEntityList.size() < 1) {
            return new ArrayList<String>();
        }
        List<String> moneysList = depositSetEntityList.stream().map(a -> a.getMoneys()).collect(Collectors.toList());
        return moneysList;
    }

    public InHospDepositCreateOrderResVO getInHospDepositCreateOrderRes(String orderSeq) {
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(orderSeq);
        InHospDepositCreateOrderResVO depositCreateOrderResVO = new InHospDepositCreateOrderResVO();
        depositCreateOrderResVO.setRechargeMoney(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        depositCreateOrderResVO.setPatientName(inpatientDepositDetailEntity.getPatientName());
        depositCreateOrderResVO.setOrderSeq(orderSeq);
        depositCreateOrderResVO.setCreateTime(DateUtils.dateToFullString((Date)inpatientDepositDetailEntity.getCreateTime()));
        depositCreateOrderResVO.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        return depositCreateOrderResVO;
    }

    private GatewayRequest<GetInpAdmissionReq> buildGetInpAdmissionReq(GetInpAdmissionReqVO getInpAdmissionReqVO) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetInpAdmissionReq getInpAdmissionReq = new GetInpAdmissionReq();
        getInpAdmissionReq.setCardNo(getInpAdmissionReqVO.getCardNo());
        getInpAdmissionReq.setInHospNo(getInpAdmissionReqVO.getInHospNo());
        gatewayRequest.setBody((Object)getInpAdmissionReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getInpAdmissionReqVO.getChannelCode()));
        gatewayRequest.setChannel(getInpAdmissionReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("GetInpAdmissionItems");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetIPDepositRecordsReq> buildGetRechargeDetailReq(InHospitalRechargeDetailReqVO inHospitalRechargeDetailReqVO) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetIPDepositRecordsReq getIPDepositRecordsReq = new GetIPDepositRecordsReq();
        getIPDepositRecordsReq.setInHospNo(inHospitalRechargeDetailReqVO.getInHospNo());
        getIPDepositRecordsReq.setStartDate(inHospitalRechargeDetailReqVO.getStartDate());
        getIPDepositRecordsReq.setEndDate(inHospitalRechargeDetailReqVO.getEndDate());
        gatewayRequest.setBody((Object)getIPDepositRecordsReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)inHospitalRechargeDetailReqVO.getChannelCode()));
        gatewayRequest.setChannel(inHospitalRechargeDetailReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("GetRechargeDetail");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetOrdItemsReq> buildGetInHospitalOrderItemDetailReq(GetIhHospitalOrderItemsReqVo getHospitalOrderItemsReqVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetOrdItemsReq getOrdItemsReq = new GetOrdItemsReq();
        getOrdItemsReq.setInHospNo(getHospitalOrderItemsReqVo.getInHospNo());
        if (StringUtils.isBlank((CharSequence)getHospitalOrderItemsReqVo.getFreeDate())) {
            getOrdItemsReq.setStartDate(DateUtils.dateToSimpleString((Date)DateUtils.getSubtractMonth((Date)new Date(), (int)1)));
            getOrdItemsReq.setEndDate(DateUtils.dateToSimpleString((Date)new Date()));
        } else {
            getOrdItemsReq.setStartDate(getHospitalOrderItemsReqVo.getFreeDate());
        }
        gatewayRequest.setBody((Object)getOrdItemsReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getHospitalOrderItemsReqVo.getChannelCode()));
        gatewayRequest.setChannel(getHospitalOrderItemsReqVo.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("GetInHospFeeDetail");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<DepositReq> buildDepositReqGetWay(InpatientDepositDetailEntity inpatientDepositDetailEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        DepositReq depositReq = new DepositReq();
        depositReq.setInHospNo(inpatientDepositDetailEntity.getAdmissionNo());
        depositReq.setPayChannel(responseNotifyRestVo.getPayChannel());
        depositReq.setFlowNo(inpatientDepositDetailEntity.getOrderSeq());
        depositReq.setAmount(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        depositReq.setCardNo(inpatientDepositDetailEntity.getPatientId());
        DepositRespmsg depositRespmsg = new DepositRespmsg();
        depositRespmsg.setAmount(String.valueOf(inpatientDepositDetailEntity.getMoney()));
        depositRespmsg.setOrderid(responseNotifyRestVo.getTradeNo());
        depositRespmsg.setPayment(String.valueOf(responseNotifyRestVo.getTotalAmount()));
        depositRespmsg.setAccDate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        depositReq.setRespmsg(depositRespmsg);
        gatewayRequest.setBody((Object)depositReq);
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)inpatientDepositDetailEntity.getChannel()));
        gatewayRequest.setChannel(inpatientDepositDetailEntity.getChannel());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("InHospDeposit");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private List<GetInpAdmissionResItems> getInpAdmission(GatewayRequest<GetInpAdmissionReq> gatewayRequest) throws InHospitalException {
        log.info("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.hospitalizationApi.getInpAdmission(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return null;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return null;
        }
        GetInpAdmissionRes getInpAdmissionRes = (GetInpAdmissionRes)gatewayResponse.getData();
        if (null == getInpAdmissionRes) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return null;
        }
        if (CollectionUtils.isEmpty((Collection)getInpAdmissionRes.getItems())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u5c31\u8bca\u8bb0\u5f55\u5217\u8868 getInpAdmission -> his\u65e0\u4f4f\u9662\u8bb0\u5f55\u4fe1\u606f\u4fe1\u606f");
            return null;
        }
        return getInpAdmissionRes.getItems();
    }

    private List<GetIPDepositRecordsItems> getRechargeDetail(GatewayRequest<GetIPDepositRecordsReq> gatewayRequest) {
        ArrayList rechargeDetailList = null;
        log.info("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.hospitalizationApi.getIPDepositRecords(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        GetIPDepositRecordsRes getIPDepositRecordsRes = (GetIPDepositRecordsRes)gatewayResponse.getData();
        if (null == getIPDepositRecordsRes) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        rechargeDetailList = getIPDepositRecordsRes.getItems();
        if (null == rechargeDetailList || rechargeDetailList.isEmpty()) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6 getInpAdmission -> his\u65e0\u9884\u4ea4\u91d1\u660e\u7ec6\u5217\u8868");
            return new ArrayList<GetIPDepositRecordsItems>();
        }
        log.info("\u83b7\u53d6\u4f4f\u9662\u9884\u4ea4\u91d1\u660e\u7ec6\uff1a,\u8fd4\u56dehis\u9884\u4ea4\u91d1\u660e\u7ec6\u5217\u8868 Items:{}", (Object)getIPDepositRecordsRes.getItems());
        return rechargeDetailList;
    }

    private GetOrdItemsRes getInHospFeeDetail(GatewayRequest<GetOrdItemsReq> gatewayRequest) throws InHospitalException {
        log.info("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.hospitalizationApi.getOrdItems(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        GetOrdItemsRes getOrdItemsRes = (GetOrdItemsRes)gatewayResponse.getData();
        if (null == getOrdItemsRes) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        if (null == getOrdItemsRes.getOrdItem() || getOrdItemsRes.getOrdItem().isEmpty()) {
            log.error("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355 getInHospFeeDetail -> his\u65e0\u8d39\u7528\u6e05\u5355\u660e\u7ec6\u5217\u8868");
            throw new InHospitalException("\u65e0\u8d39\u7528\u6e05\u5355\u660e\u7ec6\u5217\u8868");
        }
        log.info("\u83b7\u53d6\u4f4f\u9662\u8d39\u7528\u6e05\u5355\uff1a,\u8fd4\u56dehis\u4f4f\u9662\u8d39\u7528\u6e05\u5355 OrdItems:{}", (Object)getOrdItemsRes);
        return getOrdItemsRes;
    }

    private DepositRes getDepositRes(GatewayRequest<DepositReq> gatewayRequest) throws InHospitalException {
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\uff1a,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.hospitalizationApi.deposit(gatewayRequest);
        if (null == gatewayResponse) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c getInHospFeeDetail -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c getInHospFeeDetail -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        DepositRes depositRes = (DepositRes)gatewayResponse.getData();
        if (null == depositRes) {
            log.error("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c getInHospFeeDetail -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new InHospitalException(gatewayResponse.getMsg());
        }
        log.info("\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\uff1a,\u8fd4\u56dehis\u5145\u503c\u6210\u529f\u51ed\u8bc1 depositRes:{}", (Object)depositRes);
        return depositRes;
    }

    private InpatientDepositDetailEntity buildInpatientDepositDetailEntity(GetInpAdmissionResItems getInpAdmissionResItems, InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO) {
        InpatientDepositDetailEntity depositDetailEntity = new InpatientDepositDetailEntity();
        depositDetailEntity.setOrganCode(this.propertiesConstant.getOrganCode());
        depositDetailEntity.setOrganName(inHospDepositCreateOrderReqVO.getHospitalName());
        depositDetailEntity.setAdmissionNo(inHospDepositCreateOrderReqVO.getInHospNo());
        depositDetailEntity.setInpatientDate(DateUtils.stringToSimpleDate((String)getInpAdmissionResItems.getStartDate()));
        depositDetailEntity.setOrderSeq(String.valueOf(this.snowflakeIdWorker.nextId()));
        depositDetailEntity.setPatientId(getInpAdmissionResItems.getPatientId());
        depositDetailEntity.setPatientOrganId(getInpAdmissionResItems.getPatientId());
        depositDetailEntity.setPatientName(getInpAdmissionResItems.getPatientName());
        depositDetailEntity.setCardId(inHospDepositCreateOrderReqVO.getCardId());
        depositDetailEntity.setUserId(inHospDepositCreateOrderReqVO.getUserId());
        depositDetailEntity.setCardNo(getInpAdmissionResItems.getCardNo());
        depositDetailEntity.setStatus(new Byte("0"));
        depositDetailEntity.setMoney(new BigDecimal(inHospDepositCreateOrderReqVO.getRechargeMoney()));
        depositDetailEntity.setChannel(inHospDepositCreateOrderReqVO.getChannelCode());
        depositDetailEntity.setCreateTime(new Date());
        depositDetailEntity.setUpdateTime(new Date());
        depositDetailEntity.setInHospitalProduceMoney(new BigDecimal(getInpAdmissionResItems.getTotalMoney()));
        depositDetailEntity.setPreMoneyTotalMoney(new BigDecimal(getInpAdmissionResItems.getDepost() != null ? getInpAdmissionResItems.getDepost() : "0"));
        BigDecimal preMoneyBalance = new BigDecimal(getInpAdmissionResItems.getDepost() != null ? getInpAdmissionResItems.getDepost() : "0").subtract(new BigDecimal(getInpAdmissionResItems.getTotalMoney()));
        depositDetailEntity.setPreMoneyBalance(preMoneyBalance);
        depositDetailEntity.setRemark("\u521b\u5efa\u8ba2\u5355\u6210\u529f\uff0c\u672a\u652f\u4ed8");
        return depositDetailEntity;
    }

    private InpatientPayorderEntity buildInpatientPayorderEntity(InHospDepositCreateOrderReqVO inHospDepositCreateOrderReqVO, Long id) {
        InpatientPayorderEntity inpatientPayorderEntity = new InpatientPayorderEntity();
        inpatientPayorderEntity.setInpatientDepositId(id);
        inpatientPayorderEntity.setOrderType(new Byte("1"));
        inpatientPayorderEntity.setDealMoney(new BigDecimal(inHospDepositCreateOrderReqVO.getRechargeMoney()));
        inpatientPayorderEntity.setBizSysSeq(ServiceCodeEnum.DEPOSITPAY.getValue());
        inpatientPayorderEntity.setPayStatus(new Byte("0"));
        inpatientPayorderEntity.setDealSeq("");
        inpatientPayorderEntity.setMerchantSeq(this.propertiesConstant.getMchCode());
        inpatientPayorderEntity.setUserId(inHospDepositCreateOrderReqVO.getUserId());
        inpatientPayorderEntity.setCreateTime(new Date());
        inpatientPayorderEntity.setUpdateTime(new Date());
        inpatientPayorderEntity.setRemark("\u521b\u5efapay\u8ba2\u5355\uff0c\u7b49\u5f85\u652f\u4ed8");
        return inpatientPayorderEntity;
    }

    private BaseResponse<String> payCreateOrder(DepositPayReqVO depositPayReqVO) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getPayUrl(), (String)JSON.toJSONString((Object)depositPayReqVO));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("baseResponse: " + baseResponse);
            if (null == baseResponse) {
                return BaseResponse.error((String)"\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
            }
            return baseResponse;
        }
        catch (Exception e) {
            log.error("InHospitalServiceImpl.payCreateOrder\u4f4f\u9662\u9884\u4ea4\u91d1\u5145\u503c\u652f\u4ed8\u53d1\u8d77\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            return BaseResponse.error((String)"\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
        }
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }
}

