/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.api.ElectronicReportApi;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.report.datas.GetReportListsData;
import com.ebaiyihui.his.pojo.vo.report.datas.LisReportListResData;
import com.ebaiyihui.his.pojo.vo.report.datas.micDatas.LisReportListResMicData;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.pojo.vo.NetReportBaseRequest;
import com.ebaiyihui.wisdommedical.pojo.vo.ReponseLisListVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ReponseLisResultVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ReponsePacsListVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ReponsePacsResultVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailData;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportDetailMicData;
import com.ebaiyihui.wisdommedical.pojo.vo.ReportInfo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestLisListVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestLisResultVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestPacsListVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestPacsResultVo;
import com.ebaiyihui.wisdommedical.service.NetReportService;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NetReportServiceImpl
implements NetReportService {
    @Resource
    private ElectronicReportApi electronicReportClient;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private ProPropertiesConstant projProperties;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public FrontResponse<ReponseLisListVo> queryReportHosList(RequestLisListVo requestLisListVo) {
        FrontRequest param = new FrontRequest();
        param.setBody((Object)requestLisListVo);
        param.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        String response = null;
        try {
            response = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "inspection/list"), (String)JSON.toJSONString((Object)param));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        return frontResponse;
    }

    public FrontResponse<ReponseLisResultVo> queryReportDetail(RequestLisResultVo requestLisResultVo) {
        FrontRequest param = new FrontRequest();
        param.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        param.setBody((Object)requestLisResultVo);
        String response = null;
        try {
            response = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "inspection/results"), (String)JSON.toJSONString((Object)param));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        return frontResponse;
    }

    public FrontResponse<ReponsePacsListVo> queryCheckReportList(RequestPacsListVo requestLisResultVo) {
        FrontRequest param = new FrontRequest();
        param.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        param.setBody((Object)requestLisResultVo);
        String response = null;
        try {
            response = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "inspection/check/list"), (String)JSON.toJSONString((Object)param));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        return frontResponse;
    }

    public FrontResponse<ReponsePacsResultVo> queryCheckReportDetail(RequestPacsResultVo requestPacsResultVo) {
        FrontRequest param = new FrontRequest();
        param.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        param.setBody((Object)requestPacsResultVo);
        String response = null;
        try {
            response = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "inspection/check/results"), (String)JSON.toJSONString((Object)param));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        return frontResponse;
    }

    private ReportDetailData matchJyReportDetail(LisReportListResData lisReportListResData) {
        ReportDetailData reportDetailData = new ReportDetailData();
        BeanUtils.copyProperties((Object)lisReportListResData, (Object)reportDetailData);
        List micDataList = lisReportListResData.getMicDatas();
        if (micDataList != null) {
            List detailMicDataList = micDataList.stream().map(arg_0 -> this.matchJyReportData(arg_0)).collect(Collectors.toList());
            reportDetailData.setMicDatas(detailMicDataList);
        }
        return reportDetailData;
    }

    private ReportDetailMicData matchJyReportData(LisReportListResMicData lisReportListResMicData) {
        ReportDetailMicData reportDetailMicData = new ReportDetailMicData();
        BeanUtils.copyProperties((Object)lisReportListResMicData, (Object)reportDetailMicData);
        return reportDetailMicData;
    }

    private ReportInfo matchReportData(GetReportListsData hisReportData) {
        ReportInfo reportData = new ReportInfo();
        reportData.setReportNo(hisReportData.getReportNo());
        reportData.setReportName(hisReportData.getReportName());
        reportData.setReportType(hisReportData.getReportType());
        reportData.setReportDate(hisReportData.getReportDate());
        reportData.setReportTime(hisReportData.getReportTime());
        reportData.setTsName(hisReportData.getTsName());
        reportData.setTsCode(hisReportData.getTsCode());
        return reportData;
    }

    private <T> T checkHisResponse(BaseResponse<T> response) {
        if (response == null) {
            this.logger.error("request his gateway error - \u65e0\u54cd\u5e94");
            return null;
        }
        if (!response.isSuccess()) {
            this.logger.error("request his gateway error - \u8bf7\u6c42\u7ed3\u679c-\u5931\u8d25");
            return null;
        }
        if (response.getData() == null) {
            this.logger.error("request his gateway error - \u8fd4\u56de\u5b9e\u4f53\u6570\u636e\u5f02\u5e38");
            return null;
        }
        return (T)response.getData();
    }

    private <T> GatewayRequest<T> getGateWayParam(NetReportBaseRequest baseRequest, T body) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setOrganCode(baseRequest.getOrganCode());
        gatewayRequest.setBody(body);
        gatewayRequest.setChannel(baseRequest.getChannel());
        gatewayRequest.setChannelName(baseRequest.getChannelName());
        String transactionId = UUID.randomUUID().toString();
        gatewayRequest.setTransactionId(transactionId);
        this.logger.info("his gateway - transactionId:{}", (Object)transactionId);
        return gatewayRequest;
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }
}

