/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ebaiyihui.card.common.vo.CardDetailsInfoReqVO;
import com.ebaiyihui.card.common.vo.CardDetailsInfoRespVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.framework.utils.IdCardUtil;
import com.ebaiyihui.his.api.OutpatientPaymentApi;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.outpatient.PayItemReq;
import com.ebaiyihui.his.pojo.vo.outpatient.datas.PayItemResDatas;
import com.ebaiyihui.his.pojo.vo.outpatient.items.PayItemResItems;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.ItemTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.OrderTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.PayStatusEnum;
import com.ebaiyihui.wisdommedical.exception.OutpatientPaymentException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpGuideEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderDetailEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.OpGuideEntity;
import com.ebaiyihui.wisdommedical.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.PayItemDatasDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.ReponseCostDetailVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ReponseFeeDetailRecordVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ReponseFeeRegVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestCardNoDateVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestCardNoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestCostDetailVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GetPayItemRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.GuidedInfoResVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.ItemTypeVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.OutpatientPaymentOrderDetailRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.OutpatientPaymentOrderRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.PayItemResVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.PaySuccessInfoRespVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetAdmissionReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.GetPayItemReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPayReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPaymentOrderDetailReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPaymentOrderReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.OutpatientPaymentReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.reqvo.RefundOrderVoReq;
import com.ebaiyihui.wisdommedical.service.OutpatientPaymentService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetCardInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import redis.clients.jedis.JedisCluster;

@Service
public class OutpatientPaymentServiceImpl
implements OutpatientPaymentService {
    private static final Logger log = LoggerFactory.getLogger(OutpatientPaymentServiceImpl.class);
    public static final int TWO_HOURS = 7200;
    public static final byte OUTPATIENT_DEPARTMENT = 1;
    public static final byte EMERGENCY_TREATMENT = 2;
    public static final byte TO_BE_PAID = 0;
    public static final byte PAID = 1;
    public static final String WECHAT = "WECHAT";
    public static final String ALIPAY = "ALIPAY";
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private OutpatientPaymentApi outpatientPaymentApi;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private GetCardInfoUtil getCardInfoUtil;
    @Autowired
    private OpGuideEntityMapper opGuideEntityMapper;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ProPropertiesConstant projProperties;

    public FrontResponse<ReponseFeeDetailRecordVo> getAdmission(RequestCardNoDateVo requestCardNoDateVo) throws OutpatientPaymentException {
        FrontRequest param = new FrontRequest();
        param.setBody((Object)requestCardNoDateVo);
        param.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        String response = null;
        try {
            response = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "card/acquire/paycost/record"), (String)JSON.toJSONString((Object)param));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        return frontResponse;
    }

    public FrontResponse<ReponseFeeRegVo> getPayItem(RequestCardNoVo requestCardNoDateVo) throws OutpatientPaymentException {
        FrontRequest param = new FrontRequest();
        param.setBody((Object)requestCardNoDateVo);
        param.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        String response = null;
        try {
            response = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "api/v1/hospitalTitle/query/bill/payment"), (String)JSON.toJSONString((Object)param));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (!"1".equals(frontResponse.getCode())) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)frontResponse.getErrCode(), (Object)frontResponse.getMessage());
            throw new OutpatientPaymentException(frontResponse.getMessage());
        }
        if (null == frontResponse.getBody()) {
            log.error("\u83b7\u53d6\u95e8\u8bca\u6536\u8d39\u9879\u76ee payItem -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new OutpatientPaymentException(frontResponse.getMessage());
        }
        return frontResponse;
    }

    public FrontResponse<ReponseCostDetailVo> queryPaymentDetails(RequestCostDetailVo requestCostDetailVo) {
        FrontRequest param = new FrontRequest();
        param.setBody((Object)requestCostDetailVo);
        param.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        String response = null;
        try {
            response = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "api/v1/hospitalTitle/query/payment/details"), (String)JSON.toJSONString((Object)param));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        CardDetailsInfoRespVO cardDetailsInfoRespVO = null;
        try {
            cardDetailsInfoRespVO = this.getCardDetail(requestCostDetailVo.getCardId());
        }
        catch (OutpatientPaymentException e) {
            e.printStackTrace();
        }
        GetPayItemRespVO getPayItemRespVO = new GetPayItemRespVO();
        getPayItemRespVO.setAdmId(requestCostDetailVo.getClinicNo());
        getPayItemRespVO.setOutPatientId(param.getTransactionId());
        GetPayItemReqVO getPayItemReqVO = this.buildGetPayItemReqVO(cardDetailsInfoRespVO, requestCostDetailVo);
        List payItemResDatasList = this.payItem((ReponseCostDetailVo)frontResponse.getBody(), requestCostDetailVo);
        this.buildPayItemDatasRespVO(param.getTransactionId(), getPayItemReqVO, getPayItemRespVO, payItemResDatasList, cardDetailsInfoRespVO);
        PayItemDatasDTO payItemDatasDTO = this.buildPayItemDatasDTOForRedis(param.getTransactionId(), getPayItemReqVO, payItemResDatasList, cardDetailsInfoRespVO);
        String payItemDatasDTOStr = JSON.toJSONString((Object)payItemDatasDTO);
        this.jedisCluster.set(param.getTransactionId(), payItemDatasDTOStr);
        this.jedisCluster.expire(param.getTransactionId(), 7200);
        return frontResponse;
    }

    GetPayItemReqVO buildGetPayItemReqVO(CardDetailsInfoRespVO cardDetailsInfoRespVO, RequestCostDetailVo requestCostDetailVo) {
        GetPayItemReqVO getPayItemReqVO = new GetPayItemReqVO();
        getPayItemReqVO.setPatientId(cardDetailsInfoRespVO.getPatientId());
        getPayItemReqVO.setUserId("");
        getPayItemReqVO.setAdmId(requestCostDetailVo.getClinicNo());
        getPayItemReqVO.setCardId(cardDetailsInfoRespVO.getCardId());
        getPayItemReqVO.setCardNo(cardDetailsInfoRespVO.getCardNo());
        getPayItemReqVO.setAdmDate(requestCostDetailVo.getRegDate());
        getPayItemReqVO.setAdmType("0");
        getPayItemReqVO.setOrganCode("130212");
        getPayItemReqVO.setChannelCode("PATIENT_WX");
        getPayItemReqVO.setDeptName(requestCostDetailVo.getDeptName());
        getPayItemReqVO.setDocName(requestCostDetailVo.getDoctorName());
        return getPayItemReqVO;
    }

    private List<PayItemResDatas> payItem(ReponseCostDetailVo reponseCostDetailVo, RequestCostDetailVo requestCostDetailVo) {
        ArrayList<PayItemResDatas> payItemResDatasList = new ArrayList<PayItemResDatas>();
        PayItemResDatas payItemResDatas = new PayItemResDatas();
        payItemResDatas.setItemType("3");
        payItemResDatas.setAdmId(requestCostDetailVo.getClinicNo());
        payItemResDatas.setStartDate(requestCostDetailVo.getRegDate());
        payItemResDatas.setEndDate(payItemResDatas.getStartDate());
        ArrayList payItemResItemsList = new ArrayList();
        BigDecimal bigDecimal = BigDecimal.ZERO;
        StringBuilder freeId = new StringBuilder();
        reponseCostDetailVo.getCostDetailList().forEach(a -> {
            PayItemResItems payItemResItems = new PayItemResItems();
            payItemResItems.setPrescriptionNo(a.getRecipeNo());
            payItemResItems.setId(a.getRecipeSeq());
            payItemResItems.setDesc(a.getItemName());
            payItemResItems.setUnit(a.getUnit());
            payItemResItems.setPrice(a.getUnitPrice());
            payItemResItems.setQty(a.getQty());
            payItemResItems.setSum(a.getCost());
            BigDecimal cost = new BigDecimal(a.getCost());
            bigDecimal.add(cost);
            String str = a.getRecipeNo() + "," + a.getRecipeSeq() + "|";
            if (freeId != null) {
                freeId.append((CharSequence)freeId).append(str);
            } else {
                freeId.append(str);
            }
            payItemResItemsList.add(payItemResItems);
        });
        payItemResDatas.setItems(payItemResItemsList);
        payItemResDatas.setAmount(String.valueOf(bigDecimal));
        if (freeId != null) {
            payItemResDatas.setFeeId(freeId.toString().substring(0, freeId.toString().length() - 1));
        }
        payItemResDatasList.add(payItemResDatas);
        return payItemResDatasList;
    }

    private void buildPayItemDatasRespVO(String outPatientId, GetPayItemReqVO getPayItemReqVO, GetPayItemRespVO getPayItemRespVO, List<PayItemResDatas> payItemResDatasList, CardDetailsInfoRespVO cardDetailsInfoRespVO) {
        getPayItemRespVO.setOutPatientId(outPatientId);
        getPayItemRespVO.setName(cardDetailsInfoRespVO.getPatientName());
        getPayItemRespVO.setSex(cardDetailsInfoRespVO.getGender().toString());
        getPayItemRespVO.setAge(IdCardUtil.getAgeByIdCard((String)cardDetailsInfoRespVO.getCredNo()) + "");
        getPayItemRespVO.setCardTypeName(cardDetailsInfoRespVO.getCardTypeName());
        getPayItemRespVO.setAdmDate(getPayItemReqVO.getAdmDate());
        getPayItemRespVO.setCreateTime(DateUtils.dateToFullString((Date)new Date()));
        List payItemResVos = this.buildPayItemResVoList(payItemResDatasList, getPayItemReqVO.getAdmId());
        BigDecimal amount = BigDecimal.ZERO;
        for (PayItemResVo payItemResVo : payItemResVos) {
            amount = amount.add(new BigDecimal(payItemResVo.getAmount()));
        }
        getPayItemRespVO.setAmount(amount.toString());
        getPayItemRespVO.setPayItemResVoList(payItemResVos);
        getPayItemRespVO.setCardNo(getPayItemReqVO.getCardNo());
        getPayItemRespVO.setDeptName(getPayItemReqVO.getDeptName());
        getPayItemRespVO.setDocName(getPayItemReqVO.getDocName());
        getPayItemRespVO.setAdmId(getPayItemReqVO.getAdmId());
    }

    private List<PayItemResVo> buildPayItemResVoList(List<PayItemResDatas> payItemResDatasList, String admId) {
        ArrayList<PayItemResVo> payItemResList = new ArrayList<PayItemResVo>();
        PayItemResVo treatmentPayItemResVo = this.buildPayItemResVo(payItemResDatasList);
        if (null != treatmentPayItemResVo) {
            payItemResList.add(treatmentPayItemResVo);
        }
        return payItemResList;
    }

    private PayItemResVo buildPayItemResVo(List<PayItemResDatas> payList) {
        if (!CollectionUtils.isEmpty(payList)) {
            PayItemResVo payItemResVo = new PayItemResVo();
            BigDecimal amount = BigDecimal.ZERO;
            ArrayList items = new ArrayList();
            ArrayList<String> feeIdList = new ArrayList<String>();
            for (PayItemResDatas payItemResDatas : payList) {
                amount = amount.add(new BigDecimal(payItemResDatas.getAmount()));
                items.addAll(payItemResDatas.getItems());
                feeIdList.add(payItemResDatas.getFeeId());
            }
            payItemResVo.setFeeId(feeIdList);
            payItemResVo.setItemType(payList.get(0).getItemType());
            payItemResVo.setItems(items);
            payItemResVo.setAmount(amount.toString());
            return payItemResVo;
        }
        return null;
    }

    private PayItemDatasDTO buildPayItemDatasDTOForRedis(String outPatientId, GetPayItemReqVO getPayItemReqVO, List<PayItemResDatas> payItemResDatasList, CardDetailsInfoRespVO cardDetailsInfoRespVO) {
        PayItemDatasDTO payItemDatasDTO = new PayItemDatasDTO();
        payItemDatasDTO.setIdCard(cardDetailsInfoRespVO.getCredNo());
        payItemDatasDTO.setUserId(getPayItemReqVO.getUserId());
        payItemDatasDTO.setOutPatientId(outPatientId);
        payItemDatasDTO.setPatientId(cardDetailsInfoRespVO.getPatientId());
        payItemDatasDTO.setPatientOrganId(cardDetailsInfoRespVO.getOrganPmi());
        payItemDatasDTO.setCardId(cardDetailsInfoRespVO.getCardId());
        payItemDatasDTO.setCardNo(cardDetailsInfoRespVO.getCardNo());
        payItemDatasDTO.setAdmDate(getPayItemReqVO.getAdmDate());
        payItemDatasDTO.setAdmType(getPayItemReqVO.getAdmType());
        payItemDatasDTO.setName(cardDetailsInfoRespVO.getPatientName());
        payItemDatasDTO.setAge(IdCardUtil.getAgeByIdCard((String)cardDetailsInfoRespVO.getCredNo()) + "");
        payItemDatasDTO.setSex(cardDetailsInfoRespVO.getGender().toString());
        payItemDatasDTO.setAdmId(getPayItemReqVO.getAdmId());
        payItemDatasDTO.setDeptName(getPayItemReqVO.getDeptName());
        payItemDatasDTO.setDeptCode(getPayItemReqVO.getDeptCode());
        payItemDatasDTO.setDocName(getPayItemReqVO.getDocName());
        payItemDatasDTO.setDocCode(getPayItemReqVO.getDocCode());
        List payItemResVos = this.buildPayItemResVoList(payItemResDatasList, getPayItemReqVO.getAdmId());
        BigDecimal amount = BigDecimal.ZERO;
        ArrayList feeIdList = new ArrayList();
        for (PayItemResVo payItemResVo : payItemResVos) {
            amount = amount.add(new BigDecimal(payItemResVo.getAmount()));
            feeIdList.addAll(payItemResVo.getFeeId());
        }
        payItemDatasDTO.setFeeIds(String.join((CharSequence)",", feeIdList));
        payItemDatasDTO.setAmount(amount.toString());
        payItemDatasDTO.setPayItemResVoList(payItemResVos);
        return payItemDatasDTO;
    }

    private CardDetailsInfoRespVO getCardDetail(String cardId) throws OutpatientPaymentException {
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        cardDetailsInfoReqVO.setCardId(cardId);
        cardDetailsInfoReqVO.setChannelCode("app");
        log.info("\u83b7\u53d6\u5c31\u8bca\u5361\u4fe1\u606f\u5165\u53c2\uff1a" + JSON.toJSONString((Object)cardDetailsInfoReqVO));
        CardDetailsInfoRespVO respVO = this.getCardInfoUtil.getCardDetail(cardDetailsInfoReqVO);
        return respVO;
    }

    private GatewayRequest<PayItemReq> buildPayItemGatewayReq(GetPayItemReqVO getPayItemReqVO) {
        PayItemReq payItemReq = new PayItemReq();
        payItemReq.setAdmId(getPayItemReqVO.getAdmId());
        payItemReq.setCardNo(getPayItemReqVO.getCardNo());
        GatewayRequest gatewayRequest = new GatewayRequest();
        gatewayRequest.setKeyWord("payItem");
        gatewayRequest.setChannelName(ChannelEnum.getDisplay((String)getPayItemReqVO.getChannelCode()));
        gatewayRequest.setChannel(getPayItemReqVO.getChannelCode());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setBody((Object)payItemReq);
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private OpBusinessOrderEntity buildOpBusinessOrderEntity(PayItemDatasDTO payItemDatasDTO, OutpatientPaymentReqVO outpatientPaymentReqVO) {
        OpBusinessOrderEntity opBusinessOrderEntity = new OpBusinessOrderEntity();
        opBusinessOrderEntity.setRemark("\u5f85\u652f\u4ed8");
        opBusinessOrderEntity.setOutPatientId(payItemDatasDTO.getOutPatientId());
        opBusinessOrderEntity.setOrganCode(this.propertiesConstant.getOrganCode());
        opBusinessOrderEntity.setOrganName(outpatientPaymentReqVO.getHospitalName());
        opBusinessOrderEntity.setAdmId(payItemDatasDTO.getAdmId());
        opBusinessOrderEntity.setAdmTime(payItemDatasDTO.getAdmDate());
        if ("E".equals(payItemDatasDTO.getAdmType())) {
            opBusinessOrderEntity.setAdmType(Byte.valueOf((byte)2));
        } else {
            opBusinessOrderEntity.setAdmType(Byte.valueOf((byte)1));
        }
        opBusinessOrderEntity.setDeptName(payItemDatasDTO.getDeptName());
        opBusinessOrderEntity.setDeptCode(payItemDatasDTO.getDeptCode());
        opBusinessOrderEntity.setDocName(payItemDatasDTO.getDocName());
        opBusinessOrderEntity.setDocCode(payItemDatasDTO.getDocCode());
        opBusinessOrderEntity.setPatientId(payItemDatasDTO.getPatientId());
        opBusinessOrderEntity.setPatientOrganId(payItemDatasDTO.getPatientOrganId());
        opBusinessOrderEntity.setPatientName(payItemDatasDTO.getName());
        opBusinessOrderEntity.setPatientGender(Integer.valueOf(Integer.parseInt(payItemDatasDTO.getSex())));
        opBusinessOrderEntity.setPatientAge(payItemDatasDTO.getAge());
        opBusinessOrderEntity.setCardNo(payItemDatasDTO.getCardNo());
        opBusinessOrderEntity.setCardId(payItemDatasDTO.getCardId());
        opBusinessOrderEntity.setIdCard(payItemDatasDTO.getIdCard());
        opBusinessOrderEntity.setUserId(payItemDatasDTO.getUserId());
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.NOT_PAY.getValue());
        opBusinessOrderEntity.setMoney(new BigDecimal(payItemDatasDTO.getAmount()));
        opBusinessOrderEntity.setReceiptId(payItemDatasDTO.getFeeIds());
        return opBusinessOrderEntity;
    }

    private List<OpBusinessOrderDetailEntity> buildOpBusinessOrderDetailEntity(PayItemDatasDTO payItemDatasDTO, String hospitalName) {
        ArrayList<OpBusinessOrderDetailEntity> opBusinessOrderDetailEntityList = new ArrayList<OpBusinessOrderDetailEntity>();
        List payItemResVoList = payItemDatasDTO.getPayItemResVoList();
        for (PayItemResVo payItemResVo : payItemResVoList) {
            List items = payItemResVo.getItems();
            for (PayItemResItems payItemResItems : items) {
                OpBusinessOrderDetailEntity opBusinessOrderDetailEntity = new OpBusinessOrderDetailEntity();
                opBusinessOrderDetailEntity.setOrganCode(this.propertiesConstant.getOrganCode());
                opBusinessOrderDetailEntity.setOrganName(hospitalName);
                opBusinessOrderDetailEntity.setOutPatientId(payItemDatasDTO.getOutPatientId());
                opBusinessOrderDetailEntity.setItemName(payItemResItems.getDesc());
                opBusinessOrderDetailEntity.setItemType(payItemResItems.getItemType());
                opBusinessOrderDetailEntity.setItemId(payItemResItems.getId());
                opBusinessOrderDetailEntity.setQuantity(Double.valueOf(Double.parseDouble(payItemResItems.getQty())));
                opBusinessOrderDetailEntity.setUnit(payItemResItems.getUnit());
                opBusinessOrderDetailEntity.setPrice(new BigDecimal(payItemResItems.getPrice()));
                opBusinessOrderDetailEntity.setMoney(new BigDecimal(payItemResItems.getSum()));
                opBusinessOrderDetailEntity.setPrescriptionNo(payItemResItems.getId());
                opBusinessOrderDetailEntityList.add(opBusinessOrderDetailEntity);
            }
        }
        return opBusinessOrderDetailEntityList;
    }

    public OutpatientPaymentOrderDetailRespVO getOutpatientSucssessDetail(OutpatientPaymentOrderDetailReqVO outpatientPaymentOrderDetailReqVO) throws OutpatientPaymentException {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outpatientPaymentOrderDetailReqVO.getOutPatientId());
        if (null == opBusinessOrderEntity) {
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u67e5\u8be2\u5931\u8d25");
        }
        List opBusinessOrderDetailEntitiesList = this.opBusinessOrderDetailEntityMapper.selectByOutPatientId(outpatientPaymentOrderDetailReqVO.getOutPatientId());
        if (null == opBusinessOrderDetailEntitiesList) {
            throw new OutpatientPaymentException("\u95e8\u8bca\u7f34\u8d39\u8ba2\u5355\u8be6\u60c5\u67e5\u8be2\u5931\u8d25");
        }
        CardDetailsInfoReqVO cardDetailsInfoReqVO = new CardDetailsInfoReqVO();
        CardDetailsInfoRespVO cardDetailsInfoRespVO = this.getCardDetail(opBusinessOrderEntity.getCardId());
        OutpatientPaymentOrderDetailRespVO outpatientPaymentOrderDetailRespVO = new OutpatientPaymentOrderDetailRespVO();
        outpatientPaymentOrderDetailRespVO.setOutPatientId(opBusinessOrderEntity.getOutPatientId());
        outpatientPaymentOrderDetailRespVO.setName(opBusinessOrderEntity.getPatientName());
        outpatientPaymentOrderDetailRespVO.setSex(opBusinessOrderEntity.getPatientGender().toString());
        outpatientPaymentOrderDetailRespVO.setAge(opBusinessOrderEntity.getPatientAge());
        outpatientPaymentOrderDetailRespVO.setCardNo(cardDetailsInfoRespVO.getCardNo());
        outpatientPaymentOrderDetailRespVO.setCardTypeName(cardDetailsInfoRespVO.getCardTypeName());
        outpatientPaymentOrderDetailRespVO.setAdmDate(opBusinessOrderEntity.getAdmTime());
        outpatientPaymentOrderDetailRespVO.setCreateTime(DateUtils.dateToFullString((Date)opBusinessOrderEntity.getCreateTime()));
        outpatientPaymentOrderDetailRespVO.setPayTime(DateUtils.dateToFullString((Date)opBusinessOrderEntity.getPayTime()));
        List payItemResVos = this.buidPayItemResVoList(opBusinessOrderDetailEntitiesList);
        outpatientPaymentOrderDetailRespVO.setPayItemResVoList(payItemResVos);
        BigDecimal amount = BigDecimal.ZERO;
        for (PayItemResVo payItemResVo : payItemResVos) {
            amount = amount.add(new BigDecimal(payItemResVo.getAmount()));
        }
        outpatientPaymentOrderDetailRespVO.setAmount(amount.toString());
        outpatientPaymentOrderDetailRespVO.setDeptName(opBusinessOrderEntity.getDeptName());
        outpatientPaymentOrderDetailRespVO.setDocName(opBusinessOrderEntity.getDocName());
        outpatientPaymentOrderDetailRespVO.setAdmId(opBusinessOrderEntity.getAdmId());
        outpatientPaymentOrderDetailRespVO.setGuidedInfoList(this.getGuidedInfo(outpatientPaymentOrderDetailReqVO.getOutPatientId()));
        return outpatientPaymentOrderDetailRespVO;
    }

    private List<PayItemResVo> buidPayItemResVoList(List<OpBusinessOrderDetailEntity> opBusinessOrderDetailList) {
        ArrayList<PayItemResVo> payItemResVoList = new ArrayList<PayItemResVo>();
        PayItemResVo treatmentPayItemResVo = this.buildPayItemResVoForDetail(opBusinessOrderDetailList);
        if (null != treatmentPayItemResVo) {
            payItemResVoList.add(treatmentPayItemResVo);
        }
        return payItemResVoList;
    }

    private PayItemResVo buildPayItemResVoForDetail(List<OpBusinessOrderDetailEntity> payItemList) {
        if (!CollectionUtils.isEmpty(payItemList)) {
            List items = this.buildPayItemResItems(payItemList);
            if (CollectionUtils.isEmpty((Collection)items)) {
                return null;
            }
            BigDecimal amount = BigDecimal.ZERO;
            for (PayItemResItems payItemResItems : items) {
                amount = amount.add(new BigDecimal(payItemResItems.getSum()));
            }
            PayItemResVo payItemResVo = new PayItemResVo();
            payItemResVo.setAmount(amount.toString());
            payItemResVo.setItems(items);
            payItemResVo.setItemType(((PayItemResItems)items.get(0)).getItemType());
            return payItemResVo;
        }
        return null;
    }

    private List<PayItemResItems> buildPayItemResItems(List<OpBusinessOrderDetailEntity> opBusinessOrderDetailEntitiesList) {
        ArrayList<PayItemResItems> payItemResItemsList = new ArrayList<PayItemResItems>();
        if (null == opBusinessOrderDetailEntitiesList || opBusinessOrderDetailEntitiesList.isEmpty()) {
            return payItemResItemsList;
        }
        for (OpBusinessOrderDetailEntity opBusinessOrderDetailEntity : opBusinessOrderDetailEntitiesList) {
            PayItemResItems payItemResItems = new PayItemResItems();
            payItemResItems.setId(opBusinessOrderDetailEntity.getItemId());
            payItemResItems.setDesc(opBusinessOrderDetailEntity.getItemName());
            payItemResItems.setUnit(opBusinessOrderDetailEntity.getUnit());
            payItemResItems.setPrice(opBusinessOrderDetailEntity.getPrice().toString());
            payItemResItems.setQty(opBusinessOrderDetailEntity.getQuantity().toString());
            payItemResItems.setSum(opBusinessOrderDetailEntity.getMoney().toString());
            payItemResItems.setItemType(opBusinessOrderDetailEntity.getItemType());
            payItemResItemsList.add(payItemResItems);
        }
        return payItemResItemsList;
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public BaseResponse<String> outpatientPayment(OutpatientPaymentReqVO outpatientPaymentReqVO) throws OutpatientPaymentException {
        log.info("OutpatientPaymentServiceImpl.createOutpatientPayment->\u4eceredis\u83b7\u53d6\u6570\u636e\uff0ckey\u4e3a\uff1a{}", (Object)outpatientPaymentReqVO.getOutPatientId());
        String payItemDatasDTOStr = this.jedisCluster.get(outpatientPaymentReqVO.getOutPatientId());
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)payItemDatasDTOStr)) {
            throw new OutpatientPaymentException("\u8be5\u8ba2\u5355\u5df2\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u64cd\u4f5c\u4e0b\u5355\uff01");
        }
        log.info("OutpatientPaymentServiceImpl.createOutpatientPayment->\u4eceredis\u83b7\u53d6\u6570\u636e\uff0c\u83b7\u53d6\u7684\u7ed3\u679c\u4e3a\uff1a{}", (Object)payItemDatasDTOStr);
        PayItemDatasDTO payItemDatasDTO = (PayItemDatasDTO)JSON.parseObject((String)payItemDatasDTOStr, PayItemDatasDTO.class);
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqJF());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
        }
        OpBusinessOrderEntity orderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outpatientPaymentReqVO.getOutPatientId());
        if (null != orderEntity) {
            OutpatientPayReqVO outpatientPayReqVO = this.buildOutpatientPayReqVO(orderEntity, outpatientPaymentReqVO, serviceMerchantConfigEntity);
            log.info("outpatientPayment \u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u53c2\u6570-> :{}", (Object)outpatientPayReqVO);
            BaseResponse baseResponse = this.payCreateOrder(outpatientPayReqVO);
            log.info("outpatientPayment \u95e8\u8bca\u7f34\u8d39\u8bf7\u6c42\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
            return baseResponse;
        }
        OpBusinessOrderEntity opBusinessOrderEntity = this.buildOpBusinessOrderEntity(payItemDatasDTO, outpatientPaymentReqVO);
        this.opBusinessOrderEntityMapper.insertSelective(opBusinessOrderEntity);
        List opBusinessOrderDetailEntityList = this.buildOpBusinessOrderDetailEntity(payItemDatasDTO, outpatientPaymentReqVO.getHospitalName());
        for (OpBusinessOrderDetailEntity opBusinessOrderDetailEntity : opBusinessOrderDetailEntityList) {
            this.opBusinessOrderDetailEntityMapper.insertSelective(opBusinessOrderDetailEntity);
        }
        OpRechargePaymentOrderEntity opRechargePaymentOrder = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outpatientPaymentReqVO.getOutPatientId());
        OutpatientPayReqVO outpatientPayReqVO = this.buildOutpatientPayReqVO(opBusinessOrderEntity, outpatientPaymentReqVO, serviceMerchantConfigEntity);
        log.info("outpatientPayment \u95e8\u8bca\u7f34\u8d39\u652f\u4ed8\u53c2\u6570-> :{}", (Object)outpatientPayReqVO);
        BaseResponse baseResponse = this.payCreateOrder(outpatientPayReqVO);
        log.info("outpatientPayment \u95e8\u8bca\u7f34\u8d39\u8bf7\u6c42\u652f\u4ed8\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        opBusinessOrderEntity.setChannelCode(outpatientPaymentReqVO.getChannelCode());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        if (null != opRechargePaymentOrder) {
            return baseResponse;
        }
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.buildOpRechargePaymentOrderEntity(outpatientPaymentReqVO, opBusinessOrderEntity);
        this.opRechargePaymentOrderEntityMapper.insertSelective(opRechargePaymentOrderEntity);
        return baseResponse;
    }

    public BaseResponse<String> outPatientRefund(String outPatientId) {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientAndOrderType(outPatientId, String.valueOf(OrderTypeEnum.PAYMENT_ORDER.getValue()));
        if (null == opRechargePaymentOrderEntity) {
            return BaseResponse.error((String)"\u6ca1\u6709\u67e5\u5230\u53ef\u9000\u6b3e\u8ba2\u5355");
        }
        if (!PayStatusEnum.HAS_PAY_OR_REFUND.getValue().equals(opRechargePaymentOrderEntity.getPayStatus())) {
            return BaseResponse.error((String)"\u5f53\u524d\u72b6\u6001\u4e0d\u53ef\u9000");
        }
        BaseResponse baseResponse = this.outpatientRefund(opBusinessOrderEntity, opRechargePaymentOrderEntity);
        if (!baseResponse.isSuccess()) {
            opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getValue());
            opBusinessOrderEntity.setRemark(BusinessOrderStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getDisplay());
            this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
            log.error("\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
            return BaseResponse.error((String)"\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getValue());
        opBusinessOrderEntity.setRemark(BusinessOrderStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getDisplay());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        this.saveOpRechargePaymentOrder(opRechargePaymentOrderEntity);
        return BaseResponse.success((Object)"\u53d1\u8d77\u9000\u6b3e\u6210\u529f");
    }

    public GetPayItemRespVO getNucleicPayItem(GetAdmissionReqVO getAdmissionReqVO) throws OutpatientPaymentException {
        return null;
    }

    private BaseResponse<String> outpatientRefund(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity) {
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqJF());
        if (null == serviceMerchantConfigEntity) {
            return BaseResponse.error((String)"\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u5931\u8d25");
        }
        RefundOrderVoReq refundOrderVoReq = new RefundOrderVoReq();
        refundOrderVoReq.setPayChannel(opRechargePaymentOrderEntity.getPaymentSeq());
        refundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        refundOrderVoReq.setOutTradeNo(opRechargePaymentOrderEntity.getOutPatientId());
        refundOrderVoReq.setDealTradeNo(opRechargePaymentOrderEntity.getDealSeq());
        refundOrderVoReq.setTotalAmount(opBusinessOrderEntity.getMoney());
        refundOrderVoReq.setRefundAmount(opRechargePaymentOrderEntity.getDealMoney());
        refundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        refundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        refundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getOutpatientRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)refundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        refundOrderVoReq.setSign(sign);
        log.info("RefundServiceImpl.refund->start\uff0c\u8bf7\u6c42\u53c2\u6570refundOrderVoReq\u4e3a\uff1a{}", (Object)refundOrderVoReq);
        BaseResponse baseResponse = this.refund(refundOrderVoReq);
        log.info("RefundServiceImpl.refund->\u8bf7\u6c42\u9000\u6b3e\u8fd4\u56de\u4fe1\u606f\uff1abaseResponse:{}", (Object)baseResponse);
        if (baseResponse == null) {
            log.error("RefundServiceImpl.outpatientPaymentRefund->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u8fd4\u56de\u53c2\u6570baseResponse\u4e3a\u7a7a");
            return BaseResponse.error((String)"\u53d1\u8d77\u9000\u6b3e\u5931\u8d25");
        }
        if (!baseResponse.getCode().equals("1")) {
            log.error("RefundServiceImpl.outpatientPaymentRefund->\u53d1\u8d77\u9000\u6b3e\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f\u4e3a\uff1a{}", (Object)baseResponse.getMsg());
        }
        return baseResponse;
    }

    private OutpatientPayReqVO buildOutpatientPayReqVO(OpBusinessOrderEntity opBusinessOrderEntity, OutpatientPaymentReqVO outpatientPaymentReqVO, ServiceMerchantConfigEntity serviceMerchantConfigEntity) {
        OutpatientPayReqVO outpatientPayReqVO = new OutpatientPayReqVO();
        outpatientPayReqVO.setMchCode(this.propertiesConstant.getMchCode());
        outpatientPayReqVO.setOutTradeNo(outpatientPaymentReqVO.getOutPatientId());
        outpatientPayReqVO.setPayChannel(outpatientPaymentReqVO.getPayChannel());
        outpatientPayReqVO.setPayType(outpatientPaymentReqVO.getPayType());
        outpatientPayReqVO.setProductInfo("\u95e8\u8bca\u7f34\u8d39");
        outpatientPayReqVO.setServiceCode(ServiceCodeEnum.OUTPATIENT.getValue());
        outpatientPayReqVO.setActuallyAmount(opBusinessOrderEntity.getMoney());
        outpatientPayReqVO.setTotalAmount(opBusinessOrderEntity.getMoney());
        outpatientPayReqVO.setUserSign(outpatientPaymentReqVO.getOpenId());
        outpatientPayReqVO.setNonceStr(SignUtil.getNonceStr());
        outpatientPayReqVO.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        outpatientPayReqVO.setPayNotifyUrl(this.propertiesConstant.getOutpatientPayNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)outpatientPayReqVO);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        outpatientPayReqVO.setSign(sign);
        return outpatientPayReqVO;
    }

    private OpRechargePaymentOrderEntity buildOpRechargePaymentOrderEntity(OutpatientPaymentReqVO outpatientPaymentReqVO, OpBusinessOrderEntity opBusinessOrderEntity) {
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = new OpRechargePaymentOrderEntity();
        Date date = new Date();
        opRechargePaymentOrderEntity.setCreateTime(date);
        opRechargePaymentOrderEntity.setUpdateTime(date);
        opRechargePaymentOrderEntity.setRemark("\u5f85\u652f\u4ed8");
        opRechargePaymentOrderEntity.setOutPatientId(outpatientPaymentReqVO.getOutPatientId());
        opRechargePaymentOrderEntity.setOrderType(Byte.valueOf(OrderTypeEnum.PAYMENT_ORDER.getValue().byteValue()));
        opRechargePaymentOrderEntity.setDealMoney(opBusinessOrderEntity.getMoney());
        opRechargePaymentOrderEntity.setBizSysSeq(ServiceCodeEnum.OUTPATIENT.getValue());
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)0));
        opRechargePaymentOrderEntity.setMerchantSeq(this.propertiesConstant.getMchCode());
        opRechargePaymentOrderEntity.setPaymentSeq(outpatientPaymentReqVO.getPayChannel());
        opRechargePaymentOrderEntity.setUserId(outpatientPaymentReqVO.getUserId());
        return opRechargePaymentOrderEntity;
    }

    private BaseResponse<String> payCreateOrder(OutpatientPayReqVO outpatientPayReqVO) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getPayUrl(), (String)JSON.toJSONString((Object)outpatientPayReqVO));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("OutpatientPaymentServiceImpl.payCreateOrder->\u53d1\u8d77\u652f\u4ed8\u8fd4\u56de\u53c2\u6570baseResponse: " + baseResponse);
            if (null == baseResponse) {
                return BaseResponse.error((String)"\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
            }
            return baseResponse;
        }
        catch (Exception e) {
            log.error("OutpatientPaymentServiceImpl.payCreateOrder\u95e8\u8bca\u7f34\u8d39\u53d1\u8d77\u5931\u8d25,\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + e.getMessage());
            return BaseResponse.error((String)"\u53d1\u8d77\u652f\u4ed8\u5931\u8d25");
        }
    }

    public PaySuccessInfoRespVO getPaySuccessInfo(String outPatientId) throws OutpatientPaymentException {
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outPatientId);
        List opBusinessOrderDetailList = this.opBusinessOrderDetailEntityMapper.selectByOutPatientId(outPatientId);
        if (null == opBusinessOrderEntity || null == opRechargePaymentOrderEntity || CollectionUtils.isEmpty((Collection)opBusinessOrderDetailList)) {
            throw new OutpatientPaymentException();
        }
        return this.buildPaySuccessInfoRespVO(opBusinessOrderEntity, opRechargePaymentOrderEntity, opBusinessOrderDetailList);
    }

    private PaySuccessInfoRespVO buildPaySuccessInfoRespVO(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, List<OpBusinessOrderDetailEntity> opBusinessOrderDetailList) {
        PaySuccessInfoRespVO paySuccessInfoRespVO = new PaySuccessInfoRespVO();
        paySuccessInfoRespVO.setDeptName(opBusinessOrderEntity.getDeptName());
        paySuccessInfoRespVO.setDocName(opBusinessOrderEntity.getDocName());
        paySuccessInfoRespVO.setAdmDate(opBusinessOrderEntity.getAdmTime());
        paySuccessInfoRespVO.setAmount(opRechargePaymentOrderEntity.getDealMoney().toString());
        paySuccessInfoRespVO.setOutPatientId(opRechargePaymentOrderEntity.getOutPatientId());
        paySuccessInfoRespVO.setPaymentSeq(opRechargePaymentOrderEntity.getPaymentSeq());
        TreeSet<String> itemType = new TreeSet<String>();
        for (OpBusinessOrderDetailEntity opBusinessOrderDetail : opBusinessOrderDetailList) {
            if (StringUtils.isEmpty((Object)opBusinessOrderDetail.getItemType())) continue;
            itemType.add(opBusinessOrderDetail.getItemType());
        }
        if (!CollectionUtils.isEmpty(itemType)) {
            ArrayList<ItemTypeVo> list = new ArrayList<ItemTypeVo>();
            for (String key : itemType) {
                ItemTypeVo itemTypeVo = new ItemTypeVo();
                if (ItemTypeEnum.MEDICAL_PAY.getValue().equals(key)) {
                    itemTypeVo.setPayItem(ItemTypeEnum.MEDICAL_PAY.getDisplay());
                }
                if (ItemTypeEnum.DIAGNOSIS_PAY.getValue().equals(key)) {
                    itemTypeVo.setPayItem(ItemTypeEnum.DIAGNOSIS_PAY.getDisplay());
                }
                list.add(itemTypeVo);
            }
            paySuccessInfoRespVO.setItemType(list);
        }
        if (opRechargePaymentOrderEntity.getPaymentSeq() != null && WECHAT.equals(opRechargePaymentOrderEntity.getPaymentSeq())) {
            paySuccessInfoRespVO.setPaymentSeqName("\u5fae\u4fe1\u652f\u4ed8");
        } else if (opRechargePaymentOrderEntity.getPaymentSeq() != null && ALIPAY.equals(opRechargePaymentOrderEntity.getPaymentSeq())) {
            paySuccessInfoRespVO.setPaymentSeqName("\u652f\u4ed8\u5b9d\u652f\u4ed8");
        }
        return paySuccessInfoRespVO;
    }

    public List<OutpatientPaymentOrderRespVO> getOutpatientPaymentOrder(OutpatientPaymentOrderReqVO outpatientPaymentOrderReqVO) throws OutpatientPaymentException {
        ArrayList<OutpatientPaymentOrderRespVO> outpatientPaymentOrderRespVOList = new ArrayList<OutpatientPaymentOrderRespVO>();
        OpBusinessOrderEntity opBusinessOrderEntity = new OpBusinessOrderEntity();
        opBusinessOrderEntity.setUserId(outpatientPaymentOrderReqVO.getUserId());
        opBusinessOrderEntity.setCardNo(outpatientPaymentOrderReqVO.getCardNo());
        List opBusinessOrderEntities = this.opBusinessOrderEntityMapper.selectByCardNoAndUserId(opBusinessOrderEntity);
        if (null == opBusinessOrderEntities || opBusinessOrderEntities.isEmpty()) {
            return outpatientPaymentOrderRespVOList;
        }
        for (OpBusinessOrderEntity opBusinessOrder : opBusinessOrderEntities) {
            OutpatientPaymentOrderRespVO outpatientPaymentOrderRespVO = new OutpatientPaymentOrderRespVO();
            outpatientPaymentOrderRespVO.setCreateTime(opBusinessOrder.getCreateTime().getTime());
            outpatientPaymentOrderRespVO.setDeptName(opBusinessOrder.getDeptName());
            outpatientPaymentOrderRespVO.setDocName(opBusinessOrder.getDocName());
            outpatientPaymentOrderRespVO.setOutPatientId(opBusinessOrder.getOutPatientId());
            outpatientPaymentOrderRespVO.setPayStatus(opBusinessOrder.getStatus().toString());
            outpatientPaymentOrderRespVO.setAdmDate(opBusinessOrder.getAdmTime());
            outpatientPaymentOrderRespVO.setAmount(opBusinessOrder.getMoney());
            outpatientPaymentOrderRespVOList.add(outpatientPaymentOrderRespVO);
        }
        outpatientPaymentOrderRespVOList.sort(Comparator.comparing(OutpatientPaymentOrderRespVO::getAdmDate).reversed());
        return outpatientPaymentOrderRespVOList;
    }

    private void saveOpRechargePaymentOrder(OpRechargePaymentOrderEntity opRechargePaymentOrderEntity) {
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntityNew = new OpRechargePaymentOrderEntity();
        opRechargePaymentOrderEntityNew.setRemark("\u95e8\u8bca\u7f34\u8d39\uff0c\u7ba1\u7406\u7aef\u53d1\u8d77\u9000\u6b3e");
        opRechargePaymentOrderEntityNew.setOutPatientId(opRechargePaymentOrderEntity.getOutPatientId());
        opRechargePaymentOrderEntityNew.setDealSeq(opRechargePaymentOrderEntity.getDealSeq());
        opRechargePaymentOrderEntityNew.setOrderType(Byte.valueOf((byte)OrderTypeEnum.REFUND_ORDER.getValue().intValue()));
        Date now = new Date();
        opRechargePaymentOrderEntityNew.setCreateTime(now);
        opRechargePaymentOrderEntityNew.setUpdateTime(now);
        opRechargePaymentOrderEntityNew.setDealMoney(opRechargePaymentOrderEntity.getDealMoney());
        opRechargePaymentOrderEntityNew.setBizSysSeq(opRechargePaymentOrderEntity.getBizSysSeq());
        opRechargePaymentOrderEntityNew.setPayStatus(Byte.valueOf((byte)PayStatusEnum.WAIT_PAY_OR_REFUND.getValue().intValue()));
        opRechargePaymentOrderEntityNew.setMerchantSeq(opRechargePaymentOrderEntity.getMerchantSeq());
        opRechargePaymentOrderEntityNew.setMerchantId(opRechargePaymentOrderEntity.getMerchantId());
        opRechargePaymentOrderEntityNew.setPaymentSeq(opRechargePaymentOrderEntity.getPaymentSeq());
        opRechargePaymentOrderEntityNew.setUserId(opRechargePaymentOrderEntity.getUserId());
        this.opRechargePaymentOrderEntityMapper.insertSelective(opRechargePaymentOrderEntityNew);
    }

    private BaseResponse<String> refund(RefundOrderVoReq refundOrderVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)refundOrderVoReq));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            if (null == baseResponse) {
                return BaseResponse.error((String)"\u8c03\u7528\u5931\u8d25");
            }
            return baseResponse;
        }
        catch (Exception e) {
            log.error("RefundServiceImpl.refund->\u8c03\u7528\u9000\u6b3e\u63a5\u53e3\u5931\u8d25\uff0c\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a{}", (Object)e.getMessage());
            return BaseResponse.error((String)"\u8c03\u7528\u5931\u8d25");
        }
    }

    private List<GuidedInfoResVO> getGuidedInfo(String outPatientId) {
        OpGuideEntity opGuideEntity = this.opGuideEntityMapper.selectByOutPatientId(outPatientId);
        if (null == opGuideEntity) {
            return new ArrayList<GuidedInfoResVO>();
        }
        String guideInfo = opGuideEntity.getGuideInfo();
        String[] split = guideInfo.split("\\|\\|");
        ArrayList<GuidedInfoResVO> guidedInfoList = new ArrayList<GuidedInfoResVO>();
        for (int i = 0; i < split.length; ++i) {
            String[] split1 = split[i].split("\\^\\^");
            System.out.println(split1.length);
            GuidedInfoResVO guidedInfoResVO = new GuidedInfoResVO();
            guidedInfoResVO.setGuidedItem(split1[0]);
            guidedInfoResVO.setGuidedDesc(split1[1]);
            guidedInfoList.add(guidedInfoResVO);
        }
        return guidedInfoList;
    }
}

