/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.api.AppointApi;
import com.ebaiyihui.his.api.HisBillApi;
import com.ebaiyihui.his.api.OutpatientPaymentApi;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationMsg;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationReq;
import com.ebaiyihui.his.pojo.vo.appoint.PayRegistrationRes;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackReq;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackRes;
import com.ebaiyihui.his.pojo.vo.hospitalization.DepositRes;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewReq;
import com.ebaiyihui.his.pojo.vo.outpatient.ComfirmPayNewRes;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.BusinessTypeEnums;
import com.ebaiyihui.wisdommedical.common.enums.ChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.DayAppointRefundCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.PayChannelEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceBillTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServicePayBillStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.exception.OutpatientPaymentException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.BusinessResultMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpGuideEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.mapper.ServicePayBillMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.BusinessResultEntity;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.OpGuideEntity;
import com.ebaiyihui.wisdommedical.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.model.ServicePayBillEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.InHospDepostPayCallDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.PayPlatformCallBackVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.ReponsePrePayVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestPayVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestPrePayVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestRefundOrderVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseNotifyRestVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseRefundNotifyRestVo;
import com.ebaiyihui.wisdommedical.service.AppointmentService;
import com.ebaiyihui.wisdommedical.service.IWaitingQueueService;
import com.ebaiyihui.wisdommedical.service.InHospitalService;
import com.ebaiyihui.wisdommedical.service.PayCallBackService;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetUserInfoUtil;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;

@Service
public class PayCallBackServiceImpl
implements PayCallBackService {
    private static final Logger log = LoggerFactory.getLogger(PayCallBackServiceImpl.class);
    public static final String ACCEPT_REQUEST = "0";
    public static final String PAY_SUCCESS = "3";
    public static final String SUCCESS = "Y";
    public static final String HIS_SUCCESS = "1";
    public static final byte TO_BE_PAID = 0;
    public static final byte PAID = 1;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private AppointApi appointApi;
    @Autowired
    private HisBillApi hisBillApi;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private BusinessResultMapper businessResultMapper;
    @Autowired
    private AppointmentService appointmentService;
    @Autowired
    private PushService pushService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private IWaitingQueueService iWaitingQueueService;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private InHospitalService inHospitalService;
    @Autowired
    private OpGuideEntityMapper opGuideEntityMapper;
    @Autowired
    private OutpatientPaymentApi outpatientPaymentApi;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private GetUserInfoUtil getUserInfoUtil;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private ProPropertiesConstant projProperties;

    public void dayAppointmentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + JSON.toJSONString((Object)responseNotifyRestVo.toString()));
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null != serviceMerchantConfigEntity) {
            Map params = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            if (!SignUtil.checkSign((Map)params, (String)serviceMerchantConfigEntity.getApplyKey())) {
                throw new AppointmentException("\u9a8c\u7b7e\u5931\u8d25\uff0c\u652f\u4ed8\u56de\u8c03\u4fe1\u606f\u53ef\u80fd\u88ab\u7be1\u6539");
            }
        } else {
            throw new AppointmentException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
        }
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVo, appointmentRecordEntity);
        if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) {
            return;
        }
        this.waitHisConfirm(responseNotifyRestVo, appointmentRecordEntity);
        GatewayRequest gatewayRequest = this.buildDayRegisterParams(appointmentRecordEntity, responseNotifyRestVo);
        BusinessResultEntity businessResultEntity = new BusinessResultEntity();
        businessResultEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        businessResultEntity.setBusinessType(new Byte(BusinessTypeEnums.PAI_CONFIRM.getValue().toString()));
        businessResultEntity.setHisRequest(JSON.toJSONString((Object)gatewayRequest));
        this.businessResultMapper.insertSelective(businessResultEntity);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse dayRegisterGatewayRes = this.appointApi.dayPayReg(gatewayRequest);
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u8bf7\u6c42his\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)dayRegisterGatewayRes));
        if (null != dayRegisterGatewayRes) {
            businessResultEntity.setErrorCode(dayRegisterGatewayRes.getErrCode());
            businessResultEntity.setErrorMsg(dayRegisterGatewayRes.getMsg());
            businessResultEntity.setTransationId(dayRegisterGatewayRes.getTransactionId());
        }
        businessResultEntity.setHisResponse(JSON.toJSONString((Object)dayRegisterGatewayRes));
        businessResultEntity.setStatus(new Byte(ACCEPT_REQUEST));
        this.businessResultMapper.updateByPrimaryKeySelective(businessResultEntity);
        if (null == dayRegisterGatewayRes) {
            log.error("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8 dayRegister -> \u8bf7\u6c42his\u4e0d\u901a,\u9000\u6b3e");
            BaseResponse baseResponse = this.appointRefund(appointmentRecordEntity, responseNotifyRestVo, serviceMerchantConfigEntity);
            if (HIS_SUCCESS.equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a,\u9000\u6b3e");
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark("\u8bf7\u6c42his\u4e0d\u901a\uff0c\u9000\u6b3e" + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            throw new AppointmentException(dayRegisterGatewayRes.getMsg());
        }
        if (!HIS_SUCCESS.equals(dayRegisterGatewayRes.getCode())) {
            String remark = DayAppointRefundCodeEnum.getDisplay((Integer)Integer.parseInt(dayRegisterGatewayRes.getErrCode()));
            BaseResponse baseResponse = this.appointRefund(appointmentRecordEntity, responseNotifyRestVo, serviceMerchantConfigEntity);
            if (HIS_SUCCESS.equals(baseResponse.getCode())) {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue());
                appointmentRecordEntity.setRemark(remark);
            } else {
                appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getValue());
                appointmentRecordEntity.setRemark(remark + AppointmentStatusEnum.LAUNCH_AUTO_REFUND_FAIL.getDisplay());
            }
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            log.error("\u5f53\u65e5\u6302\u53f7 dayRegister -> his\u6302\u53f7\u5931\u8d25 err_code:{},mag:{}", (Object)dayRegisterGatewayRes.getErrCode(), (Object)dayRegisterGatewayRes.getMsg());
            throw new AppointmentException(dayRegisterGatewayRes.getMsg());
        }
        PayRegistrationRes dayRegisterRes = (PayRegistrationRes)dayRegisterGatewayRes.getData();
        this.updateHisReturnMsg(appointmentRecordEntity, dayRegisterRes);
        this.updateAppointmentPayorder(appointmentRecordEntity, payOrderEntity, dayRegisterRes);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(appointmentRecordEntity.getHospitalCode());
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTradeNo());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
    }

    private BaseResponse<String> appointRefund(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo, ServiceMerchantConfigEntity serviceMerchantConfigEntity) {
        RequestRefundOrderVoReq requestRefundOrderVoReq = new RequestRefundOrderVoReq();
        requestRefundOrderVoReq.setPayChannel(appointmentRecordEntity.getPayChannelCode());
        requestRefundOrderVoReq.setMchCode(this.propertiesConstant.getMchCode());
        requestRefundOrderVoReq.setOutTradeNo(appointmentRecordEntity.getSysAppointmentId());
        requestRefundOrderVoReq.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        requestRefundOrderVoReq.setTotalAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setRefundAmount(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        requestRefundOrderVoReq.setNonceStr(SignUtil.getNonceStr());
        requestRefundOrderVoReq.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        requestRefundOrderVoReq.setRefundNotifyUrl(this.propertiesConstant.getRefundNotifyUrl());
        Map map = SignUtil.getKeyAndValue((Object)requestRefundOrderVoReq);
        String sign = SignUtil.createSign((Map)map, (String)serviceMerchantConfigEntity.getApplyKey(), (String[])new String[0]);
        requestRefundOrderVoReq.setSign(sign);
        log.info("\u5f53\u65e5\u6302\u53f7\u81ea\u52a8\u9000\u6b3e\u8bf7\u6c42\u53c2\u6570\u4e3a:{}", (Object)JSON.toJSONString((Object)requestRefundOrderVoReq));
        return this.refund(requestRefundOrderVoReq);
    }

    private BaseResponse<String> refund(RequestRefundOrderVoReq requestRefundOrderVoReq) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getRefundUrl(), (String)JSON.toJSONString((Object)requestRefundOrderVoReq));
            BaseResponse response = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            return response;
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u8bf7\u6c42\u5931\u8d25\uff0c\u539f\u56e0\u662f:{}", (Object)e.getMessage());
            return BaseResponse.error((String)e.getMessage());
        }
    }

    private AppointmentPayorderEntity saveAppointmentPayorder(ResponseNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity) {
        AppointmentPayorderEntity payOrderEntity = new AppointmentPayorderEntity();
        payOrderEntity.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        payOrderEntity.setMerchantId(responseNotifyRestVo.getMchId());
        payOrderEntity.setBizSysSeq(responseNotifyRestVo.getServiceCode());
        payOrderEntity.setPaymentTime(responseNotifyRestVo.getPayTime());
        payOrderEntity.setPayBillNo(responseNotifyRestVo.getTradeNo());
        payOrderEntity.setOrderStatus(new Byte(PAY_SUCCESS));
        payOrderEntity.setDealMoney(new BigDecimal(appointmentRecordEntity.getPayAmount()));
        payOrderEntity.setSysAppointmentId(appointmentRecordEntity.getSysAppointmentId());
        payOrderEntity.setBizDealSeq(String.valueOf(this.snowflakeIdWorker.nextId()));
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        this.appointmentPayOrderMapper.insertSelective(payOrderEntity);
        return payOrderEntity;
    }

    private void updateAppointmentPayorder(AppointmentRecordEntity appointmentRecordEntity, AppointmentPayorderEntity payOrderEntity, PayRegistrationRes dayRegisterRes) {
        payOrderEntity.setUserId(appointmentRecordEntity.getUserId());
        payOrderEntity.setHospitalCode(appointmentRecordEntity.getHospitalCode());
        payOrderEntity.setBusinessByToDay(JSON.toJSONString((Object)dayRegisterRes));
        payOrderEntity.setChannelCode(appointmentRecordEntity.getChannelCode());
        payOrderEntity.setPatientId(appointmentRecordEntity.getPatientId());
        payOrderEntity.setPaymentSeq(appointmentRecordEntity.getPayChannelCode());
        this.appointmentPayOrderMapper.updateByPrimaryKey(payOrderEntity);
    }

    private void updateHisReturnMsg(AppointmentRecordEntity appointmentRecordEntity, PayRegistrationRes dayRegisterRes) {
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.PAY.getValue());
        appointmentRecordEntity.setReceptId(dayRegisterRes.getReceiptId());
        appointmentRecordEntity.setRemark("\u652f\u4ed8\u6210\u529f\uff0chis\u5f53\u65e5\u6302\u53f7\u786e\u8ba4\u6210\u529f");
        log.info("\u5f53\u65e5\u6302\u53f7\u652f\u4ed8\u4fdd\u5b58his\u8fd4\u56dereceiptId\u8ba2\u5355:" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    private void waitHisConfirm(ResponseNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity) {
        appointmentRecordEntity.setPayAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        appointmentRecordEntity.setPayPostId(responseNotifyRestVo.getMchId());
        appointmentRecordEntity.setPayTransationId(responseNotifyRestVo.getTradeNo());
        appointmentRecordEntity.setPayChannel(PayChannelEnum.getDisplay((String)responseNotifyRestVo.getPayChannel()));
        appointmentRecordEntity.setPayChannelCode(responseNotifyRestVo.getPayChannel());
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.WAIT_HIS_CONFIRM.getValue());
        appointmentRecordEntity.setRemark(AppointmentStatusEnum.WAIT_HIS_CONFIRM.getDisplay());
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u6210\u529f\uff0c\u5f85his\u786e\u8ba4\uff1a" + JSON.toJSONString((Object)appointmentRecordEntity));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
    }

    private GatewayRequest<PayRegistrationReq> buildDayRegisterParams(AppointmentRecordEntity appointmentRecordEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        PayRegistrationReq payRegistrationReq = new PayRegistrationReq();
        payRegistrationReq.setCardNo(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setPatientId(appointmentRecordEntity.getPatientCardNo());
        payRegistrationReq.setScheduleId(appointmentRecordEntity.getAppointmentId());
        payRegistrationReq.setAppointId(appointmentRecordEntity.getAppointmentNo());
        payRegistrationReq.setRegFee(appointmentRecordEntity.getPayAmount());
        payRegistrationReq.setFlowNo(responseNotifyRestVo.getTradeNo());
        payRegistrationReq.setAppointDate(appointmentRecordEntity.getAdmDate());
        payRegistrationReq.setPayChannel(appointmentRecordEntity.getPayChannel());
        payRegistrationReq.setScheduleId(appointmentRecordEntity.getHisTimeArrangeId());
        PayRegistrationMsg payRegistrationMsg = new PayRegistrationMsg();
        payRegistrationMsg.setOrderid(responseNotifyRestVo.getOutTradeNo());
        payRegistrationMsg.setPayment(appointmentRecordEntity.getPayAmount());
        payRegistrationMsg.setSuccess(SUCCESS);
        payRegistrationReq.setRespMsg(payRegistrationMsg);
        gatewayRequest.setBody((Object)payRegistrationReq);
        gatewayRequest.setChannel(appointmentRecordEntity.getChannelCode());
        gatewayRequest.setOrganCode(appointmentRecordEntity.getHospitalCode());
        gatewayRequest.setKeyWord("dayRegister");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    public void appointmentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u9884\u7ea6\u6302\u53f7\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + responseNotifyRestVo.toString());
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null != serviceMerchantConfigEntity) {
            Map params = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            if (!SignUtil.checkSign((Map)params, (String)serviceMerchantConfigEntity.getApplyKey())) {
                throw new AppointmentException("\u9a8c\u7b7e\u5931\u8d25\uff0c\u652f\u4ed8\u56de\u8c03\u4fe1\u606f\u53ef\u80fd\u88ab\u7be1\u6539");
            }
        } else {
            throw new AppointmentException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
        }
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        log.info("\u652f\u4ed8\u6210\u529f------>{}", (Object)sysAppointmentId);
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        log.info("\u652f\u4ed8\u6210\u529f------>{}", (Object)appointmentRecordEntity);
        AppointmentPayorderEntity payOrderEntity = this.saveAppointmentPayorder(responseNotifyRestVo, appointmentRecordEntity);
        if (AppointmentStatusEnum.WAIT_PAY.getValue().intValue() != appointmentRecordEntity.getAppointStatus().intValue()) {
            return;
        }
        this.waitHisConfirm(responseNotifyRestVo, appointmentRecordEntity);
        this.appointmentService.payAppointmentPayToHis(appointmentRecordEntity, responseNotifyRestVo, payOrderEntity);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(appointmentRecordEntity.getHospitalCode());
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTradeNo());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        this.taskExecutor.execute(() -> this.pushService.appointmentSuccessMsgPush(appointmentRecordEntity));
    }

    public List<PayPlatformCallBackVoRes> payPlatformCallBack(String posId, String tranDate) {
        return this.appointmentRecordMapper.selectByPayPosIdAndDate(posId, tranDate, this.propertiesConstant.getOrganCode());
    }

    public void outpatientPaymentCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws OutpatientPaymentException {
        log.info("\u7f34\u8d39\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + responseNotifyRestVo.toString());
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqJF());
        if (null == serviceMerchantConfigEntity) {
            throw new OutpatientPaymentException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
        }
        String outPatientId = responseNotifyRestVo.getOutTradeNo();
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outPatientId);
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)1));
        opRechargePaymentOrderEntity.setPayBillNo(responseNotifyRestVo.getTradeNo());
        opRechargePaymentOrderEntity.setPaymentTime(responseNotifyRestVo.getPayTime());
        opRechargePaymentOrderEntity.setMerchantId(responseNotifyRestVo.getMchId());
        opRechargePaymentOrderEntity.setUpdateTime(new Date());
        opRechargePaymentOrderEntity.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        opRechargePaymentOrderEntity.setRemark("\u5df2\u652f\u4ed8");
        log.info("\u66f4\u65b0\u652f\u4ed8\u4fe1\u606f\uff0c\u53c2\u6570\u4e3aopRechargePaymentOrderEntity\uff1a{}", (Object)opRechargePaymentOrderEntity);
        this.opRechargePaymentOrderEntityMapper.updateByPrimaryKey(opRechargePaymentOrderEntity);
        FrontRequest frontRequest = this.buildUp(opBusinessOrderEntity);
        String responseUp = null;
        try {
            responseUp = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "card/topup"), (String)JSON.toJSONString((Object)frontRequest));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        FrontResponse frontResponseUp = (FrontResponse)JSON.parseObject(responseUp, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (!HIS_SUCCESS.equals(frontResponseUp.getCode())) {
            throw new OutpatientPaymentException("\u8d26\u6237\u5145\u503c\u5931\u8d25");
        }
        ReponsePrePayVo reponsePrePayVo = (ReponsePrePayVo)frontResponseUp.getBody();
        if (reponsePrePayVo != null) {
            BigDecimal a = opBusinessOrderEntity.getMoney();
            BigDecimal b = new BigDecimal(reponsePrePayVo.getVacancy());
            if (b.compareTo(a) < 0) {
                throw new OutpatientPaymentException("\u8d26\u6237\u4f59\u989d\u4e0d\u8db3\u65e0\u6cd5\u7f34\u8d39");
            }
        }
        FrontRequest gatewayRequest = this.buildComfirmPayNewReq(opBusinessOrderEntity, opRechargePaymentOrderEntity, responseNotifyRestVo);
        String response = null;
        try {
            response = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "api/v1/hospitalTitle/payCost"), (String)JSON.toJSONString((Object)gatewayRequest));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject(response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (!HIS_SUCCESS.equals(frontResponse.getCode())) {
            throw new OutpatientPaymentException("\u7f34\u8d39\u5931\u8d25");
        }
        if (HIS_SUCCESS.equals(frontResponse.getCode())) {
            String receiptId = ((ReponsePrePayVo)frontResponse.getBody()).getInvoiceNo();
            opBusinessOrderEntity.setReceiptId(receiptId);
        }
        if (ChannelEnum.USER_APPLETS.getValue().equals(opBusinessOrderEntity.getChannelCode())) {
            this.taskExecutor.execute(() -> this.pushService.outPatientSuccessMsgPush(opBusinessOrderEntity, DateUtils.dateToFullString((Date)responseNotifyRestVo.getPayTime())));
        }
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.PAID.getValue());
        opBusinessOrderEntity.setPayTime(responseNotifyRestVo.getPayTime());
        opBusinessOrderEntity.setRemark("\u5df2\u652f\u4ed8");
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(this.propertiesConstant.getOrganCode());
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTradeNo());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
    }

    public FrontRequest<RequestPrePayVo> buildUp(OpBusinessOrderEntity opBusinessOrderEntity) {
        FrontRequest frontRequest = new FrontRequest();
        RequestPrePayVo requestPrePayVo = new RequestPrePayVo();
        requestPrePayVo.setBankNo("Wechat");
        requestPrePayVo.setBankName("\u5fae\u4fe1");
        requestPrePayVo.setAmt(opBusinessOrderEntity.getMoney().toString());
        requestPrePayVo.setPayMode("YS");
        requestPrePayVo.setCardNo(opBusinessOrderEntity.getCardNo());
        requestPrePayVo.setFlowNo(opBusinessOrderEntity.getOutPatientId());
        frontRequest.setBody((Object)requestPrePayVo);
        frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return frontRequest;
    }

    public void inHospDepositPayCallBack(ResponseNotifyRestVo responseNotifyRestVo) throws InHospitalException {
        log.info("\u4f4f\u9662\u5145\u503c\u652f\u4ed8\u56de\u8c03responseNotifyRestVo: " + responseNotifyRestVo.toString());
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqZY());
        if (null != serviceMerchantConfigEntity) {
            Map params = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            if (!SignUtil.checkSign((Map)params, (String)serviceMerchantConfigEntity.getApplyKey())) {
                throw new InHospitalException("\u9a8c\u7b7e\u5931\u8d25\uff0c\u652f\u4ed8\u56de\u8c03\u4fe1\u606f\u53ef\u80fd\u88ab\u7be1\u6539");
            }
        } else {
            throw new InHospitalException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u652f\u4ed8\u56de\u8c03\u5931\u8d25");
        }
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(responseNotifyRestVo.getOutTradeNo());
        InHospDepostPayCallDTO inHospDepostPayCallDTO = new InHospDepostPayCallDTO();
        inHospDepostPayCallDTO.setPayTime(DateUtils.dateToString((Date)responseNotifyRestVo.getPayTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        inHospDepostPayCallDTO.setRemark("\u652f\u4ed8\u56de\u8c03\u6210\u529f\uff0c\u652f\u4ed8\u5b8c\u6210");
        inHospDepostPayCallDTO.setOrderSeq(inpatientDepositDetailEntity.getOrderSeq());
        inHospDepostPayCallDTO.setUpdateTime(new Date());
        inHospDepostPayCallDTO.setPayStatus(Byte.valueOf(BusinessOrderStatusEnum.WAIT_CONFIRM.getValue().byteValue()));
        inHospDepostPayCallDTO.setInpatientIepositId(String.valueOf(inpatientDepositDetailEntity.getId()));
        inHospDepostPayCallDTO.setBankTradeNo("");
        inHospDepostPayCallDTO.setMerchantId(responseNotifyRestVo.getMchId());
        inHospDepostPayCallDTO.setPaymentSeq(responseNotifyRestVo.getPayChannel());
        inHospDepostPayCallDTO.setPayBillNo(responseNotifyRestVo.getTradeNo());
        inHospDepostPayCallDTO.setDealSeq(responseNotifyRestVo.getDealTradeNo());
        this.inpatientDepositDetailEntityMapper.updateByOrderSeq(inHospDepostPayCallDTO);
        this.inpatientPayorderEntityMapper.updateByInpatientDepositId(inHospDepostPayCallDTO);
        DepositRes depositRes = this.inHospitalService.InHospDeposit(inpatientDepositDetailEntity, responseNotifyRestVo);
        inHospDepostPayCallDTO.setReceiptId(depositRes.getReceiptId());
        inHospDepostPayCallDTO.setPayStatus(Byte.valueOf(BusinessOrderStatusEnum.PAID.getValue().byteValue()));
        inHospDepostPayCallDTO.setUpdateTime(new Date());
        inHospDepostPayCallDTO.setRemark("\u5df2\u652f\u4ed8\uff0chis\u6210\u529f\u786e\u8ba4");
        this.inpatientDepositDetailEntityMapper.updateByOrderSeqToHisPaid(inHospDepostPayCallDTO);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.PAY_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.PAID.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(this.propertiesConstant.getOrganCode());
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setTradeTime(responseNotifyRestVo.getPayTime());
        servicePayBillEntity.setTradeNo(responseNotifyRestVo.getTradeNo());
        servicePayBillEntity.setOutTradeNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
        servicePayBillEntity.setOrderAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
    }

    private OpGuideEntity buildOpGuideEntity(OpBusinessOrderEntity opBusinessOrderEntity, GatewayResponse<ComfirmPayNewRes> gatewayResponse) {
        OpGuideEntity opGuideEntity = new OpGuideEntity();
        Date now = new Date();
        opGuideEntity.setGuideInfoId(String.valueOf(this.snowflakeIdWorker.nextId()));
        opGuideEntity.setGuideInfo(((ComfirmPayNewRes)gatewayResponse.getData()).getRemark());
        opGuideEntity.setCreateTime(now);
        opGuideEntity.setUpdateTime(now);
        opGuideEntity.setOutPatientId(opBusinessOrderEntity.getOutPatientId());
        opGuideEntity.setAdmId(opBusinessOrderEntity.getAdmId());
        opGuideEntity.setPatientId(opBusinessOrderEntity.getPatientId());
        opGuideEntity.setPatientOrganId(opBusinessOrderEntity.getPatientOrganId());
        opGuideEntity.setCardNo(opBusinessOrderEntity.getCardNo());
        opGuideEntity.setCardId(opBusinessOrderEntity.getCardId());
        opGuideEntity.setUserId(opBusinessOrderEntity.getUserId());
        opGuideEntity.setOrganCode(opBusinessOrderEntity.getOrganCode());
        opGuideEntity.setOrganName(opBusinessOrderEntity.getOrganName());
        return opGuideEntity;
    }

    private GatewayResponse<ComfirmPayNewRes> comfirmPayNew(GatewayRequest<ComfirmPayNewReq> gatewayRequest) throws OutpatientPaymentException {
        log.info("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3,\u8bf7\u6c42his\u53c2\u6570 gatewayRequest:{}", gatewayRequest);
        GatewayResponse gatewayResponse = this.outpatientPaymentApi.comfirmPayNew(gatewayRequest);
        log.info("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 gatewayResponse ->{}" + gatewayResponse.toString() + gatewayResponse.getCode() + gatewayResponse.getMsg() + gatewayResponse.getData());
        if (gatewayResponse == null) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (!HIS_SUCCESS.equals(gatewayResponse.getCode())) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8bf7\u6c42\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new OutpatientPaymentException(gatewayResponse.getMsg());
        }
        log.info("gatewayResponse.getData():" + ((ComfirmPayNewRes)gatewayResponse.getData()).toString());
        ComfirmPayNewRes comfirmPayNewRes = (ComfirmPayNewRes)gatewayResponse.getData();
        if (null == comfirmPayNewRes) {
            log.error("\u95e8\u8bca\u6536\u8d39\u786e\u8ba4\u63a5\u53e3 comfirmPayNew -> his\u8fd4\u56de\u5bfc\u8bca\u4fe1\u606f\u4e3a\u7a7a");
            throw new OutpatientPaymentException("his\u8fd4\u56de\u5bfc\u8bca\u4fe1\u606f\u4e3a\u7a7a");
        }
        return gatewayResponse;
    }

    private FrontRequest<RequestPayVo> buildComfirmPayNewReq(OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, ResponseNotifyRestVo responseNotifyRestVo) {
        FrontRequest frontRequest = new FrontRequest();
        RequestPayVo requestPayVo = new RequestPayVo();
        requestPayVo.setCardNo(opBusinessOrderEntity.getCardNo());
        requestPayVo.setClinicNo(opBusinessOrderEntity.getAdmId());
        requestPayVo.setPactCode("01");
        requestPayVo.setUserID("002005");
        requestPayVo.setFlowNo(responseNotifyRestVo.getOutTradeNo());
        requestPayVo.setBankNo("Wechat");
        requestPayVo.setBankName("\u5fae\u4fe1");
        requestPayVo.setMoney(opBusinessOrderEntity.getMoney().toString());
        requestPayVo.setRecipeID(opBusinessOrderEntity.getReceiptId());
        frontRequest.setBody((Object)requestPayVo);
        frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return frontRequest;
    }

    private boolean refundCallBackToHis(ResponseRefundNotifyRestVo responseRefundNotifyRestVo, String orderNo, String trandNo, String refundSerialNo) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        RefundCallBackReq refundCallBackReq = new RefundCallBackReq();
        refundCallBackReq.setFlowNo(orderNo);
        refundCallBackReq.setRefundTrandNo(responseRefundNotifyRestVo.getRefundNo());
        refundCallBackReq.setMoney(String.valueOf(responseRefundNotifyRestVo.getRefundMoney()));
        gatewayRequest.setBody((Object)refundCallBackReq);
        gatewayRequest.setChannel(responseRefundNotifyRestVo.getPayChannel());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("refundResult");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u6302\u53f7\u9000\u6b3e\u56de\u8c03\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse refundCallBack = this.hisBillApi.refundCallBack(gatewayRequest);
        log.info("\u6302\u53f7\u9000\u6b3e\u56de\u8c03\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        return refundCallBack.isSuccess() && HIS_SUCCESS.equals(((RefundCallBackRes)refundCallBack.getData()).getState());
    }

    private void outPatientRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, OpBusinessOrderEntity opBusinessOrderEntity, OpRechargePaymentOrderEntity opRechargePaymentOrderEntity, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, opBusinessOrderEntity.getOutPatientId(), opRechargePaymentOrderEntity.getPayBillNo(), refundSerialNo);
        if (!flag) {
            opBusinessOrderEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        }
    }

    private void inHospRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, InpatientDepositDetailEntity inpatientDepositDetailEntity, String trandNo, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, inpatientDepositDetailEntity.getOrderSeq(), trandNo, refundSerialNo);
        if (!flag) {
            inpatientDepositDetailEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
        }
    }

    private void appointRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity, String refundSerialNo) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, appointmentRecordEntity.getSysAppointmentId(), appointmentRecordEntity.getPayTransationId(), refundSerialNo);
        if (!flag) {
            appointmentRecordEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        }
    }
}

