/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ebaiyihui.his.api.HisBillApi;
import com.ebaiyihui.his.pojo.vo.base.FrontRequest;
import com.ebaiyihui.his.pojo.vo.base.FrontResponse;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackReq;
import com.ebaiyihui.his.pojo.vo.bill.RefundCallBackRes;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AppointmentStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundChannelCodeEnum;
import com.ebaiyihui.wisdommedical.common.enums.RefundReason;
import com.ebaiyihui.wisdommedical.common.enums.RefundStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServiceBillTypeEnum;
import com.ebaiyihui.wisdommedical.common.enums.ServicePayBillStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.BusinessOrderStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.InpatientDepositDetailStatusEnum;
import com.ebaiyihui.wisdommedical.common.enums.medical.PayStatusEnum;
import com.ebaiyihui.wisdommedical.exception.AppointmentException;
import com.ebaiyihui.wisdommedical.exception.InHospitalException;
import com.ebaiyihui.wisdommedical.exception.OutpatientPaymentException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientDepositDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.InpatientPayorderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderDetailEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpBusinessOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.OpRechargePaymentOrderEntityMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ServiceMerchantConfigMapper;
import com.ebaiyihui.wisdommedical.mapper.ServicePayBillMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.InpatientDepositDetailEntity;
import com.ebaiyihui.wisdommedical.model.InpatientPayorderEntity;
import com.ebaiyihui.wisdommedical.model.OpBusinessOrderEntity;
import com.ebaiyihui.wisdommedical.model.OpRechargePaymentOrderEntity;
import com.ebaiyihui.wisdommedical.model.ServiceMerchantConfigEntity;
import com.ebaiyihui.wisdommedical.model.ServicePayBillEntity;
import com.ebaiyihui.wisdommedical.pojo.vo.RegRecord;
import com.ebaiyihui.wisdommedical.pojo.vo.ReponseRegisterRecordVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestCancelRegVo;
import com.ebaiyihui.wisdommedical.pojo.vo.RequestCardNoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ResponseRefundNotifyRestVo;
import com.ebaiyihui.wisdommedical.service.PushService;
import com.ebaiyihui.wisdommedical.service.RefundCallBackService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import com.ebaiyihui.wisdommedical.util.SignUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.task.TaskExecutor;
import org.springframework.stereotype.Service;
import redis.clients.jedis.JedisCluster;

@Service
public class RefundCallBackServiceImpl
implements RefundCallBackService {
    private static final Logger log = LoggerFactory.getLogger(RefundCallBackServiceImpl.class);
    public static final String HIS_SUCCESS = "1";
    @Autowired
    private OpBusinessOrderEntityMapper opBusinessOrderEntityMapper;
    @Autowired
    private OpBusinessOrderDetailEntityMapper opBusinessOrderDetailEntityMapper;
    @Autowired
    private OpRechargePaymentOrderEntityMapper opRechargePaymentOrderEntityMapper;
    @Autowired
    private InpatientPayorderEntityMapper inpatientPayorderEntityMapper;
    @Autowired
    private InpatientDepositDetailEntityMapper inpatientDepositDetailEntityMapper;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private HisBillApi hisBillApi;
    @Autowired
    private PushService pushService;
    @Autowired
    private TaskExecutor taskExecutor;
    @Autowired
    private JedisCluster jedisCluster;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private AppointmentPayorderMapper appointmentPayOrderMapper;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private ServiceMerchantConfigMapper serviceMerchantConfigMapper;
    @Autowired
    private ServicePayBillMapper servicePayBillMapper;
    @Autowired
    private ProPropertiesConstant projProperties;

    public void outpatientRefundCallBack(ResponseRefundNotifyRestVo responseNotifyRestVo) throws OutpatientPaymentException {
        log.info("\u7f34\u8d39\u9000\u6b3e\u56de\u8c03\u8fd4\u56de\u5165\u53c2\uff1aresponseNotifyRestVo-----------responseNotifyRestVo:{}", (Object)responseNotifyRestVo);
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqJF());
        if (null != serviceMerchantConfigEntity) {
            Map params = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            if (!SignUtil.checkSign((Map)params, (String)serviceMerchantConfigEntity.getApplyKey())) {
                throw new OutpatientPaymentException("\u9a8c\u7b7e\u5931\u8d25\uff0c\u652f\u4ed8\u56de\u8c03\u4fe1\u606f\u53ef\u80fd\u88ab\u7be1\u6539");
            }
        } else {
            throw new OutpatientPaymentException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9000\u6b3e\u56de\u8c03\u5931\u8d25");
        }
        Date now = new Date();
        String outPatientId = responseNotifyRestVo.getOutTradeNo();
        OpBusinessOrderEntity opBusinessOrderEntity = this.opBusinessOrderEntityMapper.selectByOutPatientId(outPatientId);
        opBusinessOrderEntity.setUpdateTime(now);
        opBusinessOrderEntity.setRemark("\u95e8\u8bca\u7f34\u8d39\uff0c\u9000\u6b3e\u6210\u529f");
        opBusinessOrderEntity.setStatus(BusinessOrderStatusEnum.REFUND.getValue());
        this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
        OpRechargePaymentOrderEntity opRechargePaymentOrderEntity = this.opRechargePaymentOrderEntityMapper.selectByOutPatientId(outPatientId);
        opRechargePaymentOrderEntity.setUpdateTime(now);
        opRechargePaymentOrderEntity.setRemark("\u95e8\u8bca\u7f34\u8d39\uff0c\u9000\u6b3e\u6210\u529f");
        opRechargePaymentOrderEntity.setPayStatus(Byte.valueOf((byte)PayStatusEnum.HAS_PAY_OR_REFUND.getValue().intValue()));
        this.opRechargePaymentOrderEntityMapper.updateByPrimaryKey(opRechargePaymentOrderEntity);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.REFUND_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.REFUNDED.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(this.propertiesConstant.getOrganCode());
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setRefundTime(responseNotifyRestVo.getRefundTime());
        servicePayBillEntity.setRefundNo(responseNotifyRestVo.getRefundNo());
        servicePayBillEntity.setOutRefundNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
        servicePayBillEntity.setRefundAmount(Double.valueOf(responseNotifyRestVo.getRefundMoney().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
    }

    public void inHospitalRefundCallBack(ResponseRefundNotifyRestVo responseNotifyRestVo) throws InHospitalException {
        log.info("\u4f4f\u9662\u5145\u503c\u9000\u6b3e\u56de\u8c03\u8fd4\u56de\u5165\u53c2\uff1aresponseNotifyRestVo-----------responseNotifyRestVo:{}", (Object)responseNotifyRestVo);
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqZY());
        if (null != serviceMerchantConfigEntity) {
            Map params = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            if (!SignUtil.checkSign((Map)params, (String)serviceMerchantConfigEntity.getApplyKey())) {
                throw new InHospitalException("\u9a8c\u7b7e\u5931\u8d25\uff0c\u652f\u4ed8\u56de\u8c03\u4fe1\u606f\u53ef\u80fd\u88ab\u7be1\u6539");
            }
        } else {
            throw new InHospitalException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9000\u6b3e\u56de\u8c03\u5931\u8d25");
        }
        Date now = new Date();
        String orderseq = responseNotifyRestVo.getOutTradeNo();
        InpatientDepositDetailEntity inpatientDepositDetailEntity = this.inpatientDepositDetailEntityMapper.selectByOrderSeq(orderseq);
        inpatientDepositDetailEntity.setUpdateTime(now);
        inpatientDepositDetailEntity.setRemark("\u4f4f\u9662\u9884\u7f34\u8d39\uff0c\u9000\u6b3e\u6210\u529f");
        inpatientDepositDetailEntity.setStatus(Byte.valueOf((byte)InpatientDepositDetailStatusEnum.REFUND.getValue().intValue()));
        this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
        InpatientPayorderEntity inpatientPayorderEntity = this.inpatientPayorderEntityMapper.selectByInpatientDepositId(inpatientDepositDetailEntity.getId());
        inpatientPayorderEntity.setUpdateTime(now);
        inpatientPayorderEntity.setRemark("\u4f4f\u9662\u9884\u7f34\u8d39\uff0c\u9000\u6b3e\u6210\u529f");
        inpatientPayorderEntity.setPayStatus(Byte.valueOf((byte)PayStatusEnum.HAS_PAY_OR_REFUND.getValue().intValue()));
        this.inpatientPayorderEntityMapper.updateByPrimaryKey(inpatientPayorderEntity);
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.REFUND_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.REFUNDED.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(this.propertiesConstant.getOrganCode());
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setRefundTime(responseNotifyRestVo.getRefundTime());
        servicePayBillEntity.setRefundNo(responseNotifyRestVo.getRefundNo());
        servicePayBillEntity.setOutRefundNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
        servicePayBillEntity.setRefundAmount(Double.valueOf(responseNotifyRestVo.getRefundMoney().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        if (inpatientPayorderEntity.getRefundType().equals(RefundChannelCodeEnum.HIS_REFUND.getValue())) {
            this.inHospRepeatCallBackHis(responseNotifyRestVo, inpatientDepositDetailEntity);
        }
    }

    public void appointRefundCallBack(ResponseRefundNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u9000\u53f7\u56de\u8c03\u8fd4\u56de\u5165\u53c2\uff1aresponseNotifyRestVo-----------responseNotifyRestVo:{}", (Object)responseNotifyRestVo);
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeqGH());
        if (null != serviceMerchantConfigEntity) {
            Map params = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            if (!SignUtil.checkSign((Map)params, (String)serviceMerchantConfigEntity.getApplyKey())) {
                throw new AppointmentException("\u9a8c\u7b7e\u5931\u8d25\uff0c\u652f\u4ed8\u56de\u8c03\u4fe1\u606f\u53ef\u80fd\u88ab\u7be1\u6539");
            }
        } else {
            throw new AppointmentException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9000\u6b3e\u56de\u8c03\u5931\u8d25");
        }
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        Integer appointStatus = appointmentRecordEntity.getAppointStatus();
        if (AppointmentStatusEnum.LAUNCH_AUTO_REFUND.getValue().equals(appointStatus)) {
            this.refundCallBack(responseNotifyRestVo);
        }
        if (AppointmentStatusEnum.ADMIN_LAUNCH_REFUND_SUCCESS.getValue().equals(appointStatus)) {
            this.refundCallBack(responseNotifyRestVo);
        }
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.REFUND_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.REFUNDED.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(appointmentRecordEntity.getHospitalCode());
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setRefundTime(responseNotifyRestVo.getRefundTime());
        servicePayBillEntity.setRefundNo(responseNotifyRestVo.getRefundNo());
        servicePayBillEntity.setOutRefundNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
        servicePayBillEntity.setRefundAmount(Double.valueOf(responseNotifyRestVo.getRefundMoney().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
        if (AppointmentStatusEnum.WAIT_REFUND_CONFIRM.getValue().equals(appointStatus)) {
            appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
            appointmentRecordEntity.setReturnTransationId(responseNotifyRestVo.getOutRefundNo());
            appointmentRecordEntity.setReturnAmount(responseNotifyRestVo.getTotalAmount());
            appointmentRecordEntity.setReturnPostId(responseNotifyRestVo.getMchId());
            appointmentRecordEntity.setRemark("\u9000\u6b3e\u6210\u529f");
            appointmentRecordEntity.setReturnAccdate(DateUtils.dateToString((Date)new Date(), (String)"yyyy-MM-dd HH:mm:ss"));
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
            AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.getBySysAppointmentId(sysAppointmentId);
            appointmentPayorderEntity.setSysAppointmentId(sysAppointmentId);
            appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.REFUND_AND_CONFIRMATION.getValue().intValue()));
            appointmentPayorderEntity.setRefundTime(responseNotifyRestVo.getRefundTime());
            appointmentPayorderEntity.setRefundType(Byte.valueOf((byte)RefundReason.FEFUND_NUMBER.getValue().intValue()));
            appointmentPayorderEntity.setRefundMoney(responseNotifyRestVo.getTotalAmount());
            appointmentPayorderEntity.setRefundBillNo(responseNotifyRestVo.getRefundNo());
            appointmentPayorderEntity.setRefundRemrak("\u9000\u6b3e\u6210\u529f");
            appointmentPayorderEntity.setRemark("\u9000\u53f7\u9000\u6b3e\u6210\u529f");
            log.info("\u9000\u53f7\u56de\u8c03\u66f4\u65b0appointmentPayOrder\u5165\u53c2\uff1a------------appointmentPayorderEntity:{}", (Object)appointmentPayorderEntity);
            this.appointmentPayOrderMapper.updateByPrimaryKeySelective(appointmentPayorderEntity);
            if (null != appointmentPayorderEntity && appointmentPayorderEntity.getRefundChannelCode().equals(RefundChannelCodeEnum.HIS_REFUND.getValue().byteValue())) {
                this.appointRepeatCallBackHis(responseNotifyRestVo, appointmentRecordEntity);
            }
            this.taskExecutor.execute(() -> this.pushService.appointmentCancelMsgPush(appointmentRecordEntity));
        }
    }

    public void dayRegistRefundCallBack(ResponseRefundNotifyRestVo responseNotifyRestVo) throws AppointmentException {
        log.info("\u9000\u53f7\u56de\u8c03\u8fd4\u56de\u5165\u53c2\uff1aresponseNotifyRestVo-----------responseNotifyRestVo:{}", (Object)responseNotifyRestVo);
        ServiceMerchantConfigEntity serviceMerchantConfigEntity = this.serviceMerchantConfigMapper.selectByMerSeqAndSysSeq(this.propertiesConstant.getMchCode(), this.propertiesConstant.getBizSysSeq());
        if (null != serviceMerchantConfigEntity) {
            Map params = SignUtil.getKeyAndValue((Object)responseNotifyRestVo);
            if (!SignUtil.checkSign((Map)params, (String)serviceMerchantConfigEntity.getApplyKey())) {
                throw new AppointmentException("\u9a8c\u7b7e\u5931\u8d25\uff0c\u652f\u4ed8\u56de\u8c03\u4fe1\u606f\u53ef\u80fd\u88ab\u7be1\u6539");
            }
        } else {
            throw new AppointmentException("\u4e1a\u52a1\u914d\u7f6e\u4fe1\u606f\u4e3a\u7a7a\uff0c\u9000\u6b3e\u56de\u8c03\u5931\u8d25");
        }
        this.refundCallBack(responseNotifyRestVo);
        AppointmentPayorderEntity appointmentPayorderEntity = this.appointmentPayOrderMapper.selectBySysAppointmentId(responseNotifyRestVo.getOutTradeNo());
        if (null != appointmentPayorderEntity && appointmentPayorderEntity.getRefundChannelCode().equals(RefundChannelCodeEnum.HIS_REFUND.getValue().byteValue())) {
            AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(responseNotifyRestVo.getOutTradeNo());
            this.appointRepeatCallBackHis(responseNotifyRestVo, appointmentRecordEntity);
        }
        ServicePayBillEntity servicePayBillEntity = new ServicePayBillEntity();
        servicePayBillEntity.setBillType(ServiceBillTypeEnum.REFUND_BILL.getValue());
        servicePayBillEntity.setStatus(ServicePayBillStatusEnum.REFUNDED.getValue());
        servicePayBillEntity.setAppCode(serviceMerchantConfigEntity.getAppCode());
        servicePayBillEntity.setOrganId(this.propertiesConstant.getOrganCode());
        servicePayBillEntity.setWorkServiceCode(serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setApplyCode(serviceMerchantConfigEntity.getMerchantSeq());
        servicePayBillEntity.setPayChannel(responseNotifyRestVo.getPayChannel());
        servicePayBillEntity.setRefundTime(responseNotifyRestVo.getRefundTime());
        servicePayBillEntity.setRefundNo(responseNotifyRestVo.getRefundNo());
        servicePayBillEntity.setOutRefundNo(responseNotifyRestVo.getOutTradeNo());
        servicePayBillEntity.setTradeStatus(responseNotifyRestVo.getErrCode());
        servicePayBillEntity.setRefundAmount(Double.valueOf(responseNotifyRestVo.getRefundMoney().doubleValue()));
        servicePayBillEntity.setDealAmount(Double.valueOf(responseNotifyRestVo.getTotalAmount().doubleValue()));
        servicePayBillEntity.setServiceCode(serviceMerchantConfigEntity.getAppCode() + "_" + serviceMerchantConfigEntity.getOrganName() + "_" + serviceMerchantConfigEntity.getBizSysSeq());
        servicePayBillEntity.setDealTradeNo(responseNotifyRestVo.getDealTradeNo());
        this.servicePayBillMapper.insertSelective(servicePayBillEntity);
    }

    private boolean refundCallBackToHis(ResponseRefundNotifyRestVo responseRefundNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity) {
        FrontRequest frontRequest = this.buildPayRegistrationReq(appointmentRecordEntity);
        String response = null;
        try {
            response = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "card/acquire/registered/record"), (String)JSON.toJSONString((Object)frontRequest));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        log.info("\u3010\u68c0\u9a8c\u68c0\u67e5\u652f\u4ed8\u540e\u786e\u8ba4\u9884\u7ea6\u3011\u8bf7\u6c42his\u5165\u53c2{}\uff0c\u8fd4\u56de\u7ed3\u679c{}", response, response);
        FrontResponse frontResponse = (FrontResponse)JSON.parseObject((String)response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        if (null == frontResponse || !HIS_SUCCESS.equals(frontResponse.getCode())) {
            return false;
        }
        ReponseRegisterRecordVo reponseRegisterRecordVo = (ReponseRegisterRecordVo)frontResponse.getBody();
        RegRecord regRecord = new RegRecord();
        if (null != reponseRegisterRecordVo && reponseRegisterRecordVo.getRegRecordList().size() > 0) {
            regRecord = (RegRecord)reponseRegisterRecordVo.getRegRecordList().get(0);
        }
        appointmentRecordEntity.setAdmId(regRecord.getClinicNo());
        FrontRequest gatewayRequest = this.buildWithdrawNumberGatewayReq(appointmentRecordEntity, appointmentRecordEntity.getAppointmentId());
        String responseStr = null;
        try {
            responseStr = HttpKit.jsonPost((String)(this.projProperties.getHisFrontUrl() + "appoint/back/number"), (String)JSON.toJSONString((Object)gatewayRequest));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        FrontResponse frontResponseStr = (FrontResponse)JSON.parseObject((String)response, (TypeReference)new /* Unavailable Anonymous Inner Class!! */, (Feature[])new Feature[0]);
        return null != frontResponseStr && HIS_SUCCESS.equals(frontResponseStr.getCode());
    }

    private FrontRequest<RequestCancelRegVo> buildWithdrawNumberGatewayReq(AppointmentRecordEntity appointmentRecordEntity, String appointmentId) {
        FrontRequest frontRequest = new FrontRequest();
        RequestCancelRegVo requestCancelRegVo = new RequestCancelRegVo();
        requestCancelRegVo.setClinicNo(appointmentRecordEntity.getAdmId());
        requestCancelRegVo.setFlowNo(appointmentRecordEntity.getSysAppointmentId());
        requestCancelRegVo.setUserId("002005");
        frontRequest.setBody((Object)requestCancelRegVo);
        frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return frontRequest;
    }

    private FrontRequest<RequestCardNoVo> buildPayRegistrationReq(AppointmentRecordEntity appointmentRecordEntity) {
        FrontRequest frontRequest = new FrontRequest();
        RequestCardNoVo requestCardNoVo = new RequestCardNoVo();
        requestCardNoVo.setCardNo(appointmentRecordEntity.getPatientCardNo() + "|" + appointmentRecordEntity.getSysAppointmentId());
        frontRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        frontRequest.setBody((Object)requestCardNoVo);
        return frontRequest;
    }

    private boolean refundCallBackToHisForMedical(ResponseRefundNotifyRestVo responseRefundNotifyRestVo, String orderNo, String admId) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        RefundCallBackReq refundCallBackReq = new RefundCallBackReq();
        refundCallBackReq.setFlowNo(orderNo);
        refundCallBackReq.setRefundTrandNo(responseRefundNotifyRestVo.getRefundNo());
        refundCallBackReq.setMoney(String.valueOf(responseRefundNotifyRestVo.getRefundMoney()));
        gatewayRequest.setBody((Object)refundCallBackReq);
        gatewayRequest.setChannel("LYT");
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("refundResult");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        log.info("\u6302\u53f7\u9000\u6b3e\u56de\u8c03\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse refundCallBack = this.hisBillApi.refundCallBack(gatewayRequest);
        log.info("\u6302\u53f7\u9000\u6b3e\u56de\u8c03\u8bf7\u6c42his\u5165\u53c2\uff1a" + JSON.toJSONString((Object)gatewayRequest));
        return refundCallBack.isSuccess() && HIS_SUCCESS.equals(((RefundCallBackRes)refundCallBack.getData()).getState());
    }

    private void outPatientRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, OpBusinessOrderEntity opBusinessOrderEntity) {
        this.taskExecutor.execute(() -> {
            int i = 1;
            int max = 5;
            while (true) {
                log.info("---------his\u53d1\u8d77\u9000\u6b3e\uff0c\u8fdb\u884c\u56de\u8c03\uff0c\u901a\u77e5his-------\u7b2c{}\u6b21", (Object)i);
                boolean flag = this.refundCallBackToHisForMedical(responseNotifyRestVo, opBusinessOrderEntity.getOutPatientId(), opBusinessOrderEntity.getAdmId());
                ++i;
                if (flag) break;
                if (i > max) {
                    opBusinessOrderEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
                    this.opBusinessOrderEntityMapper.updateByPrimaryKey(opBusinessOrderEntity);
                    break;
                }
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void inHospRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, InpatientDepositDetailEntity inpatientDepositDetailEntity) {
        this.taskExecutor.execute(() -> {
            int i = 1;
            int max = 5;
            while (true) {
                log.info("---------his\u53d1\u8d77\u9000\u6b3e\uff0c\u8fdb\u884c\u56de\u8c03\uff0c\u901a\u77e5his-------\u7b2c{}\u6b21", (Object)i);
                boolean flag = this.refundCallBackToHisForMedical(responseNotifyRestVo, inpatientDepositDetailEntity.getOrderSeq(), "");
                ++i;
                if (flag) break;
                if (i > max) {
                    inpatientDepositDetailEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
                    this.inpatientDepositDetailEntityMapper.updateByPrimaryKey(inpatientDepositDetailEntity);
                    break;
                }
                try {
                    Thread.sleep(300000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void appointRepeatCallBackHis(ResponseRefundNotifyRestVo responseNotifyRestVo, AppointmentRecordEntity appointmentRecordEntity) {
        boolean flag = this.refundCallBackToHis(responseNotifyRestVo, appointmentRecordEntity);
        if (!flag) {
            appointmentRecordEntity.setRemark("\u9000\u6b3e\u6210\u529f\uff0c\u56de\u8c03his\u5931\u8d25");
            this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        }
    }

    private void refundCallBack(ResponseRefundNotifyRestVo responseNotifyRestVo) {
        log.info("\u9000\u6b3e\u56de\u8c03\u8fd4\u56de\u5165\u53c2\uff1aresponseNotifyRestVo-----------responseNotifyRestVo:{}", (Object)responseNotifyRestVo);
        String sysAppointmentId = responseNotifyRestVo.getOutTradeNo();
        AppointmentRecordEntity appointmentRecordEntity = this.appointmentRecordMapper.selectBySysAppointId(sysAppointmentId);
        appointmentRecordEntity.setAppointStatus(AppointmentStatusEnum.ALREADY_REFUND_CONFIRM.getValue());
        appointmentRecordEntity.setReturnTransationId(responseNotifyRestVo.getRefundNo());
        appointmentRecordEntity.setReturnAmount(responseNotifyRestVo.getTotalAmount());
        appointmentRecordEntity.setReturnPostId(responseNotifyRestVo.getMchId());
        appointmentRecordEntity.setRemark("\u9000\u6b3e\u6210\u529f");
        appointmentRecordEntity.setReturnAccdate(DateUtils.dateToString((Date)responseNotifyRestVo.getRefundTime(), (String)"yyyy-MM-dd HH:mm:ss"));
        this.appointmentRecordMapper.updateByPrimaryKeySelective(appointmentRecordEntity);
        AppointmentPayorderEntity appointmentPayorderEntity = new AppointmentPayorderEntity();
        appointmentPayorderEntity.setSysAppointmentId(sysAppointmentId);
        appointmentPayorderEntity.setRefundStatus(Byte.valueOf((byte)RefundStatusEnum.REFUND_AND_CONFIRMATION.getValue().intValue()));
        appointmentPayorderEntity.setRefundTime(responseNotifyRestVo.getRefundTime());
        appointmentPayorderEntity.setRefundType(Byte.valueOf((byte)RefundReason.FEFUND_NUMBER.getValue().intValue()));
        appointmentPayorderEntity.setRefundMoney(responseNotifyRestVo.getTotalAmount());
        appointmentPayorderEntity.setRefundBillNo(responseNotifyRestVo.getRefundNo());
        appointmentPayorderEntity.setRefundRemrak("\u9000\u6b3e\u6210\u529f");
        appointmentPayorderEntity.setRemark("\u9000\u6b3e\u6210\u529f");
        log.info("\u81ea\u52a8\u9000\u6b3e\u66f4\u65b0appointmentPayOrder\u5165\u53c2\uff1a------------appointmentPayorderEntity:{}", (Object)appointmentPayorderEntity);
        this.appointmentPayOrderMapper.updateRefundStatusBySysAppointmentId(appointmentPayorderEntity);
    }
}

