/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.doctoruser.api.pojo.base.dto.DoctorBaseInfoDTO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.his.api.ScheduleApi;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptDoctorInfoReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetDeptDoctorInfoResVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleReqVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduleResVO;
import com.ebaiyihui.his.pojo.vo.schedule.GetScheduledTimeResVo;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetDeptDoctorInfoResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleResItems;
import com.ebaiyihui.his.pojo.vo.schedule.items.GetScheduleTimeReq;
import com.ebaiyihui.his.pojo.vo.schedule.items.TimeArrangeItems;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.common.enums.AdmTimeRangeEnum;
import com.ebaiyihui.wisdommedical.exception.ScheduleException;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.DeptCategoryRelationMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleDetailRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.ScheduleRecordMapper;
import com.ebaiyihui.wisdommedical.model.DeptCategoryRelationEntity;
import com.ebaiyihui.wisdommedical.model.DoctorRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleDetailRecordEntity;
import com.ebaiyihui.wisdommedical.model.ScheduleRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.GetScheduleDTO;
import com.ebaiyihui.wisdommedical.pojo.vo.DayDoctorScheduleVo;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetDoctorScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetNewDoctorScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetNewDoctorScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoReq;
import com.ebaiyihui.wisdommedical.pojo.vo.GetScheduleVoRes;
import com.ebaiyihui.wisdommedical.pojo.vo.RecommendedDoctorInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.ScheduleBaseInfoVo;
import com.ebaiyihui.wisdommedical.pojo.vo.repsvo.ScheduleStatusResVO;
import com.ebaiyihui.wisdommedical.service.DoctorService;
import com.ebaiyihui.wisdommedical.service.ScheduleService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.GetDoctorInfoUtil;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class ScheduleServiceImpl
implements ScheduleService {
    private static final Logger log = LoggerFactory.getLogger(ScheduleServiceImpl.class);
    @Autowired
    private ScheduleApi scheduleApi;
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AppointmentRecordMapper appointmentRecordMapper;
    @Autowired
    private ScheduleRecordMapper scheduleRecordMapper;
    @Autowired
    private ScheduleDetailRecordMapper scheduleDetailRecordMapper;
    @Autowired
    private DoctorService doctorService;
    @Autowired
    private ProPropertiesConstant propertiesConstant;
    @Autowired
    private GetDoctorInfoUtil getDoctorInfoUtil;
    @Resource
    private DeptCategoryRelationMapper deptCategoryRelationMapper;

    public List<GetScheduleVoRes> getSchedule(GetScheduleVoReq getScheduleVoReq) throws ScheduleException {
        String[] deptCode = new String[]{"581", "125"};
        List scheduleResItemsList = null;
        GatewayRequest gatewayRequest = this.buildGetScheduleGatewayReq(getScheduleVoReq);
        log.info("\u5b9e\u65f6\u83b7\u53d6\u5f53\u65e5\u6392\u73ed\u5165\u53c2" + JSON.toJSONString((Object)gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(gatewayRequest);
        log.info("\u5b9e\u65f6\u83b7\u53d6\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (CollectionUtils.isEmpty((Collection)getScheduleResVO.getItems())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new ScheduleException("\u6682\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        scheduleResItemsList = getScheduleResVO.getItems();
        log.info("\u8fc7\u6ee4\u8fc7\u65f6\u7684\u53f7\u6e90\u4e4b\u524d scheduleResItemsList- >{}", (Object)JSON.toJSONString((Object)scheduleResItemsList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (!Arrays.asList(deptCode).contains(getScheduleVoReq.getDeptCode())) {
            scheduleResItemsList = scheduleResItemsList.stream().filter(item -> !new BigDecimal(item.getRegFee()).equals(BigDecimal.ZERO)).collect(Collectors.toList());
        }
        log.info("\u8fc7\u6ee40\u5143\u53f7\u6e90\u540e scheduleResItemsList- >{}", (Object)JSON.toJSONString(scheduleResItemsList, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        List getScheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> {
            if (getScheduleVoReq.getStartDate().equals(LocalDate.now().toString())) {
                Integer hours = LocalDateTime.now().getHour();
                if (hours >= 12 && String.valueOf(AdmTimeRangeEnum.MORNING.getValue()).equals(getScheduleResItems.getAdmTimeRange())) {
                    return false;
                }
                if (hours >= 17 && String.valueOf(AdmTimeRangeEnum.AFTERNOON.getValue()).equals(getScheduleResItems.getAdmTimeRange())) {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        log.info("\u8fc7\u6ee4\u8fc7\u65f6\u7684\u53f7\u6e90\u4e4b\u540e\uff1a" + getScheduleResItemsList);
        Map<String, List<GetScheduleResItems>> getScheduleResItemMap = getScheduleResItemsList.stream().collect(Collectors.groupingBy(GetScheduleResItems::getDocCode));
        log.info("\u6839\u636edoccode\u5206\u7ec4\u4e4b\u540e\uff1a" + getScheduleResItemsList);
        ArrayList<GetScheduleVoRes> getScheduleVoResList = new ArrayList<GetScheduleVoRes>();
        for (String docCode : getScheduleResItemMap.keySet()) {
            log.info("\u904d\u5386\u7684\u4fe1\u606f--->  {}", (Object)getScheduleResItemMap.get(docCode).get(0));
            GetScheduleResItems getScheduleResItems2 = getScheduleResItemMap.get(docCode).get(0);
            BaseResponse getScheduleVoResData = this.buildGetScheduleVoResVo(docCode, getScheduleResItems2, getScheduleVoReq);
            if (!"1".equals(getScheduleVoResData.getCode())) {
                throw new ScheduleException(getScheduleVoResData.getMsg());
            }
            GetScheduleVoRes getScheduleVoRes = (GetScheduleVoRes)getScheduleVoResData.getData();
            log.info("\u7ec4\u88c5\u533b\u751f\u57fa\u7840\u4fe1\u606f\u7ed9\u524d\u7aef----> {}", (Object)getScheduleVoRes);
            Integer appointmentCount = this.appointmentRecordMapper.selectDoctorAppointmentCount(getScheduleVoRes.getDocCode(), getScheduleVoReq.getOrganCode());
            getScheduleVoRes.setAppointmentCount(appointmentCount);
            List scheduleBaseInfoVoList = getScheduleResItemMap.get(docCode).stream().map(scheduleResItem -> {
                scheduleResItem.setAdmDate(getScheduleVoReq.getStartDate());
                return this.buildScheduleBaseInfoVo(scheduleResItem);
            }).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(scheduleBaseInfoVoList)) continue;
            scheduleBaseInfoVoList.sort(Comparator.comparing(ScheduleBaseInfoVo::getAdmTimeRange));
            getScheduleVoRes.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
            getScheduleVoResList.add(getScheduleVoRes);
        }
        return getScheduleVoResList;
    }

    public BaseResponse<List<TimeArrangeItems>> getScheduledTime(GetScheduleTimeReq getScheduleTimeReq) throws ScheduleException {
        GatewayRequest param = new GatewayRequest();
        getScheduleTimeReq.setSchedId(getScheduleTimeReq.getSchedId());
        param.setOrganCode(this.propertiesConstant.getOrganCode());
        param.setBody((Object)getScheduleTimeReq);
        GatewayResponse gatewayResponse = this.scheduleApi.getScheduledTime(param);
        if (gatewayResponse == null) {
            log.error("\u5206\u65f6\u6bb5\u4fe1\u606f\u67e5\u8be2 getScheduledTime -> his\u8bf7\u6c42\u65e0\u54cd\u5e94" + gatewayResponse.getMsg());
            throw new ScheduleException("his\u8bf7\u6c42\u65e0\u54cd\u5e94");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u5206\u65f6\u6bb5\u67e5\u8be2 getScheduledTime -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            throw new ScheduleException(gatewayResponse.getMsg());
        }
        List timeArrangeItems = ((GetScheduledTimeResVo)gatewayResponse.getData()).getTimeArrangeItems();
        return BaseResponse.success((Object)timeArrangeItems);
    }

    private BaseResponse<GetScheduleVoRes> buildGetScheduleVoResVo(String docCode, GetScheduleResItems getScheduleResItems, GetScheduleVoReq getScheduleVoReq) {
        if (StringUtils.isBlank((CharSequence)docCode)) {
            GetScheduleVoRes getScheduleVoRes = new GetScheduleVoRes();
            getScheduleVoRes.setHospitalArea("\u897f\u5b89\u7ecf\u5f00\u5987\u5e7c\u533b\u9662");
            getScheduleVoRes.setHospitalAreaCode(this.propertiesConstant.getOrganCode());
            getScheduleVoRes.setLocCode(getScheduleResItems.getLocCode());
            getScheduleVoRes.setLocName(getScheduleResItems.getLocName());
            getScheduleVoRes.setRegTitleName("\u666e\u901a\u53f7");
            getScheduleVoRes.setDocCode(getScheduleResItems.getLocCode());
            return BaseResponse.success((Object)getScheduleVoRes);
        }
        GatewayRequest param = new GatewayRequest();
        param.setOrganCode(this.propertiesConstant.getOrganCode());
        GetDeptDoctorInfoReqVO getDeptDoctorInfoReqVO = new GetDeptDoctorInfoReqVO();
        getDeptDoctorInfoReqVO.setDeptCode(getScheduleVoReq.getDeptCode());
        param.setBody((Object)getDeptDoctorInfoReqVO);
        GatewayResponse gatewayResponse = this.scheduleApi.getDeptDoctorInfo(param);
        if (gatewayResponse == null) {
            log.error("\u5206\u65f6\u6bb5\u4fe1\u606f\u67e5\u8be2 getDoctorInfo -> his\u8bf7\u6c42\u65e0\u54cd\u5e94" + gatewayResponse.getMsg());
            return BaseResponse.error((String)"\u533b\u751f\u4fe1\u606f\u67e5\u8be2 getDoctorInfo -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u533b\u751f\u4fe1\u606f\u67e5\u8be2 getDoctorInfo -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return BaseResponse.error((String)("\u7f16\u7801" + docCode + "\u533b\u751f\u4fe1\u606f\u67e5\u8be2\u5931\u8d25"));
        }
        List doctorInfoResItems = ((GetDeptDoctorInfoResVO)gatewayResponse.getData()).getItems();
        List collect = doctorInfoResItems.stream().filter(i -> docCode.equals(i.getDoctorCode())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(collect)) {
            return BaseResponse.error((String)("\u7f16\u7801" + docCode + "\u533b\u751f\u6ca1\u6709\u67e5\u5230\u4fe1\u606f"));
        }
        GetDeptDoctorInfoResItems doctorInfoRes = (GetDeptDoctorInfoResItems)collect.get(0);
        GetScheduleVoRes getScheduleVoRes = new GetScheduleVoRes();
        getScheduleVoRes.setHospitalArea("\u897f\u5b89\u7ecf\u5f00\u5987\u5e7c\u533b\u9662");
        getScheduleVoRes.setHospitalAreaCode(this.propertiesConstant.getOrganCode());
        getScheduleVoRes.setDocCode(doctorInfoRes.getDoctorCode());
        getScheduleVoRes.setDocName(doctorInfoRes.getDoctorName());
        getScheduleVoRes.setLocCode(doctorInfoRes.getDeptCode());
        getScheduleVoRes.setLocName(doctorInfoRes.getDeptName());
        getScheduleVoRes.setAdmLocation(doctorInfoRes.getDeptName());
        getScheduleVoRes.setRegTitleCode("");
        getScheduleVoRes.setRegTitleName(doctorInfoRes.getDoctorTitle());
        getScheduleVoRes.setDoctorGender(String.valueOf(doctorInfoRes.getSex()));
        getScheduleVoRes.setDoctorSpeciality(doctorInfoRes.getDoctorDesc());
        return BaseResponse.success((Object)getScheduleVoRes);
    }

    public GetDoctorScheduleVoRes getDoctorSchedule(GetDoctorScheduleVoReq getDoctorScheduleVoReq) throws ScheduleException {
        String theDay = DateUtils.getCurrentDateToString();
        List<Object> scheduleResItemsList = new ArrayList();
        for (int i = 0; i < 7; ++i) {
            getDoctorScheduleVoReq.setStartDate(theDay);
            getDoctorScheduleVoReq.setEndDate(theDay);
            GatewayRequest gatewayRequest = this.buildGetDoctorScheduleGatewayReq(getDoctorScheduleVoReq);
            List itemsList = this.getDocSchedule(gatewayRequest);
            theDay = DateUtils.getNextDayToString((String)theDay);
            if (CollectionUtils.isEmpty((Collection)itemsList)) continue;
            scheduleResItemsList.addAll(itemsList);
        }
        if (CollectionUtils.isEmpty(scheduleResItemsList = scheduleResItemsList.stream().map(getScheduleResItems -> {
            getScheduleResItems.setAdmDate(DateUtils.dateToSimpleString((Date)DateUtils.stringToSimpleDate((String)getScheduleResItems.getAdmDate())));
            return getScheduleResItems;
        }).collect(Collectors.toList()))) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            throw new ScheduleException("\u6682\u65e0\u6392\u73ed\u4fe1\u606f");
        }
        GetDoctorScheduleVoRes getDoctorScheduleVoRes = new GetDoctorScheduleVoRes();
        GetScheduleResItems getScheduleResItem = (GetScheduleResItems)scheduleResItemsList.get(0);
        getDoctorScheduleVoRes.setDocCode(getScheduleResItem.getDocCode());
        getDoctorScheduleVoRes.setDocName(getScheduleResItem.getDocName());
        getDoctorScheduleVoRes.setRegTitleCode(getScheduleResItem.getRegTitleCode());
        getDoctorScheduleVoRes.setRegTitleName(getScheduleResItem.getRegTitleName());
        getDoctorScheduleVoRes.setDeptCode(getDoctorScheduleVoReq.getDeptCode());
        getDoctorScheduleVoRes.setDeptName(getScheduleResItem.getLocName());
        getDoctorScheduleVoRes.setHospitalName(getScheduleResItem.getHospitalArea());
        List getScheduleResItemsList = scheduleResItemsList.stream().filter(getScheduleResItems -> {
            if (getScheduleResItems.getAdmDate().equals(LocalDate.now().toString())) {
                Integer hours = LocalDateTime.now().getHour();
                if (hours >= 12 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.MORNING.getValue()))) {
                    return false;
                }
                if (hours >= 17 && getScheduleResItems.getAdmTimeRange().equals(String.valueOf(AdmTimeRangeEnum.AFTERNOON.getValue()))) {
                    return false;
                }
            }
            return true;
        }).collect(Collectors.toList());
        Map<String, List<GetScheduleResItems>> getScheduleResItemsMap = getScheduleResItemsList.stream().collect(Collectors.groupingBy(GetScheduleResItems::getAdmDate));
        ArrayList dayDoctorScheduleVoList = new ArrayList();
        List<String> admDateList = getScheduleResItemsMap.keySet().stream().map(amdDate -> amdDate).collect(Collectors.toList());
        admDateList.sort(Comparator.comparing(admDate -> admDate));
        admDateList.forEach(amdDate -> {
            DayDoctorScheduleVo dayDoctorScheduleVo = new DayDoctorScheduleVo();
            List getScheduleResItems = (List)getScheduleResItemsMap.get(amdDate);
            List scheduleBaseInfoVoList = getScheduleResItems.stream().map(getScheduleRes -> this.buildScheduleBaseInfoVo(getScheduleRes)).collect(Collectors.toList());
            scheduleBaseInfoVoList.sort(Comparator.comparing(ScheduleBaseInfoVo::getAdmTimeRange));
            dayDoctorScheduleVo.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
            dayDoctorScheduleVoList.add(dayDoctorScheduleVo);
        });
        getDoctorScheduleVoRes.setDayDoctorScheduleVoList(dayDoctorScheduleVoList);
        DoctorRecordEntity doctorRecordEntity = this.doctorService.getDoctorRecordByDoctorCodeAndHosCode(getDoctorScheduleVoReq.getDoctorCode(), getDoctorScheduleVoReq.getOrganCode());
        Long docId = 0L;
        if (null != doctorRecordEntity && StringUtils.isNotBlank((CharSequence)doctorRecordEntity.getDoctorId())) {
            docId = Long.valueOf(doctorRecordEntity.getDoctorId());
        }
        getDoctorScheduleVoRes.setDoctorId(docId);
        DoctorBaseInfoDTO doctorBaseInfoDTO = this.getDoctorInfoUtil.getDoctorInfo(docId, getDoctorScheduleVoReq.getOrganId());
        if (doctorBaseInfoDTO != null) {
            getDoctorScheduleVoRes.setDoctorHeadPortrait(doctorBaseInfoDTO.getPortrait());
            getDoctorScheduleVoRes.setDoctorSpeciality(doctorBaseInfoDTO.getProfession());
            getDoctorScheduleVoRes.setDoctorIntroduce(doctorBaseInfoDTO.getIntroduction());
            getDoctorScheduleVoRes.setDoctorScore(5.0);
            getDoctorScheduleVoRes.setCommentOfDoctorRes(null);
        }
        Integer appointmentCount = this.appointmentRecordMapper.selectDoctorAppointmentCount(getDoctorScheduleVoReq.getDoctorCode(), getDoctorScheduleVoReq.getOrganCode());
        getDoctorScheduleVoRes.setAppointmentCount(appointmentCount);
        List scheduleRecordEntityList = this.scheduleRecordMapper.selectRecommendedDoctor(getDoctorScheduleVoReq.getDoctorCode(), getDoctorScheduleVoReq.getDeptCode(), getDoctorScheduleVoReq.getOrganCode());
        if (!CollectionUtils.isEmpty((Collection)scheduleRecordEntityList)) {
            List doctorCodeList = scheduleRecordEntityList.stream().map(ScheduleRecordEntity::getDocCode).collect(Collectors.toList());
            List doctorRecordEntityList = this.doctorService.getDoctorIdList(doctorCodeList, getDoctorScheduleVoReq.getOrganCode());
            List doctorIdList = doctorRecordEntityList.stream().map(doctorRecord -> {
                if (StringUtils.isNotBlank((CharSequence)doctorRecordEntity.getDoctorId())) {
                    return Long.valueOf(doctorRecordEntity.getDoctorId());
                }
                return 0L;
            }).collect(Collectors.toList());
            Map<String, String> doctorMap = doctorRecordEntityList.stream().collect(Collectors.toMap(DoctorRecordEntity::getDocCode, DoctorRecordEntity::getDoctorId));
            List doctorBaseInfoDTOList = this.getDoctorInfoList(getDoctorScheduleVoReq.getOrganId(), doctorIdList);
            Map<String, DoctorBaseInfoDTO> doctorBaseInfoDTOMap = doctorBaseInfoDTOList.stream().collect(Collectors.toMap(doctorBaseInfo -> doctorBaseInfoDTO.getXId().toString(), doctorBaseInfo -> doctorBaseInfo));
            List doctorIds = doctorBaseInfoDTOList.stream().map(DoctorBaseInfoDTO::getXId).collect(Collectors.toList());
            if (!CollectionUtils.isEmpty((Collection)scheduleRecordEntityList)) {
                List recommendedDoctorInfoVoList = scheduleRecordEntityList.stream().map(scheduleRecordEntity -> {
                    RecommendedDoctorInfoVo recommendedDoctorInfoVo = new RecommendedDoctorInfoVo();
                    recommendedDoctorInfoVo.setDeptCode(scheduleRecordEntity.getDeptCode());
                    recommendedDoctorInfoVo.setDeptName(scheduleRecordEntity.getDeptName());
                    recommendedDoctorInfoVo.setDoctorCode(scheduleRecordEntity.getDocCode());
                    recommendedDoctorInfoVo.setDoctorName(scheduleRecordEntity.getDocName());
                    recommendedDoctorInfoVo.setRegTitleName(scheduleRecordEntity.getRegTitelName());
                    String doctorId = (String)doctorMap.get(scheduleRecordEntity.getDocCode());
                    DoctorBaseInfoDTO doctorBaseInfo = (DoctorBaseInfoDTO)doctorBaseInfoDTOMap.get(doctorId);
                    if (doctorBaseInfo != null) {
                        recommendedDoctorInfoVo.setDoctorHeadPortrait(doctorBaseInfoDTO.getPortrait());
                        recommendedDoctorInfoVo.setDoctorSpeciality(doctorBaseInfoDTO.getProfession());
                        recommendedDoctorInfoVo.setDoctorGender(String.valueOf(doctorBaseInfoDTO.getGender()));
                        recommendedDoctorInfoVo.setDoctorScore(new Double(5.0));
                    }
                    Integer count = this.appointmentRecordMapper.selectDoctorAppointmentCount(scheduleRecordEntity.getDocCode(), scheduleRecordEntity.getHospitalCode());
                    recommendedDoctorInfoVo.setAppointmentCount(count);
                    return recommendedDoctorInfoVo;
                }).collect(Collectors.toList());
                getDoctorScheduleVoRes.setRecommendedDoctorInfoVoList(recommendedDoctorInfoVoList);
            }
        }
        return getDoctorScheduleVoRes;
    }

    public List<ScheduleStatusResVO> getScheduleStatus(GetScheduleVoReq getScheduleVoReq) throws ScheduleException {
        String admDate = DateUtils.getCurrentDateSimpleToString();
        ArrayList<ScheduleStatusResVO> list = new ArrayList<ScheduleStatusResVO>();
        for (int i = 0; i < 7; ++i) {
            ScheduleStatusResVO scheduleStatusResVO = new ScheduleStatusResVO();
            getScheduleVoReq.setStartDate(admDate);
            getScheduleVoReq.setEndDate(admDate);
            GatewayRequest gatewayRequest = this.buildGetScheduleGatewayReq(getScheduleVoReq);
            boolean flag = this.getSchduleStatus(gatewayRequest);
            if (flag) {
                scheduleStatusResVO.setStatus("1");
            } else {
                scheduleStatusResVO.setStatus("-1");
            }
            scheduleStatusResVO.setAdmDate(admDate);
            if (admDate.equals(DateUtils.getCurrentDateSimpleToString())) {
                scheduleStatusResVO.setWeek("\u4eca\u5929");
            } else {
                scheduleStatusResVO.setWeek(DateUtils.getWeekSimpleChinese((String)admDate));
            }
            scheduleStatusResVO.setViewDate(admDate.replace("-", ".").substring(5));
            list.add(scheduleStatusResVO);
            admDate = DateUtils.getNextDayToString((String)admDate);
        }
        return list;
    }

    private ScheduleBaseInfoVo buildScheduleBaseInfoVo(GetScheduleResItems scheduleResItem) {
        log.info("\u7ec4\u88c5\u4fe1\u606f----->{}", (Object)scheduleResItem);
        ScheduleBaseInfoVo scheduleBaseInfoVo = new ScheduleBaseInfoVo();
        scheduleBaseInfoVo.setAdmDate(DateUtils.dateToSimpleString((Date)DateUtils.stringToSimpleDate((String)scheduleResItem.getAdmDate())));
        scheduleBaseInfoVo.setAdmTimeRange(scheduleResItem.getAdmTimeRange());
        scheduleBaseInfoVo.setAppStartNo(scheduleResItem.getAppStartNo());
        scheduleBaseInfoVo.setIsTimeArrange(scheduleResItem.getIsTimeArrange());
        scheduleBaseInfoVo.setLocTypeCode(scheduleResItem.getLocTypeCode());
        scheduleBaseInfoVo.setLocTypeName(scheduleResItem.getLocTypeName());
        scheduleBaseInfoVo.setRegAvailable(scheduleResItem.getRegAvailable());
        scheduleBaseInfoVo.setRegFee(String.valueOf(new BigDecimal(scheduleResItem.getRegFee()).doubleValue()));
        scheduleBaseInfoVo.setDiagFee(scheduleResItem.getDiagFee());
        BigDecimal totalFee = new BigDecimal(scheduleResItem.getRegFee()).add(new BigDecimal(scheduleResItem.getDiagFee()));
        scheduleBaseInfoVo.setTotalFee(String.valueOf(totalFee.doubleValue()));
        scheduleBaseInfoVo.setReplaceScheduleId(scheduleResItem.getReplaceScheduleId());
        scheduleBaseInfoVo.setScheduleId(scheduleResItem.getScheduleId());
        scheduleBaseInfoVo.setScheduleLevelCode(scheduleResItem.getScheduleLevelCode());
        scheduleBaseInfoVo.setScheduleLevelName(scheduleResItem.getRegTitleName());
        scheduleBaseInfoVo.setScheduleStatus(scheduleResItem.getScheduleStatus());
        scheduleBaseInfoVo.setScheduleType(scheduleResItem.getScheduleType());
        scheduleBaseInfoVo.setIsAppend(scheduleResItem.getIsAppend());
        ArrayList timeArrangeItemsList = scheduleResItem.getTimeArrangeItems();
        if (CollectionUtils.isEmpty((Collection)timeArrangeItemsList)) {
            timeArrangeItemsList = new ArrayList();
        }
        scheduleBaseInfoVo.setTimeArrangeItems((List)timeArrangeItemsList);
        return scheduleBaseInfoVo;
    }

    private List<DoctorBaseInfoDTO> getDoctorInfoList(String organId, List<Long> doctorIdList) throws ScheduleException {
        if (CollectionUtils.isEmpty(doctorIdList)) {
            return new ArrayList<DoctorBaseInfoDTO>();
        }
        log.info("\u67e5\u8be2\u533b\u751f\u4fe1\u606f\u8bf7\u6c42\u53c2\u6570\uff1a" + doctorIdList);
        List doctorBaseInfoDTOList = this.getDoctorInfoUtil.getDoctorInfoList(doctorIdList, organId);
        if (doctorBaseInfoDTOList == null) {
            return new ArrayList<DoctorBaseInfoDTO>();
        }
        return doctorBaseInfoDTOList;
    }

    private GatewayRequest<GetScheduleReqVO> buildGetScheduleGatewayReq(GetScheduleVoReq getScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(getScheduleVoReq.getStartDate());
        getScheduleReqVO.setEdDate(getScheduleVoReq.getEndDate());
        getScheduleReqVO.setLocCode(getScheduleVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(getScheduleVoReq.getDocCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetScheduleReqVO> buildGetDoctorScheduleGatewayReq(GetDoctorScheduleVoReq getDoctorScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(getDoctorScheduleVoReq.getStartDate());
        getScheduleReqVO.setEdDate(getDoctorScheduleVoReq.getEndDate());
        getScheduleReqVO.setLocCode(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(getDoctorScheduleVoReq.getDoctorCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GatewayRequest<GetScheduleReqVO> buildDaySchduleReq(GetDoctorScheduleVoReq getDoctorScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(getDoctorScheduleVoReq.getStartDate());
        getScheduleReqVO.setEdDate(getDoctorScheduleVoReq.getStartDate());
        getScheduleReqVO.setLocCode(getDoctorScheduleVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(getDoctorScheduleVoReq.getDoctorCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getDoctorScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getDaySchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }

    private GetScheduleResItems buildGetScheduleResItems(ScheduleRecordEntity scheduleRecordEntity, List<TimeArrangeItems> timeArrangeItemsList) {
        GetScheduleResItems scheduleResItems = new GetScheduleResItems();
        scheduleResItems.setScheduleId(scheduleRecordEntity.getScheduleHisId());
        scheduleResItems.setScheduleType(Integer.valueOf(scheduleRecordEntity.getScheduleType().intValue()));
        scheduleResItems.setAdmDate(DateUtils.dateToString((Date)scheduleRecordEntity.getScheduleDate(), (String)"yyyy-MM-dd"));
        scheduleResItems.setAdmTimeRange(scheduleRecordEntity.getScheduleRange().toString());
        scheduleResItems.setHospitalArea(scheduleRecordEntity.getHospitalAreaName());
        scheduleResItems.setHospitalAreaCode(scheduleRecordEntity.getHospitalArea());
        scheduleResItems.setDocCode(scheduleRecordEntity.getDocCode());
        scheduleResItems.setDocName(scheduleRecordEntity.getDocName());
        scheduleResItems.setLocCode(scheduleRecordEntity.getDeptCode());
        scheduleResItems.setLocName(scheduleRecordEntity.getDeptName());
        scheduleResItems.setRegFee(scheduleRecordEntity.getRegFee().toString());
        scheduleResItems.setRegTitleCode(scheduleRecordEntity.getRegTitelCode());
        scheduleResItems.setRegTitleName(scheduleRecordEntity.getRegTitelName());
        scheduleResItems.setScheduleLevelCode(scheduleRecordEntity.getScheduleLevelCode());
        scheduleResItems.setScheduleLevelName(scheduleRecordEntity.getScheduleLevel());
        scheduleResItems.setLocTypeCode(scheduleRecordEntity.getDeptCategoryCode());
        scheduleResItems.setLocTypeName(scheduleRecordEntity.getDeptCategoryName());
        scheduleResItems.setAdmLocation(scheduleRecordEntity.getAdmLocation());
        scheduleResItems.setRegAvailable(scheduleRecordEntity.getAvailableCount());
        scheduleResItems.setRegTotal(scheduleRecordEntity.getTotalCount());
        scheduleResItems.setAppStartNo(String.valueOf(scheduleRecordEntity.getStartNo()));
        scheduleResItems.setScheduleStatus(scheduleRecordEntity.getStatus().toString());
        scheduleResItems.setReplaceScheduleId(scheduleRecordEntity.getReplaceScheduleHisId());
        scheduleResItems.setIsTimeArrange(Integer.valueOf(scheduleRecordEntity.getIsPrecise().intValue()));
        scheduleResItems.setDiagFee(scheduleRecordEntity.getDiagFee().toString());
        scheduleResItems.setTimeArrangeItems(timeArrangeItemsList);
        return scheduleResItems;
    }

    private List<TimeArrangeItems> buildTimeArrangeItems(List<ScheduleDetailRecordEntity> scheduleDetailRecordList) {
        List<TimeArrangeItems> TimeArrangeItemList = scheduleDetailRecordList.stream().map(scheduleDetailRecordEntity -> {
            TimeArrangeItems getTimeArrangeItems = new TimeArrangeItems();
            getTimeArrangeItems.setStartNo(scheduleDetailRecordEntity.getStartNo());
            getTimeArrangeItems.setEndNo(scheduleDetailRecordEntity.getEndNo());
            getTimeArrangeItems.setStartTime(scheduleDetailRecordEntity.getStartTime());
            getTimeArrangeItems.setEndTime(scheduleDetailRecordEntity.getEndTime());
            getTimeArrangeItems.setTimeArrangeId(scheduleDetailRecordEntity.getHisTimeArrangeId());
            getTimeArrangeItems.setBookedNos(scheduleDetailRecordEntity.getBookedNos());
            return getTimeArrangeItems;
        }).collect(Collectors.toList());
        return TimeArrangeItemList;
    }

    private List<ScheduleRecordEntity> getScheduleByScheduleDTO(GetScheduleDTO getScheduleDTO) {
        return this.scheduleRecordMapper.selectByGetScheduleDTO(getScheduleDTO);
    }

    private List<ScheduleDetailRecordEntity> getScheduleDetailRecord(String hisScheduleId, String organCode) {
        return this.scheduleDetailRecordMapper.selectByHisScheduleId(hisScheduleId, organCode);
    }

    private List<GetScheduleResItems> getScheduleResItemsList(GetScheduleDTO getScheduleDTO) {
        List recordEntityList = this.getScheduleByScheduleDTO(getScheduleDTO);
        List filterRecordEntityList = recordEntityList.stream().filter(scheduleRecordEntity -> scheduleRecordEntity.getRegFee().compareTo(BigDecimal.ZERO) != 0).collect(Collectors.toList());
        List<GetScheduleResItems> scheduleResItemsList = filterRecordEntityList.stream().map(scheduleRecordEntity -> {
            GetScheduleResItems getScheduleResItems = new GetScheduleResItems();
            List scheduleDetailRecordList = this.getScheduleDetailRecord(scheduleRecordEntity.getScheduleHisId(), scheduleRecordEntity.getHospitalCode());
            List TimeArrangeItems2 = this.buildTimeArrangeItems(scheduleDetailRecordList);
            getScheduleResItems = this.buildGetScheduleResItems(scheduleRecordEntity, TimeArrangeItems2);
            return getScheduleResItems;
        }).collect(Collectors.toList());
        log.info("\u83b7\u53d6\u6392\u73ed\u4fe1\u606f \uff1a{}", (Object)JSON.toJSONString(scheduleResItemsList));
        return scheduleResItemsList;
    }

    private List<GetScheduleResItems> getDocSchedule(GatewayRequest<GetScheduleReqVO> gatewayRequest) {
        log.info("\u67e5\u8be2\u533b\u751f\u9884\u7ea6\u6392\u73ed\u5165\u53c2" + JSON.toJSONString(gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(gatewayRequest);
        log.info("\u67e5\u8be2\u533b\u751f\u9884\u7ea6\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (gatewayResponse == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        if (getScheduleResVO == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        List<GetScheduleResItems> getScheduleResItemsList = getScheduleResVO.getItems();
        if (CollectionUtils.isEmpty((Collection)getScheduleResItemsList)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f" + gatewayResponse.getMsg());
            return new ArrayList<GetScheduleResItems>();
        }
        getScheduleResItemsList = getScheduleResItemsList.stream().filter(getScheduleResItems -> getScheduleResItems.getDocCode().equals(((GetScheduleReqVO)gatewayRequest.getBody()).getDocCode())).collect(Collectors.toList());
        log.info("\u8fc7\u6ee4\u51fa\u8be5\u533b\u751f\u6392\u73ed\uff1a" + getScheduleResItemsList);
        return getScheduleResItemsList;
    }

    private boolean getSchduleStatus(GatewayRequest<GetScheduleReqVO> gatewayRequest) {
        log.info("\u83b7\u53d6\u6392\u73ed\u5165\u53c2" + JSON.toJSONString(gatewayRequest));
        GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(gatewayRequest);
        log.info("\u83b7\u53d6\u6392\u73ed\u51fa\u53c2" + JSON.toJSONString((Object)gatewayResponse));
        if (null == gatewayResponse) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
            return false;
        }
        if (!"1".equals(gatewayResponse.getCode())) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
            return false;
        }
        if (gatewayResponse.getData() == null) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
            return false;
        }
        GetScheduleResVO getScheduleResVO = (GetScheduleResVO)gatewayResponse.getData();
        List items = getScheduleResVO.getItems();
        if (!"581".equals(((GetScheduleReqVO)gatewayRequest.getBody()).getLocCode())) {
            items = items.stream().filter(item -> !new BigDecimal(item.getRegFee()).equals(BigDecimal.ZERO)).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)items)) {
            log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
            return false;
        }
        return true;
    }

    public List<GetNewDoctorScheduleVoRes> getNewDoctorSchedule(GetNewDoctorScheduleVoReq getScheduleVoReq) throws ScheduleException, ParseException {
        List deptCategoryRelationEntities = this.deptCategoryRelationMapper.selectDeptCodeByDocId(getScheduleVoReq.getDeptCode());
        ArrayList<GetNewDoctorScheduleVoRes> getScheduleList = new ArrayList<GetNewDoctorScheduleVoRes>();
        ArrayList<GetNewDoctorScheduleVoRes> getScheduleListVO = new ArrayList<GetNewDoctorScheduleVoRes>();
        HashMap<String, GetNewDoctorScheduleVoRes> getNewDoctorScheduleVoResMap = new HashMap<String, GetNewDoctorScheduleVoRes>();
        for (DeptCategoryRelationEntity deptCategoryRelationEntity : deptCategoryRelationEntities) {
            getScheduleVoReq.setDeptCode(deptCategoryRelationEntity.getDeptCode());
            for (int i = 0; i < 7; ++i) {
                Date dateAfter = DateUtils.getAfterCurrentDay((int)i);
                getScheduleVoReq.setStartDate(new SimpleDateFormat("yyyy-MM-dd").format(dateAfter));
                getScheduleVoReq.setEndDate(new SimpleDateFormat("yyyy-MM-dd").format(dateAfter));
                GatewayRequest gatewayRequest = this.buildNewGetScheduleGatewayReq(getScheduleVoReq);
                GatewayResponse gatewayResponse = this.scheduleApi.getSchedule(gatewayRequest);
                if (gatewayResponse == null) {
                    log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u8bf7\u6c42\u65e0\u54cd\u5e94");
                    continue;
                }
                if (!"1".equals(gatewayResponse.getCode())) {
                    log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u67e5\u8be2\u5931\u8d25 err_code:{},mag:{}", (Object)gatewayResponse.getErrCode(), (Object)gatewayResponse.getMsg());
                    continue;
                }
                if (gatewayResponse.getData() == null) {
                    log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u54cd\u5e94\u5b9e\u4f53\u5f02\u5e38");
                    continue;
                }
                List scheduleResItemsList = ((GetScheduleResVO)gatewayResponse.getData()).getItems();
                if (CollectionUtils.isEmpty((Collection)scheduleResItemsList)) {
                    log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
                    continue;
                }
                if (CollectionUtils.isEmpty(scheduleResItemsList = scheduleResItemsList.stream().map(getScheduleResItems -> {
                    getScheduleResItems.setAdmDate(DateUtils.dateToSimpleString((Date)DateUtils.stringToSimpleDate((String)getScheduleResItems.getAdmDate())));
                    return getScheduleResItems;
                }).collect(Collectors.toList()))) {
                    log.error("\u6302\u53f7\u6392\u73ed\u67e5\u8be2 getSchedule -> his\u65e0\u6392\u73ed\u4fe1\u606f");
                    continue;
                }
                GetNewDoctorScheduleVoRes getDoctorScheduleVoRes = new GetNewDoctorScheduleVoRes();
                GetScheduleResItems getScheduleResItem = (GetScheduleResItems)scheduleResItemsList.get(0);
                getDoctorScheduleVoRes.setDocCode(getScheduleResItem.getDocCode());
                getDoctorScheduleVoRes.setDoctorId(getScheduleVoReq.getDoctorCode());
                getDoctorScheduleVoRes.setDocName(getScheduleResItem.getDocName());
                getDoctorScheduleVoRes.setRegTitleCode(getScheduleResItem.getRegTitleCode());
                getDoctorScheduleVoRes.setRegTitleName(getScheduleResItem.getRegTitleName());
                getDoctorScheduleVoRes.setDeptCode(getScheduleVoReq.getDeptCode());
                getDoctorScheduleVoRes.setDeptName(getScheduleResItem.getLocName());
                getDoctorScheduleVoRes.setHospitalName(getScheduleResItem.getHospitalArea());
                List scheduleBaseInfoVoList = scheduleResItemsList.stream().map(arg_0 -> this.buildScheduleBaseInfoVo(arg_0)).collect(Collectors.toList());
                getDoctorScheduleVoRes.setScheduleBaseInfoVoList(scheduleBaseInfoVoList);
                getScheduleList.add(getDoctorScheduleVoRes);
            }
        }
        for (GetNewDoctorScheduleVoRes getNewDoctorScheduleVoRes : getScheduleList) {
            if (getNewDoctorScheduleVoResMap.containsKey(getNewDoctorScheduleVoRes.getDocCode())) {
                GetNewDoctorScheduleVoRes getNewDoctorScheduleVoRes1 = (GetNewDoctorScheduleVoRes)getNewDoctorScheduleVoResMap.get(getNewDoctorScheduleVoRes.getDocCode());
                getNewDoctorScheduleVoRes1.getScheduleBaseInfoVoList().addAll(getNewDoctorScheduleVoRes.getScheduleBaseInfoVoList());
                getNewDoctorScheduleVoResMap.put(getNewDoctorScheduleVoRes.getDocCode(), getNewDoctorScheduleVoRes1);
                continue;
            }
            getNewDoctorScheduleVoResMap.put(getNewDoctorScheduleVoRes.getDocCode(), getNewDoctorScheduleVoRes);
        }
        getNewDoctorScheduleVoResMap.forEach((key, value) -> getScheduleListVO.add((GetNewDoctorScheduleVoRes)value));
        return getScheduleListVO;
    }

    private GatewayRequest<GetScheduleReqVO> buildNewGetScheduleGatewayReq(GetNewDoctorScheduleVoReq getScheduleVoReq) {
        GatewayRequest gatewayRequest = new GatewayRequest();
        GetScheduleReqVO getScheduleReqVO = new GetScheduleReqVO();
        getScheduleReqVO.setBgDate(getScheduleVoReq.getStartDate());
        getScheduleReqVO.setEdDate(getScheduleVoReq.getEndDate());
        getScheduleReqVO.setLocCode(getScheduleVoReq.getDeptCode());
        getScheduleReqVO.setDocCode(getScheduleVoReq.getDoctorCode());
        gatewayRequest.setBody((Object)getScheduleReqVO);
        gatewayRequest.setChannelName(getScheduleVoReq.getChannelName());
        gatewayRequest.setChannel(getScheduleVoReq.getChannelName());
        gatewayRequest.setOrganCode(this.propertiesConstant.getOrganCode());
        gatewayRequest.setKeyWord("getSchedule");
        gatewayRequest.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        return gatewayRequest;
    }
}

