/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.service.impl;

import com.ebaiyihui.framework.utils.JsonUtil;
import com.ebaiyihui.his.api.AppointApi;
import com.ebaiyihui.his.pojo.vo.appoint.AppointRecordItem;
import com.ebaiyihui.his.pojo.vo.appoint.GetAppointRecordReq;
import com.ebaiyihui.his.pojo.vo.appoint.GetAppointRecordRes;
import com.ebaiyihui.his.pojo.vo.base.GatewayRequest;
import com.ebaiyihui.his.pojo.vo.base.GatewayResponse;
import com.ebaiyihui.wisdommedical.mapper.AppointmentPayorderMapper;
import com.ebaiyihui.wisdommedical.mapper.AppointmentRecordMapper;
import com.ebaiyihui.wisdommedical.mapper.HospitalAreaRecordMapper;
import com.ebaiyihui.wisdommedical.model.AppointmentPayorderEntity;
import com.ebaiyihui.wisdommedical.model.AppointmentRecordEntity;
import com.ebaiyihui.wisdommedical.model.HospitalAreaRecordEntity;
import com.ebaiyihui.wisdommedical.pojo.dto.SyncAppointPayOrderDTO;
import com.ebaiyihui.wisdommedical.pojo.dto.SyncAppointRecordDTO;
import com.ebaiyihui.wisdommedical.service.SyncHisOrderService;
import com.ebaiyihui.wisdommedical.util.DateUtils;
import com.ebaiyihui.wisdommedical.util.SnowflakeIdWorker;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SyncHisOrderServiceImpl
implements SyncHisOrderService {
    private static Logger logger = LoggerFactory.getLogger(SyncHisOrderServiceImpl.class);
    @Autowired
    private SnowflakeIdWorker snowflakeIdWorker;
    @Autowired
    private AppointApi appointApi;
    @Autowired
    private AppointmentRecordMapper recordMapper;
    @Autowired
    private AppointmentPayorderMapper payorderMapper;
    @Autowired
    private HospitalAreaRecordMapper hospitalAreaRecordMapper;

    @Transactional
    public void syncHisOrder(String hospitalCode, String cardNo) {
        HospitalAreaRecordEntity hospitalRecord = this.hospitalAreaRecordMapper.selectOneByhospitalCode(hospitalCode);
        if (null == hospitalRecord) {
            logger.info("----------------\u533b\u9662\u672a\u914d\u7f6e\uff0c\u8bf7\u5148\u624b\u52a8\u914d\u7f6e\u533b\u9662\u7f16\u7801" + hospitalCode);
            return;
        }
        List items = this.getHisOrder(hospitalCode, cardNo);
        Map itemsMap = this.groupOrder(items);
        for (Map.Entry entry : itemsMap.entrySet()) {
            String appointmentId = entry.getKey().toString();
            List list = (List)entry.getValue();
            AppointmentRecordEntity recordEntity = this.recordMapper.selectByAppointId(appointmentId);
            if (null == recordEntity && !StringUtils.isEmpty((String)recordEntity.toString())) continue;
            AppointmentPayorderEntity payorderEntity = this.payorderMapper.selectBySysAppointmentId(recordEntity.getSysAppointmentId());
            SyncAppointRecordDTO appointRecordDTO = new SyncAppointRecordDTO();
            appointRecordDTO.setAppointmentId(appointmentId);
            appointRecordDTO.setUpdatetime(new Date());
            SyncAppointPayOrderDTO payOrderDTO = new SyncAppointPayOrderDTO();
            payOrderDTO.setSysAppointmentId(recordEntity.getSysAppointmentId());
            payOrderDTO.setUpdatetime(new Date());
            if (2 == list.size()) {
                appointRecordDTO.setAppointStatus(Byte.valueOf((byte)8));
                appointRecordDTO.setRemark("his\u6302\u53f7\u8ba2\u5355\u4e3a\u5df2\u9000\u6b3e\u72b6\u6001");
                logger.info("\u67e5\u8be2\u5230\u8be5\u6302\u53f7\u8bb0\u5f55\uff0c\u66f4\u65b0\u8be5his\u6302\u53f7\u8bb0\u5f55\u72b6\u6001\uff1a" + appointRecordDTO.toString());
                this.recordMapper.updateByAppointId(appointRecordDTO);
                if (null == payorderEntity) continue;
                payOrderDTO.setOrderStatus(Byte.valueOf((byte)7));
                payOrderDTO.setRemark("his\u6302\u53f7\u8ba2\u5355\u4e3a\u5df2\u9000\u6b3e\u72b6\u6001");
                logger.info("\u67e5\u8be2\u5230\u8be5\u7b14\u8ba2\u5355\uff0c\u66f4\u65b0\u66f4\u6539his\u5df2\u9000\u6b3e\u72b6\u6001\uff1a" + appointRecordDTO.toString());
                this.payorderMapper.updateBySysAppointmentId(payOrderDTO);
                continue;
            }
            if (1 != list.size()) continue;
            appointRecordDTO.setAppointStatus(Byte.valueOf((byte)7));
            appointRecordDTO.setRemark("his\u6302\u53f7\u8ba2\u5355\u4e3a\u5df2\u652f\u4ed8\u72b6\u6001");
            logger.info("\u67e5\u8be2\u5230\u6302\u53f7\u8bb0\u5f55\uff0chis\u6302\u53f7\u8ba2\u5355\u4e3a\u5df2\u652f\u4ed8\u72b6\u6001\uff0c\u66f4\u65b0\u72b6\u6001\uff1a" + appointRecordDTO.toString());
            this.recordMapper.updateByAppointId(appointRecordDTO);
            if (null == payorderEntity) continue;
            payOrderDTO.setOrderStatus(Byte.valueOf((byte)6));
            payOrderDTO.setRemark("his\u6302\u53f7\u8ba2\u5355\u4e3a\u5df2\u652f\u4ed8\u72b6\u6001");
            logger.info("\u67e5\u8be2\u5230\u8ba2\u5355\u72b6\u6001\uff0chis\u6302\u53f7\u8ba2\u5355\u4e3a\u5df2\u652f\u4ed8\u72b6\u6001\uff0c\u66f4\u65b0\u72b6\u6001\uff1a" + appointRecordDTO.toString());
            this.payorderMapper.updateBySysAppointmentId(payOrderDTO);
        }
    }

    private Map<String, List<AppointRecordItem>> groupOrder(List<AppointRecordItem> itemList) {
        HashMap<String, List<AppointRecordItem>> resultMap = new HashMap<String, List<AppointRecordItem>>();
        for (AppointRecordItem appointRecordItem : itemList) {
            if (resultMap.containsKey(appointRecordItem.getAppointId())) {
                ((List)resultMap.get(appointRecordItem.getAppointId())).add(appointRecordItem);
                continue;
            }
            ArrayList<AppointRecordItem> tmpList = new ArrayList<AppointRecordItem>();
            tmpList.add(appointRecordItem);
            resultMap.put(appointRecordItem.getAppointId(), tmpList);
        }
        return resultMap;
    }

    private List<AppointRecordItem> getHisOrder(String hospitalCode, String cardNo) {
        GetAppointRecordRes data;
        GatewayRequest request = new GatewayRequest();
        GetAppointRecordReq appointRecordReq = new GetAppointRecordReq();
        String startDate = DateUtils.getCurrentDate((String)"yyyy-MM-dd");
        appointRecordReq.setStartDate("2017-07-23");
        appointRecordReq.setCardNo(cardNo);
        appointRecordReq.setStatus("1");
        request.setChannel("\u4e92\u8054\u7f51APP");
        request.setChannelName("\u5927\u4f17\u7aef");
        request.setOrganCode("SRJD");
        request.setTransactionId(String.valueOf(this.snowflakeIdWorker.nextId()));
        request.setBody((Object)appointRecordReq);
        logger.info("\u67e5\u8be2\u6302\u53f7\u8bb0\u5f55\u8bf7\u6c42\u53c2\u6570:" + JsonUtil.convertObject((Object)request));
        GatewayResponse response = this.appointApi.getAppointRecord(request);
        logger.info("\u67e5\u8be2\u6302\u53f7\u8bb0\u5f55\u8fd4\u56de\u53c2\u6570:" + JsonUtil.convertObject((Object)response));
        if ("1".equals(response.getCode()) && null != (data = (GetAppointRecordRes)response.getData())) {
            return data.getItems();
        }
        return null;
    }
}

