/*
 * Decompiled with CFR 0.152.
 */
package com.ebaiyihui.wisdommedical.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.doctoruser.api.pojo.dto.UcConfigurationDTO;
import com.doctoruser.api.pojo.vo.UcConfigurationVO;
import com.ebaiyihui.framework.response.BaseResponse;
import com.ebaiyihui.wisdommedical.common.constant.ProPropertiesConstant;
import com.ebaiyihui.wisdommedical.pojo.vo.PushConfigSignCodeDetailVO;
import com.ebaiyihui.wisdommedical.pojo.vo.PushConfigurationDetailVO;
import com.ebaiyihui.wisdommedical.pojo.vo.PushSubscribeMessageReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.UmPushMsgAndroidReqVO;
import com.ebaiyihui.wisdommedical.pojo.vo.UmPushMsgIOSReqVo;
import com.ebaiyihui.wisdommedical.util.HttpKit;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PushInfoManagerUtils {
    private static final Logger log = LoggerFactory.getLogger(PushInfoManagerUtils.class);
    @Autowired
    private ProPropertiesConstant propertiesConstant;

    public BaseResponse<String> pushSubscribeMessage(PushSubscribeMessageReqVO pushSubscribeMessageReqVO) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getWechatpushUrl(), (String)JSON.toJSONString((Object)pushSubscribeMessageReqVO));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u5c0f\u7a0b\u5e8f\u63a8\u9001\u8fd4\u56de\u503cbaseResponse: " + baseResponse.toString());
            return baseResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public BaseResponse<String> pushAndroidMessage(UmPushMsgAndroidReqVO umPushMsgAndroidReqVO) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getAndroidPushurl(), (String)JSON.toJSONString((Object)umPushMsgAndroidReqVO));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("\u5b89\u5353\u63a8\u9001\u8fd4\u56de\u503cbaseResponse: " + baseResponse.toString());
            return baseResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public BaseResponse<String> pushIOSMessage(UmPushMsgIOSReqVo umPushMsgIOSReqVo) {
        try {
            String body = HttpKit.jsonPost((String)this.propertiesConstant.getIosPushurl(), (String)JSON.toJSONString((Object)umPushMsgIOSReqVo));
            BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject((String)body), BaseResponse.class);
            log.info("ios\u63a8\u9001\u8fd4\u56de\u503cbaseResponse: " + baseResponse.toString());
            return baseResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public PushConfigurationDetailVO getPushConfig(String appCode, String pushType, String userType, String channlType) {
        PushConfigurationDetailVO configurationDetailVO = new PushConfigurationDetailVO();
        UcConfigurationDTO ucConfigurationDTO = new UcConfigurationDTO();
        ucConfigurationDTO.setType(pushType);
        ucConfigurationDTO.setAppCode(appCode);
        String body = null;
        try {
            body = HttpKit.jsonPost((String)this.propertiesConstant.getPushConfigUrl(), (String)JSON.toJSONString((Object)ucConfigurationDTO));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        BaseResponse baseResponse = (BaseResponse)JSONObject.toJavaObject((JSON)JSONObject.parseObject(body), BaseResponse.class);
        log.info("\u83b7\u53d6\u63a8\u9001\u914d\u7f6e\u8fd4\u56de\u503cbaseResponse: " + baseResponse.toString());
        if (!baseResponse.isSuccess()) {
            log.error("\u63a8\u9001\u8fd4\u56de\u503cbaseResponse\u4e3a\u7a7a");
            return null;
        }
        UcConfigurationVO ucConfigurationVO = (UcConfigurationVO)JSONObject.parseObject((String)JSONObject.toJSONString((Object)baseResponse.getData()), UcConfigurationVO.class);
        String configuration = ucConfigurationVO.getClientCode();
        log.info("\u63a8\u9001\u8fd4\u56de\u503cconfiguration " + configuration);
        if (pushType.equals("youmengPush")) {
            List configurationDetailVOS = JSONObject.parseArray((String)configuration, PushConfigurationDetailVO.class);
            log.info(" json\u8f6clist ==configurationDetailVOS :{}", (Object)JSON.toJSONString((Object)configurationDetailVOS));
            for (PushConfigurationDetailVO detailVO : configurationDetailVOS) {
                if (!detailVO.getUserType().equals(userType) || !detailVO.getDeviceType().equals(channlType)) continue;
                BeanUtils.copyProperties((Object)detailVO, (Object)configurationDetailVO);
            }
            return configurationDetailVO;
        }
        PushConfigurationDetailVO pushConfigurationDetailVO = (PushConfigurationDetailVO)JSONObject.parseObject((String)configuration, PushConfigurationDetailVO.class);
        log.info(" json\u8f6cobj ==pushConfigurationDetailVO :{}", (Object)JSON.toJSONString((Object)pushConfigurationDetailVO));
        if (pushType.equals("sms")) {
            PushConfigSignCodeDetailVO pushConfigSignCodeDetailVO = (PushConfigSignCodeDetailVO)JSONObject.parseObject((String)pushConfigurationDetailVO.getSignCode(), PushConfigSignCodeDetailVO.class);
            log.info(" json\u8f6cobj ==pushConfigSignCodeDetailVO :{}", (Object)JSON.toJSONString((Object)pushConfigSignCodeDetailVO));
            pushConfigurationDetailVO.setDoctorCode(pushConfigSignCodeDetailVO.getDoctorCode());
            pushConfigurationDetailVO.setPatientCode(pushConfigSignCodeDetailVO.getPatientCode());
        }
        return pushConfigurationDetailVO;
    }
}

